*********************************************
* BOF menudemo.prg
*********************************************
* Author:	Mark Hall
* Date:		4th February (my birthday) 1996
* Version:	1.0
* Desc:		Demo of the menulib classes
*			Wow, isn't this great!!
*********************************************

*********************************************
* Attach the Class Library to VFP
*********************************************
IF NOT "MENULIB" $ SET("CLASSLIB")
	SET CLASSLIB TO menulib ADDITIVE
ENDIF

*********************************************
* Attach the Procedure Library to VFP
*********************************************
IF NOT "MENUPROC" $ SET("PROCEDURE")
	SET PROCEDURE TO menuproc ADDITIVE
ENDIF

*********************************************
* Create the menu object
*********************************************
oMenu=CREATEOBJECT("menu")

*********************************************
* Hide any active VFP toolbars
*********************************************
oMenu.HideSystemToolbars()

*********************************************
* Construct the menu options
*********************************************
oMenu.AddObject("File","menupad")
oMenu.AddObject("Edit","menupad")
oMenu.AddObject("View","menupad")
oMenu.AddObject("Special","menupad")
oMenu.AddObject("Help","menupad")

oMenu.File.AddObject("Open","menupad")
oMenu.File.AddObject("Close","menupad")
oMenu.File.AddObject("Spacer1","menupad","\-")
oMenu.File.AddObject("Exit","menupad","E\<xit")

oMenu.Edit.AddObject("Cut","menupad","Cu\<t")
oMenu.Edit.AddObject("Copy","menupad")
oMenu.Edit.AddObject("Paste","menupad")

oMenu.View.AddObject("DemoCode","menupad","\<Demo Code")

oMenu.Special.AddObject("Check","menupad","\<Toggle Checkmark")
oMenu.Special.AddObject("Enable","menupad","\<Toggle Enabled")
oMenu.Special.AddObject("Add","menupad","\<Add some more menu items")

oMenu.Help.AddObject("About","menupad")



*********************************************
* Set messages where needed
*********************************************
oMenu.File.Message("File type options")
oMenu.Edit.Message("Editting type options")
oMenu.View.Message("Viewing type options")
oMenu.Special.Message("Special, showing off stuff")
oMenu.Help.Message("Helping type options")

oMenu.File.Exit.Message("Return menus to normal - Boo!")

oMenu.View.DemoCode.Message("View the menu code for this demo")

oMenu.Special.Check.Message("Toggle the check mark on this menu item")
oMenu.Special.Enable.Message("Toggle the enabled property for the following menu item")
oMenu.Special.Add.Message("Add a couple more levels of menu")

oMenu.Help.About.Message("See the MnuClass About window")



*********************************************
* Set Shortcuts 
*********************************************
oMenu.File.Shortcut("ALT+F")
oMenu.Edit.Shortcut("ALT+E")
oMenu.View.Shortcut("ALT+V")
oMenu.Special.Shortcut("ALT+S")
oMenu.Help.Shortcut("ALT+H")

oMenu.File.exit.Shortcut("ALT+X")

oMenu.Edit.Cut.Shortcut("CTRL+X")
oMenu.Edit.Copy.Shortcut("CTRL+C")
oMenu.Edit.Paste.Shortcut("CTRL+V")


*********************************************
* Change the edit menu bars to represent
* standard VFP system menu bars
*********************************************
oMenu.Edit.Cut.BarNo(_MED_CUT)
oMenu.Edit.Copy.BarNo(_MED_COPY)
oMenu.Edit.Paste.BarNo(_MED_PASTE)

*********************************************
* Set up all the commands
*********************************************
oMenu.File.Open.Command([=GETFILE("PRG;VCX;SCX","Dummy open file dialog","Do Nothing")])
oMenu.File.Exit.Command("CLEAR EVENTS")
oMenu.View.DemoCode.Command("MODIFY COMMAND menudemo NOEDIT")
oMenu.Help.About.Command("Do Form AboutFrm")
oMenu.Special.Check.Command("oMenu.Special.Check.Checked( NOT oMenu.Special.Check.Checked() )")
oMenu.Special.Enable.Command("oMenu.Special.Add.Enabled( NOT oMenu.Special.Add.Enabled() )")
oMenu.Special.Add.Command("Do additems")

READ EVENTS  &&The Exit option does a CLEAR EVENTS

*********************************************
* Show any previously hidden toolbars
*********************************************
oMenu.ShowHiddenToolbars()

*********************************************
* The custom menu will disappear when this program finishes
* because at that time, the menu object variable (oMenu) is
* automatically released.  When this happens, that object
* automatically issues a SET SYSMENU TO DEFAULT command
*********************************************
* EOF menudemo.prg
*********************************************
