************************************************************
* Date / Author:
* 09.08.1995 / Mario Benuzzi @ CIS 100255,33
* Name:
* GetNewID ()
* Description:
* fetches a new ID for the table specified
* Returns:
* >0 : valid ID
* -1 : unexpected error
* -2 : no database open
* -3 : unable to lock IDs table
#DEFINE IDS_TABLENAME	"ids"

FUNCTION GetNewID()
	PARAMETERS cTable
	LOCAL lnRet
	lnRet = -1
	cTable = LOWER (m.cTable)
	*-- (Creates), Opens and SET INDEX into the last used IDs table
	IF NOT FILE (LEFT (DBC(), RAT ('\', DBC())) + IDS_TABLENAME + ".dbf")
		IF EMPTY (DBC())
			*-- no database open
			RETURN -2
		ENDIF
		CREATE TABLE (LEFT (DBC(), RAT ('\', DBC())) + IDS_TABLENAME) ;
			(table C (32) PRIMARY KEY, last N (6,0))
		USE IN (IDS_TABLENAME)
	ENDIF
	IF USED ("ids")
		SET ORDER TO TAG table IN ids
	ELSE
		USE (IDS_TABLENAME) IN 0 ORDER TAG table SHARED ALIAS ids
	ENDIF

	*-- Last ID LookUp	
	IF NOT SEEK (PADR (ALLTRIM (m.cTable), LEN (ids.table)), "ids")
		INSERT INTO ids (table, last) VALUES (m.cTable, 0)
	ENDIF

	*-- Get New ID
	IF RLOCK ("ids")
		REPLACE ids.last WITH ids.last + 1 IN ids
		lnRet = ids.last
		UNLOCK IN ids
	ELSE
		lnRet = -3
	ENDIF

	RETURN (m.lnRet)
ENDFUNC
* EOF : GetNewID()
************************************************************
