*   Mac Alert Box Function patterned after the Windows FMSGBOX function.
*	Call it with a Message to display, the type of message, the symbol to use,
*	and the title.  The last tree parameters are optional.  Just call it from the command
*	window and you'll get a wait window with the params.  All params are strings.
*	It does this without using the FOXTOOLS.MLB which requires licensing ASLM to
*	distribute.
*
*	Function returns a string with the selected buttons text in it.
*
*	Robert Vandehey
*	CIS: 76346,2172
*	Message Box ver 1.0 6/8/94
*	Any suggestions or improvements are welcomed.
*
FUNCTION macalert
PARAMETER m.lcmsg, m.lctype, m.lcsymbol, m.lctitle
PRIVATE m.breply, m.symfile, m.btnpict, m.btnpos, m.reply, m.linecount, i, m.lastchar, m.charcount, m.char, m.break

IF PARAMETERS() = 0
	WAIT WINDOW "msg, type=ok-okcancel-abort-ync-yn-retry, symbol=?-!-info-*-stop, title"
	RETURN
ENDIF

DIMENSION reply(3)

IF PARAMETERS() < 4
	m.lctitle = ""
	IF PARAMETERS() < 3
		m.lcsymbol = "?"
		IF PARAMETERS() < 2
			m.lctype = "OK"
			IF PARAMETERS() < 1
				m.lcmsg = ""
			ENDIF
		ENDIF
	ENDIF
ENDIF

* The following code justs estimates the number of lines needed by the alert box
m.linecount = 0
m.charcount = 0
m.lastchar = " "
m.break = .F.

#DEFINE MIN_LINES	2
#DEFINE MAX_CHARS	50
#DEFINE CR			CHR(13)
#DEFINE LF			CHR(10)
#DEFINE B_1_POS		26.000
#DEFINE B_2_POS		20.880
#DEFINE B_3_POS		15.633

FOR i = 1 TO LEN(m.lcmsg)
	m.char = SUBSTR(m.lcmsg,i,1)
	m.charcount = m.charcount + 1
	DO CASE
	CASE m.char = CR
		m.break = .T.
	CASE m.char = LF
		IF m.lastchar <> CR
			m.break = .T.
		ENDIF
	CASE m.charcount >= MAX_CHARS
		m.break = .T.
	ENDCASE
	m.lastchar = m.char
	IF m.break
		m.linecount = m.linecount + 1
		m.charcount = 0
		m.break = .F.
	ENDIF
NEXT i

IF m.charcount > 0
	m.linecount = m.linecount + 1
ENDIF

m.lctype = UPPER(m.lctype)
m.lcsymbol = UPPER(m.lcsymbol)

m.breply = 0

m.linecount = MAX(m.linecount + 1, MIN_LINES)

IF EMPTY(m.lctitle)
DEFINE WINDOW alert ;
	AT  0.000, 0.000  ;
	SIZE 5.000 + m.linecount,62.000 ;
	FONT "Geneva", 12 ;
	STYLE "B" ;
	NOFLOAT ;
	NOCLOSE ;
	PANEL ;
	COLOR RGB(,,,255,255,255)
ELSE
DEFINE WINDOW alert ;
	AT  0.000, 0.000  ;
	SIZE 5.000 + m.linecount,62.000 ;
	TITLE m.lctitle ;
	FONT "Geneva", 12 ;
	STYLE "B" ;
	NOFLOAT ;
	NOCLOSE ;
	PANEL ;
	COLOR RGB(,,,255,255,255)
ENDIF
MOVE WINDOW alert CENTER

ACTIVATE WINDOW alert SAME

?? CHR(7)

DO CASE
CASE INLIST(m.lcsymbol,"?","INFO")
	m.symfile = "macnote.pct"
CASE INLIST(m.lcsymbol,"!","*")
	m.symfile = "macexclm.pct"
CASE m.lcsymbol = "STOP"
	m.symfile = "macstop.pct"
OTHERWISE
	m.symfile = "macnote.pct"
ENDCASE

DO CASE
CASE m.lctype == "OK"
	m.btnpict = "\!OK"
	m.btnpos = B_1_POS
	reply[1] = "OK"
CASE m.lctype == "OKCANCEL"
	m.btnpict = "\!OK;\?Cancel"
	m.btnpos = B_2_POS
	reply[1] = "OK"
	reply[2] = "CANCEL"
CASE m.lctype == "ABORT"
	m.btnpict = "\!Abort;Retry;Ignore"
	m.btnpos = B_3_POS
	reply[1] = "ABORT"
	reply[2] = "RETRY"
	reply[3] = "IGNORE"
CASE m.lctype == "YNC"
	m.btnpict = "\!Yes;No;\?Cancel"
	m.btnpos = B_3_POS
	reply[1] = "YES"
	reply[2] = "NO"
	reply[3] = "CANCEL"
CASE m.lctype == "YN"
	m.btnpict = "\!Yes;No"
	m.btnpos = B_2_POS
	reply[1] = "YES"
	reply[2] = "NO"
CASE m.lctype == "ABORT"
	m.btnpict = "\!Retry;\?Cancel"
	m.btnpos = B_2_POS
	reply[1] = "RETRY"
	reply[2] = "CANCEL"
OTHERWISE
	m.btnpict = "\!OK"
	m.btnpos = B_1_POS
	reply[1] = "OK"
ENDCASE

@ 1.800,3.375 SAY m.symfile BITMAP ;
	SIZE 2.133,4.00 ;
	ISOMETRIC ;
	STYLE "T"
	
* Since @ SAY's have a limitation of 255 chars, I use an EDIT region to display the text.
@ 1.600,9.250 EDIT m.lcmsg ;
	SIZE m.linecount,MAX_CHARS,0.000 ;
	PICTURE "@2" ;
	FONT "Geneva", 12 ;
	STYLE "B" ;
	COLOR RGB(255,255,255,,,,)
* The only problem with using an EDIT region, is a border is displayed around the region.
* Draw a white border to cover-up the EDIT regions border.
@ 1.600 - 0.133,9.250 - 0.375 TO 1.600 + 0.133 + m.linecount ,9.250 + 0.375 + MAX_CHARS ;
	PEN 2, 8 ;
	STYLE "T" ;
	COLOR RGB(255,255,255,,,,)
*	COLOR RGB(192,192,192,,,,)		&& Enable this line for dimension testing

* We don't need anything but the BUTTON in the READ so CLEAR the GETS
CLEAR GETS

@ 2.600 + m.linecount,m.btnpos GET m.breply ;
	PICTURE "@*HT2 "+m.btnpict ;
	SIZE 1.500,10.714,1.143 ;
	DEFAULT 1 ;
	FONT "Geneva", 10 ;
	STYLE "B"

ACTIVATE WINDOW alert

DO WHILE m.breply = 0
	READ CYCLE MODAL SAVE
ENDDO

RELEASE WINDOW alert

RETURN reply[m.breply]

