* Program-id...: INVOICE1.PRG
* Author.......: Richard H. Elliott, Ferret Software
* Purpose......: Uses LaserPro procedure file routines to
*              : print a report.
*              : Uses soft fonts.

SET TALK off

SET PROCEDURE TO LaserPro                        && Use LaserPro procedure

DO init_print                                    && Initialize
??? reset                                        && Clean up stuff left behind

** LOAD FONTS, ASSIGN ID NUMBERS
??? FONTLOAD("HELV24ST.SFP", 101,printport)         && Loads fonts and assigns
??? FONTLOAD("HELV6.SFP",    102,printport)         && ID numbers
??? FONTLOAD("ROMN10.SFP",   103,printport)
??? FONTLOAD("ROMN18CB.SFP", 104,printport)
helv24   = 101                                    && Assign font IDs
helv6    = 102                                    && to variables (makes
roman10  = 103                                    && program more readable
roman18  = 104

** DRAW INVOICE
??? BOX( 0.60 , 1.20 , 6.00 , 7.50 ,  5 )        && Draws upper right
??? HLINE( 0.80 , 6.00, 1.50, 5 )                && invoice number box
??? SHADING( 0.60 , 0.80 , 6.00 , 7.50 ,  20 )

??? BOX( 4.00 , 9.50, 0.50 , 7.50 ,  7 )         && Big box for invoice
??? HLINE( 4.20 , 0.50, 7.00, 5 )
??? HLINE( 4.60 , 0.50, 7.00, 5 )
??? HLINE( 4.80 , 0.50, 7.00, 5 )
??? HLINE( 8.40 , 0.50, 7.00, 5 )
??? SHADING( 4.00 , 4.20 , 0.50 , 7.50 ,  20 )   && Medium shading for column
??? SHADING( 4.60 , 4.80 , 0.50 , 7.50 ,  20 )   && headings
??? VLINE( 4.00 , 1.50, 0.60, 5 )
??? VLINE( 4.00 , 2.50, 0.60, 5 )
??? VLINE( 4.00 , 4.00, 0.60, 5 )
??? VLINE( 4.00 , 5.00, 0.60, 5 )
??? VLINE( 4.00 , 6.50, 0.60, 5 )
??? VLINE( 4.60 , 1.50, 0.20, 5 )
??? VLINE( 4.60 , 2.50, 0.20, 5 )
??? VLINE( 4.60 , 5.00, 0.20, 5 )
??? VLINE( 4.60 , 5.50, 0.20, 5 )
??? VLINE( 4.60 , 6.50, 0.20, 5 )
??? VLINE( 4.80 , 1.50, 3.60, 2 )
??? VLINE( 4.80 , 2.50, 3.60, 2 )
??? VLINE( 4.80 , 5.00, 3.60, 2 )
??? VLINE( 4.80 , 5.50, 3.60, 2 )
??? VLINE( 4.80 , 6.50, 3.60, 2 )
??? VLINE( 8.40 , 5.50, 1.10, 5 )
??? VLINE( 8.40 , 6.50, 1.10, 5 )
??? SHADING( 4.80 , 5.00 , 0.50 , 7.50 , 5 )   && Light shading for invoice
??? SHADING( 5.20 , 5.40 , 0.50 , 7.50 , 5 )   && text bars
??? SHADING( 5.60 , 5.80 , 0.50 , 7.50 , 5 )
??? SHADING( 6.00 , 6.20 , 0.50 , 7.50 , 5 )
??? SHADING( 6.40 , 6.60 , 0.50 , 7.50 , 5 )
??? SHADING( 6.80 , 7.00 , 0.50 , 7.50 , 5 )
??? SHADING( 7.20 , 7.40 , 0.50 , 7.50 , 5 )
??? SHADING( 7.60 , 7.80 , 0.50 , 7.50 , 5 )
??? SHADING( 8.00 , 8.20 , 0.50 , 7.50 , 5 )

** FILL OUT TEXT PORTION OF INVOICE

??? SOFTFONT(roman18)                            && Select 18 point Times-Roman
??? SAYIT( 0.60, 0.50, 'FERRET SOFTWARE','')
??? SOFTFONT(roman10)                            && Select 10 point Times-Roman
??? SAYIT( 0.80, 0.50, '1102 Burwick Drive')
??? SAYIT( 1.00, 0.50, 'Herndon, VA 22070')
??? SAYIT( 1.20, 0.50, '(703) 742-8266')
??? SOFTFONT(helv24)                             && Select 24 point Helvetica
??? SAYIT( 0.35, 5.90, 'INVOICE','')
??? SOFTFONT(roman10)                            && Select 10 point Times-Roman
??? SAYIT( 0.76, 6.30, 'INVOICE NO.','')
??? SOFTFONT(helv6)                              && Select 6 point Helvetica
??? SAYIT( 2.30, 0.50, 'S','')
??? SAYIT( 2.40, 0.50, 'O','')
??? SAYIT( 2.50, 0.50, 'L','')
??? SAYIT( 2.60, 0.50, 'D','')
??? SAYIT( 2.80, 0.50, 'T','')
??? SAYIT( 2.90, 0.50, 'O','')
??? SAYIT( 2.30, 4.50, 'S','')
??? SAYIT( 2.40, 4.50, 'H','')
??? SAYIT( 2.50, 4.50, 'I','')
??? SAYIT( 2.60, 4.50, 'P','')
??? SAYIT( 2.80, 4.50, 'T','')
??? SAYIT( 2.90, 4.50, 'O','')
??? VLINE( 1.90 , 0.50, 0.30, 1 )
??? VLINE( 2.95 , 0.50, 0.30, 1 )
??? HLINE( 1.90 , 0.50, 0.30, 1 )
??? HLINE( 3.25 , 0.50, 0.30, 1 )
??? VLINE( 1.90 , 4.50, 0.30, 1 )
??? VLINE( 2.95 , 4.50, 0.30, 1 )
??? HLINE( 1.90 , 4.50, 0.30, 1 )
??? HLINE( 3.25 , 4.50, 0.30, 1 )
??? SOFTFONT(roman10)                            && Select 10 point Times-Roman
??? SAYIT( 4.16, 0.65, 'INV DATE','')
??? SAYIT( 4.16, 1.60, 'SALES REP','')
??? SAYIT( 4.16, 2.80, 'ORDER NO.','')
??? SAYIT( 4.16, 4.03, 'ORDER DATE','')
??? SAYIT( 4.16, 5.40, 'SHIP VIA','')
??? SAYIT( 4.16, 6.72, 'TERMS','')
??? SAYIT( 4.76, 0.58, 'QTY ORDER','')
??? SAYIT( 4.76, 1.69, 'QTY SHIP','')
??? SAYIT( 4.76, 2.70, 'ITEM NUMBER/DESCRIPTION','')
??? SAYIT( 4.76, 5.07, 'UNIT','')
??? SAYIT( 4.76, 5.55, 'UNIT PRICE','')
??? SAYIT( 4.76, 6.65, 'AMOUNT','')
??? SAYIT( 8.60, 5.60, 'SALES','')
??? SAYIT( 8.80, 5.60, 'SALES TAX','')
??? SAYIT( 9.00, 5.60, 'FREIGHT','')
??? HLINE( 9.10, 5.50, 2.00, 3 )
??? SAYIT( 9.35, 5.60, 'TOTAL','')

** Remove the following for "real" use
??? INTERNAL(1)                                 && Selects internal Courier 10
??? SAYIT( 10.00, 0.50, 'INVOICE1.PRG - SOFT FONT DEMO','' )

** NOTE: The following uses the DOS copy command
** to copy an image to the printer.  I'm experimenting
** with this and hope to have something in the
** future to allow image management as well.
** Remove unless you like ferrets.

!COPY FERRET.PIC /B &printport /B > NUL               && Prints cute picture

EJECT

** EOF: INVOICE1.PRG
