;     KEYLED.ASM
;     Keven Miller    25 Mar 1993   70732,1340
;     For FOXPRO 2.x
;
;     ** FREEWARE **  Use as you see fit
;
;     Set keyboard LEDS on and/or off
;     Only works on 101 keyboards and 80x86 (286,386)
;
;     Led patterns:  Bit 1  Scrolllock LED
;                    Bit 2  Numlock LED
;                    Bit 3  Capslock LED
;
;     Pass in either ASCII "0" thru "7" or binary 0 thru 7 as 1st char
;     to set leds. Any other char will reset the leds to the current
;     BIOS keyboard flag settings.
;
;     LOAD keyleds
;     m.leds = "1"      && or m.leds = CHR (1)
;     CALL keyleds WITH m.leds
;     RELEASE MODULE keyleds
;
;     To create KEYLED.BIN:
;        MASM keyled,,;
;        LINK keyled/map;
;        EXE2BIN keyled keyled.bin
;
         ORG     0
PROGRAM SEGMENT
         ASSUME  CS:PROGRAM
MYPROC   PROC    FAR
START:
         OR      BX,BX           ; Test for parameter passed
         JZ      EXIT

         PUSH  AX
         PUSH  CX
         PUSH  ES
         MOV   AH,BYTE PTR [BX]  ;Get passed LED pattern
         CMP   AH,'0'            ;  Pattern can be ascii "0" to "7"
         JL    NOTASCII          ;     or binary 0 to 7
         SUB   AH,'0'
NOTASCII:
         CMP   AH,7        ; Range check <= 7
         JG    RESET
         CMP   AH,0        ; Range check >= 0
         JGE   SETLEDS
RESET:
         MOV   AX,40H
         MOV   ES,AX             ;Set ES to BIOS data area
         MOV   AH,ES:BYTE PTR [17H] ;Get current BIOS keyboard flag
         AND   AH,70H            ;Mask out all but CAPSLOCK,NUMLOCK,SCROLL
         SHR   AH,1              ;  bit 6 Capslock, 5 Numlock, 4 Scrolllock
         SHR   AH,1              ;Shift to lower nibble to make
         SHR   AH,1              ;  current LED pattern
         SHR   AH,1
SETLEDS:
         CLI
         MOV   CX,4000H    ;Timeout counter (For non-101 style keyboards)
         MOV   AL,0EDH     ;Keyboard command byte to control leds
         OUT   60H,AL
WAIT:
         IN    AL,64H      ;Wait until keyboard has read it
         TEST  AL,2        ;   bit 2 is Input-buffer-full
         JZ    DONE
         LOOP  WAIT        ;For non-80x86 or non-101 style keyboards
DONE:
         MOV   AL,AH       ;Set LED pattern
         OUT   60H,AL
         STI
         POP   ES
         POP   CX
         POP   AX
EXIT:
         RET
MYPROC   ENDP
PROGRAM  ENDS
         END
