*******************************************************************************
* Program File: CALC.PRG
*
*         DATE: 09/15/1994
*     Revision: 1.0
*      Version: dBASE for Windows 5.0
*       Author: Joseph T. Saturnia, Jr.
*		Kurt C. Saturnia
*		CRC Database Group, Inc.
*		Copyright (c) 1994, All Rights Reserved
*      Example: CALC.PRG
*  Description: Talking Calculator
*******************************************************************************

#define DISPLAYSIZE 12			&& Define maximum display to 12 digits

SET TALK OFF				&& Set TALK OFF

calc = NEW calculator("Calculator")
calc.Open()

CLASS Calculator(name) OF FORM(name)

   this.Width = 25.5
   this.HelpFile = ""
   this.Left = 3
   this.Top = 3
   this.HelpId = ""
   this.Height = 16
   this.MDI = .F.
   this.Menufile = "CALC.MNU"
   this.OnOpen = CLASS::calculator_OnOpen
   this.OnGotFocus = CLASS::calculator_OnGotFocus
   this.OnLostFocus = CLASS::calculator_OnLostFocus
   this.Display = CLASS::calculator_Display
   
   b1  = NEW CALCALLCLEAR(Form, 3, 1,"AC","AC")			&& All clear
   b2  = NEW CALCCLEAR(Form, 3, 7,"CE","CE")			&& Clear entry
   b3  = NEW CALCPERCENT(Form, 3,13,"%","PERCENT")		&& Percent
   b4  = NEW CALCROOT(Form, 3,19,"^","ROOT")			&& Square root
   b5  = NEW CALCMEMORY(Form, 5, 1,"M","MEMORY")		&& Memory
   b6  = NEW CALCMEMMINUS(Form, 5, 7,"M-","MEMMINUS")		&& Memory minus
   b7  = NEW CALCMEMPLUS(Form, 5,13,"M+","MEMPLUS")		&& Memory plus
   b8  = NEW CALCCHANGE(Form, 5,19,"+/-","CHANGE")		&& Change sign
   b9  = NEW CALCNUM(Form, 7, 1,"7","7")			&& 7
   b10 = NEW CALCNUM(Form, 7, 7,"8","8") 			&& 8
   b11 = NEW CALCNUM(Form, 7,13,"9","9") 			&& 9
   b12 = NEW CALCOPER(Form, 7,19,"/","DIVIDE") 			&& Divide
   b13 = NEW CALCNUM(Form, 9, 1,"4","4")			&& 4
   b14 = NEW CALCNUM(Form, 9, 7,"5","5") 			&& 5
   b15 = NEW CALCNUM(Form, 9,13,"6","6") 			&& 6
   b16 = NEW CALCOPER(Form, 9,19,"*","TIMES") 			&& 7
   b17 = NEW CALCNUM(Form,11, 1,"1","1")			&& 1
   b18 = NEW CALCNUM(Form,11, 7,"2","2") 			&& 2
   b19 = NEW CALCNUM(Form,11,13,"3","3") 			&& 3
   b20 = NEW CALCOPER(Form,11,19,"-","MINUS") 			&& -
   b21 = NEW CALCNUM(Form,13, 1,"0","0")			&& 0
   b22 = NEW CALCDECIMAL(Form,13, 7,".","POINT") 		&& Decimal point
   b23 = NEW CALCEQUAL(Form,13,13,"=","EQUAL")			&& =
   b24 = NEW CALCOPER(Form,13,19,"+","PLUS")  			&& +
         
   DEFINE TEXT text1 OF THIS;
       PROPERTY; 
         Width  15,;
         Text "0",;
         Alignment 5,;
         Left 5,;
         Top  1,;
         Height 1,;
         ColorNormal "N/W+"
  

   PROCEDURE Calculator_OnOpen

      this.nTotal = 0				&& Running total
      this.nSubTotal = 0			&& Sub total
      this.lDisplay = .T.			&& New display indicator
      this.nMemory = 0				&& Value in memory
      this.cOperator = "+"			&& Current operator
      this.cButton = ""				&& Last key pressed
      this.nDecimal = -1			&& Number of decimals

   
   PROCEDURE Calculator_OnGotFocus
      this.nOldDecimal = SET("Decimal")

   PROCEDURE Calculator_OnLostFocus
      SET DECIMALS TO this.nOldDecimal

   PROCEDURE Calculator_Display(nDisplay)
      LOCAL n1						&& Counter					
      IF nDisplay >= 10^DISPLAYSIZE			&& If the display value is too large	
         form.text1.text = "ERROR"			&& Display ERROR
         form.nTotal = 0				&& Reset total
         form.nSubTotal = 0				&& Reset subtotal
         form.lDisplay = .T.				&& Indicate new display
         form.nMemory = 0				&& Clear memory
         form.cOperator = "+"				&& Reset current operator
         form.cButton = ""				&& Reset last key pressed
         form.nDecimal = -1				&& Reset number of decimals
      ELSEIF INT(nDisplay) <> nDisplay			&& If number has decimals   
         FOR n1 = DISPLAYSIZE TO 1 STEP -1		&& Find out how many
            IF SUBSTR(STR(nDisplay,DISPLAYSIZE,DISPLAYSIZE),n1,1) <> "0"
               form.text1.text = SUBSTR(STR(nDisplay,DISPLAYSIZE,DISPLAYSIZE),1,n1)
               EXIT
            ENDIF   
         ENDFOR   
      ELSEIF form.nDecimal = 0				&& If decimal point was pressed
         form.text1.text = STR(nDisplay,DISPLAYSIZE-1) + "."
      ELSE   						&& No decimals, update display
         form.text1.text = STR(nDisplay,DISPLAYSIZE)	
      ENDIF
      
ENDCLASS


CLASS CALCKEY(form,top,left,text,filename) OF PUSHBUTTON(form)

   this.Group = .T.
   this.Width = 5.5   
   this.Default = .T.
   this.Text = text
   this.ColorNormal = "N/W*"
   this.Left = left
   this.Top = top
   this.Height = 1.75
   this.Filename = filename
   this.OnClick = CLASS::Playwav		
   
   PROCEDURE playwav				&& Play *.WAV file of key pressed
      IF form.Root.File.Mute.Checked = .F.
         PLAY SOUND FILENAME "SOUND\"+this.filename+".wav"
      ENDIF   
      form.cButton = this.text    		&& Save last button pressed

ENDCLASS         


CLASS CALCOPER(form,top,left,text,filename) OF CALCKEY(form,top,left,text,filename)

   this.OnClick = CLASS::Calcoper_OnClick

   PROCEDURE Calcoper_OnClick
      PRIVATE cOperator
      
      IF form.cButton <> "+" .AND. ;				&& If last key pressed was not
         form.cButton <> "-" .AND. ;				&& +,-,*,/,=,+/-
         form.cButton <> "/" .AND. ;
         form.cButton <> "*" .AND. ;
         form.cButton <> "=" .AND. ;
         form.cButton <> "+/-"
            
         cOperator = form.cOperator				&& Save operator
         form.nTotal = form.nTotal &cOperator. form.nSubTotal	&& Calculate new total
         form.lDisplay = .T.					&& Indicate new display
         form.nDecimal = -1					&& Reset decimals to 0
         form.Display(form.nTotal)				&& Refresh Display
         
      ENDIF
      super::Playwav()						&& Play *.WAV file
      form.cOperator = this.Text				&& Save operator

ENDCLASS


CLASS CALCNUM(form,top,left,text,filename) of CALCKEY(form,top,left,text,filename)

   this.OnClick = class::Calcnum_OnClick

   PROCEDURE Calcnum_OnClick	
      IF form.lDisplay = .T.						&& If the display is new
         IF form.cButton = "="						&& If last operator was =
            form.nTotal = 0						&& Reset total
            form.cOperator = "+"					&& Reset operator
         ENDIF   
         form.lDisplay = .F.						&& Set Display to old
         form.nSubTotal = VAL(this.text)				&& Set subtotal
         form.Display(form.nSubTotal)					&& Refresh Display
      ELSEIF LEN(LTRIM(form.text1.text)) >= DISPLAYSIZE			&& If the display exceeds DISPLAYSIZE characters
         CHR(7)								&& BEEP
         RETURN TO MASTER						
      ELSE   								&& Otherwise, add key to diplay value
         IF form.nDecimal > 0						&& If there are decimals
            form.nSubTotal = VAL(LTRIM(STR(form.nSubTotal,DISPLAYSIZE,form.nDecimal)) + this.Text)         
            form.nDecimal = form.nDecimal + 1
         ELSEIF form.nDecimal = 0					&& If the next digit is the first decimal
            form.nDecimal = form.nDecimal + 1
            form.nSubTotal = VAL(LTRIM(STR(form.nSubTotal,DISPLAYSIZE,0) + "." + this.Text))         
         ELSE								&& Add the digit
            form.nSubTotal = VAL(LTRIM(STR(form.nSubTotal,DISPLAYSIZE,form.nDecimal)) + this.Text)
         ENDIF   
         form.Display(form.nSubTotal)					&& Refresh the display
      ENDIF
      super::Playwav()							&& Play *.WAV file
  
ENDCLASS


CLASS CALCALLCLEAR(form,top,left,text,filename) OF CALCKEY(form,top,left,text,filename)

   this.OnClick = CLASS::CalcAllClear_OnClick
      
   PROCEDURE CalcAllClear_OnClick
      form.nTotal = 0					&& Reset total
      form.nSubTotal = 0				&& Reset subtotal
      form.lDisplay = .T.				&& Indicate new display
      form.nMemory = 0					&& Reset memory
      form.cOperator = "+"				&& Reset operator
      form.cButton = ""					&& Reset last key pressed
      form.nDecimal = -1				&& Rest number of decimals
      form.text1.text = "0"				&& Reset display
      super::Playwav()					&& Play *.WAV file

ENDCLASS
   

CLASS CALCCLEAR(form,top,left,text,filename) OF CALCKEY(form,top,left,text,filename)

   this.OnClick = CLASS::CalcClear_OnClick
   
   PROCEDURE CalcClear_OnClick
      form.nSubTotal = 0				&& Reset subtotal
      form.lDisplay = .T.				&& Indicate new display
      form.nDecimal = -1				&& Reset decimals
      form.text1.text = "0"				&& Reset display
      super::Playwav()					&& Play *.WAV file

ENDCLASS


CLASS CALCPERCENT(form,top,left,text,filename) OF CALCKEY(form,top,left,text,filename)

   this.OnClick = CLASS::CalcPercent_OnClick

   PROCEDURE CalcPercent_OnClick
      PRIVATE cOperator,nOldTotal

      IF form.cButton <> "+" .AND. ;			&& If the last operator was not
         form.cButton <> "-" .AND. ;			&& +,-,*,/,=,+/-
         form.cButton <> "/" .AND. ;
         form.cButton <> "*" .AND. ;
         form.cButton <> "=" .AND. ;
         form.cButton <> "+/-"

         cOperator = form.cOperator			&& Save operator
         nOldTotal = form.nTotal			&& Save total
         form.nTotal = form.nTotal &cOperator. (form.nTotal*(form.nSubTotal/100)) && Calculate new total
         form.nSubTotal = nOldTotal			&& Save subtotal to old total
         form.Display(form.nTotal)			&& Update the display text
         form.lDisplay = .T.				&& indicate new display
         super::Playwav()     				&& Play *.WAV file
      ELSE
         CHR(7)						&& BEEP
      ENDIF   

ENDCLASS


CLASS CALCROOT(form,top,left,text,filename) OF CALCKEY(form,top,left,text,filename)

   this.OnClick = CLASS::CalcRoot_OnClick

   PROCEDURE CalcRoot_OnClick
      
      form.nSubTotal = SQRT(form.nSubTotal) 		&& Calculate subtotal
      form.Display(form.nSubTotal)			&& Update the display text
      form.lDisplay = .T.				&& Indicate new display
      super::Playwav()					&& Play *.WAV file

ENDCLASS


CLASS CALCMEMORY(form,top,left,text,filename) OF CALCKEY(form,top,left,text,filename)

   this.OnClick = CLASS::CalcMemory_OnClick

   PROCEDURE CalcMemory_OnClick
      If form.cButton = this.text			&& If the ast button pressed was MEMORY
         form.nMemory = 0				&& Clear the memory
      ELSE
         form.nSubTotal = form.nMemory 			&& Put memory in the subtotal
         form.Display(form.nSubTotal)			&& Update the display
      ENDIF
      super::Playwav()					&& Play *.WAV file

ENDCLASS


CLASS CALCMEMMINUS(form,top,left,text,filename) OF CALCKEY(form,top,left,text,filename)

   this.OnClick = CLASS::CalcMemMinus_OnClick
   
   PROCEDURE CalcMemMinus_OnClick
      PRIVATE cOperator
      IF form.cButton <> "+" .AND. ;				&& If the last key pressed was not
         form.cButton <> "-" .AND. ;				&& +,-,*,/,=,	
         form.cButton <> "/" .AND. ;
         form.cButton <> "*" .AND. ;
         form.cButton <> "="

         cOperator = form.cOperator				&& Save operator
         form.nTotal = form.nTotal &cOperator. form.nSubTotal	&& Calculate new total
         form.lDisplay = .T.					&& indicate new display 
         form.Display(form.nTotal)				&& Update the display

      ENDIF
      form.nMemory = form.nMemory - form.nTotal			&& Subtract total from memory
      super::Playwav()						&& Play *.WAV file

ENDCLASS   


CLASS CALCMEMPLUS(form,top,left,text,filename) OF CALCKEY(form,top,left,text,filename)

   this.OnClick = CLASS::CalcMemPlus_OnClick
   
   PROCEDURE CalcMemPlus_OnClick
      PRIVATE cOperator
      IF form.cButton <> "+" .AND. ;				&& If the last key pressed was not
         form.cButton <> "-" .AND. ;				&& +,-,*,/,=
         form.cButton <> "/" .AND. ;
         form.cButton <> "*" .AND. ;
         form.cButton <> "="

         cOperator = form.cOperator				&& Save operator
         form.nTotal = form.nTotal&cOperator.form.nSubTotal	&& Calculate new total
         form.lDisplay = .T.					&& Indicate new display 
         form.Display(form.nTotal)				&& Update the display

      ENDIF
      form.nMemory = form.nMemory + form.nTotal			&& Add total to memory
      super::Playwav()						&& Play *.WAV file

ENDCLASS 


CLASS CALCCHANGE(form,top,left,text,filename) OF CALCKEY(form,top,left,text,filename)

   this.OnClick = CLASS::CalcChange_OnClick
    
   PROCEDURE CalcChange_OnClick
      IF form.cButton <> "+".AND. ;			&& If the last key pressed was not
         form.cButton <> "-".AND. ;			&& +,-,/,*,=
         form.cButton <>"/" .AND. ;
         form.cButton <>"*" .AND. ;
         form.cButton <> "="

         form.nSubTotal = form.nSubTotal * -1		&& Change sign of subtotal
         form.Display(form.nSubTotal)			&& Update the display
      ELSE
         form.nTotal = form.nTotal * -1			&& Change sign of total
         form.Display(form.nTotal)			&& Update the display text
      ENDIF   
      super::Playwav()					&& Play*.WAV file

ENDCLASS


CLASS CALCDECIMAL(form,top,left,text,filename) OF CALCKEY(form,top,left,text,filename)

   this.OnClick = CLASS::CalcDecimal_OnClick

   PROCEDURE CalcDecimal_OnClick	
      IF form.nDecimal >= 0 .OR. ;			&& Is there is a decimal point already or
         LEN(LTRIM(form.text1.text)) >= DISPLAYSIZE	&& does the display exceed DISPLAYSIZE
         CHR(7)						&& BEEP
      ELSE 						&& 
         form.lDisplay = .F.				&& Set display to used
         form.nDecimal = form.nDecimal + 1		&& Increment the decimal position
         form.Display(form.nSubTotal)			&& Refresh the display
         super::Playwav()				&& Play *.WAV file
      ENDIF

ENDCLASS


CLASS CALCEQUAL(form,top,left,text,filename) OF CALCKEY(form,top,left,text,filename)

   this.OnClick = CLASS::CalcEqual_OnClick

   PROCEDURE CalcEqual_OnClick
      PRIVATE cOperator

      cOperator = form.cOperator					&& Save operator
      form.nTotal = form.nTotal &cOperator. form.nSubTotal		&& Calculate new total
      form.lDisplay = .T.						&& indocate new display 
      form.nDecimal = -1						&& Reset decimals
      form.Display(form.nTotal)						&& Refresh the display
   
      IF form.Root.File.Answer_only.Checked = .F.			&& If the ANSWER ONLY menu choice is checked
         PlayTotal(VAL(form.text1.text))				&& Play answer
      ENDIF   
      form.cButton = this.text    					&& Save last charater pressed
   
ENDCLASS


PROCEDURE PlayTotal(nValue)

   PRIVATE  cChunk,;			&& *.WAV file data chunk
            nChunkSize,;		&& Size (bytes) of data chunk
            nFile,;			&& File number
            cFilename,;			&& Unique file name
            n1				&& Counter	
           
   cChunk = NEW ARRAY(0)		&& Initialize ARRAY for chunk data
   nChunkSize = 1			&& Set chunk size to 1

   *** Process Billions	
   IF nValue >= 1000000000000						&& If value is >= 1,000,000,000,000
      MakeChunk("ERROR")						&& Play error 	
      RETURN TO MASTER
   ENDIF

   Makechunk("EQUAL")   						&& Equals
   
   IF nValue < 0
      MakeChunk("MINUS")
      nValue = nValue * -1
   ENDIF

   *** Process Billions
   IF nValue >= 1000000000						&& If value is >= 1,000,000,000
   
      IF nValue >= 100000000000						&& Process 100 Billions
         MakeChunk(LTRIM(STR(INT(nValue/100000000000)))) 		&& Create #
         MakeChunk("100") 						&& Create word HUNDRED
         nValue = nValue - (INT(nValue/100000000000)*100000000000)	&& Subtract played value
      ENDIF
   
      IF nValue >= 20000000000    					&& If value >= 20 Billion
         MakeChunk(LTRIM(STR(INT(nValue/10000000000))+"0"))		&& Play 20+ 
            nValue = nValue - (INT(nValue/10000000000)*10000000000)	&& Subtract played value
      ELSEIF nValue >= 11000000000    					&& If value >= 11 Billion
         MakeChunk(LTRIM(STR(INT(nValue/1000000000))))			&& Play teens 
         nValue = nValue - (INT(nValue/1000000000)*1000000000)		&& Subtract played value
      ELSEIF nValue >= 10000000000    					&& If value >= 10 Billion
         MakeChunk("10")						&& Play 10
         nValue = nValue - (INT(nValue/10000000000)*10000000000)	&& Sutract played value
      ENDIF
   
      IF INT(nValue/1000000000) >= 1					&& If value >= 1 Billion
         MakeChunk(LTRIM(STR(INT(nValue/1000000000))))			&& Play 1's
         nValue = nValue - (INT(nValue/1000000000)*1000000000)		&& Sutract played value
      ENDIF
   
      MakeChunk("BILLION") 						&& Create word BILLION
   
   ENDIF
   
   *** Process Millions
   IF nValue >= 1000000							&& If value is >= 1 Million
   
      IF nValue >= 100000000						&& Process 100 Millions
         MakeChunk(LTRIM(STR(INT(nValue/100000000)))) 			&& Create #
         MakeChunk("100") 						&& Create word HUNDRED
         nValue = nValue - (INT(nValue/100000000)*100000000)		&& Subtract played value
      ENDIF
   
      IF nValue >= 20000000    						&& If value >= 20 Million
         MakeChunk(LTRIM(STR(INT(nValue/10000000))+"0"))		&& Play 20+ 
         nValue = nValue - (INT(nValue/10000000)*10000000)		&& Subtract played value
      ELSEIF nValue >= 11000000    					&& If value >= 11 Million
         MakeChunk(LTRIM(STR(INT(nValue/1000000))))			&& Play teens 
         nValue = nValue - (INT(nValue/1000000)*1000000)		&& Subtract played value
      ELSEIF nValue >= 10000000    					&& If value >= 10 million
         MakeChunk("10")						&& Play 10
         nValue = nValue - (INT(nValue/10000000)*10000000)		&& Sutract played value
      ENDIF
   
      IF INT(nValue/1000000) >= 1					&& If value >= 1 million
         MakeChunk(LTRIM(STR(INT(nValue/1000000))))			&& Play 1's
         nValue = nValue - (INT(nValue/1000000)*1000000)		&& Sutract played value
      ENDIF
   
      MakeChunk("MILLION") 						&& Create word MILLION
   
   ENDIF
   
   *** Process Thousands
   IF nValue >= 1000							&& If value is >= 1 Thousand
      
      IF nValue >= 100000						&& Process 100 Thousand
         MakeChunk(LTRIM(STR(INT(nValue/100000)))) 			&& Create #
         MakeChunk("100") 						&& Create word HUNDRED
         nValue = nValue - (INT(nValue/100000)*100000)			&& Subtract played value
      ENDIF
   
   
      IF nValue >= 20000    						&& If value >= 20 Thousand
         MakeChunk(LTRIM(STR(INT(nValue/10000))+"0"))			&& Play 20+ 
         nValue = nValue - (INT(nValue/10000)*10000)			&& Subtract played value
      ELSEIF nValue >= 11000    					&& If value >= 11 Thousand
         MakeChunk(LTRIM(STR(INT(nValue/1000))))			&& Play teens 
         nValue = nValue - (INT(nValue/1000)*1000)			&& Subtract played value
      ELSEIF nValue >= 10000    					&& If value >= 10 Thousand
         MakeChunk("10")						&& Play 10
         nValue = nValue - (INT(nValue/10000)*10000)			&& Sutract played value
      ENDIF
   
      IF INT(nValue/1000) >= 1						&& If value >= 1 Thousand
         MakeChunk(LTRIM(STR(INT(nValue/1000))))			&& Play 1's
         nValue = nValue - (INT(nValue/1000)*1000)			&& Sutract played value
      ENDIF
   
      MakeChunk("THOUSAND") 						&& Create word THOUSAND
   
   ENDIF
   
   *** Process Hundreds
   IF nValue >= 1							&& If value is >= 1 
   
      IF nValue >= 100							&& Process 100
         MakeChunk(LTRIM(STR(INT(nValue/100)))) 			&& Create #
         MakeChunk("100") 						&& Create word HUNDRED
         nValue = nValue - (INT(nValue/100)*100)			&& Subtract played value
      ENDIF

      IF nValue >= 20    						&& If value >= 20 
         MakeChunk(LTRIM(STR(INT(nValue/10))+"0"))			&& Play 20+ 
         nValue = nValue - (INT(nValue/10)*10)				&& Subtract played value
      ELSEIF nValue >= 11    						&& If value >= 11 
         MakeChunk(LTRIM(STR(INT(nValue))))				&& Play teens 
         nValue = nValue - INT(nValue)					&& Subtract played value
      ELSEIF nValue >= 10    						&& If value >= 10
         MakeChunk("10")						&& Play 10
         nValue = nValue - (INT(nValue/10)*10)				&& Sutract played value
      ENDIF

      IF INT(nValue) >= 1						&& If value >= 1
         MakeChunk(LTRIM(STR(INT(nValue))))				&& Play 1's
         nValue = nValue - INT(nValue)					&& Sutract played value
      ENDIF

   ENDIF

   *** Process Decimals
   IF nValue <> 0							&& If value is <> 0 
      MakeChunk("POINT")						&& Create "POINT"
      FOR n1 = DISPLAYSIZE TO 2 STEP -1					&& Search for the last nonzero
         IF SUBSTR(STR(nValue,DISPLAYSIZE,DISPLAYSIZE),n1,1) <> "0"	&& digit. 
            nDecimal = n1 - 1						
            EXIT
         ENDIF   
      ENDFOR   
      FOR n1 = nDecimal TO 1 STEP -1 					
          MakeChunk(SUBSTR(LTRIM(STR(nValue,DISPLAYSIZE,nDecimal)),;	  && Process digits		
                    LEN(LTRIM(STR(nValue,DISPLAYSIZE,nDecimal)))+1-n1,1)) && Create #
      ENDFOR
   ENDIF


   cFilename = FUNIQUE("CALC????.WAV")					&& Make unique *.WAV file name
   nFile = FCREATE(cFilename)						&& Create file for writing
   FWRITE(nFile,"RIFF"+CHR(MOD(nChunkSize+38,256))+;			&& Write *.WAV file header
          CHR(MOD(INT((nChunkSize+38)/256),256))+;			&& Calculate data chunk size
          CHR(MOD(INT((nChunkSize+38)/(256^2)),256))+;
          CHR(0)+"WAVEfmt "+CHR(16)+CHR(0)+CHR(0)+;
          CHR(0)+CHR(1)+CHR(0)+CHR(1)+;
          CHR(0)+CHR(17)+CHR(43)+CHR(0)+;
          CHR(0)+CHR(17)+CHR(43)+CHR(0)+CHR(0)+;
          CHR(1)+CHR(0)+CHR(8)+CHR(0)+"data"+;
          CHR(MOD(nChunkSize,256))+;					&& Calculate data chunk size
          CHR(MOD(INT(nChunkSize/256),256))+;
          CHR(MOD(INT(nChunkSize/(256^2)),256))+CHR(0))

   FOR x = 1 TO ALEN(cChunk,0)						&& Write data chunks to file
      FWRITE(nFile,cChunk[x])
   ENDFOR
   FCLOSE(nFile)							&& Close File
   
   PLAY SOUND FILENAME &cFilename					&& Play newly created file	
   DELETE FILE &cFilename						&& Delete file

   RETURN

PROCEDURE MakeChunk(cWavFilename)   
   LOCAL nFile

   AGROW(cChunk,1)							&& Insert a row in the array

   nFile = FOPEN("SOUND\"+cWavFilename+".WAV")				&& Open designated *.WAV file
   FSEEK(nFile,44)							&& Skip header
   cChunk[ALEN(cChunk)] = FREAD(nFile,32677)				&& Read data into variable
   cChunk[ALEN(cChunk)] = SUBSTR(cChunk[ALEN(cChunk)],1,;		&& Remove character at end of file
                          LEN(cChunk[ALEN(cChunk)])-1)
   FCLOSE(nFile)							&& Close the file
   nChunkSize = nChunksize + LEN(cChunk[ALEN(cChunk)])			&& Set the size of the data chunk
   RETURN
  
