*:*************************************************************************
*:
*:      Program: JOBS.PRG
*:
*:       System: Job Search - Version 2.0
*:       Author: R. J. Kovach
*:
*:*************************************************************************
*:       Copyright (C) 1993, R.J. Kovach & Assoc.    ALL RIGHTS RESERVED
*:*************************************************************************
*:
*:       System: Runs with dBase III Plus and Foxpro version 2.0 and later.
*:
*:        Calls: PROGTYPE (procedure in JOBEDIT.PRG)
*:             : NEWRECORD (procedure in JOBADD.PRG)
*:             : DUPLICATE (procedure in JOBADD.PRG)
*:             : EDITDATA (procedure in JOBEDIT.PRG)
*:             : REPORTS (procedure in JOBREP.PRG)
*:             : SUMMARY (procedure in JOBUTIL.PRG)
*:             : BACKUP (procedure in JOBUTIL.PRG)
*:             : DBINDX (procedure in JOBUTIL.PRG)
*:             : PACKDB (procedure in JOBUTIL.PRG)
*:             : UTILITIES (procedure in JOBUTIL.PRG)
*:
*: Memory Files: SETUP.MEM
*:
*: Binary Files: TWENTY.BIN   (Reserves twenty files)
*:
*: Documented: 4/23/93
*: Revised:    6/01/93
*:
*: Revision History:
*:    Rev. 2.0 : Major rewrite of code.  Adapted to run on Foxpro
*:
*:*************************************************************************


CLEAR ALL
CLEAR
LOAD twenty.bin
CALL twenty
SET STATUS OFF
SET TALK OFF
SET BELL OFF
SET ESCAPE ON
SET SAFETY OFF
SET EXACT OFF
ON ESCAPE DO stopret
PUBLIC mono, mono2, mono3, mcolor, mcolor2, mcolor3
PUBLIC mcolor4, mcolor5, mcolor6, mcolor7, monitor, moniprnt, monidb
STORE ' ' to monidb
@  7,24 SAY 'J O B  S E A R C H   P R O G R A M'
@ 10,35 SAY 'Version 2.0 '
@ 13,23 SAY '(C) 1993, R. J. Kovach & Associates'
@ 14,26 SAY '     ALL RIGHTS RESERVED'
RESTORE FROM setup
IF monidb = 'D'
   @ 16,32 SAY 'dBase III Version'
ENDIF
IF monidb = 'F'
   @ 16,34 SAY 'Foxpro Version'
ENDIF
IF monidb <> 'D'
   IF monidb <> 'F'
      @ 16,5 SAY 'CAUTION: Not configured for a database, run Setup before continuing.'
      @ 18,0
      WAIT
   ENDIF
ENDIF
@  5,21 TO 18,60 DOUBLE
@ 24,78 SAY ' '
STORE 1 TO x
IF monidb = 'D'
   DO WHILE x < 500
      x = x + 1
      LOOP
   ENDDO
ELSE
   DO WHILE x < 5000
      x = x + 1
      LOOP
   ENDDO
ENDIF

SET PROCEDURE TO jobrep.prg
DO register
CLOSE PROCEDURE

mono    = "W/N,N/W,N,N"
mono2   = "W*/N,N/W,N,N"
mono3   = "W+/N,N/W,N,N"
mcolor  = "G+/B,N/R,B"
mcolor2 = "BG+/B,N/R,B"
mcolor3 = "R+/B,N/R,B"
mcolor4 = "RB+/B,N/R,B"
mcolor5 = "GR+/B,N/R,B"
mcolor6 = "W+/B,BG/R,B,B"
* mcolor6 = "W+/B,GR+BG,B,B"
mcolor7 = "R+*/B,N/R,B"
SET FUNCTION 2 TO ' '
SET FUNCTION 3 TO ' '
SET FUNCTION 4 TO ' '
SET FUNCTION 5 TO ' '
SET FUNCTION 6 TO ' '
SET FUNCTION 7 TO ' '
SET FUNCTION 8 TO ' '
SET FUNCTION 9 TO ' '
* SET FUNCTION 3 TO CHR(13)+'Latest Year Organized:          Owner Change Date:         '+CHR(13)+'State of Incorporation:         Date of Incorporation:       '+CHR(13)+'Annual Sales Revision Date:          '+CHR(13)
* SET FUNCTION 4 TO CHR(13)+'                        LATEST            TREND             BASE'+CHR(13)+'                          YEAR             YEAR             YEAR'+CHR(13)+'                                          (19  )           (19  )'+CHR(13)
* SET FUNCTION 5 TO CHR(13)+'Sales               $                $                $          '+CHR(13)+'Employees Total               '+CHR(13)+'Employees Here         '+CHR(13)
* SET FUNCTION 6 TO CHR(13)+'  Sales Growth:         Net Worth:                '+CHR(13)+'  Employment Growth:         '+CHR(13)
* SET FUNCTION 7 TO CHR(13)+'Square Footage:'+CHR(13)+'Sales Territory:                  Number of Accounts:'+CHR(13)+'Accounting Firm:'+CHR(13)+'Bank: '+CHR(13)
SET PROCEDURE TO jobedit.prg
IF monitor = "C"
   SET COLOR TO &mcolor
ELSE
   SET COLOR TO &mono
ENDIF
STORE " " TO type
STORE " " TO type1
STORE " " TO type2

DO progtype

DO WHILE .T.
   CLEAR
   IF monitor = 'C'
      SET COLOR TO &mcolor2
   ENDIF
   @ 3,4 TO 20,76
   @ 1,22 TO 3,58 DOUBLE
   @ 7,5 TO 7,75
   IF monitor = 'C'
      SET COLOR TO &mcolor3
   ENDIF
   @ 2,5 SAY DATE()
   @ 2,68 SAY TIME()
   IF monitor = 'C'
      SET COLOR TO &mcolor2
   ENDIF
   @ 2,26 SAY 'M A I N   M E N U  -  J O B S'
   IF monitor = 'C'
      SET COLOR TO &mcolor
   ENDIF
   @ 5,21 SAY '1> Change Database, Currently - '
   IF monitor = 'C'
      SET COLOR TO &mcolor4
   ENDIF
   @ 5,53 SAY type1
   @ 6,46 SAY RECCOUNT()
   IF monitor = 'C'
      SET COLOR TO &mcolor
   ENDIF
   @  6,57 SAY 'records'
   @  9,10 SAY '2> Add New Records              6> File Backup'
   @ 12,10 SAY '3> Edit or Delete Records       7> Reindex all databases'
   @ 15,10 SAY '4> Print Reports                8> Remove Deleted Records (Pack)'
   @ 18,10 SAY '5> Summaries                    9> Setup & Utilities'
   IF monitor = 'C'
      SET COLOR TO &mcolor5
   ENDIF
   @ 21,0 SAY ' '
   WAIT '                          Pick a number, type Q to Quit  ' TO choice

   DO CASE
   CASE choice = '1'
      DO progtype
      CLEAR
   CASE choice = '2'
      CLOSE PROCEDURE
      SET PROCEDURE TO jobadd.prg
      DO newrecord
      CLOSE PROCEDURE
      SET PROCEDURE TO jobedit.prg
      CLEAR
   CASE UPPER(choice) = 'D'
      CLOSE PROCEDURE
      SET PROCEDURE TO jobadd.prg
      DO duplicate
      CLOSE PROCEDURE
      SET PROCEDURE TO jobedit.prg
      CLEAR
   CASE choice = '3'
      DO editdata
      CLEAR
   CASE choice = '4'
      CLOSE PROCEDURE
      SET PROCEDURE TO jobrep.prg
      DO reports
      CLOSE PROCEDURE
      SET PROCEDURE TO jobedit.prg
      CLEAR
   CASE choice = '5'
      CLOSE PROCEDURE
      SET PROCEDURE TO jobutil.prg
      DO summary
      CLOSE PROCEDURE
      SET PROCEDURE TO jobedit.prg
      CLEAR
   CASE choice = '6'
      CLOSE PROCEDURE
      SET PROCEDURE TO jobutil.prg
      DO backup
      CLOSE PROCEDURE
      SET PROCEDURE TO jobedit.prg
      CLEAR
   CASE choice = '7'
      CLOSE PROCEDURE
      SET PROCEDURE TO jobutil.prg
      DO dbindx
      CLOSE PROCEDURE
      SET PROCEDURE TO jobedit.prg
      CLEAR
   CASE choice = '8'
      CLOSE PROCEDURE
      SET PROCEDURE TO jobutil.prg
      DO packdb
      CLOSE PROCEDURE
      SET PROCEDURE TO jobedit.prg
      CLEAR
   CASE choice = '9'
      CLOSE PROCEDURE
      SET PROCEDURE TO jobutil.prg
      DO utilities
      IF monitor = 'C'
         SET COLOR TO &mcolor5
      ELSE
         SET COLOR TO &mono
      ENDIF
      CLOSE PROCEDURE
      SET PROCEDURE TO jobedit.prg
      CLEAR
   CASE UPPER(choice) = 'Q'
      CLEAR
      IF monitor = 'C'
         SET COLOR TO &mcolor2
      ENDIF
      @ 4,4 TO 13,76
      IF monitor = 'C'
         SET COLOR TO &mcolor
      ENDIF
      @ 6,28 SAY 'Return to:'
      @ 8,33 SAY '1> Operating System (DOS)'
      IF monidb = 'F'
         @ 10,33 SAY '2> Foxpro System'
      ELSE
         @ 10,33 SAY '2> dBase System'
      ENDIF
      IF monitor = 'C'
         SET COLOR TO &mcolor5
      ENDIF
      @ 15,15 SAY ' '
      WAIT '               Pick a number or type Q to return to the Main Menu  ' TO choice2
      DO CASE
      CASE choice2 = '1'
         SET STATUS ON
         CLEAR
         CLEAR ALL
         QUIT
      CASE choice2 = '2'
         SET STATUS ON
         SET TALK ON
         SET SAFETY ON
         SET ESCAPE ON
         SET EXACT ON
         IF monitor = 'C'
            SET COLOR TO &mcolor6
         ENDIF
         IF monidb = 'F'
            SET FUNCTION 2 TO 'SET'+CHR(13)
         ELSE
            SET FUNCTION 2 TO 'ASSIST'+CHR(13)
         ENDIF
         SET FUNCTION 3 TO 'LIST'
         SET FUNCTION 4 TO 'DIR'
         SET FUNCTION 5 TO 'DISPLAY STRUCTURE'+CHR(13)
         SET FUNCTION 6 TO 'DISPLAY STATUS'+CHR(13)
         SET FUNCTION 7 TO 'DISPLAY MEMORY'+CHR(13)
         SET FUNCTION 8 TO 'DISPLAY'+CHR(13)
         SET FUNCTION 9 TO 'APPEND'+CHR(13)
         CLEAR
         CLEAR ALL
         CLOSE PROCEDURE
         RETURN
      CASE UPPER(choice) = 'Q'
         CLEAR
         LOOP
      ENDCASE
   ENDCASE
ENDDO


*: EOF: JOBS.PRG
