***************************************************************************
*:
*:      Program: JOBEDIT.PRG
*:
*:       System: Job Search - Version 2.0
*:       Author: R. J. Kovach
*:
*:*************************************************************************
*:       Copyright (C) 1993, R.J. Kovach & Assoc.    ALL RIGHTS RESERVED
*:*************************************************************************
*:
*:Procs & Fncts: PROGTYPE       Selects databases
*:             : EDITDATA       Edit record menu
*:             : RECORDUPD      Edit entire record
*:             : SIZEUPD        Edit size fields (company database only)
*:             : PICK           Pick company for edit
*:             : CONTACT        Edit contact fields (company database only)
*:             : FOLLOWUP       Edit followup fields (company database only)
*:             : STATUSUPD      Edit status fields (company database only)
*:             : BROWSEDB       Browse database
*:             : RECDELETE      Delete a record
*:             : DELMSG
*:             : COMPDEL        Screen for company records to be deleted
*:             : NETDEL         Screen for network records to be deleted
*:             : SRCHDEL        Screen for execsrch or tempsrch records to be deleted
*:             : NOTVALID       Not valid message
*:             : STOPRET        Returns to previous menu after pressing Esc
*:
*:      Formats: COMPANY.FMT
*:             : NETWORK.FMT
*:             : SIZE.FMT
*:             : CONTACT.FMT
*:             : FOLLOWUP.FMT
*:             : STATUS.FMT
*:             : EXECSRCH.FMT
*:             : TEMPSRCH.FMT
*:             : JOBEXPEN.FMT
*:
*:      Filters:
*:             :
*:         Uses: COMPANY.DBF
*:             : NETWORK.DBF
*:             : EXECSRCH.DBF
*:             : TEMPSRCH.DBF
*:             : JOBEXPEN.DBF
*:
*:   Memo files: COMPANY.DBT
*:             : NETWORK.DBT
*:             : EXECSRCH.DBT
*:             : TEMPSRCH.DBT
*:
*:      Indexes: DIVISION.NDX
*:             : NETWORK.NDX
*:             : EXECNAME.NDX
*:             : TEMPNAME.NDX
*:             : JOBEXPEN.NDX
*:             : SICNO.NDX
*:
*:       Set by: JOBS.PRG
*:
*: Documented: 4/23/93
*: Revised:    6/01/93
*:*************************************************************************


*******************
PROCEDURE progtype
*******************

DO WHILE .T.
   CLEAR
   CLOSE DATABASES
   IF monitor = 'C'
      SET COLOR TO &mcolor3
   ENDIF
   @2,19 SAY 'Choose a Database:'
   IF monitor = 'C'
      SET COLOR TO &mcolor
   ENDIF
   @5,23 SAY 'C> Company Database'
   @ 8,23 SAY 'E> Executive Search Firm Database'
   @11,23 SAY 'N> Network Database'
   @14,23 SAY 'T> Temporary Placement Firm Database'
   @17,23 SAY 'J> Job Hunting Expenses'
   IF monitor = 'C'
      SET COLOR TO &mcolor2
   ENDIF
   @19,0 SAY ' '
   WAIT '                Choose C, E, N, T or J  ' TO choice
   DO CASE
      CASE UPPER(choice) = 'C'
         STORE 'C' TO type
         STORE 'Company' TO type1
         SELECT 1
         USE company INDEX division
         RETURN
      CASE UPPER(choice) = 'E'
         STORE 'E' To type
         STORE 'Executive Search' TO type1
         SELECT 3
         USE execsrch INDEX execname
         RETURN
      CASE UPPER(choice) = 'N'
         STORE 'N' TO type
         STORE 'Network' TO type1
         SELECT 2
         USE network INDEX network
         RETURN
      CASE UPPER(choice) = 'T'
         STORE 'T' TO type
         STORE 'Temporary Placement' TO type1
         SELECT 4
         USE tempsrch INDEX tempname
         RETURN
      CASE UPPER(choice) = 'J'
         STORE 'J' TO type
         STORE 'Job Hunting Expenses' TO type1
         SELECT 5
         USE jobexpen INDEX jobexpen
         RETURN
   ENDCASE
ENDDO


******************
PROCEDURE editdata
******************

CLEAR
CLEAR GETS
DO WHILE .T.
   CLEAR
   IF monitor = 'C'
      SET COLOR TO &mcolor2
   ENDIF
   @ 3,4 TO 19,76
   @ 1,19 TO 3,61 DOUBLE
   IF monitor = 'C'
      SET COLOR TO &mcolor3
   ENDIF
   @ 2,5 SAY DATE()
   @ 2,68 SAY TIME()
   IF monitor = 'C'
      SET COLOR TO &mcolor2
   ENDIF
   @ 2,22 SAY 'E D I T   o r   D E L E T E   M E N U'
   IF monitor = 'C'
      SET COLOR TO &mcolor
   ENDIF
   @ 5,25 SAY '1> Edit Entire Record'
   @ 7,25 SAY '2> Edit Size, SIC Code & Product Information'
   @ 9,25 SAY '3> Edit Contact Information'
   @ 11,25 SAY '4> Edit Followup Dates'
   @ 13,25 SAY '5> Edit Status & Comments'
   @ 15,25 SAY '6> Browse the Database'
   @ 17,25 SAY '7> Delete a Record (mark for deletion)'
   IF monitor = 'C'
      SET COLOR TO &mcolor5
   ENDIF
   @ 21,0 SAY ' '
   WAIT '                        Pick a number or type Q to Quit  ' TO choice
   IF monitor = 'C'
      SET COLOR TO &mcolor
   ENDIF

   DO CASE
      CASE choice = '1'
         DO recordupd
      CASE choice = '2'
         IF type = 'C'
            DO sizeupd
         ELSE
            DO notvalid
         ENDIF
      CASE choice = '3'
         IF type = 'C'
            DO contact
         ELSE
            DO notvalid
         ENDIF
      CASE choice = '4'
         IF type = 'C'
            DO followup
         ELSE
            DO notvalid
         ENDIF
      CASE choice = '5'
         IF type = 'C'
            DO statusupd
         ELSE
            DO notvalid
         ENDIF
      CASE choice = '6'
         DO browsedb
      CASE choice = '7'
         DO recdelete
      CASE UPPER(choice) = 'Q'
         RETURN TO MASTER
   ENDCASE
ENDDO


*******************
PROCEDURE recordupd
*******************

CLEAR GETS
IF type = 'C'
   SELECT 1
   USE company INDEX division
   CLEAR
   SET FORMAT TO company
   DO WHILE .NOT. EOF()
      @ 23,5 SAY ' '
      ACCEPT '            Enter the division to be edited or press [Esc] to quit:  ' TO div
      ON ESCAPE DO stopret
      IF monidb = 'D'
         SEEK UPPER(div)
      ELSE
         SEEK UPPER(div)
      ENDIF
      IF FOUND()
         CHANGE
         IF EOF()
            ? 'No additional records found.'
            WAIT
            GO TOP
            CLOSE FORMAT
            RETURN
         ENDIF
      ELSE
         ?
         ? 'This division is not in the file'
         WAIT
         CLEAR
         GO TOP
         LOOP
      ENDIF
   ENDDO
ENDIF
IF type = 'N'
      SELECT 2
      USE network INDEX network
      CLEAR
      SET FORMAT TO network
      DO WHILE .NOT. EOF()
         @ 23,5 SAY ' '
         ACCEPT '            Enter the last name to be edited or press [Esc] to quit:  ' TO lst
         ON ESCAPE DO stopret
         SEEK lst
         IF FOUND()
            CHANGE
            IF EOF()
               ? 'No additional records found.'
               WAIT
               GO TOP
               CLOSE FORMAT
               RETURN
            ENDIF
         ELSE
            ?
            ? 'This name is not in the file'
            WAIT
            CLEAR
            GO TOP
            LOOP
         ENDIF
      ENDDO
ENDIF
IF type = 'E'
   SELECT 3
   USE execsrch INDEX execname
   CLEAR
   SET FORMAT TO execsrch
   DO WHILE .NOT. EOF()
      @ 23,5 SAY ' '
      ACCEPT '            Enter the name to be edited or press [Esc] to quit:  ' TO nam
      ON ESCAPE DO stopret
      SEEK nam
      IF FOUND()
         CHANGE
         IF EOF()
            ? 'No additional records found.'
            WAIT
            GO TOP
            CLOSE FORMAT
            RETURN
         ENDIF
      ELSE
         ?
         ? 'This name is not in the file'
         WAIT
         CLEAR
         GO TOP
         LOOP
      ENDIF
   ENDDO
ENDIF
IF type = 'T'
   SELECT 4
   USE tempsrch INDEX tempname
   CLEAR
   SET FORMAT TO tempsrch
   DO WHILE .NOT. EOF()
      @ 23,5 SAY ' '
      ACCEPT '            Enter the name to be edited or press [Esc] to quit:  ' TO nam
      ON ESCAPE DO stopret
      SEEK nam
      IF FOUND()
         CHANGE
         IF EOF()
            ? 'No additional records found.'
            WAIT
            GO TOP
            CLOSE FORMAT
            RETURN
         ENDIF
      ELSE
         ?
         ? 'This name is not in the file'
         WAIT
         CLEAR
         GO TOP
         LOOP
      ENDIF
   ENDDO
ELSE
   SELECT 5
   USE jobexpen INDEX jobexpen
   CLEAR
   SET FORMAT TO jobexpen
   DO WHILE .NOT. EOF()
      @ 23,5 SAY ' '
      ACCEPT '    Enter the date in the form '+CHR(34)+'mm/dd/yy'+CHR(34)+' or press [Esc] to quit:  ' TO nam
      ON ESCAPE DO stopret
      SEEK CTOD(nam)
      IF FOUND()
         CHANGE
         IF EOF()
            ? 'No additional records found.'
            WAIT
            GO TOP
            CLOSE FORMAT
            RETURN
         ENDIF
      ELSE
         ?
         ? 'This date is not in the file'
         WAIT
         CLEAR
         GO TOP
         LOOP
      ENDIF
   ENDDO
ENDIF


*****************
PROCEDURE sizeupd
*****************

CLEAR GETS
SELECT 1
USE company INDEX division
CLEAR
SET FORMAT TO SIZE
DO PICK
RETURN TO MASTER


**************
PROCEDURE pick
**************

DO WHILE .NOT. EOF()
   @ 23,5 SAY ' '
   ACCEPT '            Enter the division to be edited or press [Esc] to quit:  ' TO div
   ON ESCAPE DO stopret
   SEEK UPPER(div)
   IF FOUND()
      CHANGE
      IF EOF()
         ? 'No additional orders found.'
         WAIT
         GO TOP
         CLOSE FORMAT
         RETURN
      ENDIF
   ELSE
      ?
      ? 'This division is not in the file'
      WAIT
      CLEAR
      GO TOP
      LOOP
   ENDIF
ENDDO


*****************
PROCEDURE contact
*****************

CLEAR GETS
SELECT 1
USE company INDEX division
CLEAR
SET FORMAT TO CONTACT
DO PICK
RETURN TO MASTER


******************
PROCEDURE followup
******************

CLEAR GETS
SELECT 1
USE company INDEX division
CLEAR
SET FORMAT TO FOLLOWUP
DO PICK
RETURN TO MASTER


*******************
PROCEDURE statusupd
*******************

CLEAR GETS
SELECT 1
USE company INDEX division
CLEAR
SET FORMAT TO STATUS
DO PICK
RETURN TO MASTER


******************
PROCEDURE browsedb
******************

CLEAR GETS
IF type = 'C'
   SELECT 1
   USE company INDEX division
ELSE
   IF type = 'N'
      SELECT 2
      USE network INDEX network
   ELSE
      IF type = 'E'
         SELECT 3
         USE execsrch INDEX execname
      ELSE
         IF type = 'T'
            SELECT 4
            USE tempsrch INDEX tempname
         ELSE
            SELECT 5
            USE jobexpen INDEX jobexpen
         ENDIF
      ENDIF
   ENDIF
ENDIF
CLEAR
BROWSE
RETURN


*******************
PROCEDURE recdelete
*******************

STORE ' ' TO ans
CLEAR GETS
IF type = 'C'
   SELECT 1
   USE company INDEX division
   CLEAR
   DO WHILE .NOT. EOF()
      @ 22,5 SAY ' '
      ACCEPT '            Enter the division to be deleted or press [Esc] to quit:  ' TO div
      ON ESCAPE DO stopret
      IF monidb = 'D'
         SEEK UPPER(div)
      ELSE
         SEEK UPPER(div)
      ENDIF
      IF FOUND()
         DO compdel
         DO fbyn
      ELSE
         ?
         ? 'This division is not in the file'
         WAIT
         CLEAR
         GO TOP
         LOOP
      ENDIF
   ENDDO
ENDIF
IF type = 'N'
   SELECT 2
   USE network INDEX network
   CLEAR
   DO WHILE .NOT. EOF()
      @ 22,5 SAY ' '
      ACCEPT '            Enter the last name to be deleted or press [Esc] to quit:  ' TO lst
      ON ESCAPE DO stopret
      SEEK lst
      IF FOUND()
         DO netdel
         DO fbyn
      ELSE
         ?
         ? 'This name is not in the file'
         WAIT
         CLEAR
         GO TOP
         LOOP
      ENDIF
   ENDDO
ENDIF
IF type = 'J'
   SELECT 5
   USE jobexpen INDEX jobexpen
   CLEAR
   STORE ' ' to dat
   DO WHILE .NOT. EOF()
      @ 22,5 SAY ' '
      ACCEPT '  Enter the date for deletion in the form '+CHR(34)+'mm/dd/yy'+CHR(34)+' or press [Esc] to quit:  ' TO dat
      ON ESCAPE DO stopret
      SEEK CTOD(dat)
      IF FOUND()
         DO expendel
         DO fbyn
      ELSE
         ?
         ? 'This date is not in the file'
         WAIT
         CLEAR
         GO TOP
         LOOP
      ENDIF
   ENDDO
ELSE
   IF type = 'E'
      SELECT 3
      USE execsrch INDEX execname
   ELSE
      SELECT 4
      USE tempsrch INDEX tempname
   ENDIF
   CLEAR
   DO WHILE .NOT. EOF()
      @ 22,5 SAY ' '
      ACCEPT '             Enter the name to be deleted or press [Esc] to quit:  ' TO nam
      ON ESCAPE DO stopret
      SEEK nam
      IF FOUND()
         DO srchdel
         DO fbyn
      ELSE
         ?
         ? 'This name is not in the file'
         WAIT
         CLEAR
         GO TOP
         LOOP
      ENDIF
   ENDDO
ENDIF


**************
PROCEDURE fbyn
**************

DO WHILE .T.
   @ 23,0
   @ 24,0
   DO delmsg
   DO case
      CASE UPPER(ans) = 'D'
         @ 23,0
         IF DELETED()
            RECALL
            @ 23,27 SAY 'This record is now restored.                 '
         ELSE
            DELETE
            @ 23,22 SAY 'This record is now marked for deletion.      '
         ENDIF
         WAIT
         @24,0
         RETURN
      CASE UPPER(ans) = 'Q'
         RETURN TO MASTER
      CASE UPPER(ans) = 'F'
         SKIP
         STORE ' ' TO ans
         IF EOF()
            ? 'No additional records found.'
            WAIT
            GO TOP
            RETURN
         ENDIF
         IF type = 'C'
            DO compdel
         ELSE
            IF type = 'N'
               DO netdel
            ELSE
               IF type = 'E'
                  DO srchdel
               ELSE
                  IF type = 'T'
                     DO srchdel
                  ENDIF
               ENDIF
            ENDIF
         ENDIF
         DO delmsg
      CASE UPPER(ans) = 'B'
         SKIP -1
         IF BOF()
            ? 'No additional records found.'
            WAIT
            GO TOP
            RETURN
         ENDIF
         IF type = 'C'
            DO compdel
         ENDIF
         IF type = 'N'
            DO netdel
         ENDIF
         IF type = 'E'
            DO srchdel
         ENDIF
         IF type = 'T'
            DO srchdel
         ENDIF
         DO delmsg
   ENDCASE
ENDDO


****************
PROCEDURE delmsg
****************

STORE ' ' TO ans
IF DELETED()
   @23, 5 SAY 'This record is marked for deletion.  Do you wish to restore it (Y/N) ? ' GET ans
   READ
   IF UPPER(ans) = 'Y'
      STORE 'D' TO ans
      RETURN
   ELSE
      STORE 'Q' TO ans
   ENDIF
ELSE
   @23,20 SAY 'Forward / Back / Delete / Quit (F/B/D/Q) ?  ' GET ans
ENDIF
READ
RETURN


*****************
PROCEDURE compdel
*****************

@ 1,1 TO 21,78 DOUBLE
@  2,32 SAY "Company Prospect"
@  4,4  SAY "Division"
@  4,43 SAY "Company"
@  5,4  SAY "Address"
@  6,4  SAY "City"
@  6,40 SAY "State"
@  6,52 SAY "Zip"
@  8,4  SAY "Phone"
@  8,29 SAY "Division Sales"
@  8,51 SAY "million"
@  8,61 SAY "Employees"
@ 10,4  SAY "Sq ft"
@ 10,23 SAY "Acres"
@ 10,35 SAY "Year Established"
@ 10,59 SAY "DUNS #"
@ 12,4  SAY "SIC Code1"
@ 12,22 SAY "SIC Code2"
@ 12,40 SAY "SIC Code3"
@ 12,58 SAY "SIC Code4"
@ 14,4  SAY "Product"
@ 15,14 SAY "Mr/Ms"
@ 15,20 SAY "First"
@ 15,36 SAY "Last"
@ 15,51 SAY "Sr/Jr"
@ 15,58 SAY "Title"
@ 16,4  SAY "Contact"
@ 18,4  SAY "Init Cont"
@ 18,24 SAY "F-up-1"
@ 18,41 SAY "F-up-2"
@ 18,58 SAY "F-up-3"
@ 20,4  SAY "Info Source"
@ 20,43 SAY "Target Firm"
IF monitor = 'C'
   SET COLOR TO &mcolor6
ELSE
   SET COLOR TO &mono3
ENDIF
@  4,14 SAY Division PICTURE "XXXXXXXXXXXXXXXXXXXXXXXXX"
@  4,52 SAY Company PICTURE "XXXXXXXXXXXXXXXXXXXXXXXXX"
@  5,14 SAY Address PICTURE "XXXXXXXXXXXXXXXXXXXXXXXXX"
@  6,14 SAY City PICTURE "!XXXXXXXXXXXXXXXXXXX"
@  6,47 SAY State PICTURE "!!"
@  6,57 SAY Zip PICTURE "99999X9999"
@  8,14 SAY Phone PICTURE "@R (999)999-9999"
@  8,44 SAY Sales PICTURE "99999.9"
@  8,71 SAY Employees PICTURE "999999"
@ 10,13 SAY Sq_ft PICTURE "999,999"
@ 10,29 SAY Acres PICTURE "999"
@ 10,52 SAY Establish PICTURE "9999"
@ 10,66 SAY Duns PICTURE "@R 99-999-9999"
@ 12,15 SAY Code1 PICTURE "9999"
@ 12,33 SAY Code2 PICTURE "9999"
@ 12,51 SAY Code3 PICTURE "9999"
@ 12,69 SAY Code4 PICTURE "9999"
@ 14,12 SAY Product PICTURE "!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
@ 16,15 SAY  Mr_Ms PICTURE "!XX"
@ 16,20 SAY  Contfirst PICTURE "!XXXXXXXXXXXXX"
@ 16,36 SAY  Contlast  PICTURE "!XXXXXXXXXXXXX"
@ 16,52 SAY  Sr_Jr PICTURE "!XX"
@ 16,57 SAY  Title PICTURE "!XXXXXXXXXXXXXXXXXXX"
@ 18,14 SAY Init_cont
@ 18,31 SAY Followup1
@ 18,48 SAY Followup2
@ 18,65 SAY Followup3
@ 20,16 SAY Source PICTURE "XXXXXXXXXXXXXXXXXXXXXXXXX"
@ 20,56 SAY Target PICTURE "!"
IF monitor = 'C'
   SET COLOR TO &mcolor
ELSE
   SET COLOR TO &mono
ENDIF
RETURN



****************
PROCEDURE netdel
****************

@  2,  1  TO 20, 77
@  3, 32  SAY "Network Database"
@  5,  5  SAY "First"
@  5, 32  SAY "Last"
@  7,  5  SAY "Title"
@  9,  5  SAY "Company"
@ 10,  5  SAY "Address"
@ 11,  5  SAY "City"
@ 11, 38  SAY "State"
@ 11, 51  SAY "Zip"
@ 13,  5  SAY "Phone"
@ 13, 30  SAY "Priority"
@ 13, 42  SAY "(A, B or C)"
@ 13, 56  SAY "Reference"
@ 13, 69  SAY "(Y, N)"
@ 15,  5  SAY "Init_Cont"
@ 15, 28  SAY "Followup1"
@ 15, 51  SAY "Followup2"
@ 18,  5  SAY "Position"
IF monitor = 'C'
   SET COLOR TO &mcolor6
ELSE
   SET COLOR TO &mono3
ENDIF
@  5, 14  SAY  NETWORK->FIRST
@  5, 38  SAY  NETWORK->LAST
@  7, 14  SAY  NETWORK->TITLE
@  9, 14  SAY  NETWORK->COMPANY
@ 10, 14  SAY  NETWORK->ADDRESS
@ 11, 14  SAY  NETWORK->CITY
@ 11, 45  SAY  NETWORK->STATE PICTURE "!!"
@ 11, 56  SAY  NETWORK->ZIP PICTURE "99999X9999"
@ 13, 14  SAY  NETWORK->PHONE PICTURE "@R (999)999-9999"
@ 13, 40  SAY  NETWORK->PRIORITY PICTURE "!"
@ 13, 67  SAY  NETWORK->REFERENCE PICTURE "!"
@ 15, 16  SAY  NETWORK->INIT_CONT
@ 15, 39  SAY  NETWORK->FOLLOWUP1
@ 15, 62  SAY  NETWORK->FOLLOWUP2
@ 18, 14  SAY  NETWORK->SITUATION
IF monitor = 'C'
   SET COLOR TO &mcolor
ELSE
   SET COLOR TO &mono
ENDIF
RETURN


*****************
PROCEDURE srchdel
*****************

@  1,  2  TO 21, 78
IF type = 'E'
   @  2, 29  SAY "Executive Search Firms"
ELSE
   @  2, 27  SAY "Temporary Placement Firms"
ENDIF
@  4,  4  SAY "Name"
@  6,  4  SAY "Address1"
@  7,  4  SAY "Address2"
@  8,  4  SAY "City"
@  8, 39  SAY "State"
@  8, 53  SAY "Zip"
@ 10,  4  SAY "Phone"
@ 10, 33  SAY "Retainer firm, Contingency or Both (R/C/B)"
@ 12, 14  SAY "Mr/Ms"
@ 12, 20  SAY "First"
@ 12, 36  SAY "Last"
@ 12, 51  SAY "Sr/Jr"
@ 12, 58  SAY "Title"
@ 13,  4  SAY "Contact"
@ 15,  4  SAY "Init Cont"
@ 15, 28  SAY "Followup1"
@ 15, 52  SAY "Followup2"
@ 17,  4  SAY "Specialty"
@ 19,  4  SAY "Industry 1"
@ 19, 23  SAY "Industry 2"
@ 19, 42  SAY "Industry 3"
@ 19, 61  SAY "Industry 4"
IF monitor = 'C'
   SET COLOR TO &mcolor6
ELSE
   SET COLOR TO &mono3
ENDIF
@  4, 15  SAY  NAME PICTURE "!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
@  6, 15  SAY  ADDRESS1
@  7, 15  SAY  ADDRESS2
@  8, 15  SAY  CITY PICTURE "!XXXXXXXXXXXXXXXXXXX"
@  8, 46  SAY  STATE PICTURE "!!"
@  8, 58  SAY  ZIP PICTURE "99999X9999"
@ 10, 15  SAY  PHONE PICTURE "@R (999)999-9999"
@ 10, 76  SAY  FIRM_TYPE PICTURE "!"
@ 13, 15  SAY  MR_MS PICTURE "!XX"
@ 13, 20  SAY  CONTFIRST PICTURE "!XXXXXXXXXXXXX"
@ 13, 36  SAY  CONTLAST  PICTURE "!XXXXXXXXXXXXX"
@ 13, 52  SAY  SR_JR PICTURE "!XX"
@ 13, 57  SAY  TITLE PICTURE "!XXXXXXXXXXXXXXXXXXX"
@ 15, 15  SAY  INIT_CONT
@ 15, 39  SAY  FOLLOWUP1
@ 15, 63  SAY  FOLLOWUP2
@ 17, 15  SAY  SPECIALTY PICTURE "!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
@ 19, 16  SAY  INDUS1
@ 19, 35  SAY  INDUS2
@ 19, 54  SAY  INDUS3
@ 19, 73  SAY  INDUS4
IF monitor = 'C'
   SET COLOR TO &mcolor
ELSE
   SET COLOR TO &mono
ENDIF
RETURN


******************
PROCEDURE expendel
******************

@  4,  1  TO 22, 77 DOUBLE
@  5, 30  SAY "Job Hunting Expenses"
@  7,  5  SAY "Date"
@  7, 12  GET  JOBEXPEN->date PICTURE "99/99/99"
@  9, 16  SAY "Codes for the "+CHR(34)+"Type"+CHR(34)+" field:"
@ 10,  5  SAY "Type"
@ 10, 12  GET  JOBEXPEN->type PICTURE "!"
@ 10, 18  SAY "L = Lodging"
@ 11, 18  SAY "M = Meals"
@ 12, 18  SAY "A = Auto expenses (mileage, parking & tolls)"
@ 13, 18  SAY "T = Transportation (Air, train, taxi, limo, etc.)"
@ 14, 18  SAY "P = Postage & Stationery"
@ 15, 18  SAY "O = All other"
@ 17,  5  SAY "Amount"
@ 17, 12  GET  JOBEXPEN->amount PICTURE "99999.99"
@ 17, 40  SAY "Miles"
@ 17, 47  GET  JOBEXPEN->miles PICTURE "99999"
@ 19,  5  SAY "Description"
@ 19, 18  GET  JOBEXPEN->descript PICTURE "!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"


******************
PROCEDURE notvalid
******************

CLEAR
@ 10,18 SAY 'This function is not valid for this database.'
@ 12,20 SAY 'Only available for the Company database.'
@ 15,14 SAY ' '
WAIT
RETURN


*****************
PROCEDURE stopret
*****************

CLOSE FORMAT
* DO editdata
RETURN TO MASTER


*: EOF: JOBEDIT.PRG

