***************************************************************************
*:
*:      Program: JOBADD.PRG
*:
*:       System: Job Search - Version 2.0
*:       Author: R. J. Kovach
*:
*:*************************************************************************
*:       Copyright (C) 1993, R.J. Kovach & Assoc.    ALL RIGHTS RESERVED
*:*************************************************************************
*:
*:Procs & Fncts: NEWRECORD      Append new record
*:             : COMPCLEAR      Clear company database memory variables
*:             : COADD          Add new company record
*:             : COMPADD        Screen format for new company record
*:             : NETCLEAR       Clear network database memory variables
*:             : NTADD          Add new network record
*:             : NETADD         Screen format for new network record
*:             : EXECCLEAR      Clear execsrch or tempsrch database memory var
*:             : EXADD          Add new execsrch or tempsrch records
*:             : EXECADD        Screen format for new execsrch or tempsrch record
*:             : JOBCLEAR       Clear the jobexpen database memory variables
*:             : JOBADD         Add new jobexpen record
*:             : JOBADD         Screen format for new jobexpen record
*:             : MEMOADD        Add a memo to a new record
*:             : DUPLICATE      Create duplicate record
*:             : DUPLIC         Duplicate record screen
*:             : STOPRET        Returns to previous menu after pressing Esc
*:
*:      Formats:
*:
*:      Filters:
*:             :
*:         Uses: COMPANY.DBF
*:             : NETWORK.DBF
*:             : EXECSRCH.DBF
*:             : TEMPSRCH.DBF
*:             : JOBEXPEN.DBF
*:
*:   Memo files: COMPANY.DBT
*:             : NETWORK.DBT
*:             : EXECSRCH.DBT
*:             : TEMPSRCH.DBT
*:
*:      Indexes: DIVISION.NDX
*:             : NETWORK.NDX
*:             : EXECNAME.NDX
*:             : TEMPNAME.NDX
*:             : JOBEXPEN.NDX
*:             : SICNO.NDX
*:
*:       Set by: JOBS.PRG
*:
*: Documented: 4/23/93
*: Revised:    6/01/93
*:*************************************************************************


*******************
PROCEDURE newrecord
*******************

STORE " " TO enter
CLEAR GETS
CLEAR
IF type = 'C'
   SELECT 1
   USE company
   GO BOTTOM
   SKIP -4
   ?
   ? 'Most recent records. . . .'
   ?
   DISPLAY OFF NEXT 5 division, company, code1
   ?
ENDIF
IF type = 'N'
   SELECT 2
   USE network
   GO BOTTOM
   SKIP -4
   ?
   ? 'Most recent records. . . .'
   ?
   DISPLAY OFF NEXT 5 first, last, phone
   ?
ENDIF
IF type = 'E'
   SELECT 3
   USE execsrch
   GO BOTTOM
   SKIP -4
   ?
   ? 'Most recent records. . . .'
   ?
   DISPLAY OFF NEXT 5 name, contfirst, contlast
   ?
ENDIF
IF type = 'T'
   SELECT 4
   USE tempsrch
   GO BOTTOM
   SKIP -4
   ?
   ? 'Most recent records. . . .'
   ?
   DISPLAY OFF NEXT 5 name, contfirst, contlast
   ?
ENDIF
IF type = 'J'
   SELECT 5
   USE jobexpen
   GO BOTTOM
   SKIP -4
   ?
   ? 'Most recent records. . . .'
   ?
   DISPLAY OFF NEXT 5 date, type, amount, miles, descript
   ?
ENDIF

@24,10 SAY '        Do you want to enter new records? (Y/N) ' GET enter
READ
IF UPPER(enter)<> 'Y'
   RETURN
ENDIF
IF type = 'C'
   DO compclear
   DO coadd
   RETURN
ENDIF
IF type = 'N'
   DO netclear
   DO ntadd
   RETURN
ENDIF
IF type = 'E'
   DO execclear
   DO exadd
   RETURN
ENDIF
IF type = 'T'
   DO execclear
   DO exadd
   RETURN
ELSE
   DO jobclear
   DO jbadd
   RETURN
ENDIF


*******************
PROCEDURE compclear
*******************

PUBLIC mans, mdivision, mcompany, maddress, mcity, mstate, mzip, mphone, msales
PUBLIC memploy, msqft, macres, mestab, mduns, mcode1, mcode2, mcode3, mcode4
PUBLIC mproduct, mtarget, mmrms, mcontfst, mcontlst, msrjr, mtitle, minitcont
PUBLIC mfollow1, mfollow2, mfollow3, msource, mdirmail, mstatus
CLEAR
SELECT 1
STORE ' ' TO mans
USE company INDEX division
STORE SPACE(25) TO mdivision
STORE SPACE(25) TO mcompany
STORE SPACE(25) TO maddress
STORE SPACE(20) TO mcity
STORE SPACE(2)  TO mstate
STORE SPACE(10) TO mzip
STORE SPACE(10) TO mphone
STORE 0.0 TO msales
STORE 0 TO memploy
STORE 0 TO msqft
STORE 0 TO macres
STORE SPACE(4)  TO mestab
STORE SPACE(9)  TO mduns
STORE SPACE(4)  TO mcode1
STORE SPACE(4)  TO mcode2
STORE SPACE(4)  TO mcode3
STORE SPACE(4)  TO mcode4
STORE SPACE(65) TO mproduct
STORE SPACE(1)  TO mtarget
STORE "Mr."     TO mmrms
STORE SPACE(14) TO mcontfst
STORE SPACE(14) TO mcontlst
STORE SPACE(3)  TO msrjr
STORE SPACE(20) TO mtitle
STORE '  /  /  ' TO minitcont
STORE '  /  /  ' TO mfollow1
STORE '  /  /  ' TO mfollow2
STORE '  /  /  ' TO mfollow3
STORE SPACE(25) TO msource
STORE SPACE(1)  TO mdirmail
STORE SPACE(28) TO mstatus
RETURN


***************
PROCEDURE coadd
***************

DO WHILE .T.
   DO compadd
   READ
   STORE 'S' to mans
   @24,15 SAY 'Save New Company ? (Save/Edit again/Cancel) 'GET mans PICTURE '!'
   READ SAVE
   DO WHILE .NOT. mans $ 'SEC'
      ?? CHR(7)
      READ SAVE
   ENDDO
   @24,0
   CLEAR GETS
   IF mans = 'E'
      CLEAR
      LOOP
   ENDIF
   IF mans = 'C'
      CLEAR
      RETURN
   ELSE
      @24,0
      @24,20 SAY '*****  Updating Company File  *****'
      APPEND BLANK
      REPLACE division WITH mdivision, company WITH mcompany, address WITH maddress
      REPLACE city WITH mcity, state WITH mstate, zip WITH mzip
      REPLACE phone WITH mphone, sales WITH msales, employees WITH memploy
      REPLACE sq_ft WITH msqft, acres WITH macres, establish WITH mestab
      REPLACE duns WITH mduns, code1 WITH mcode1, code2 WITH mcode2
      REPLACE code3 WITH mcode3, code4 WITH mcode4, product WITH mproduct
      REPLACE mr_ms WITH mmrms, contfirst WITH mcontfst, contlast WITH mcontlst
      REPLACE sr_jr WITH msrjr, title WITH mtitle, init_cont WITH CTOD(minitcont)
      REPLACE followup1 WITH CTOD(mfollow1), followup2 WITH CTOD(mfollow2), followup3 WITH CTOD(mfollow3)
      REPLACE source WITH msource, dir_mail WITH mdirmail, status WITH mstatus
      DO memoadd
      STORE 'Y' to mans
      @24,0
      @24,23 SAY 'Enter another record ? (Y/N) ' GET mans PICTURE '!'
      READ SAVE
      DO WHILE .NOT. mans $ 'YN'
         ?? CHR(7)
         READ SAVE
      ENDDO
      @24,0
      CLEAR GETS
      IF mans = 'Y'
         CLEAR
         DO compclear
         LOOP
      ELSE
         RETURN
      ENDIF
   ENDIF
ENDDO


*****************
PROCEDURE compadd
*****************

@ 1,1 TO 23,78 DOUBLE
@  2,32 SAY "Company Prospect"
@  4,4  SAY "Division"
@  4,14 GET mdivision PICTURE "!XXXXXXXXXXXXXXXXXXXXXXXX"
@  4,43 SAY "Company"
@  4,52 GET mcompany PICTURE "!XXXXXXXXXXXXXXXXXXXXXXXX"
@  5,4  SAY "Address"
@  5,14 GET maddress PICTURE "XXXXXXXXXXXXXXXXXXXXXXXXX"
@  6,4  SAY "City"
@  6,14 GET mcity PICTURE "!XXXXXXXXXXXXXXXXXXX"
@  6,40 SAY "State"
@  6,47 GET mstate PICTURE "!!"
@  6,52 SAY "Zip"
@  6,57 GET mzip PICTURE "XXXXXXXXXX"
@  8,4  SAY "Phone"
@  8,14 GET mphone PICTURE "@R (999)999-9999"
@  8,29 SAY "Division Sales"
@  8,44 GET msales PICTURE "99999.9"
@  8,51 SAY "million"
@  8,61 SAY "Employees"
@  8,71 GET memploy PICTURE "999999"
@ 10,4  SAY "Sq ft"
@ 10,13 GET msqft PICTURE "999,999"
@ 10,23 SAY "Acres"
@ 10,29 GET macres PICTURE "999"
@ 10,35 SAY "Year Established"
@ 10,52 GET mestab PICTURE "9999"
@ 10,59 SAY "DUNS #"
@ 10,66 GET mduns PICTURE "@R 99-999-9999"
@ 12,4  SAY "SIC Code1"
@ 12,15 GET mcode1 PICTURE "9999"
@ 12,22 SAY "SIC Code2"
@ 12,33 GET mcode2 PICTURE "9999"
@ 12,40 SAY "SIC Code3"
@ 12,51 GET mcode3 PICTURE "9999"
@ 12,58 SAY "SIC Code4"
@ 12,69 GET mcode4 PICTURE "9999"
@ 14,4  SAY "Product"
@ 14,12 GET mproduct PICTURE "!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
@ 15,14 SAY "Mr/Ms"
@ 15,20 SAY "First"
@ 15,36 SAY "Last"
@ 15,51 SAY "Sr/Jr"
@ 15,58 SAY "Title"
@ 16, 4 SAY "Contact"
@ 16,15 GET  mmrms PICTURE "!XX"
@ 16,20 GET  mcontfst PICTURE "!XXXXXXXXXXXXX"
@ 16,36 GET  mcontlst  PICTURE "!XXXXXXXXXXXXX"
@ 16,52 GET  msrjr PICTURE "!XX"
@ 16,57 GET  mtitle PICTURE "!XXXXXXXXXXXXXXXXXXX"
@ 18,4  SAY "Init Cont"
@ 18,14 GET minitcont PICTURE '99/99/99'
@ 18,24 SAY "F-up-1"
@ 18,31 GET mfollow1  PICTURE '99/99/99'
@ 18,41 SAY "F-up-2"
@ 18,48 GET mfollow2  PICTURE '99/99/99'
@ 18,58 SAY "F-up-3"
@ 18,65 GET mfollow3  PICTURE '99/99/99'
@ 20,4  SAY "Info Source"
@ 20,16 GET msource PICTURE "XXXXXXXXXXXXXXXXXXXXXXXXX"
@ 20,43 SAY "Target Firm"
@ 20,56 GET mtarget PICTURE "!"
@ 22,4  SAY "Direct Mail"
@ 22,16 GET mdirmail PICTURE "!"
@ 22,24 SAY "Status"
@ 22,32 GET mstatus PICTURE "XXXXXXXXXXXXXXXXXXXXXXXXXXXX"
RETURN


******************
PROCEDURE netclear
******************

PUBLIC mans, mfirst, mlast, mtitle, mcompany, maddress, mcity, mstate
PUBLIC mzip, mphone, mpriority, mrefer, minitcont, mfollow1, mfollow2, msituatn
CLEAR
SELECT 2
STORE ' ' TO mans
USE network INDEX network
STORE SPACE(12) TO mfirst
STORE SPACE(15) TO mlast
STORE SPACE(20) TO mtitle
STORE SPACE(30) TO mcompany
STORE SPACE(30) TO maddress
STORE SPACE(20) TO mcity
STORE SPACE(2)  TO mstate
STORE SPACE(10) TO mzip
STORE SPACE(10) TO mphone
STORE SPACE(1)  TO mpriority
STORE SPACE(1)  TO mrefer
STORE '  /  /  ' TO minitcont
STORE '  /  /  ' TO mfollow1
STORE '  /  /  ' TO mfollow2
STORE SPACE(60) TO msituatn
RETURN


***************
PROCEDURE ntadd
***************

DO WHILE .T.
   DO netadd
   READ
   STORE 'S' to mans
   @24,15 SAY 'Save New Network Name ? (Save/Edit again/Cancel) 'GET mans PICTURE '!'
   READ SAVE
   DO WHILE .NOT. mans $ 'SEC'
      ?? CHR(7)
      READ SAVE
   ENDDO
   @24,0
   CLEAR GETS
   IF mans = 'E'
      CLEAR
      LOOP
   ENDIF
   IF mans = 'C'
      CLEAR
      RETURN
   ELSE
      @24,0
      @24,20 SAY '*****  Updating Network File  *****'
      APPEND BLANK
      REPLACE first WITH mfirst, last WITH mlast, title WITH mtitle
      REPLACE company WITH mcompany, address WITH maddress
      REPLACE city WITH mcity, state WITH mstate, zip WITH mzip
      REPLACE phone WITH mphone, priority WITH mpriority, reference WITH mrefer
      REPLACE init_cont WITH CTOD(minitcont), followup1 WITH CTOD(mfollow1), followup2 WITH CTOD(mfollow2)
      REPLACE situation WITH msituatn
      DO memoadd
      STORE 'Y' to mans
      @24,0
      @24,23 SAY 'Enter another record ? (Y/N) ' GET mans PICTURE '!'
      READ SAVE
      DO WHILE .NOT. mans $ 'YN'
         ?? CHR(7)
         READ SAVE
      ENDDO
      @24,0
      CLEAR GETS
      IF mans = 'Y'
         CLEAR
         DO netclear
         LOOP
      ELSE
         RETURN
      ENDIF
   ENDIF
ENDDO


****************
PROCEDURE netadd
****************

@  2,  1  TO 22, 77    DOUBLE
@  3, 28  SAY "Network Database"
@  5,  5  SAY "First"
@  5, 14  GET  mfirst PICTURE '!XXXXXXXXXXX'
@  5, 32  SAY "Last"
@  5, 38  GET  mlast PICTURE '!XXXXXXXXXXXXXX'
@  7,  5  SAY "Title"
@  7, 14  GET  mtitle PICTURE '!XXXXXXXXXXXXXXXXXXX'
@  9,  5  SAY "Company"
@  9, 14  GET  mcompany PICTURE '!XXXXXXXXXXXXXXXXXXXXXXXXXXXXX'
@ 10,  5  SAY "Address"
@ 10, 14  GET  maddress PICTURE 'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'
@ 11,  5  SAY "City"
@ 11, 14  GET  mcity PICTURE '!XXXXXXXXXXXXXXXXXXX'
@ 11, 38  SAY "State"
@ 11, 45  GET  mstate PICTURE "!!"
@ 11, 51  SAY "Zip"
@ 11, 56  GET  mzip PICTURE "XXXXXXXXXX"
@ 13,  5  SAY "Phone"
@ 13, 14  GET  mphone PICTURE "@R (999)999-9999"
@ 13, 30  SAY "Priority"
@ 13, 40  GET  mpriority PICTURE "!"
@ 13, 42  SAY "(A, B or C)"
@ 13, 56  SAY "Reference"
@ 13, 67  GET  mrefer PICTURE "!"
@ 13, 69  SAY "(Y, N)"
@ 15,  5  SAY "Init_Cont"
@ 15, 16  GET  minitcont PICTURE '99/99/99'
@ 15, 28  SAY "Followup1"
@ 15, 39  GET  mfollow1 PICTURE '99/99/99'
@ 15, 51  SAY "Followup2"
@ 15, 62  GET  mfollow2 PICTURE '99/99/99'
@ 18,  5  SAY "Position"
@ 18, 15  GET  msituatn PICTURE 'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'
RETURN


*******************
PROCEDURE execclear
*******************

PUBLIC mans, mname, maddr1, maddr2, mcity, mstate, mzip, mphone, mmrms
PUBLIC mcontfst, mcontlst, msrjr, mtitle, minitcont, mfollow1, mfollow2
PUBLIC mspec, mindus1, mindus2, mindus3, mindus4, mprosp, mfirmtp
CLEAR
IF type = 'E'
   SELECT 3
   USE execsrch INDEX execname
ELSE
   SELECT 4
   USE tempsrch INDEX tempname
ENDIF
STORE ' ' TO mans
STORE SPACE(45) TO mname
STORE SPACE(30) TO maddr1
STORE SPACE(30) TO maddr2
STORE SPACE(20) TO mcity
STORE SPACE(2)  TO mstate
STORE SPACE(10) TO mzip
STORE SPACE(10) TO mphone
STORE SPACE(1)  TO mfirmtp
STORE 'Mr.'     TO mmrms
STORE SPACE(14) TO mcontfst
STORE SPACE(14) TO mcontlst
STORE SPACE(3)  TO msrjr
STORE SPACE(20) TO mtitle
STORE '  /  /  ' TO minitcont
STORE '  /  /  ' TO mfollow1
STORE '  /  /  ' TO mfollow2
STORE SPACE(60) TO mspec
STORE SPACE(4)  TO mindus1
STORE SPACE(4)  TO mindus2
STORE SPACE(4)  TO mindus3
STORE SPACE(4)  TO mindus4
STORE SPACE(1)  TO mprosp
RETURN


***************
PROCEDURE exadd
***************

DO WHILE .T.
   DO execadd
   READ
   STORE 'S' to mans
   IF type = 'E'
      @24,12 SAY 'Save New Executive Search Firm ? (Save/Edit again/Cancel) 'GET mans PICTURE '!'
   ELSE
      @24,12 SAY 'Save New Temporary Search Firm ? (Save/Edit again/Cancel) 'GET mans PICTURE '!'
   ENDIF
   READ SAVE
   DO WHILE .NOT. mans $ 'SEC'
      ?? CHR(7)
      READ SAVE
   ENDDO
   @24,0
   CLEAR GETS
   IF mans = 'E'
      CLEAR
      LOOP
   ENDIF
   IF mans = 'C'
      CLEAR
      RETURN
   ELSE
      @24,0
      @24,23 SAY '*****  Updating Search Firm File  *****'
      APPEND BLANK
      REPLACE name WITH mname, address1 WITH maddr1, address2 WITH maddr2
      REPLACE city WITH mcity, state WITH mstate, zip WITH mzip
      REPLACE phone WITH mphone, mr_ms WITH mmrms, contfirst WITH mcontfst
      REPLACE contlast WITH mcontlst, sr_jr WITH msrjr, title WITH mtitle
      REPLACE init_cont WITH CTOD(minitcont), firm_type WITH mfirmtp
      REPLACE followup1 WITH CTOD(mfollow1), followup2 WITH CTOD(mfollow2)
      REPLACE specialty WITH mspec, indus1 WITH mindus1, indus2 WITH mindus2
      REPLACE indus3 WITH mindus3, indus4 WITH mindus4, prospect WITH mprosp
      DO memoadd
      STORE 'Y' to mans
      @24,0
      @24,23 SAY 'Enter another record ? (Y/N) ' GET mans PICTURE '!'
      READ SAVE
      DO WHILE .NOT. mans $ 'YN'
         ?? CHR(7)
         READ SAVE
      ENDDO
      @24,0
      CLEAR GETS
      IF mans = 'Y'
         CLEAR
         DO execclear
         LOOP
      ELSE
         RETURN
      ENDIF
   ENDIF
ENDDO


*****************
PROCEDURE execadd
*****************

@  1,  2  TO 22, 78 DOUBLE
IF type = 'E'
   @  2, 29  SAY "Executive Search Firm"
ELSE
   @  2, 29  SAY "Temporary Search Firm"
ENDIF
@  4,  4  SAY "Name"
@  4, 15  GET  mname PICTURE "!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
@  6,  4  SAY "Address1"
@  6, 15  GET  maddr1 PICTURE "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
@  7,  4  SAY "Address2"
@  7, 15  GET  maddr2 PICTURE "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
@  8,  4  SAY "City"
@  8, 15  GET  mcity PICTURE "!XXXXXXXXXXXXXXXXXXX"
@  8, 39  SAY "State"
@  8, 46  GET  mstate PICTURE "!!"
@  8, 53  SAY "Zip"
@  8, 58  GET  mzip PICTURE "XXXXXXXXXX"
@ 10,  4  SAY "Phone"
@ 10, 15  GET  mphone PICTURE "@R (999)999-9999"
@ 10, 33  SAY "Retainer firm, Contingency or Both (R/C/B)"
@ 10, 76  GET  mfirmtp PICTURE "!"
@ 12, 14  SAY "Mr/Ms"
@ 12, 20  SAY "First"
@ 12, 36  SAY "Last"
@ 12, 51  SAY "Sr/Jr"
@ 12, 58  SAY "Title"
@ 13,  4  SAY "Contact"
@ 13, 15  GET  mmrms PICTURE "!XX"
@ 13, 20  GET  mcontfst PICTURE "!XXXXXXXXXXXXX"
@ 13, 36  GET  mcontlst PICTURE "!XXXXXXXXXXXXX"
@ 13, 52  GET  msrjr PICTURE "!XX"
@ 13, 57  GET  mtitle PICTURE "!XXXXXXXXXXXXXXXXXXX"
@ 15,  4  SAY "Init Cont"
@ 15, 15  GET  minitcont PICTURE "99/99/99"
@ 15, 28  SAY "Followup1"
@ 15, 39  GET  mfollow1 PICTURE "99/99/99"
@ 15, 52  SAY "Followup2"
@ 15, 63  GET  mfollow2 PICTURE "99/99/99"
@ 17,  4  SAY "Specialty"
@ 17, 15  GET  mspec PICTURE "!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
@ 19,  4  SAY "Industry 1"
@ 19, 16  GET  mindus1
@ 19, 23  SAY "Industry 2"
@ 19, 35  GET  mindus2
@ 19, 42  SAY "Industry 3"
@ 19, 54  GET  mindus3
@ 19, 61  SAY "Industry 4"
@ 19, 73  GET  mindus4
@ 21, 62  SAY "Job Prospect"
@ 21, 76  GET  mprosp PICTURE "!"
RETURN


******************
PROCEDURE jobclear
******************

PUBLIC mans, mdate, mtype, mamount, mmiles, mdescrip
CLEAR
USE jobexpen INDEX jobexpen
STORE ' ' TO mans
STORE '  /  /  ' TO mdate
STORE SPACE(1)   TO mtype
STORE 0 TO mamount
STORE 0 TO mmiles
STORE SPACE(40)  TO mdescrip
RETURN


***************
PROCEDURE jbadd
***************

DO WHILE .T.
   DO jobadd
   READ
   STORE 'S' to mans
   @24,15 SAY 'Save Job Hunting Expense ? (Save/Edit again/Cancel) 'GET mans PICTURE '!'
   READ SAVE
   DO WHILE .NOT. mans $ 'SEC'
      ?? CHR(7)
      READ SAVE
   ENDDO
   @24,0
   CLEAR GETS
   IF mans = 'E'
      CLEAR
      LOOP
   ENDIF
   IF mans = 'C'
      CLEAR
      RETURN
   ELSE
      @24,0
      @24,19 SAY '*****  Updating Job Hunting Expense File  *****'
      APPEND BLANK
      REPLACE date WITH CTOD(mdate), type WITH mtype, amount WITH mamount
      REPLACE miles WITH mmiles, descript WITH mdescrip
      STORE 'Y' to mans
      @24,0
      @24,23 SAY 'Enter another record ? (Y/N) ' GET mans PICTURE '!'
      READ SAVE
      DO WHILE .NOT. mans $ 'YN'
         ?? CHR(7)
         READ SAVE
      ENDDO
      @24,0
      CLEAR GETS
      IF mans = 'Y'
         CLEAR
         DO jobclear
         LOOP
      ELSE
         RETURN
      ENDIF
   ENDIF
ENDDO


****************
PROCEDURE jobadd
****************

@  4,  1  TO 22, 77 DOUBLE
@  5, 30  SAY "Job Hunting Expenses"
@  7,  5  SAY "Date"
@  7, 12  GET  mdate PICTURE "99/99/99"
@  9, 16  SAY "Codes for the "+CHR(34)+"Type"+CHR(34)+" field:"
@ 10,  5  SAY "Type"
@ 10, 12  GET  mtype PICTURE "!"
@ 10, 18  SAY "L = Lodging"
@ 11, 18  SAY "M = Meals"
@ 12, 18  SAY "A = Auto expenses (mileage, parking & tolls)"
@ 13, 18  SAY "T = Transportation (Air, train, taxi, limo, etc.)"
@ 14, 18  SAY "P = Postage & Stationery"
@ 15, 18  SAY "O = All other"
@ 17,  5  SAY "Amount"
@ 17, 12  GET  mamount PICTURE "99999.99"
@ 17, 40  SAY "Miles"
@ 17, 47  GET  mmiles PICTURE "99999"
@ 19,  5  SAY "Description"
@ 19, 18  GET  mdescrip PICTURE "!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
RETURN


*****************
PROCEDURE memoadd
*****************

STORE 'N' TO mans
@ 24,0
@ 24,20 SAY 'Enter Comments (memos) now ? (Y/N) ' GET mans PICTURE '!'
READ SAVE
DO WHILE .NOT. mans $ 'YN'
   ?? CHR(7)
   READ SAVE
ENDDO
@24,0
CLEAR GETS
IF mans = 'N'
   RETURN
ELSE
   @ 1,1 GET comments
   EDIT FIELDS comments
   RETURN
ENDIF


*******************
PROCEDURE duplicate
*******************

IF type = 'N'
   CLEAR
   @ 10,5 SAY 'Duplicate record function is not valid for the Network database'
   @ 15,5 SAY ' '
   WAIT
   RETURN
ENDIF
IF type = 'E'
   CLEAR
   @ 10,1 SAY 'Duplicate record function is not valid for the Executive Search database'
   @ 15,5 SAY ' '
   WAIT
   RETURN
ENDIF
IF type = 'T'
   CLEAR
   @ 10,1 SAY 'Duplicate record function is not valid for the Temporary Placement database'
   @ 15,5 SAY ' '
   WAIT
   RETURN
ENDIF

STORE " " TO enter
STORE 0 TO xsize, xemp
CLEAR GETS
CLEAR
SELECT 1
USE company INDEX division
CLEAR
SET FORMAT TO company
DO WHILE .NOT. EOF()
   @ 24,0
   ACCEPT '         Enter the division to be duplicated or press [Esc] to quit:  ' TO div
   ON ESCAPE DO stopret
   SEEK UPPER(div)
   IF FOUND()
      DO DUPLIC
      @ 23,0
      WAIT SPACE(20)+'Duplicate this order?  <Y>es, <N>o, <Q>uit  ' TO enter
      IF UPPER(enter) = 'Y'
         xdiv    = division
         xcomp   = company
         xadd    = address
         xcity   = city
         xstate  = state
         xzip    = zip
         xphone  = phone
         xsales  = sales
         xempl   = employees
         xsqft   = sq_ft
         xacres  = acres
         xestab  = establish
         xduns   = duns
         xsic1   = code1
         xsic2   = code2
         xsic3   = code3
         xsic4   = code4
         xprod   = product
         xcont   = contact
         xtitle  = title
         xinit   = init_cont
         xfu1    = followup1
         xfu2    = followup2
         xfu3    = followup3
         xsource = source
         xpros   = prospect
         xstat   = status

         APPEND BLANK
         REPLACE division   WITH xdiv
         REPLACE company    WITH xcomp
         REPLACE address    WITH xadd
         REPLACE city       WITH xcity
         REPLACE state      WITH xstate
         REPLACE zip        WITH xzip
         REPLACE phone      WITH xphone
         REPLACE code1      WITH xsic1
         REPLACE code2      WITH xsic2
         REPLACE code3      WITH xsic3
         REPLACE code4      WITH xsic4
         REPLACE duns       WITH xduns
         REPLACE sales      WITH xsales
         REPLACE employees  WITH xempl
         REPLACE sq_ft      WITH xsqft
         REPLACE acres      WITH xacres
         REPLACE establish  WITH xestab
         REPLACE product    WITH xprod
         REPLACE contact    WITH xcont
         REPLACE title      WITH xtitle
         REPLACE init_cont  WITH xinit
         REPLACE followup1  WITH xfu1
         REPLACE followup2  WITH xfu2
         REPLACE followup3  WITH xfu3
         REPLACE source     WITH xsource
         REPLACE prospect   WITH xpros
         REPLACE status     WITH xstat
         EDIT
         @ 24,0
         WAIT
         CLOSE FORMAT
         RETURN
      ENDIF
      IF UPPER(enter) = 'N'
         CLEAR
         SKIP
         LOOP
      ENDIF
      IF EOF()
         ? 'No additional records found.'
         WAIT
         GO TOP
         CLOSE FORMAT
         RETURN
      ENDIF
      CLOSE FORMAT
      RETURN
   ENDIF
   ?
   ? 'This record is not in the file'
   WAIT
   GO TOP
   LOOP
ENDDO
RETURN


****************
PROCEDURE duplic
****************

CLEAR
IF monitor = 'M'
   SET COLOR TO &mono3
ENDIF
@  2,32 SAY "Company Prospect"
@  4,4  SAY "Division"
@  4,43 SAY "Company"
@  5,4  SAY "Address"
@  6,4  SAY "City"
@  6,40 SAY "State"
@  6,52 SAY "Zip"
@  8,4  SAY "Phone"
@  8,29 SAY "Division Sales"
@  8,51 SAY "million"
@  8,61 SAY "Employees"
@ 10,4  SAY "Sq ft"
@ 10,23 SAY "Acres"
@ 10,35 SAY "Year Established"
@ 10,59 SAY "DUNS #"
@ 12,4  SAY "SIC Code1"
@ 12,22 SAY "SIC Code2"
@ 12,40 SAY "SIC Code3"
@ 12,58 SAY "SIC Code4"
@ 14,4  SAY "Product"
@ 16,4  SAY "Contact"
@ 16,42 SAY "Title"
@ 18,4  SAY "Init Cont"
@ 18,24 SAY "F-up-1"
@ 18,41 SAY "F-up-2"
@ 18,58 SAY "F-up-3"
@ 20,4  SAY "Info Source"
@ 20,43 SAY "Target Firm"
@ 21,4  SAY "Prospect"
@ 21,24 SAY "Status"
IF monitor = 'C'
   SET COLOR TO &mcolor2
ELSE
   SET COLOR TO &mono
ENDIF
@  4,14 SAY division PICTURE "XXXXXXXXXXXXXXXXXXXXXXXXX"
@  4,52 SAY company PICTURE "XXXXXXXXXXXXXXXXXXXXXXXXX"
@  5,14 SAY address PICTURE "XXXXXXXXXXXXXXXXXXXXXXXXX"
@  6,14 SAY city PICTURE "!XXXXXXXXXXXXXXXXXXX"
@  6,47 SAY state PICTURE "!!"
@  6,57 SAY zip PICTURE "99999X9999"
@  8,14 SAY phone PICTURE "@R (999)999-9999"
@  8,44 SAY sales PICTURE "9999.9"
@  8,71 SAY employees PICTURE "999999"
@ 10,13 SAY sq_ft PICTURE "999,999"
@ 10,29 SAY acres PICTURE "999"
@ 10,52 SAY establish PICTURE "9999"
@ 10,66 SAY duns PICTURE "@R 99-999-9999"
@ 12,15 SAY code1 PICTURE "9999"
@ 12,33 SAY code2 PICTURE "9999"
@ 12,51 SAY code3 PICTURE "9999"
@ 12,69 SAY code4 PICTURE "9999"
@ 14,12 SAY product PICTURE "!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
@ 16,14 SAY contact PICTURE "!XXXXXXXXXXXXXXXXXXXXXXXX"
@ 16,48 SAY title PICTURE "!XXXXXXXXXXXXXXXXXXXXXXXX"
@ 18,14 SAY init_cont PICTURE '99/99/99'
@ 18,31 SAY followup1  PICTURE '99/99/99'
@ 18,48 SAY followup2  PICTURE '99/99/99'
@ 18,65 SAY followup3  PICTURE '99/99/99'
@ 20,16 SAY source PICTURE "XXXXXXXXXXXXXXXXXXXXXXXXX"
@ 20,56 SAY target PICTURE "!"
@ 21,14 SAY prospect PICTURE "!XXXXXX"
@ 21,32 SAY status PICTURE "XXXXXXXXXXXXXXXXXXXXXXXXXXXX"

IF monitor = 'C'
   SET COLOR TO &mcolor
ENDIF
@ 1,1 TO 22,78 DOUBLE
RETURN


*****************
PROCEDURE stopret
*****************

CLOSE FORMAT
* DO editdata
RETURN TO MASTER


*: EOF: JOBADD.PRG

