FUNCTION ISDIR
	PARAMETER lc_dir, lc_access
	PRIVATE ALL LIKE l*
	IF .NOT. FILE("ISDIRECT.EXE")
		RETURN "ISDIRECT.EXE can not be located"
	ENDIF
	DO CASE
		CASE PCOUNT() = 0
			RETURN "Usage: ISDIR(<directory>[,<access permission>])"
		CASE TYPE("lc_dir") # "C" .OR. ISBLANK(lc_dir)
			RETURN "Usage: ISDIR(<directory>[,<access permission>])"
		CASE PCOUNT() > 1 .AND. TYPE("lc_access") # "C"
			RETURN "Usage: ISDIR(<directory>[,<access permission>])"
	ENDCASE
	lc_comm = IIF(PCOUNT() = 1, "ISDIRECT " + lc_dir, ;
		      "ISDIRECT " + lc_dir + " "  + lc_access )
	ln_val = 1
	DO WHILE .T.
		lc_file = "isdir" + LTRIM(STR(ln_val)) + ".tmp"
		IF .NOT. FILE(lc_file)
			EXIT
		ELSE
			IF ln_val >= 999
				RETURN "Unable to generate temporary file"
			ENDIF
		ENDIF
		ln_val = ln_val + 1
	ENDDO
		
	lc_comm = lc_comm + " > " + lc_file
	ln_run = RUN(lc_comm)
	IF ln_run # 0
		RETURN -1
	ELSE
		ln_handle = FOPEN((lc_file),"R")
		lc_dir    = FGETS(ln_handle)
		ll_close  = FCLOSE(ln_handle)
		ERASE (lc_file)
	ENDIF
RETURN  IIF( lc_dir = "T", .T.,IIF( lc_dir = "F", .F.,""))
