****************************************************************************
*
* PROGRAM
*		HConvert
*
* RETURNS
*		Logical
*
* DESCRIPTION
*		Removes all lines that don't begin with #DEFINE, but converts
*		comments as well.  Converts HEX strings to DEC.
*
* PARAMETERS
*		<expC1>
*		Name of old file
*
*		<expC2>
*		Name of new file
*
****************************************************************************
PARAMETERS pcOldFile, pcNewFile

SET LIBRARY TO FOXTOOLS ADDITIVE

pcOldFile = IIF( !EMPTY( pcOldFile ), pcOldFile, GETFILE( "h", "Pick a h file", "Open", 2 ) )
pcNewFile = IIF( !EMPTY( pcNewFile ), pcNewFile, PUTFILE( "Save new h file as", "new" + JUSTFNAME( pcOldFile ), "h") )

PRIVATE lnOldHandle, lnNewHandle, lnLineNo, lnCount, lnCount2, ;
	lcTestString, lcOldValue, lcNewValue

IF TYPE( "pcOldFile" ) # "C" .OR. EMPTY( pcOldFile )
	RETURN .F.
ENDIF

IF TYPE( "pcNewFile" ) # "C" .OR. EMPTY( pcNewFile )
	RETURN .F.
ENDIF

IF UPPER( pcOldFile ) = UPPER( pcNewFile )
	RETURN .F.
ENDIF

lnOldHandle = FOPEN( pcOldFile )
IF lnOldHandle = -1
	RETURN .F.
ENDIF

lnNewHandle = FCREATE( pcNewFile )
IF lnNewHandle = -1
	RETURN .F.
ENDIF

lnLineNo = 0

= FSEEK( lnOldHandle, 0, 0 )

DO WHILE !FEOF( lnOldHandle )
	lcTestString = FGETS( lnOldHandle )
	lnLineNo = lnLineNo + 1
	WAIT WINDOW "Processing Line: " + ALLTRIM( STR( lnLineNo ) ) NOWAIT
	lcOldValue = ""
	lcNewValue = ""
	IF LEFT( UPPER( lcTestString ), 7 ) = "#DEFINE" ;
		OR LEFT( lcTestString, 1 ) = "*" ;
		OR LEFT( lcTestString, 1 ) = "/"
		
		lcTestString = IIF( LEFT( lcTestString, 1 ) = "/", "*" + SUBSTR( lcTestString, 2 ), lcTestString )
		FOR lnCount = 1 TO LEN( lcTestString )
			IF UPPER( SUBSTR( lcTestString, lnCount, 2 ) ) = "0X"
				FOR lnCount2 = lnCount TO LEN( lcTestString )
					IF !( SUBSTR( lcTestString, lnCount2, 1 ) = " " .OR. SUBSTR( lcTestString, lnCount2, 1 ) = CHR( 13 ) )
						lcOldValue = lcOldValue + SUBSTR( lcTestString, lnCount2, 1 )
					ENDIF
				ENDFOR
				lcNewValue = ALLTRIM( STR( INT( HexToDec( lcOldValue ) ) ) )
				lcWriteString = STRTRAN( lcTestString, lcOldValue, lcNewValue )
				EXIT
			ELSE
				lcWriteString = lcTestString
			ENDIF
		ENDFOR
		= FPUTS( lnNewHandle, lcWriteString )
	ENDIF
ENDDO
= FCLOSE( lnOldHandle )
= FCLOSE( lnNewHandle )
RETURN .T.



FUNCTION DecToBin
** Converts POSETIVE decimal integers to BIN.
*--	Input:	NUMERIC
*-- Output:	CHAR

PARAMETER InNum
	OutStr=SPACE(0)
	DO WHILE InNum>0
			OutStr=STR(MOD(InNum,2),1,0)+OUTSTR 				
			InNum=INT(InNum/2)
	ENDDO
RETURN(OutStr)

FUNCTION BinToDec
** Converts POSETIVE binary numbers (represented by Char) to decimal integer.
*--	Input:	CHAR
*-- Output:	NUMERIC

PARAMETER InStr
	PRIVATE ALL LIKE j*
	jnLen=LEN(ALLTRIM(InStr))
	jnSum=0
	FOR nCtr=0 TO jnLen
		IF SUBSTR(InStr,jnLen-nCtr,1)='1'
			jnSum=jnSum+(2^nCtr)
		ENDIF
	ENDFOR
RETURN(jnSum)	

FUNCTION DecToHex
** Converts POSETIVE decimal integers to hex (Char).
*--	Input:	NUMERIC
*-- Output:	CHAR

PARAMETER InNum
	OutStr=SPACE(0)
	DO WHILE InNum>0
			OutStr=FindHex(MOD(InNum,16))+OutStr 				
			InNum=INT(InNum/16)
	ENDDO
RETURN(OutStr)

FUNCTION FindHex
** Lookup table for conversion of alpha hex chars.
*--	Input:	NUMERIC
*-- Output:	CHAR

PARAMETERS InVal	&& Integer
PRIVATE ALL LIKE j*
	DO CASE
		CASE InVal=10
			jOutStr='A'
		CASE InVal=11
			jOutStr='B'
		CASE InVal=12
			jOutStr='C'
		CASE InVal=13
			jOutStr='D'
		CASE InVal=14
			jOutStr='E'
		CASE InVal=15
			jOutStr='F'
		OTHERWISE
			jOutStr=STR(InVal,1,0)
	ENDCASE
RETURN(jOutStr)

FUNCTION HexToDec
*--	This function converts POSETIVE hex (Char) to decimal.	
*--	Input:	CHAR
*-- Output:	NUMERIC

PARAMETERS InStr
InStr=ALLTRIM(InStr)
PRIVATE ALL LIKE J*
jLen=LEN(InStr)
nSum=0
rPtr=0
FOR nCtr= 1 TO jLen
	cPtr=UPPER(SUBSTR(InStr,jLen-rPtr,1))
	DO CASE
		CASE cPtr='A' 
			cPtr='10'			
		CASE cPtr='B' 
			cPtr='11'			
		CASE cPtr='C' 
			cPtr='12'			
		CASE cPtr='D'
			cPtr='13'			
		CASE cPtr='E'
			cPtr='14'			
		CASE cPtr='F'
			cPtr='15'			
	ENDCASE	 
	nSum=nSum+(VAL(cPtr) * 16^(nCtr-1)) 
	rPtr=rPtr+1
ENDFOR
RETURN(nSum)	
