****************************************************************************************
* INBRWSET.PRG	: GenScrnX/InBrowse Driver - Move Browse code into a function
* Author		: Julian Ransom
* CIS Id		: 100415,2675
* Version		: 1.00
* Copyright		: None (Public Domain)
*
* Note:
*   This software is provided "as is" without
*   any warranty expressed or implied. In no event shall
*   the author (Julian Ransom) be liable for any damages.
*
* Description:
*	This add-on for InBrowse moves the generated BROWSE code into a function
*	called "BrwSetup" and calls it at the relevant point.
*	BrwSetup() can then be called later to redefine the Browse - particularly
*	useful if the Browse contains macro substitutions.
*
* Usage:
*	In the Setup snippet:
*		*:SPRDRV6 InBrwSet
*
****************************************************************************************
*
*	Please send me your comments and suggestions on Compuserve
*	(Internet access: 100415.2675@CompuServe.com)
*
****************************************************************************************

PRIVATE	lnFrom, lnTo, lcBrowCode

m.lnFrom = at('PRIVATE Offset', SPR)
if m.lnFrom=0
	wait window 'Could not find "PRIVATE Offset"'
	return .F.
endif
m.lnTo = at('PRIVATE Offset', SPR, 2)
if m.lnTo=0
	wait window 'Could not find second "PRIVATE Offset"'
	return .F.
endif

m.lcBrowCode	= substr(SPR, m.lnFrom, m.lnTo - m.lnFrom)

replace SPR with left(SPR, m.lnFrom - 1);
				+ 'DO BrwSetup' + cr_lf ;
				+ substr(SPR, m.lnTo) ;
				+ cr_lf ;
				+ cr_lf ;
				+ 'FUNCTION	BrwSetup' + cr_lf ;
				+ m.lcBrowCode
