****************************************************************************************
* GXNOACTI.PRG	: GenScrnX Driver - Remove the ACTIVATE WINDOW clause from the SPR.
* Author		: Julian Ransom
* CIS Id		: 100415,2675
* Version		: 1.00
* Copyright		: None (Public Domain)
*
* Note:
*   This software is provided "as is" without
*   any warranty expressed or implied. In no event shall
*   the author (Julian Ransom) be liable for any damages.
*
* Description:
*	GXNoActi comments out the ACTIVATE WINDOW clause in the generated SPR code.
*
* Usage:
*	In the Setup snippet:
*		*:SPRDRV6 GXNoActi
*
****************************************************************************************
*
*	Please send me your comments and suggestions on Compuserve
*	(Internet access: 100415.2675@CompuServe.com)
*
****************************************************************************************

PRIVATE	nSelect, cWindName
nSelect	= select()

SELECT 0
USE (M.FSCXDATA) AGAIN ALIAS GXNoActi
LOCATE FOR OBJTYPE=1 AND OBJCODE=63
SELECT (m.nSelect)

IF FOUND('GXNoActi')
	m.cWindName=alltrim(GXNoActi.Name)
	replace SPR with strtran(SPR, 'ACTIVATE WINDOW ' + lower(m.cWindName) + cr_lf, '*ACTIVATE WINDOW ' + lower(m.cWindName) + cr_lf)
ELSE
	wait window 'GXNoActi Error - could not find Header record in ' + m.fscxdata
ENDIF

USE IN GXNoActi