****************************************************************************************
* GXRMVBOX.PRG	: GenScrnX Driver - Remove all dotted boxes from the generated SPR.
* Author		: Julian Ransom
* CIS Id		: 100415,2675
* Version		: 1.00
* Copyright		: None (Public Domain)
*
* Note:
*   This software is provided "as is" without
*   any warranty expressed or implied. In no event shall
*   the author (Julian Ransom) be liable for any damages.
*
* Description:
*	Quite simply, remove all dotted boxes from the SPR.
*	This is useful in conjunction with the INBROWSE driver - make the BROWSE
*	box dotted, and you end up with no box around the Browse.
*
* Usage:
*	In the Setup snippet:
*		*:SPRDRV6 GXRmvBox
*
****************************************************************************************
*
*	Please send me your comments and suggestions on Compuserve
*	(Internet access: 100415.2675@CompuServe.com)
*
****************************************************************************************

PRIVATE	i, StyleLine

i	= 1
do while .T.
	StyleLine	= atc('PEN 1, 1', SPR, m.i)
	if m.StyleLine>0
		LineStart	= rat('@', left(SPR, m.StyleLine))
		replace SPR with stuff(SPR, m.LineStart, 0, '*')
		m.i	= m.i + 1
	else
		exit
	endif
enddo