****************************************************************************************
* WNAMEVAR.PRG	: GenScrnX Driver - Use a variable for a Window name
* Author		: Julian Ransom
* CIS Id		: 100415,2675
* Version		: 1.00
* Copyright		: None (Public Domain)
*
* Note:
*   This software is provided "as is" without
*   any warranty expressed or implied. In no event shall
*   the author (Julian Ransom) be liable for any damages.
*
* Description:
*	Treat the window name as a variable. For instance, if the window name
*	was "WindName", this would be replaced with (WindName) or m.WindName
*	where appropriate. This allows you to open multiple instances of the
*	same screen.
*
* Usage:
*	In the Setup snippet:
*		*:SCXDRV5 WNameVar
*
*	DO NOT put "M." at the start of the variable, as GenScrn misinterprets this.
*
****************************************************************************************
*
*	Please send me your comments and suggestions on Compuserve
*	(Internet access: 100415.2675@CompuServe.com)
*
****************************************************************************************

PRIVATE	nSelect, cWindName, uWindName
nSelect	= select()

SELECT 0
USE (M.FSCXDATA) AGAIN ALIAS WNameVar
LOCATE FOR OBJTYPE=1 AND OBJCODE=63
SELECT (m.nSelect)

IF FOUND('WNameVar')
	m.cWindName=WNameVar.Name
	m.uWindName=UPPER(m.cWindName)
	* Make sure are all upper case:
	replace SPR with strtran(SPR, lower(m.cWindName), m.uWindName)
	replace SPR with strtran(SPR, m.cWindName, m.uWindName)
	
	* Change ("WINDNAME") to (WINDNAME)
	replace SPR with strtran(SPR, '("' + m.uWindName + '")', '(' + m.uWindName + ')')
	
	* Change "WINDNAME" to (WINDNAME)
	replace SPR with strtran(SPR, '"' + m.uWindName + '"', '(' + m.uWindName + ')')
	
	* Change "WINDNAME. to WINDNAME+".
	replace SPR with strtran(SPR, '"' + m.uWindName + '.', m.uWindName + '+".')
	
	* Change WINDOW WINDNAME to WINDOW (WINDNAME)
	replace SPR with strtran(SPR, 'WINDOW ' + m.uWindName, 'WINDOW (' + m.uWindName + ')')
	
ELSE
	wait window 'WNameVar Error - could not find Header record in ' + m.fscxdata
ENDIF

USE IN WNameVar