*PROCEDURE GlobalX
Parameter lcSpec

CLEAR
Close All
lctalkstate = SET("TALK")
SET TALK OFF
DIMENSION lafulllist[1], laselected[1], lafrom[5], lato[5],tmparr[1,5]
gncurrow=1   	&& Shows the row on which the search string was found.
lnarrcnt=0		&& The number of files matching the filespec.
llwholewrd=.F.	&& Specify whether whole word search is perform
llcase=.F.		&& Specify whether case sensitivity is perform
lnfull=1		&& Returns the position of the selected file in lafulllist()
lnprompt=1		&& Specify whether user is alert before change is perform
lnaction=0		&& Controls "Move", "Remove",etc. (from main menu) operations.
lnselectcnt=0	&& Counts number of files moved into array laselected()
lafrom=""		&& Array containing the word(s) for the Change
lato=""			&& Array containing the word(s) for the Replace 
lnenter= 13		&& ASCII value for Enter key
lnescape=27		&& ASCII value for ESC key
lnwinlen=7		&& Rows of the ["Replace","Skip"...] window
lnscrlen=22		&& Rows of the "file content display" window
lnReplCnt=0		&& Number of replacements in a file
lcReplace=""	&& Alternative String for the Replace - 
		        && on the ["Replace","Skip"...] window
lcpath=""		&& combination of lcdir(Directory) and lcspec (Eg. *.Prg)
lcSpec = IIF(Empty(lcSpec),"*.PRG",Alltrim(lcSpec))
lcdir=CURDIR()
lnCancel=3		&& User cancels working with the current file
lnChange=1		&& User performs Replace
lnSkip=2		&& User skips Replace
lnreplace=2		&& Specify whether "Replace" or "Skip" is perform
DO getpath		&& Get the another directory
DO globalx.spr	&& Main screen
SET TALK &lctalkstate


** User presses Enter key or double click on the mouse left button.
** Proc "Fulllistvalid" disables the selected file from array lafulllist()
** and calls Proc "Moveit " to move it to array laSelected().

PROCEDURE fulllistvalid
IF LASTKEY() = lnenter AND lnfull <= lnarrcnt
   IF !('\' $ lafulllist(lnfull))
      lafulllist(lnfull) = '\'+lafulllist(lnfull)
      _CUROBJ= OBJNUM(lnfull)
   ENDIF
   DO moveit WITH lafulllist(lnfull)
   lnfull = lnfull + 1
ENDIF
SHOW GETS
RETURN

** Simply moves the selected file from array lafulllist() to
** array laselected().

PROCEDURE moveit  && called by Move and Move All
PARAMETER lcitem
lnselectcnt = lnselectcnt+1
DIMENSION laselected[lnSelectCnt]
laselected[lnSelectCnt] = SUBSTR(lcitem,2)
RETURN

** The opposite of Proc "Moveit", it removes the selected file from
** array laselected() to array lafulllist().
** Note: If the user decides to cancel the operation, removeit is
** not perform on the file.
** Called by ReMove and ReMove All

PROCEDURE removeit   
PARAMETER lcitem
IF lnselectcnt >= 1 And lnReplace != lnCancel
   lnpos = ASCAN(laselected,lcitem)
   =ADEL(laselected,lnpos)
   DIMENSION laselected[Alen(laSelected)-IIF(Alen(laSelected)>1,1,0)]
   lnpos = ASCAN(lafulllist,"\"+lcitem)
   lafulllist[lnPos] = SUBSTR(lafulllist[lnPos],2)
   lnselectcnt = lnselectcnt - 1
   IF TYPE('laSelected[1]') = 'L'
      laselected=""
   ENDIF
ENDIF
SHOW GETS && lnSelect
_CUROBJ= OBJNUM(lnselect)
RETURN

** User decides to change to another directory.
** Files are fetched and are sorted.
** Arrays lafulllist() and laselected() are re-dimensioned to reflect
** the number of files matching lcpath.

PROCEDURE getpath
EXTERNAL  ARRAY lafulllist,laselected

WAIT WINDOW "Reading dir..." NOWAIT
DIMENSION tmparr(1), lafulllist(1), laselected(1)
STORE "File not found." TO tmparr(1),lafulllist(1)
STORE "" TO laselected(1)
lnselectcnt = 0
lcpath = lcdir+lcspec
=ADIR(tmparr,lcpath)
lnarrcnt= ALEN(tmparr)/5
FOR i = 1 TO lnarrcnt
   DIMENSION lafulllist[i]
   lafulllist[i] = tmparr[i,1]
ENDFOR
RELEASE tmparr
=ASORT(lafulllist)
WAIT CLEAR
RETURN

** Determines when to disable and/or enables the controls of the
** main screen.

PROCEDURE REFRESH
EXTERNAL  ARRAY laselected

IF WONTOP('GlobalX')
	@ 0,1 TO 0,78 CLEAR
	@ 0,(WCOLS()/2)-(LEN(lcpath)+6)/2 SAY "PATH: "+lcpath && Center text
Endif	
IF EMPTY(laselected(1))
   SHOW GET lnaction,4 DISABLE && Remove
   SHOW GET lnaction,5 DISABLE && Remove All
   SHOW GET lnaction,7 DISABLE && Ok
ELSE
   SHOW GET lnaction,4 ENABLE && Remove
   SHOW GET lnaction,5 ENABLE && Remove All
   SHOW GET lnaction,7 ENABLE && Ok
ENDIF
IF ALEN(lafulllist) = ALEN(laselected)
   SHOW GET lnaction,2 DISABLE && Move
   SHOW GET lnaction,3 DISABLE && Move All
ELSE
   SHOW GET lnaction,2 ENABLE && Move
   SHOW GET lnaction,3 ENABLE && Move All
ENDIF
RETURN

PROCEDURE processcmd
EXTERNAL  ARRAY lafulllist,laselected, laFrom, laTo

IF WONTOP('Globalst')
   IF lnlstop = 2 && Clear All
      lafrom=""  && Clear arrays
      lato=""
   ELSE
      CLEAR READ
   ENDIF
ELSE
DO CASE
   CASE lnaction=1 && New Directory
      lcdir=GETDIR()
      IF !Empty(lcdir)
         DO getpath
         _CUROBJ= OBJNUM(lnfull)        
      ENDIF
   CASE lnaction=2 && Move
      DO fulllistvalid
   CASE lnaction=3 && Move	All
      FOR i = 1 TO lnarrcnt
         IF !( "\" $ lafulllist[i])
            lafulllist[i] = "\"+lafulllist[i]
            DO moveit WITH lafulllist[i]
         ENDIF
      ENDFOR
   CASE lnaction=4 && Remove
      DO removeit WITH laselected[lnSelect]
   CASE lnaction=5 && Remove All
      FOR i = 1 TO lnselectcnt
         DO removeit WITH laselected[1]
      ENDFOR
   CASE lnaction=6 && Change
   	  lcTmpSpec=lcSpec
      DO globalst.spr
      If (lcTmpSpec != lcSpec)
      	  lcSpec = IIF(Empty(lcSpec),lcTmpSpec,lcSpec)	
	      DO getpath      
	  Endif    
   CASE lnaction=7 && Ok
      i = 0   	     	 
   	  Do While (lnReplace != lnCancel)  And (lnselectcnt > i) 	
         DO processfile WITH lcdir, laselected[1] 
         DO removeit WITH laselected[1]                  
      Enddo
      lnReplace = 1
   CASE lnaction=8 && Cancel
      CLEAR READ ALL
   ENDCASE
ENDIF
SHOW GETS
RETURN

** Receives a file (lcthisfile), opens it, process it, and closes it.

PROCEDURE Processfile
PARAMETER lcdir, lcthisfile
EXTERNAL  ARRAY laBuffer

lldone=.F.
lnReplace=1
lnReplCnt=0
DIMENSION labuffer[23]
DEFINE WINDOW globals ;
   FROM INT((SROW()-24)/2),INT((SCOL()-79)/2) ;
   TO INT((SROW()-24)/2)+24,INT((SCOL()-79)/2)+79 ;
   NOSHADOW ;
   TITLE " Processing: "+lcdir+lcthisfile+" " ;
   COLOR SCHEME 1
ACTIVATE WINDOW globals
STORE 0 TO lncnt
outhandle =FCREATE(lcdir+'Temp.Txt')
inhandle = FOPEN(lcdir+lcthisfile)
IF (outhandle > 0 AND inhandle > 0)
   DO WHILE (!lldone) And (lnReplace != lnCancel)
      IF !FEOF(inhandle)
         IF lncnt <= 22
            lncnt = lncnt + 1
            labuffer[lnCnt] = FGETS(inhandle)
            @ lncnt-1,1 SAY labuffer[lnCnt]
         ELSE
            DO processpg WITH labuffer,lncnt
            DO FlushBuffer With labuffer,lncnt, outhandle
            CLEAR
            lncnt=0
         ENDIF
      ELSE
         lldone = .T.
         DO processpg WITH labuffer,lncnt
         DO FlushBuffer With labuffer,lncnt, outhandle
      ENDIF
	ENDDO
	=FCLOSE(inhandle)
	=FCLOSE(outhandle)	
	Do Case
		Case lnReplace != lnCancel 		
			 Erase (lcdir+lcthisfile)
			 Rename lcdir+"Temp.Txt" To (lcdir+lcthisfile)
		Case lnprompt = 1  
			 Wait Window Ltrim(Str(lnReplCnt))+" Replacement(s)"
	Endcase	
Else
	Wait Window "Cannot open: "+lcdir+lcthisfile	
	=FCLOSE(outhandle)	
	=FCLOSE(inhandle)
ENDIF
Release WINDOW Globals
RETURN

** Writes 1 to 22 lines of text to file "Temp.txt" in turn until 
** the file is fully processed.

Procedure FlushBuffer
Parameter labuffer,lncnt, outhandle
EXTERNAL  Array laBuffer

	For lnLine = 1 To lnCnt
		=FPUTS(outhandle,labuffer[lnLine])
	Endfor
Return

** The heart of GlobalX.Prg; it receives array labuffer, 1 to 22 lines 
** of text. Each line of the array is traversed in search of the words
** specified in array lafrom(). 

PROCEDURE processpg
PARAMETER labuffer,lncnt
EXTERNAL  ARRAY laBuffer,laFrom, laTo
PRIVATE i,j,K

FOR i = 1 TO lncnt
   FOR j = 1 TO 5
      IF !EMPTY(lafrom[j])
         lcfrom  = ALLTRIM(lafrom[j])
         lcto    = ALLTRIM(lato[j])
         lnfrom  = LEN(lcfrom)
         lnto    = LEN(lcto)
         lcLine  = labuffer[i]
         lnoccur = occursx(lcfrom,labuffer[i])		
         FOR k = 1 TO lnoccur
          lnpos = IIF(llcase,AT(lcfrom,labuffer[i],IIF(lnReplace=2,k,1)), ;
               ATC(lcfrom,labuffer[i],IIF(lnReplace=2,k,1)))                
               IF llwholewrd
	               lctmpstr = labuffer[i]
    	           lcposstr= SUBSTR(lctmpstr,lnpos+lnfrom)
        	       lcprestr= SUBSTR(lctmpstr,lnpos)
            	   IF (lnpos = 1) AND (!Between(ASC(lcposstr),0,32))
                	  lnpos=0
	               ELSE
	    			   IF !Between(ASC(lcprestr),0,32) AND ;
    	                  !Between(ASC(lcposstr),0,32)
        	              lnpos=0
            	      ENDIF
    	          ENDIF
	            ENDIF
            IF lnpos != 0
			   lctmpstr=SUBSTR(labuffer[i],lnpos,lnfrom)
               IF lnpos+LEN(lctmpstr) > 77
                  @ i-1,0 TO i-1,79 CLEAR
                  @ i-1, 1 SAY SUBSTR(labuffer[i],lnpos-20)
                  @ i-1, 20+1 SAY lctmpstr COLOR R/W
                  lnwhereX = 21
               ELSE
                  @ i-1, lnpos SAY lctmpstr COLOR R/W 
                  lnwhereX = lnpos
               ENDIF
                gncurrow = i-1
                IF lnprompt = 1 && prompt before change
                  DO globalp.spr
                ENDIF  
                Do Case
                	Case lnReplace = lnChange
						laBuffer[i] = Stuff(laBuffer[i],lnPos,lnfrom, '')
						laBuffer[i] = Stuff(laBuffer[i],lnPos, 0, ;
		            	IIF(Empty(lcReplace),lcto,Trim(lcReplace)))
		                @ i-1,0 TO i-1,79 CLEAR
			            @ i-1, 1 Say laBuffer[i]          
			            lnReplCnt = lnReplCnt+1
               		Case lnReplace = lnSkip
             			@ i-1, lnwhereX SAY lctmpstr COLOR W+/B
               		Case lnReplace = lnCancel
                  		 Return
                  	EndCase               
            ENDIF
         ENDFOR
      ENDIF
   ENDFOR
ENDFOR
RETURN

** Positions the ["Replace", "Skip"...] window proportionately 
** to where the word, to be changed, is found.

PROCEDURE winpos
IF gncurrow <= 22-lnwinlen
   MOVE WINDOW globalp TO gncurrow+2,CEILING((RAND()*SCOLS()/4)/2)+5
ELSE
   MOVE WINDOW globalp TO gncurrow-6,CEILING((RAND()*SCOLS()/4)/2)+5
ENDIF
RETURN

** Written to replace Foxpro's Occurs() function. The builtin function
** performs an exact match for a substring in string. However, I
** needed one which would be case insensitive.

FUNCTION occursx
PARAMETERS lcsource, lctarget
PRIVATE i,j,k,lctarget

lccnt = 0
i=0
j = LEN(lcsource)
k = LEN(lctarget)
DO WHILE i < k And (k-i) >= j
   lnpos = IIF(llcase,AT(lcsource,lctarget),ATC(lcsource,lctarget))
   IF lnpos != 0
      lccnt = lccnt+1
      i = lnpos+j
      lctarget = SUBSTR(lctarget,i)
   ELSE
      i = i+1
   ENDIF
ENDDO
RETURN lccnt


