*:*********************************************************************
*:
*: Procedure file: GETSTAMP.PRG
*:
*:         System: Time & Date Stamp Retrieval
*:         Author: Steve Snyder
*:      Copyright (c) , Steve Snyder
*:  Last modified: 11/14/90     14:12
*:
*:  Procs & Fncts: GETSTAMP()
*:
*:           Uses: &TEMP.DBF      
*:
*:    Other Files: TEMP
*:
*:      Documented 11/14/90 at 14:18               FoxDoc  version 2.01
*:*********************************************************************
* Program Name: getstamp.prg
* Author: Stephen Snyder
PARAMETERS dfile                                  && Incoming file name to get
*
IF .NOT. FILE(dfile)                             && If the file doesn't exist, abort
   RETURN SPACE(0)
ENDIF
temp=SYS(3)                                     && Create a temporary file
RUN DIR &dfile >&temp                           && Do a directory listing into the temporary file
fp=FOPEN(temp)                                  && Open the temporary file / low level file I/O
IF fp <0                                        && Error opening file / abort
   RETURN SPACE(0)
ENDIF

dirline=SPACE(0)                                && initialize directory line
                                                && skip header lines / quit at end of file
                                                && Ignores lines:
                                                &&   -that are blank
                                                &&   -that don't start in column one
                                                &&  -aborts at end of file
DO WHILE ((LEN(TRIM(dirline))=0 .OR. EMPTY(SUBSTR(dirline,1,1)))) .AND. .NOT. FEOF(fp)
   dirline=FGETS(fp)                              && Read in a line from the temp file
ENDDO
=FCLOSE(fp)                                      && Close the Temp file
oldsafe=SET("safety")
ERASE &temp                                      && Erase the temp file
SET SAFETY &oldsafe                              && Reset the original safety setting

IF (LEN(TRIM(dirline))=0 .OR. EMPTY(SUBSTR(dirline,1,1)))  && Unsuccessful return
   RETURN SPACE(0)
ELSE
   stamp = ALLTRIM(SUBSTR(dirline,24))           && Extract time & date from the line
   RETURN stamp                                  && Successful return
ENDIF

*: EOF: GETSTAMP.PRG
