* next few lines test getadate() function
clear
set talk off
x=getadate( {1/30/59}, 'Pick a date...' )
WAIT WINDOW NOWAIT DTOC(x)
? x

*
*   To try this function now press Ctrl O
*
*   This getadate() function pops up a Quicken-like calendar to edit
*   a date. The other versions I have seen seem too slow and
*   complex. This one doesn't use a READ level and is only about
*   150 lines of code with comments. getadate() can be called from an
*   @ GET WHEN clause with something like 
*   ON KEY LABEL ? this_var = getadate( this_var, 'SELECT THIS_VAR NOW')
*   to pop-up the calendar when the ? key is pressed.
*   Don't forget to clear the ON KEY LABEL ? in the valid clause.
*
*   Let me know if you like getadate() or if you make any improvements.
*   Daniel Biener  CompuServe 75252,137  Phone 314-256-0690
*
*   Parameters passed to this function are:
*   sel_date = initial high-lighted date. If empty defaults to DATE().
*   win_title = calendar window title. If empty defaults to none.
*   winrow = top window row. If empty defaults to center.
*   wincol = left window column. If empty defaults to center.
*
*   Returned value is date selected or initial date if [ESC] or <Cancel>.
*
*   To navigate calendar use cursor keys as expected.
*   HOME      1st day of month
*   END       last day of month
*   PgUp      back one month
*   PgDn      foreword one month
*   'T'oday   DATE()
*   ESC or 'C'ancel to quit and return initial date
*   ENTER, SPACE or click on day to select date and exit
*   click on top row arrows to increment or decrement month and year


FUNCTION getadate
   PARAMETERS sel_date, win_title, winrow, wincol

   *center window if no location passed   
   winrow = IIF( EMPTY(winrow), INT((SROW()-16)/2), winrow )
   wincol = IIF( EMPTY(wincol), INT((SCOL()-22)/2), wincol )
   win_title = IIF( EMPTY(win_title), '', win_title )
   sel_date = IIF( EMPTY(sel_date), DATE(), sel_date )

   SET TALK OFF
   SET COLOR TO W/B

   *type & initialize vars
   save_mo = {}
   DIMENSION montharr(6,7)
   esc_date = sel_date

   *draw a window
   DEFINE WINDOW calendar AT winrow, wincol SIZE 16, 22 TITLE win_title ;
      NOCLOSE FLOAT NOGROW NOMINIMIZE NOZOOM
   ACTIVATE WINDOW calendar

   DO WHILE .T.
      *test if different month needs to be loaded into array
      IF MONTH(sel_date) <> MONTH(save_mo) .OR. YEAR(sel_date) <> YEAR(save_mo)
         day_month=1
         STORE "" TO montharr

         *get the length of the month
         mo_length = DAY(GOMONTH(sel_date, 1) - DAY(GOMONTH(sel_date, 1)))

         *load month array
         FOR calrow = 1 TO 6
            FOR calcol = 1 TO 7
               IF ( calrow = 1 .AND. calcol < DOW(sel_date-DAY(sel_date)+1 ) ) .OR. day_month > mo_length
                  montharr(calrow, calcol) = "   "
               ELSE
                  montharr(calrow, calcol) = TRANSFORM(day_month, "###")
                  day_month = day_month +1
               ENDIF
            NEXT
         NEXT
         save_mo = sel_date
         CLEAR
         
         *say dow's
         @ 1, 1 SAY "Su"+ " " +"Mo"+ " " +"Tu"+ " " +"We"+ " " +"Th"+ " " +"Fr"+ " " +"Sa"
         *say month and year
         @ 0,1 SAY PADC(CMONTH(sel_date) + " " + STR(YEAR(sel_date),4),  21)

         *draw buttons
         @ 15,0 SAY "  <Today>   <Cancel>"
         @ 0,0 SAY "M"
         @ 0,19 SAY "Y"
      ENDIF

      *draw days on calendar
      FOR calrow = 1 TO 6
         FOR calcol = 1 TO 7
            @ calrow*2+1, calcol*3-3 SAY montharr(calrow, calcol)
         NEXT
         @ calrow*2+1, 21 SAY SPACE(1)
         @ calrow*2, 0 SAY SPACE(22)
      NEXT
      @ 14,0 SAY SPACE(22)

      * highlight selected date
      SET COLOR TO GR+/B
      day_el = ASCAN(montharr, TRANSFORM( DAY(sel_date), "###"))
      darow = ASUBSCRIPT(montharr, day_el, 1 ) * 2 + 1
      dacol = ASUBSCRIPT(montharr, day_el, 2 ) * 3 - 3

      @ darow -1, dacol SAY "EII""
      @ darow, dacol SAY DAY(sel_date) PICTURE "o##o"
      @ darow +1, dacol SAY "EII?"
      SET COLOR TO W/B

      *handle user input key or mouse
      key_press = INKEY(0, 'HM')
      DO CASE
         CASE key_press = 24                       &&DOWN
            sel_date = sel_date+7
         CASE key_press = 5                        &&UP
            sel_date = sel_date-7
         CASE key_press = 4                        &&RIGHT
            sel_date = sel_date+1
         CASE key_press = 19                       &&LEFT
            sel_date = sel_date-1
         CASE key_press = 18                       &&PG UP BACK 1 MONTH
            sel_date = GOMONTH(sel_date, -1)
         CASE key_press = 3                        &&PG DN FOREWARD 1 MONTH
            sel_date = GOMONTH(sel_date, 1)
         CASE key_press = 1                        &&HOME 1ST OF MONTH
            sel_date = sel_date - DAY(sel_date) +1
         CASE key_press = 6                        &&HOME END OF MONTH
            sel_date = GOMONTH(sel_date, 1) - DAY(GOMONTH(sel_date, 1))
         CASE key_press = 27   .OR. key_press = 99 &&ESCAPE OR Cancel
            sel_date = esc_date
            EXIT
         CASE key_press = 13   .OR. key_press = 32 &&ENTER OR SPACE
            EXIT
         CASE key_press = 116                      &&Today
            sel_date = DATE()
         CASE key_press = 151                      &&MOUSE CLICK
            mouserow = MROW()
            mousecol = MCOL()
            DO CASE
               CASE mouserow = 0 .AND. mousecol = 0   &&MONTH +
                  sel_date = GOMONTH(sel_date, 1)
                  LOOP
               CASE mouserow = 0 .AND. mousecol = 2   &&MONTH -
                  sel_date = GOMONTH(sel_date, -1)
                  LOOP
               CASE mouserow = 0 .AND. mousecol = 19  &&YEAR +
                  sel_date = GOMONTH(sel_date, 12)
                  LOOP
               CASE mouserow = 0 .AND. mousecol = 21  &&YEAR -
                  sel_date = GOMONTH(sel_date, -12)
                  LOOP
               CASE mouserow = 15 .AND. BETWEEN(mousecol, 2, 8)   &&TODAY
                  sel_date = DATE()
                  LOOP
               CASE mouserow = 15 .AND. BETWEEN(mousecol, 12, 19) &&CANCEL
                  sel_date = esc_date
                  EXIT
            ENDCASE

            *throw out some bad clicks
            IF MOD(mouserow, 2) = 0 .OR. MOD(mousecol, 3) = 0 ;
                  .OR. mouserow = -1 .OR. mousecol = -1 ;
                  .OR. mouserow = 15
               LOOP
            ENDIF

            *fix value if clicked on left date digit
            IF MOD(mousecol -1, 3) = 0
               mousecol = mousecol +1
            ENDIF

            *calculate new date
            newday = VAL(montharr( (mouserow-1)/2, (mousecol+1)/3 ))

            *throw out some more bad clicks
            IF EMPTY(newday)
               LOOP
            ENDIF

            IF newday > DAY(sel_date)
               sel_date = sel_date + ABS( DAY(sel_date) - newday )
               EXIT
            ELSE
               sel_date = sel_date - ABS( DAY(sel_date) - newday )
               EXIT
            ENDIF
      ENDCASE
   ENDDO
   RELEASE WINDOW calendar
RETURN sel_date
