***************************************************************************
*
* Procedure file: GENSCRNX.PRG
*         System: GenScrnX
*        Version: 2.0
*         Author: Ken R. Levy
*        Company: Jet Propulsion Laboratory
*      Copyright: None (Public Domain)
*
***************************************************************************
*
* GENSCRNX - Screen Database Generator.
*
* Description:
* This program generates database from objects designed and built with
* FoxPro screen builder.
*
* Notes:
* In this program, for clarity/readability reasons, variable names
* are used that are longer than 10 characters.  Note, however, that only
* the first 10 characters are significant.
*
PARAMETERS projdbf,recno,dummy
PRIVATE gstatus,gsx_mode,fconfigfp,cr,lf,cr_lf,null
PRIVATE genscrn,genscrnx,warnings,gsxversion,mvcount
PRIVATE transport,transportx,ftrndrv1,ftrndrv2,drvoffs
PRIVATE pathfox,fgenscx,fupdspr,ffoxscx,ffoxscx2,projpath
PRIVATE fpjxbase,fscxbase,fscxdata,fsprout,fspxout,fsprout2
PRIVATE spxout2,fsprerr,compspr,dispspr,autorun,noautorun,autorunsave
PRIVATE drv_no,drv_cnt,platonly,autohalt,outtxt,lastpoint,lastselect
PRIVATE inclibs,baslibs,fromproj,fcountadj,fnctnames,scnobj
PRIVATE lastonerror,lastsetcomp,lastsetexac,lastsetpath,lastsettr
PRIVATE lastsetcry,lastsetnear,lastsetdec,lastsetsfty,lastsetdel
PRIVATE lastsetexcl,lastsetudfp,lastmemow,updsprflag
PRIVATE c_defobj,c_basobj,c_insobj,c_insscx,c_inclib,c_deflib
PRIVATE c_baslib,c_trntxt,c_memvar,c_instxt,c_delete,c_delobj
PRIVATE c_if,c_size,c_nosize,c_svsize,c_svpict,c_basbefore,c_setupmthd
PRIVATE c_defobj,c_group,c_default,c_picture,c_refresh,c_name,p_name,s_para
PRIVATE c_pjx_set,c_set,c_insert,p_insert,c_prg,c_disable,c_enable,c_visible
PRIVATE c_outfile,c_endtxt,c_function,c_endfnct,c_method,c_endmthd
PRIVATE c_genscrnx,c_nogen,c_noxgen,c_section3,c_nowclaus,c_click,c_button
PRIVATE c_compspr,c_nocompspr,c_dispspr,c_nodispspr,c_drvoff
PRIVATE c_autorun,c_noautorun,c_scnobj,c_noscnobj,c_screenset
PRIVATE c_braces,c_nobraces,c_ignrbrcs,c_evltxt,c_precmd,c_poscmd
PRIVATE m_deflib,m_defobj,m_basobj,m_instxt,m_disable,m_enable,m_visible
PRIVATE m_delete,m_if,m_size,m_nosize,m_svsize,m_svpict,m_basbefore
PRIVATE m_click,m_button,m_default,m_section3,m_method,find_str
PRIVATE scx_name,memline,i,j,k,newsetpath,pjxset,eval_cmnt
PRIVATE r_projbase,r_scxdata,platform_,cplatform_,splatform_
PRIVATE lib_mode,gen_mode,xgen_mode,braces,ignrbraces,doprogram
PRIVATE scxcount,cscxcount,allplatforms,screens,scrnsetflag
PRIVATE msg1,msg2,msg3,nextfile,memtemp1,memtemp2,memtemp3
PRIVATE c_dlgface,c_dlgsize,c_dlgstyle,badchars,stdascii
DIMENSION a_fscxdrv(1,8),a_scxdrv(1,8),a_scxdrvs(8),a_scxdrvm(8),;
          a_c_scxdrv(8),a_fsprdrv(1,6),a_sprdrv(1,6),a_sprdrvs(6),;
          a_sprdrvm(6),a_c_sprdrv(6),a_drvoff(1)

m.gsxversion='2.0'
m.doprogram=IIF(PARAMETERS()=1.AND.TYPE('m.projdbf')=='C',m.projdbf,'')
m.lastsettr=SET('TRBETWEEN')
SET TRBETWEEN OFF
_FOX25=(SUBSTR(VERSION(),AT('2.',VERSION()),3)>='2.5')
_FOX26=(SUBSTR(VERSION(),AT('2.',VERSION()),3)>='2.6')
_FOX25REV=IIF(_FOX25,SUBSTR(VERSION(),AT('2.',VERSION())+3,1),'')
_FOX26REV=IIF(_FOX26,SUBSTR(VERSION(),AT('2.',VERSION())+3,1),'')
IF .NOT._FOX25
  _DOS=.T.
  _WINDOWS=.F.
  _MAC=.F.
  _UNIX=.F.
ENDIF
DO CASE
  CASE _WINDOWS
    m.cplatform_='WINDOWS'
  CASE _MAC
    m.cplatform_='MAC'
  CASE _UNIX
    m.cplatform_='UNIX'
  OTHERWISE
    m.cplatform_='DOS'
ENDCASE
m.cplatform_=PADR(m.cplatform_,8)
IF TYPE('m.recno')#'N'
  m.recno=0
ENDIF
m.gsx_mode=m.recno>=2.AND.ATC('.PJX',m.projdbf)>0
m.gstatus=0
m.warnings=0
m.pathfox=SYS(2004)
m.cr=CHR(13)
m.lf=CHR(10)
m.cr_lf=m.cr+m.lf
m.null=CHR(0)
DIMENSION a_file_ext(4)
a_file_ext(1)='.EXE'
a_file_ext(2)='.APP'
a_file_ext(3)='.PRG'
a_file_ext(4)='.FXP'
IF .NOT.EMPTY(m.doprogram)
  m.gen_mode=.F.
  m.xgen_mode=.F.
  m.lib_mode=.F.
  m.fgenscx=''
  DO (m.doprogram)
  IF m.lastsettr=='ON'
    SET TRBETWEEN ON
  ELSE
    SET TRBETWEEN OFF
  ENDIF
  RETURN .F.
ENDIF
m.lastselect=SELECT()
m.lastsetpath=SET('PATH')
m.lastpoint=SET('POINT')
SET POINT TO '.'
m.fconfigfp=SYS(2019)
IF FILE(m.fconfigfp)
  CREATE CURSOR CONFIGFP (FP M)
  IF _WINDOWS.OR._MAC
    SET MESSAGE TO ' '
  ENDIF
  INSERT BLANK
  APPEND MEMO FP FROM (m.fconfigfp) OVERWRITE
  REPLACE FP WITH evltxt(FP)
ELSE
  m.fconfigfp=''
ENDIF
FOR m.i = 7 TO 4 STEP -1
  m.mvcount=configfp(LEFT('MVCOUNT',m.i),'256')
  IF VAL(m.mvcount)>=512
    EXIT
  ENDIF
ENDFOR
IF VAL(m.mvcount)<512
 =warning("'MVCOUNT="+m.mvcount+"' should be set to at least 512 in "+;
          SYS(2019))
ENDIF
m.genscrnx=IIF(TYPE('_GENSCRNX')=='C',UPPER(_GENSCRNX),configfp('GENSCRNX','ON'))
m.genscrn=add_fext(configfp('_GENSCRNX',m.pathfox+'GENSCRN.PRG'))
m.ffoxscx=IIF(TYPE('_FOXSCX')=='C',UPPER(_FOXSCX),configfp('_FOXSCX',;
          m.pathfox+'FOXSCX.DBF'))
IF .NOT.EMPTY(m.ffoxscx).AND..NOT.'.'$m.ffoxscx
  m.ffoxscx=m.ffoxscx+'.DBF'
ENDIF
m.ffoxscx=FULLPATH(m.ffoxscx)
IF TYPE('m.projdbf')#'C'
  m.i=openfoxscx()
  IF USED('CONFIGFP')
    USE IN CONFIGFP
  ENDIF
  IF .NOT.m.i
    RETURN .F.
  ENDIF
  m.memline="PLATFORM=='"+m.cplatform_+"'"
  SET FILTER TO &memline
  RETURN .T.
ENDIF
IF .NOT.m.gsx_mode
  m.transport=add_fext(configfp('_TRANSPRTX',m.pathfox+'TRANSPRT.PRG'))
  m.ftrndrv1=add_fext(configfp('_trndrv1',''))
  m.ftrndrv2=add_fext(configfp('_trndrv2',''))
  IF USED('CONFIGFP')
    USE IN CONFIGFP
  ENDIF
  IF FILE(m.ftrndrv1)
    DO (m.ftrndrv1) WITH m.projdbf,m.recno,m.dummy
    IF m.gstatus=-2
      RETURN 0
    ENDIF
    IF m.gstatus=-1
      RETURN -1
    ENDIF
  ENDIF
  IF .NOT.FILE(m.transport)
    RETURN -1
  ENDIF
  m.transport=trimext(m.transport)
  RELEASE ALL LIKE ?_*
  SET PATH TO (m.pathfox)
  macrofnct='m.gstatus='+trimpath(m.transport)+'(m.projdbf,m.recno,m.dummy)'
  &macrofnct
  IF EMPTY(m.lastsetpath)
    SET PATH TO
  ELSE
    SET PATH TO (m.lastsetpath)
  ENDIF
  IF FILE(m.ftrndrv2)
    DO (m.ftrndrv2) WITH m.projdbf,m.recno,m.dummy
  ENDIF
  RETURN m.gstatus
ENDIF
IF m.genscrnx=='OFF'
  IF USED('CONFIGFP')
    USE IN CONFIGFP
  ENDIF
  IF .NOT.FILE(m.genscrn)
    RETURN 2
  ENDIF
  RELEASE ALL LIKE ?_*
  RELEASE ALL LIKE f*
  RELEASE ALL LIKE last*
  DO (m.genscrn) WITH m.projdbf,m.recno
  RETURN m.gstatus
ENDIF
IF _WINDOWS.OR._MAC
  SET MESSAGE TO ' '
ENDIF
m.fgenscx=configfp('_GENSCX','GENSCX')
m.fupdspr=configfp('_UPDSPR','UPDSPR')
a_fscxdrv=''
a_scxdrv=''
a_fsprdrv=''
a_sprdrv=''
a_drvoff=''
m.drvoffs=0
FOR m.i = 1 TO 8
  a_scxdrvm(m.i)=0
  m.find_str='_SCXDRV'+STR(m.i,1)
  FOR m.j = 1 TO 255
    m.memline=add_fext(configfp(m.find_str,'',m.j))
    IF EMPTY(m.memline)
      IF ATC(m.find_str,CONFIGFP.FP,m.j)=0
        EXIT
      ENDIF
      LOOP
    ENDIF
    FOR m.k = 1 TO a_scxdrvm(m.i)
      IF FULLPATH(a_fscxdrv(m.k,m.i))==FULLPATH(m.memline)
        m.memline=''
        EXIT
      ENDIF
    ENDFOR
    IF EMPTY(m.memline)
      LOOP
    ENDIF
    a_scxdrvm(m.i)=a_scxdrvm(m.i)+1
    IF ALEN(a_fscxdrv)<(8*a_scxdrvm(m.i))
      DIMENSION a_fscxdrv(a_scxdrvm(m.i),8)
    ENDIF
    a_fscxdrv(a_scxdrvm(m.i),m.i)=m.memline
  ENDFOR
  IF m.i>6
    LOOP
  ENDIF
  a_sprdrvm(m.i)=0
  m.find_str='_SPRDRV'+STR(m.i,1)
  FOR m.j = 1 TO 255
    m.memline=add_fext(configfp(m.find_str,'',m.j))
    IF EMPTY(m.memline)
      IF ATC(m.find_str,CONFIGFP.FP,m.j)=0
        EXIT
      ENDIF
      LOOP
    ENDIF
    FOR m.k = 1 TO a_sprdrvm(m.i)
      IF FULLPATH(a_fsprdrv(m.k,m.i))==FULLPATH(m.memline)
        m.memline=''
        EXIT
      ENDIF
    ENDFOR
    IF EMPTY(m.memline)
      LOOP
    ENDIF
    a_sprdrvm(m.i)=a_sprdrvm(m.i)+1
    IF ALEN(a_fsprdrv)<(6*a_sprdrvm(m.i))
      DIMENSION a_fsprdrv(a_sprdrvm(m.i),6)
    ENDIF
    a_fsprdrv(a_sprdrvm(m.i),m.i)=m.memline
  ENDFOR
ENDFOR
m.compspr=IIF(TYPE('_COMPSPR')=='C',UPPER(_COMPSPR),;
          configfp('COMPSPR','OFF'))
m.dispspr=IIF(TYPE('_DISPSPR')=='C',UPPER(_DISPSPR),;
          configfp('DISPSPR','OFF'))
m.autorun=IIF(TYPE('_AUTORUN')=='C',UPPER(_AUTORUN),;
          configfp('AUTORUN','OFF'))
m.platonly=IIF(TYPE('_PLATONLY')=='C',UPPER(_PLATONLY),;
           configfp('PLATONLY',''))
m.autohalt=IIF(TYPE('_AUTOHALT')=='C',UPPER(_AUTOHALT),;
           configfp('AUTOHALT','ON'))
m.outtxt=IIF(TYPE('_OUTTXT')=='C',UPPER(_OUTTXT),;
         configfp('OUTTXT','OFF'))
m.scnobj=IIF(TYPE('_SCNOBJ')=='C',UPPER(_SCNOBJ),;
         configfp('SCNOBJ','ON'))
m.braces=IIF(TYPE('_BRACES')=='C',UPPER(_BRACES),;
         configfp('BRACES','ON'))
m.ignrbraces=.F.
SET ESCAPE OFF
m.lastonerror=ON('ERROR')
ON ERROR DO errorhnd WITH ERROR(),MESSAGE(),PROGRAM(),LINENO(),MESSAGE(1)
m.lastsetcomp=SET('COMPATIBLE')
SET COMPATIBLE OFF
m.lastsetexac=SET('EXACT')
SET EXACT OFF
m.lastsetsfty=SET('SAFETY')
SET SAFETY OFF
m.lastsetdel=SET('DELETED')
SET DELETED OFF
m.lastsetcry=SET('CARRY')
SET CARRY OFF
m.lastsetnear=SET('NEAR')
SET NEAR OFF
m.lastsetdec=SET('DECIMALS')
SET DECIMALS TO 9
m.lastsetexcl=SET('EXCLUSIVE')
SET EXCLUSIVE ON
m.lastsetudfp=SET('UDFPARMS')
SET UDFPARMS TO VALUE
m.lastmemow=SET('MEMOWIDTH')
SET MEMOWIDTH TO 254
ACTIVATE SCREEN
SET CURSOR OFF
IF WEXIST('_weditfile')
  RELEASE WINDOW _weditfile
ENDIF
m.c_defobj='*:DEFOBJ'
m.c_basobj='*:BASOBJ'
m.c_insobj='*:INSOBJ'
m.c_insscx='*:INSSCX'
m.c_inclib='*:INCLIB'
m.c_deflib='*:DEFLIB'
m.c_baslib='*:BASLIB'
m.c_instxt='*:INSTXT'
m.c_trntxt='*:TRNTXT'
m.c_memvar='*:MEMVAR'
FOR m.i = 1 TO 8
  a_c_scxdrv(m.i)='*:SCXDRV'+STR(i,1)
  a_scxdrvs(m.i)=0
  IF m.i>6
    LOOP
  ENDIF
  a_c_sprdrv(m.i)='*:SPRDRV'+STR(i,1)
  a_sprdrvs(m.i)=0
ENDFOR
m.c_delete='*:DELETE'
m.c_delobj='*:DELOBJ'
m.c_if='*:IF'
m.c_disable='*:DISABLE'
m.c_enable='*:ENABLE'
m.c_visible='*:VISIBLE'
m.c_size='*:SIZE'
m.c_nosize='*:NOSIZE'
m.c_svsize='*:SAVESIZE'
m.c_svpict='*:SAVEPICT'
m.c_click='*:CLICK'
m.c_button='*:BUTTON'
m.c_scnobj='*:SCNOBJ'
m.c_noscnobj='*:NOSCNOBJ'
m.c_braces='*:BRACES'
m.c_nobraces='*:NOBRACES'
m.c_ignrbrcs='*:IGNOREBRACES'
m.c_evltxt='*:EVLTXT'
m.c_screenset='*:SCREENSET'
m.c_basbefore='*:BASBEFORE'
m.c_setupmthd='*:SETUPMTHD'
m.c_group='*:GROUP'
m.c_default='*:DEFAULT'
m.c_picture='*:PICTURE'
m.c_refresh='*:REFRESH'
m.c_nogen='*:NOGEN'
m.c_noxgen='*:NOXGEN'
m.c_compspr='*:COMPSPR'
m.c_nocompspr='*:NOCOMPSPR'
m.c_dispspr='*:DISPSPR'
m.c_nodispspr='*:NODISPSPR'
m.c_drvoff='*:DRVOFF'
m.c_autorun='*:AUTORUN'
m.c_noautorun='*:NOAUTORUN'
m.c_genscrnx='*:GENSCRNX'
m.c_insert='#:INSERT'
m.p_insert='#INSE'
m.c_name='*:NAME'
m.p_name='#NAME'
m.s_para='PARA'
m.c_prg='*:PRG'
m.c_outfile='*:OUTFILE'
m.c_pjxset='*:PJXSET'
m.c_set='*:SET'
m.c_section3='#:SECTION 3'
m.c_nowclaus='*:NOWCLAUSES'
m.c_endtxt='*:ENDTXT'
m.c_function='*:FUNCTION'
m.c_method='*:METHOD'
m.c_endfnct='*:ENDFNCT'
m.c_endmthd='*:ENDMTHD'
m.m_deflib='*-:DEFLIB'
m.m_defobj='*-:DEFOBJ'
m.m_basobj='*-:BASOBJ'
m.m_instxt='*-:INSTXT'
m.m_delete='*-:DELETE'
m.m_if='*-:IF'
m.m_disable='*-:DISABLE'
m.m_enable='*-:ENABLE'
m.m_visible='*-:VISIBLE'
m.m_size='*-:SIZE'
m.m_nosize='*-:NOSIZE'
m.m_svsize='*-:SAVESIZE'
m.m_svpict='*-:SAVEPICT'
m.m_basbefore='*-:BASBEFORE'
m.m_click='*-:CLICK'
m.m_button='*-:BUTTON'
m.m_default='*-:DEFAULT'
m.m_section3='*-#SECTION 3'
m.m_method='*-:METHOD'
m.c_precmd='*# USERPRECOMMAND'
m.c_postcmd='*# USERPOSTCOMMAND'
IF _MAC
  m.c_dlgface='Geneva'
  m.c_dlgsize=10
  m.c_dlgstyle=''
ELSE
  m.c_dlgface='MS Sans Serif'
  m.c_dlgsize=8
  m.c_dlgstyle='B'
ENDIF
m.badchars=' /\,-=:;{}[]!@#$%^&*.<>()+|'+CHR(34)+CHR(39)
m.stdascii=''
m.eval_cmnt='SUBSTR(COMMENT,MAX(ATC(m.c_defobj,COMMENT),'+;
            'ATC(m.m_defobj,COMMENT)))'
DIMENSION a_inclib(1),a_baslib(1)
m.inclibs=0
m.baslibs=0
DIMENSION a_fnctname(1,2)
m.fnctnames=0
DIMENSION a_fscxdata(1),a_scxupd(1),a_scxalias(1),a_nowclaus(1,4)
a_scxupd=''
a_nowclaus=''
m.scxcount=0
m.cscxcount='0'
m.screens=0
m.scrnsetflag=.F.
m.platform_=''
m.splatform_=m.cplatform_
m.fcountadj=IIF(_FOX25,8,9)
m.ffoxscx2=''
m.fpjxbase=STRTRAN(m.projdbf,CHR(0),'')
m.fscxbase=''
m.fscxdata=''
m.fsprout=''
m.fspxout=''
m.fsprerr=''
m.scx_name=''
m.newsetpath=''
m.projpath=''
m.lib_mode=.F.
m.gen_mode=.T.
m.xgen_mode=.T.
m.fromproj=.T.
m.pjxset=.F.
m.drv_no=0
m.drv_cnt=0
m.r_pjxbase=m.recno
m.r_scxdata=1
m.allplatforms=.F.
m.updsprflag=.F.
m.noautorun=.F.
m.autorunsave=.F.
IF .NOT.EMPTY(m.ffoxscx)
  IF m.fgenscx=='GENSCX'.OR.FILE(m.fgenscx)
    CLEAR TYPEAHEAD
    DO (m.fgenscx) WITH m.projdbf,m.recno
  ELSE
    =warning('_GENSCX =',m.fgenscx)
    m.fgenscx=''
  ENDIF
ELSE
  m.fgenscx=''
ENDIF
RELEASE a_fscxdrv,a_scxdrv,a_scxdrvs,a_scxdrvm,a_c_scxdrv
IF m.gen_mode
  IF FILE(m.genscrn)
    IF EMPTY(m.lastsetpath)
      SET PATH TO
    ELSE
      SET PATH TO (m.lastsetpath)
    ENDIF
    m.memtemp1=uniqueflnm()+'.MEM'
    SAVE TO (m.memtemp1) ALL LIKE ?_*
    RELEASE ALL LIKE ?_*
    m.memtemp2=uniqueflnm()+'.MEM'
    SAVE TO (m.memtemp2) ALL LIKE f*
    RELEASE ALL LIKE f*
    m.memtemp3=uniqueflnm()+'.MEM'
    SAVE TO (m.memtemp3) ALL LIKE last*
    RELEASE ALL LIKE last*
    CLEAR TYPEAHEAD
    ON ERROR
    DO (m.genscrn) WITH m.projdbf,m.recno
    SET ESCAPE OFF
    ON ERROR DO errorhnd WITH ERROR(),MESSAGE(),PROGRAM(),LINENO(),MESSAGE(1)
    IF _WINDOWS.OR._MAC
      SET MESSAGE TO ' '
    ENDIF
    IF FILE(m.memtemp1)
      RESTORE FROM (m.memtemp1) ADDITIVE
      ERASE (m.memtemp1)
    ENDIF
    IF FILE(m.memtemp2)
      RESTORE FROM (m.memtemp2) ADDITIVE
      ERASE (m.memtemp2)
    ENDIF
    IF FILE(m.memtemp3)
      RESTORE FROM (m.memtemp3) ADDITIVE
      ERASE (m.memtemp3)
    ENDIF
    DO restoreenv
  ELSE
    =warning('_GENSCRNX =',m.genscrn)
    m.genscrn=''
  ENDIF
ELSE
  m.genscrn=''
ENDIF
IF m.xgen_mode.AND..NOT.m.lib_mode.AND.FILE(m.fsprout)
  IF m.fupdspr=='UPDSPR'.OR.FILE(m.fupdspr)
    CLEAR TYPEAHEAD
    DO (m.fupdspr) WITH m.projdbf,m.recno
  ELSE
    =warning('_UPDSPR =',m.fupdspr)
    m.fupdspr=''
  ENDIF
ELSE
  m.fupdspr=''
ENDIF
DO cleanup WITH .T.
IF m.lastsettr=='ON'
  SET TRBETWEEN ON
ELSE
  SET TRBETWEEN OFF
ENDIF
RETURN m.gstatus

* END genscrnx



FUNCTION genscx
PARAMETER projdbf,recno
PRIVATE screenset,obj_lib,obj_name,obj_base,obj_field,obj_expr
PRIVATE lib_name,lib_upd,loop_plat,loop_flag,loop_obj,loop_def
PRIVATE lastslct,lastexac,lastfilter,winrelease,scx_file
PRIVATE insscxs,memvarmode,basbefore,screenend,setupcd,section3
PRIVATE basobjs,setfilter,field_name,field_eval,field_type
PRIVATE old_text,new_text,match,match_drv,match_pos,match_no
PRIVATE snpttype,snptname,snptname_,storesize,fnctname,paramlist
PRIVATE name_mode,scx_alias,file_ext,comp_flag,gsx_flag,set_mode
PRIVATE rec_count,rec_total,str_data,str_data2,str_data3
PRIVATE r,r2,memline,at_pos,at_pos2,at_line,i,j,k,codedata
PRIVATE disable,enable,visible,dsblcode,enblcode

m.lastslct=SELECT()
IF USED('FOXSCX')
  USE IN FOXSCX
ENDIF
IF USED('_PJXDATA')
  SELECT _PJXDATA
  USE
ELSE
  SELECT 0
ENDIF
IF USED('PJXBASE')
  USE IN PJXBASE
ENDIF
IF USED('PJXDATA')
  SELECT PJXDATA
  USE
ELSE
  SELECT 0
ENDIF
USE (m.projdbf) AGAIN ALIAS PJXBASE
SET FILTER TO .NOT.DELETED()
LOCATE
IF .NOT.TYPE=='H'
  LOCATE FOR TYPE=='H'
  IF EOF()
    USE
    SELECT (m.lastslct)
    RETURN m.gstatus
  ENDIF
ENDIF
m.projpath=MLINE(NAME,1)
IF .NOT.'\'$m.projpath
  m.projpath=FULLPATH(m.projpath,m.projdbf)
ENDIF
m.projdbf=FULLPATH(uniqueflnm(),m.projdbf)
GOTO m.recno
IF TYPE==m.null
  m.recno=2
ELSE
  m.recno=3
ENDIF
m.i=SETID
IF m.i=0
  m.fromproj=.F.
ENDIF
IF m.i=0
  SORT TO (m.projdbf) ON SCRNORDER
ELSE
  SORT TO (m.projdbf) ON SCRNORDER FOR SETID=m.i.AND.UPPER(TYPE)=='S'
ENDIF
LOCATE
SELECT PJXBASE
LOCATE FOR TYPE=='H'
IF EOF()
  LOCATE
ENDIF
IF RECNO()>m.r_pjxbase
  m.r_pjxbase=m.r_pjxbase+1
ENDIF
RELEASE a_scatter
SCATTER TO a_scatter MEMO
SELECT 0
USE (m.projdbf) ALIAS PJXDATA
LOCATE
IF m.i#0
  INSERT BLANK BEFORE
  GATHER FROM a_scatter MEMO
  REPLACE SETID WITH m.i
ENDIF
RELEASE a_scatter
LOCATE FOR TYPE==m.null.OR.TYPE=='S'
IF m.fromproj.AND.RECNO()<=2
  SCATTER TO a_scatter MEMO
  DELETE
  APPEND BLANK
  GATHER FROM a_scatter MEMO
  RELEASE a_scatter
  PACK
  LOCATE FOR TYPE==m.null.OR.TYPE=='S'
  m.r_pjxbase=RECNO()
ENDIF
IF EOF()
  USE
  SELECT (m.lastslct)
  RETURN m.gstatus
ENDIF
m.recno=RECNO()
COUNT TO m.screens FOR SETID=m.i.AND.TYPE=='s'
IF m.screens=0
  m.screens=1
ENDIF
DIMENSION a_scxalias(m.screens),a_nowclaus(m.screens,4)
GOTO m.recno
DO CASE
  CASE TYPE('SAVECODE')#'L'
    m.allplatforms=.T.
  CASE m.platonly=='ON'
    m.allplatforms=.F.
    REPLACE SAVECODE WITH .T.
  CASE m.platonly=='OFF'
    m.allplatforms=.T.
    REPLACE SAVECODE WITH .F.
  OTHERWISE
    m.allplatforms=.NOT.SAVECODE
ENDCASE
m.memline=MLINE(OUTFILE,1)
IF m.fromproj
  m.fsprout=FULLPATH(STRTRAN(ALLTRIM(m.memline),m.null,''),m.projpath)
ELSE
  IF _WINDOWS
    m.fsprout=SUBSTR(FULLPATH(STRTRAN(STRTRAN(ALLTRIM(m.memline),;
              '..\',''),m.null,'')),3)
    IF ':'$m.memline
      m.fsprout=LEFT(m.memline,2)+m.fsprout
    ENDIF  
  ELSE
    m.fsprout=FULLPATH(STRTRAN(ALLTRIM(m.memline),m.null,''),m.projpath)
  ENDIF
ENDIF
IF .NOT.':'$m.fsprout
  SKIP -1
  IF SUBSTR(MLINE(NAME,1),2,1)==':'
    m.fsprout=LEFT(MLINE(NAME,1),2)+m.fsprout
  ENDIF
ENDIF
GOTO m.recno
m.fromproj=.NOT.EMPTY(TYPE).AND.ASC(TYPE)>0
IF m.fromproj
  m.at_pos=RAT('\',m.projpath)
  IF m.at_pos>0
    IF .NOT.LEFT(m.fsprout,1)=='\'.AND..NOT.':'$m.fsprout
      m.fsprout=LEFT(m.projpath,m.at_pos)+m.fsprout
    ENDIF
  ELSE
    LOCATE
    m.fsprout=FULLPATH(m.fsprout,HOMEDIR)
  ENDIF
ELSE
  m.fsprout=FULLPATH(m.fsprout,HOMEDIR)
ENDIF
GOTO m.recno
m.file_ext=UPPER(RIGHT(m.fsprout,4))
DO CASE
  CASE m.file_ext=='.SPR'
    m.file_ext='.SPX'
  CASE m.file_ext=='.MPR'
    m.file_ext='.MPX'
  OTHERWISE
    m.file_ext='.FXP'
ENDCASE
m.fspxout=trimext(m.fsprout)+m.file_ext
m.fsprerr=trimext(m.fsprout)+'.ERR'
IF m.fromproj
  REPLACE OUTFILE WITH m.fsprout+m.null, HOMEDIR WITH ''
ENDIF
m.winrelease=trimpath(m.fsprerr)
IF WEXIST(m.winrelease)
  RELEASE WINDOW (m.winrelease)
ENDIF
IF FILE(m.fsprerr)
  ERASE (m.fsprerr)
ENDIF
IF FILE(m.fspxout)
  ERASE (m.fspxout)
ENDIF
IF m.fromproj
  SELECT PJXBASE
  GOTO m.r_pjxbase
  IF RECNO()>=4
    SKIP -2
    IF .NOT.EOF()
      GOTO m.r_pjxbase
      SKIP -1
      m.i=0
      IF ATC('.SCX',NAME)=0
        SKIP 2
      ENDIF
      SKIP -1
      IF ATC('.SPR',NAME)=0
        SKIP -1
      ENDIF
      IF ATC('.SPR',NAME)>0
        m.fsprout2=FULLPATH(STRTRAN(ALLTRIM(MLINE(NAME,1)),m.null,''),m.fsprout)
        m.fspxout2=trimext(m.fsprout2)+'.SPX'
        IF FILE(m.fsprout2).AND..NOT.FILE(m.fspxout2)
          IF ADIR(a_dir,m.fsprout2)=1.AND.a_dir(1,2)=0
            ERASE (m.fsprout2)
          ENDIF
          RELEASE a_dir
        ENDIF
      ENDIF
    ENDIF
  ENDIF
ENDIF
m.screenend=.F.
IF m.fromproj
  SELECT PJXBASE
  GOTO m.r_pjxbase
  m.i=SETID
  SKIP 2
  IF EOF().OR.SETID=0
    m.screenend=.T.
  ENDIF
ENDIF
SELECT PJXBASE
IF m.recno>RECCOUNT()
  LOCATE FOR TYPE==m.null.OR.TYPE=='S'
  IF EOF()
    LOCATE
  ELSE
    m.recno=RECNO()
  ENDIF
ENDIF
GOTO m.recno
m.msg1=''
m.loop_plat=.F.
m.screenset=.F.
m.comp_flag=.F.
DO WHILE .T.
  DO WHILE .T.
    =esc_check()
    IF USED('SCXDATA')
      m.rec_count=RECCOUNT('SCXDATA')
    ENDIF
    m.platform_=ALLTRIM(m.platform_)
    DO CASE
      CASE EMPTY(m.platform_)
        IF m.allplatforms
          m.platform_=m.cplatform_
        ELSE
          DO CASE
            CASE _WINDOWS
              m.platform_='WINDOWS'
            CASE _MAC
              m.platform_='MAC'
            CASE _UNIX
              m.platform_='UNIX'
            OTHERWISE
              m.platform_='DOS'
          ENDCASE
        ENDIF
      CASE .NOT._FOX25.OR..NOT.m.allplatforms
        EXIT
      CASE m.platform_==m.null
        m.platform_=m.splatform_
      CASE .NOT.USED('SCXDATA')
        =.F.
      OTHERWISE
        DO CASE
          CASE m.platform_=='DOS'
            m.platform_='WINDOWS'
          CASE m.platform_=='WINDOWS'
            m.platform_='MAC'
          CASE m.platform_=='MAC'
            m.platform_='UNIX'
          CASE m.platform_=='UNIX'.AND..NOT.ALLTRIM(m.splatform_)=='DOS'
            m.platform_='DOS'
          OTHERWISE
            EXIT
        ENDCASE
        IF m.platform_==ALLTRIM(m.splatform_)
          EXIT
        ENDIF
    ENDCASE
    m.platform_=PADR(m.platform_,8)
    IF .NOT.m.allplatforms.OR.m.platform_==m.splatform_
      m.name_mode=.F.
      SELECT PJXDATA
      IF .NOT.TYPE=='s'
        LOCATE FOR TYPE=='s'
      ENDIF
      IF EOF()
        EXIT
      ENDIF
      IF m.fromproj
        m.fscxbase=ALLTRIM(MLINE(NAME,1))
        IF '\\'$m.fscxbase
          m.fscxbase=LOWER(FULLPATH(m.fscxbase,m.projpath))
          IF .NOT.':'$m.fscxbase.AND.SUBSTR(m.projpath,2,1)==':'
            m.fscxbase=LEFT(m.projpath,2)+m.fscxbase
          ENDIF
        ENDIF
        IF .NOT.FILE(m.fscxbase)
          m.at_pos=RAT('\',m.projpath)
          IF m.at_pos>0.AND..NOT.LEFT(m.fscxbase,1)=='\'.AND.;
             .NOT.':'$m.fscxbase
            m.fscxbase=LEFT(m.projpath,m.at_pos)+m.fscxbase
          ELSE
            LOCATE
            m.fscxbase=FULLPATH(trimpath(m.fscxbase),HOMEDIR)
            IF .NOT.FILE(m.fscxbase)
              m.fscxbase=FULLPATH(trimpath(m.fscxbase),m.projpath)
            ENDIF
          ENDIF
        ENDIF
        IF '\\'$m.fscxbase
          IF SUBSTR(m.fscxbase,2,1)==':'
            m.fscxbase=LEFT(m.fscxbase,2)+'\'+trimpath(m.fscxbase)
          ELSE
            m.fscxbase='\'+trimpath(m.fscxbase)
          ENDIF
        ENDIF
      ELSE
        m.fscxbase=SUBSTR(FULLPATH(STRTRAN(ALLTRIM(MLINE(NAME,1)),'..\','')),3)
        IF .NOT.'\'$m.fscxbase
          LOCATE
          m.fscxbase=FULLPATH(m.fscxbase,NAME)
        ELSE
          IF .NOT.':'$m.fscxbase
            IF SUBSTR(m.fsprout,2,1)==':'
              m.fscxbase=LEFT(m.fsprout,2)+m.fscxbase
            ENDIF
          ENDIF
          IF .NOT.FILE(m.fscxbase)
            m.fscxbase=trimpath(m.fscxbase)
            IF .NOT.FILE(m.fscxbase)
              LOCATE
              m.fscxbase=FULLPATH(m.fscxbase,NAME)
            ENDIF
          ENDIF
        ENDIF
      ENDIF
      m.fscxbase=STRTRAN(m.fscxbase,m.null,'')
      IF EOF().OR..NOT.FILE(m.fscxbase)
        EXIT
      ENDIF
      IF USED('SCXBASE')
        SELECT SCXBASE
        USE
      ELSE
        SELECT 0
      ENDIF
      USE (m.fscxbase) ALIAS SCXBASE AGAIN
      IF TYPE('PLATFORM')=='C'
        LOCATE FOR OBJTYPE=1.AND.PLATFORM==m.cplatform_
      ELSE
        LOCATE FOR OBJTYPE=1
      ENDIF
      IF EOF()
        IF TYPE('PLATFORM')#'C'
          EXIT
        ENDIF
        LOCATE FOR OBJTYPE=1.AND.PLATFORM==m.splatform_
        IF EOF()
          LOCATE FOR OBJTYPE=1
          IF EOF()
            EXIT
          ENDIF
          m.splatform_=PLATFORM
          m.platform_=m.null
          IF m.platonly=='ON'
            m.gen_mode=.F.
            EXIT
          ENDIF
          LOOP
        ENDIF
      ENDIF
      IF USED('FOXSCX')
        SELECT FOXSCX
        IF TYPE('PLATFORM')=='C'
          SET FILTER TO PLATFORM==m.platform_
        ELSE
          SET FILTER TO
        ENDIF
        SET ORDER TO OBJNAME_
        LOCATE
      ENDIF
      SELECT SCXBASE
      SCATTER MEMVAR MEMO
      IF .NOT.wordsearch(m.c_ignrbrcs)==m.null
        m.ignrbraces=.T.
      ENDIF
      m.setupcd=SETUPCODE
      m.setupcd=evltxt(m.setupcd)
      m.gsx_flag=(.NOT.SETUPCODE==m.setupcd)
      m.at_line=ATCLINE(m.c_noxgen,m.setupcd)
      IF m.at_line>0
        m.memline=ALLTRIM(MLINE(m.setupcd,m.at_line))
        m.at_pos=ATC(m.c_noxgen,m.memline)
        IF m.at_pos=1
          m.xgen_mode=.F.
          EXIT
        ENDIF
      ENDIF
      IF m.platonly=='ON'
        m.setupcd='*:SET PLATONLY ON'+m.cr_lf+m.setupcd
      ENDIF
      m.j=0
      FOR m.i = 1 TO 8
        IF .NOT.EMPTY(a_fscxdrv(1,m.i)).OR.(m.i<=6.AND.;
           .NOT.EMPTY(a_fsprdrv(1,m.i)))
          m.j=1
          EXIT
        ENDIF
      ENDFOR
      IF .NOT.m.gsx_flag.AND.m.j=0.AND..NOT.'*:'$m.setupcd.AND.;
         .NOT.m.c_insert$m.setupcd.AND..NOT.m.c_section3$m.setupcd
        LOCATE FOR '*:'$COMMENT.OR.('{{'$COMMENT.AND.'}}'$COMMENT)
        IF EOF()
          EXIT
        ENDIF
      ENDIF
      m.msg1='Initializing Screen Database...'
      m.msg2=trimpath(STRTRAN(IIF(_WINDOWS.OR._MAC,LOWER(m.fscxbase),;
             UPPER(m.fscxbase)),m.null,''))
      DO delaybar WITH m.msg1,m.msg2,0,.NOT.WEXIST('_wdelaybar')
      m.scxcount=m.scxcount+1
      m.cscxcount=ALLTRIM(STR(m.scxcount,2))
      FOR m.i = 1 TO m.screens
        a_scxalias(m.i)=uniqueflnm()+'.DBF'
        IF USED(a_scxalias(m.i))
          USE IN (a_scxalias(m.i))
        ENDIF
      ENDFOR
      m.fscxdata=FULLPATH(a_scxalias(m.scxcount),FULLPATH(m.fscxbase,m.fpjxbase))
      DIMENSION a_fscxdata(m.scxcount),a_scxupd(m.scxcount)
      a_fscxdata(m.scxcount)=m.fscxdata
      IF TYPE('PLATFORM')#'C'
        _FOX25=.F.
      ENDIF
      SELECT * FROM SCXBASE INTO TABLE (m.fscxdata)
      USE
      IF USED('SCXDATA')
        SELECT SCXDATA
        USE
      ELSE
        SELECT 0
      ENDIF
      USE (m.fscxdata) ALIAS SCXDATA
      IF TYPE('PLATFORM')=='C'
        LOCATE FOR OBJTYPE=1.AND.PLATFORM==m.splatform_
      ELSE
        LOCATE FOR OBJTYPE=1
      ENDIF
      IF EOF()
        EXIT
      ENDIF
      m.setupcd=SETUPCODE
      SCATTER MEMVAR MEMO
      m.setupcd=evltxt(m.setupcd)
      m.section3=''
      m.at_pos=ATC(m.c_section3,m.setupcd)
      IF m.at_pos>0.AND..NOT.wordsearch(m.c_section3,'m.setupcd')==m.null
        m.section3=SUBSTR(m.setupcd,m.at_pos)
        m.setupcd=LEFT(m.setupcd,m.at_pos-1)
      ENDIF
      m.setupcd=m.setupcd+m.cr_lf+REPLICATE('*',65)+m.cr_lf+;
                '*           This program was preprocessed by GENSCRNX.'+;
                m.cr_lf++'*'+m.cr_lf+;
                '*--GENSCRNX  '+m.gsxversion+m.cr_lf+;
                '*--Platform  '+VERSION()+m.cr_lf+;
                '*--Screen    '+m.fscxbase+m.cr_lf+;
                IIF(m.fromproj,'*--Project   '+m.fpjxbase+m.cr_lf,'')+;
                '*--FOXSCX    '+ALLTRIM(m.ffoxscx)+m.cr_lf+;
                '*--Time      '+DTOC(DATE())+' '+TIME()+m.cr_lf+;
                '*'+m.cr_lf+REPLICATE('*',65)+m.cr_lf+m.section3
      REPLACE SETUPCODE WITH m.setupcd
      SCATTER MEMVAR MEMO
      m.setupcd=''
      m.section3=''
      m.rec_count=RECCOUNT()
      DO delaybar WITH '','',100
      m.msg1=''
      IF m.scxcount>=2.AND.m.lib_mode.AND.wordsearch(m.c_deflib)==m.null
        LOOP
      ENDIF
    ENDIF
    IF .NOT.USED('SCXDATA')
      IF .NOT._FOX25
        =warning("GENSCRNX could not preprocess file")
        EXIT
      ENDIF
      LOCATE
      IF EOF()
        EXIT
      ENDIF
      m.splatform_=ALLTRIM(m.splatform_)
      DO CASE
        CASE m.splatform_=='WINDOWS'
          m.splatform_='DOS'
        CASE m.splatform_=='MAC'
          m.splatform_='WINDOWS'
        CASE m.splatform_=='UNIX'
          m.splatform_='MAC'
        CASE m.splatform_=='DOS'
          m.splatform_='UNIX'
        OTHERWISE
          EXIT
      ENDCASE
      m.splatform_=PADR(m.splatform_,8)
      m.platform_=m.null
      LOOP
    ENDIF
    m.screenset=.F.
    SELECT SCXDATA
    IF TYPE('PLATFORM')=='C'
      SET FILTER TO PLATFORM==m.platform_.AND.OBJTYPE#2.AND.OBJTYPE#10.AND.;
                    OBJTYPE#23
    ELSE
      SET FILTER TO OBJTYPE#2.AND.OBJTYPE#10.AND.OBJTYPE#23
    ENDIF 
    LOCATE
    IF EOF()
      LOOP
    ENDIF
    IF .NOT.m.lib_mode.AND..NOT.EMPTY(m.msg1)
      m.msg2=IIF(m.gen_mode,'['+ALLTRIM(m.platform_)+']','')
      DO delaybar WITH m.msg1,m.msg2,.1
    ENDIF
    IF USED('FOXSCX')
      SELECT FOXSCX
      IF TYPE('PLATFORM')=='C'
        SET FILTER TO PLATFORM==m.platform_
      ELSE
        SET FILTER TO
      ENDIF
      SET ORDER TO OBJNAME_
      LOCATE
      SELECT SCXDATA
    ENDIF
    COUNT TO m.rec_total
    LOCATE FOR OBJTYPE#1
    m.r_scxdata=IIF(EOF(),m.r_scxdata,RECNO())
    LOCATE
    m.setupcd=SETUPCODE
    m.setupcd=evltxt(m.setupcd)
    LOCATE
    m.section3=''
    m.at_pos=ATC(m.c_section3,m.setupcd)
    IF m.at_pos>0.AND..NOT.wordsearch(m.c_section3,'m.setupcd')==m.null
      m.section3=strtranc(SUBSTR(m.setupcd,m.at_pos),m.c_section3,;
                 m.m_section3)
      m.setupcd=LEFT(m.setupcd,m.at_pos-1)
    ENDIF
    REPLACE SETUPCODE WITH m.setupcd
    m.setupcd=''
    SCATTER MEMVAR MEMO
    m.scx_name=trimpath(m.fscxbase,.T.)
    m.lib_name=m.scx_name
    str_data=';'+ALLTRIM(FULLPATH(' ',m.fscxbase))+';'
    IF ATC(str_data,m.lastsetpath)=0
      m.newsetpath=m.lastsetpath+str_data
    ENDIF
    SET PATH TO (m.newsetpath)
    a_inclib=''
    a_baslib=''
    DIMENSION a_inclib(1),a_baslib(1)
    m.inclibs=0
    m.baslibs=0
    m.memvarmode=.F.
    m.match_drv=.F.
    FOR m.i = 1 TO 8
      a_scxdrvs(m.i)=0
      FOR m.k = 1 TO a_scxdrvm(m.i)
        IF FILE(a_fscxdrv(m.k,m.i))
          m.match_drv=.T.
          a_scxdrvs(m.i)=a_scxdrvs(m.i)+1
          IF ALEN(a_scxdrv)<(8*a_scxdrvs(m.i))
            DIMENSION a_scxdrv(a_scxdrvs(m.i),8)
          ENDIF
          a_scxdrv(a_scxdrvs(m.i),m.i)=a_fscxdrv(m.k,m.i)
        ELSE
          =warning(a_c_scxdrv(m.i),a_fscxdrv(m.k,m.i))
        ENDIF
      ENDFOR
      IF m.i>6
        LOOP
      ENDIF
      a_sprdrvs(m.i)=0
      FOR m.k = 1 TO a_sprdrvm(m.i)
        IF FILE(a_fsprdrv(m.k,m.i))
          a_sprdrvs(m.i)=a_sprdrvs(m.i)+1
          IF ALEN(a_sprdrv)<(6*a_sprdrvs(m.i))
            DIMENSION a_sprdrv(a_sprdrvs(m.i),6)
          ENDIF
          a_sprdrv(a_sprdrvs(m.i),m.i)=a_fsprdrv(m.k,m.i)
        ELSE
          =warning(a_c_sprdrv(m.i),a_fsprdrv(m.k,m.i))
        ENDIF
      ENDFOR
    ENDFOR
    m.loop_plat=.T.
    m.at_line=ATCLINE(m.c_drvoff,SETUPCODE)
    IF m.at_line>0
      m.i=m.at_line-1
      DO WHILE m.i<MEMLINES(SETUPCODE)
        m.i=m.i+1
        m.memline=ALLTRIM(MLINE(SETUPCODE,m.i))
        IF m.i>m.at_line.AND..NOT.'*:'$m.memline
          m.at_pos=AT(m.cr,SETUPCODE,m.i)+1
          IF m.at_pos=1.OR.ATC(m.c_drvoff,SUBSTR(SETUPCODE,m.at_pos))=0
            EXIT
          ENDIF
          LOOP
        ENDIF
        m.at_pos=ATC(m.c_drvoff,m.memline)
        IF m.at_pos=1
          m.memline=add_fext(ALLTRIM(SUBSTR(m.memline,m.at_pos+;
                    LEN(m.c_drvoff))))
          IF EMPTY(m.memline)
            LOOP
          ENDIF
          m.drvoffs=m.drvoffs+1
          DIMENSION a_drvoff(m.drvoffs)
          a_drvoff(m.drvoffs)=FULLPATH(m.memline)
        ENDIF
      ENDDO
    ENDIF
    m.at_line=ATCLINE(a_c_scxdrv(1),SETUPCODE)
    IF m.at_line>0
      m.i=m.at_line-1
      DO WHILE m.i<MEMLINES(SETUPCODE)
        m.i=m.i+1
        m.memline=ALLTRIM(MLINE(SETUPCODE,m.i))
        IF m.i>m.at_line.AND..NOT.'*:'$m.memline
          m.at_pos=AT(m.cr,SETUPCODE,m.i)+1
          IF m.at_pos=1.OR.ATC(a_c_scxdrv(1),SUBSTR(SETUPCODE,m.at_pos))=0
            EXIT
          ENDIF
          LOOP
        ENDIF
        m.at_pos=ATC(a_c_scxdrv(1),m.memline)
        IF m.at_pos=1
          m.memline=add_fext(ALLTRIM(SUBSTR(m.memline,m.at_pos+;
                    LEN(a_c_scxdrv(1)))))
          IF EMPTY(m.memline).OR..NOT.FILE(m.memline)
            =warning(a_c_scxdrv(1),m.memline)
            LOOP
          ENDIF
          FOR m.k = 1 TO a_scxdrvs(1)
            IF FULLPATH(a_scxdrv(m.k,1))==FULLPATH(m.memline)
              m.memline=''
              EXIT
            ENDIF
          ENDFOR
          IF EMPTY(m.memline)
            LOOP
          ENDIF
          a_scxdrvs(1)=a_scxdrvs(1)+1
          DIMENSION a_scxdrv(a_scxdrvs(1),8)
          a_scxdrv(a_scxdrvs(1),1)=FULLPATH(m.memline)
          LOOP
        ENDIF
      ENDDO
    ENDIF
    IF a_scxdrvs(1)>0
      m.drv_no=1
      FOR m.drv_cnt = 1 TO a_scxdrvs(1)
        IF ASCAN(a_drvoff,FULLPATH(a_scxdrv(m.drv_cnt,1)))>0
          LOOP
        ENDIF
        SCAN ALL FOR .NOT.DELETED()
          m.match_drv=.T.
          DO (a_scxdrv(m.drv_cnt,1))
          DO esc_check
        ENDSCAN
        LOCATE
        SCATTER MEMVAR MEMO
        DO restoreenv
      ENDFOR
    ENDIF
    m.insscxs=0
    m.at_line=ATCLINE('*:',SETUPCODE)
    IF m.at_line>0
      m.i=m.at_line-1
      DO WHILE m.i<MEMLINES(SETUPCODE)
        m.i=m.i+1
        m.memline=ALLTRIM(MLINE(SETUPCODE,m.i))
        IF m.i>m.at_line.AND..NOT.'*:'$m.memline
          m.at_pos=AT(m.cr,SETUPCODE,m.i)+1
          IF m.at_pos=1.OR.ATC('*:',SUBSTR(SETUPCODE,m.at_pos))=0
            EXIT
          ENDIF
          LOOP
        ENDIF
        FOR m.j = 2 TO 8
          m.at_pos=ATC(a_c_scxdrv(m.j),m.memline)
          IF m.at_pos=1
            m.memline=add_fext(ALLTRIM(SUBSTR(m.memline,m.at_pos+;
                      LEN(a_c_scxdrv(m.j)))))
            IF EMPTY(m.memline).OR..NOT.FILE(m.memline)
              =warning(a_c_scxdrv(m.j),m.memline)
              LOOP
            ENDIF
            FOR m.k = 1 TO a_scxdrvs(m.j)
              IF FULLPATH(a_scxdrv(m.k,m.j))==FULLPATH(m.memline)
                m.memline=''
                EXIT
              ENDIF
            ENDFOR
            IF EMPTY(m.memline)
              LOOP
            ENDIF
            a_scxdrvs(m.j)=a_scxdrvs(m.j)+1
            IF ALEN(a_scxdrv)<(8*a_scxdrvs(m.j))
              DIMENSION a_scxdrv(a_scxdrvs(m.j),8)
            ENDIF
            a_scxdrv(a_scxdrvs(m.j),m.j)=FULLPATH(m.memline)
            LOOP
          ENDIF
        ENDFOR
        FOR m.j = 1 TO 6
          m.at_pos=ATC(a_c_sprdrv(m.j),m.memline)
          IF m.at_pos=1
            m.memline=add_fext(ALLTRIM(SUBSTR(m.memline,m.at_pos+;
                      LEN(a_c_sprdrv(m.j)))))
            IF EMPTY(m.memline).OR..NOT.FILE(m.memline)
              =warning(a_c_sprdrv(m.j),m.memline)
              LOOP
            ENDIF
            FOR m.k = 1 TO a_sprdrvs(m.j)
              IF FULLPATH(a_sprdrv(m.k,m.j))==FULLPATH(m.memline)
                m.memline=''
                EXIT
              ENDIF
            ENDFOR
            IF EMPTY(m.memline)
              LOOP
            ENDIF
            a_sprdrvs(m.j)=a_sprdrvs(m.j)+1
            IF ALEN(a_sprdrv)<(8*a_sprdrvs(m.j))
              DIMENSION a_sprdrv(a_sprdrvs(m.j),8)
            ENDIF
            a_sprdrv(a_sprdrvs(m.j),m.j)=FULLPATH(m.memline)
            LOOP
          ENDIF
        ENDFOR
        IF m.scxcount=1.AND.(m.screens=1.OR.m.scrnsetflag).AND.;
           m.platform_==m.splatform_
          m.at_pos=ATC(m.c_screenset,m.memline)
          IF m.at_pos=1
            m.memline=ALLTRIM(SUBSTR(m.memline,m.at_pos+LEN(m.c_screenset)))
            IF EMPTY(m.memline)
              LOOP
            ENDIF
            IF .NOT.'.'$m.memline
              m.memline=m.memline+'.SCX'
            ENDIF
            m.memline=UPPER(FULLPATH(m.memline))
            IF FILE(m.memline)
              SELECT PJXDATA
              m.r2=RECNO()
              LOCATE FOR TYPE=='s'
              IF .NOT.EOF().AND.trimpath(m.fscxbase,.F.,.T.)==trimpath(STRTRAN(;
                 ALLTRIM(MLINE(NAME,1)),m.null,''),.F.,.T.)
                m.r2=RECNO()
                m.scrnsetflag=.T.
                RELEASE a_fscatter2
                SCATTER TO a_fscatter2 MEMO
                APPEND BLANK
                GATHER FROM a_fscatter2 MEMO
                RELEASE a_fscatter2
                REPLACE NAME WITH m.memline, SCRNORDER WITH m.screens
                m.screens=m.screens+1
                DIMENSION a_scxalias(m.screens),a_nowclaus(m.screens,4)
                a_scxalias(m.screens)=uniqueflnm()+'.DBF'
                IF USED(a_scxalias(m.screens))
                  USE IN (a_scxalias(m.screens))
                ENDIF
              ENDIF
              GOTO m.r2
              SELECT SCXDATA
            ELSE
              =warning(m.c_screenset,m.memline)
            ENDIF
            LOOP
          ENDIF
        ENDIF
        m.at_pos=ATC(m.c_deflib,m.memline)
        IF m.at_pos=1
          m.memline=ALLTRIM(UPPER(SUBSTR(m.memline,m.at_pos+LEN(m.c_deflib))))
          IF EMPTY(m.memline)
            LOOP
          ENDIF
          m.lib_mode=.T.
          m.lib_name=m.memline
          REPLACE SETUPCODE WITH strtranc(SETUPCODE,m.c_deflib,m.m_deflib)
        ELSE
          m.at_pos=ATC(m.c_nogen,m.memline)
        ENDIF
        IF m.at_pos=1
          IF .NOT.m.gen_mode
            LOOP
          ENDIF
          m.gen_mode=.F.
          IF m.fromproj.AND..NOT.m.screenend
            REPLACE COMMENT WITH ''
            COPY MEMO COMMENT TO (m.fsprout)
          ELSE
            IF FILE(m.fsprout)
              ERASE (m.fsprout)
            ENDIF
          ENDIF
          IF FILE(m.fspxout)
            ERASE (m.fspxout)
          ENDIF
          IF FILE(m.fsprerr)
            ERASE (m.fsprerr)
          ENDIF
          LOOP
        ENDIF
        m.at_pos=ATC(m.c_inclib,m.memline)
        IF m.at_pos=1
          m.memline=CHRTRAN(UPPER(ALLTRIM(SUBSTR(m.memline,m.at_pos+;
                    LEN(m.c_inclib)))),m.badchars,m.stdascii)
          IF EMPTY(m.memline)
            LOOP
          ENDIF
          m.inclibs=m.inclibs+1
          DIMENSION a_inclib(m.inclibs)
          a_inclib(m.inclibs)=m.memline
          LOOP
        ENDIF
        m.at_pos=ATC(m.c_baslib,m.memline)
        IF m.at_pos=1
          m.memline=CHRTRAN(UPPER(ALLTRIM(SUBSTR(m.memline,m.at_pos+;
                    LEN(m.c_baslib)))),m.badchars,m.stdascii)
          IF EMPTY(m.memline)
            LOOP
          ENDIF
          m.baslibs=m.baslibs+1
          DIMENSION a_baslib(m.baslibs)
          a_baslib(m.baslibs)=m.memline
          IF ASCAN(a_inclib,m.memline)=0
            m.inclibs=m.inclibs+1
            DIMENSION a_inclib(m.inclibs)
            a_inclib(m.inclibs)=m.memline
          ENDIF
          LOOP
        ENDIF
        m.at_pos=ATC(m.c_nowclaus,m.memline)
        IF m.at_pos=1
          m.memline=ALLTRIM(SUBSTR(m.memline,m.at_pos+LEN(m.c_nowclaus)))
          IF EMPTY(m.memline)
            LOOP
          ENDIF
          m.str_data=LEFT(m.platform_,1)
          DO CASE
            CASE m.str_data=='D'
              m.j=1
            CASE m.str_data=='W'
              m.j=2
            CASE m.str_data=='M'
              m.j=3
            OTHERWISE
              m.j=4
          ENDCASE
          IF EMPTY(m.name)
            m.name=SYS(2015)
          ENDIF
          m.name=PADR(m.name,10)+m.str_data
          REPLACE NAME WITH m.name
          a_nowclaus(m.scxcount,m.j)=m.name+ALLTRIM(m.memline)
          m.updsprflag=.T.
          LOOP
        ENDIF
        m.at_pos=ATC(m.c_memvar,m.memline)
        IF m.at_pos=1
          m.memvarmode=.T.
          LOOP
        ENDIF
        IF TYPE('PLATFORM')=='C'
          m.at_pos=ATC(m.c_name,m.memline)
          IF m.at_pos=1
            m.name_mode=.T.
            LOOP
          ENDIF
        ENDIF
        IF .NOT.m.platform_==m.cplatform_.AND..NOT.m.platform_==m.splatform_
          LOOP
        ENDIF
        m.at_pos=ATC(m.c_noxgen,m.memline)
        IF m.at_pos=1
          m.xgen_mode=.F.
          EXIT
        ENDIF
        m.at_pos=ATC(m.c_pjxset,m.memline)
        IF m.at_pos=1
          m.pjxset=.T.
          LOOP
        ENDIF
        m.at_pos=ATC(m.c_set,m.memline)
        IF m.at_pos=1
          IF m.pjxset.AND.m.fromproj
            LOOP
          ENDIF
          m.memline=ALLTRIM(STRTRAN(SUBSTR(m.memline,m.at_pos+;
                    LEN(m.c_set)),CHR(9),' '))
          m.at_pos=AT(' ',m.memline)
          IF m.at_pos=0
            LOOP
          ENDIF
          m.field_name='PJXDATA.'+ALLTRIM(UPPER(LEFT(m.memline,m.at_pos)))
          IF TYPE(m.field_name)=='U'
            m.field_name=STRTRAN(STRTRAN(m.field_name,'BORDERGETS','NOLOGO'),;
                         'PLATONLY','SAVECODE')
            IF TYPE(m.field_name)=='U'
              LOOP
            ENDIF
          ENDIF
          m.memline=ALLTRIM(UPPER(SUBSTR(m.memline,m.at_pos)))
          DO CASE
            CASE EMPTY(m.memline)
              LOOP
            CASE ATC('ASSOCWINDS',m.field_name)>0
              m.at_pos=AT(' ',m.memline)
              IF m.at_pos=0
                LOOP
              ENDIF
              IF .NOT.ALLTRIM(UPPER(LEFT(m.memline,m.at_pos)))=='TO'
                LOOP
              ENDIF
              m.memline=ALLTRIM(SUBSTR(m.memline,m.at_pos))
              m.set_mode=STRTRAN(m.memline,',',CHR(13))+CHR(13)
            CASE m.memline=='ON'
              m.set_mode=.T.
            CASE m.memline=='OFF'
              m.set_mode=.F.
            OTHERWISE
              LOOP
          ENDCASE
          GOTO m.recno IN PJXDATA
          IF TYPE(m.field_name)=='M'
            REPLACE (m.field_name) WITH EVALUATE(m.field_name)+m.set_mode,;
                    PJXDATA.MODAL WITH .T.
          ELSE
            REPLACE (m.field_name) WITH m.set_mode
            IF ATC('SAVECODE',m.field_name)>0
              m.allplatforms=.NOT.EVALUATE(m.field_name)
            ENDIF
          ENDIF
          LOOP
        ENDIF
        m.at_pos=ATC(m.c_prg,m.memline)
        IF m.at_pos=1
          IF m.pjxset.AND.m.fromproj
            LOOP
          ENDIF
          m.at_pos=AT('.',m.fsprout)
          REPLACE SETUPCODE WITH '#NOREAD PLAIN'+m.cr_lf+SETUPCODE
          m.i=m.i+1
          m.memline=m.c_outfile+' '+IIF(m.at_pos=0,m.fsprout,;
                    LEFT(m.fsprout,m.at_pos-1))+'.PRG'
        ENDIF
        m.at_pos=ATC(m.c_outfile,m.memline)
        IF m.at_pos=1
          IF m.fromproj
            LOOP
          ENDIF
          m.memline=UPPER(ALLTRIM(SUBSTR(m.memline,m.at_pos+LEN(m.c_outfile))))
          m.at_pos=AT('.',m.memline)
          DO CASE
            CASE EMPTY(m.memline)
              LOOP
            CASE m.at_pos=0
              m.memline=m.memline+'.SPR'
            CASE m.at_pos=LEN(m.memline)
              m.memline=m.memline+'SPR'
          ENDCASE
          GOTO m.recno IN PJXDATA
          IF ':'$m.memline.OR.'\'$m.memline
            m.fsprout=m.memline
          ELSE
            m.fsprout=FULLPATH(m.memline,m.fscxbase)
          ENDIF
          m.file_ext=UPPER(RIGHT(m.fsprout,4))
          DO CASE
            CASE m.file_ext=='.SPR'
              m.file_ext='.SPX'
            CASE m.file_ext=='.MPR'
              m.file_ext='.MPX'
            OTHERWISE
              m.file_ext='.FXP'
          ENDCASE
          m.fspxout=trimext(m.fsprout)+m.file_ext
          m.fsprerr=trimext(m.fsprout)+'.ERR'
          REPLACE PJXDATA.OUTFILE WITH m.fsprout+m.null
          m.winrelease=trimpath(m.fsprerr)
          IF WEXIST(m.winrelease)
            RELEASE WINDOW (m.winrelease)
          ENDIF
          IF FILE(m.fsprerr)
            ERASE (m.fsprerr)
          ENDIF
          IF FILE(m.fspxout)
            ERASE (m.fspxout)
          ENDIF
          m.winrelease=trimpath(m.fsprout)
          IF WEXIST(m.winrelease)
            RELEASE WINDOW (m.winrelease)
          ENDIF
          IF FILE(m.fsprout)
            ERASE (m.fsprout)
          ENDIF
          LOOP
        ENDIF
        m.at_pos=ATC(m.c_compspr,m.memline)
        IF m.at_pos=1
          m.compspr='ON'
          LOOP
        ENDIF
        m.at_pos=ATC(m.c_nocompspr,m.memline)
        IF m.at_pos=1
          m.compspr='OFF'
          LOOP
        ENDIF
        m.at_pos=ATC(m.c_dispspr,m.memline)
        IF m.at_pos=1
          m.dispspr='ON'
          LOOP
        ENDIF
        m.at_pos=ATC(m.c_nodispspr,m.memline)
        IF m.at_pos=1
          m.dispspr='OFF'
          LOOP
        ENDIF
        IF .NOT.m.noautorun
          m.at_pos=ATC(m.c_autorun,m.memline)
          IF m.at_pos=1
            m.autorun='ON'
            IF .NOT.m.autorunsave
              m.str_data=UPPER(ALLTRIM(SUBSTR(m.memline,m.at_pos+LEN(m.c_autorun))))
              m.autorunsave=(m.str_data=='SAVE')
            ENDIF
            LOOP
          ENDIF
        ENDIF
        m.at_pos=ATC(m.c_noautorun,m.memline)
        IF m.at_pos=1
          m.autorun='OFF'
          m.noautorun=.T.
          LOOP
        ENDIF
        m.at_pos=ATC(m.c_scnobj,m.memline)
        IF m.at_pos=1
          m.scnobj='ON'
          LOOP
        ENDIF
        m.at_pos=ATC(m.c_noscnobj,m.memline)
        IF m.at_pos=1
          m.scnobj='OFF'
          LOOP
        ENDIF
        m.at_pos=ATC(m.c_braces,m.memline)
        IF m.at_pos=1
          m.braces='ON'
          LOOP
        ENDIF
        m.at_pos=ATC(m.c_nobraces,m.memline)
        IF m.at_pos=1
          m.braces='OFF'
          LOOP
        ENDIF
        m.at_pos=ATC(m.c_ignrbrcs,m.memline)
        IF m.at_pos=1
          m.ignrbraces=.T.
          LOOP
        ENDIF
        m.at_pos=ATC(m.c_genscrnx,m.memline)
        IF m.at_pos=1
          m.memline=ALLTRIM(SUBSTR(m.memline,m.at_pos+LEN(m.c_genscrnx)))
          IF EMPTY(m.memline)
            LOOP
          ENDIF
          IF ':'$m.memline.OR.'\'$m.memline
            m.genscrn=m.memline
          ELSE
            m.genscrn=FULLPATH(m.memline,SYS(2004))
          ENDIF
          IF .NOT.'.'$RIGHT(m.genscrn,4)
            m.genscrn=m.genscrn+'.PRG'
          ENDIF
          LOOP
        ENDIF
      ENDDO
    ENDIF
    IF .NOT.m.xgen_mode
      EXIT
    ENDIF
    SELECT SCXDATA
    LOCATE
    IF EMPTY(m.msg1)
      m.comp_flag=.T.
      m.str_data=LOWER(IIF(':'$m.fscxbase,m.fscxbase,FULLPATH(m.fscxbase)))
      DO CASE
        CASE m.gen_mode
          IF _WINDOWS.OR._MAC
            SET MESSAGE TO LEFT('Generating Screen Database: '+m.str_data,79)
          ENDIF
          m.msg1='Generating Screen Database...'
        CASE m.lib_mode
          IF _WINDOWS.OR._MAC
            SET MESSAGE TO LEFT('Updating Library Database: '+m.str_data,79)
          ENDIF
          m.msg1='Updating Library Database...'
        OTHERWISE
          IF _WINDOWS.OR._MAC
            SET MESSAGE TO LEFT('Scanning Screen Database: '+m.str_data,79)
          ENDIF
          m.msg1='Scanning Screen Database...'
      ENDCASE
      m.msg2=IIF(m.gen_mode,'['+ALLTRIM(m.platform_)+']','')
      DO delaybar WITH m.msg1,m.msg2,.1
    ELSE
      m.msg2=IIF(m.gen_mode,'['+ALLTRIM(m.platform_)+']','')
    ENDIF
    DO esc_check
    GOTO m.recno IN PJXDATA
    IF .NOT.openfoxscx()
      EXIT
    ENDIF
    SELECT FOXSCX
    IF TYPE('PLATFORM')=='C'
      SET FILTER TO PLATFORM==m.platform_
    ELSE
      SET FILTER TO
    ENDIF
    SET ORDER TO OBJSCX_
    LOCATE
    m.scx_name=PADR(m.scx_name,LEN(OBJSCX_))
    m.lib_name=PADR(m.lib_name,LEN(OBJLIB_))
    SEEK m.scx_name+m.lib_name
    REPLACE REST OBJFLAG_ WITH .F.;
            WHILE OBJSCX_==m.scx_name.AND.OBJLIB_==m.lib_name
    LOCATE
    SELECT SCXDATA
    LOCATE
    m.setupcd=SETUPCODE
    REPLACE SETUPCODE WITH evltxt(m.setupcd)
    m.setupcd=''
    IF ATC(m.c_defobj,SETUPCODE)>0.OR.ATC(m.c_basobj,SETUPCODE)>0
      REPLACE COMMENT WITH SETUPCODE
    ENDIF
    SCATTER MEMVAR MEMO
    m.lastfilter=FILTER()
    m.lib_upd=.F.
    m.loop_flag=.F.
    m.loop_def=.F.
    DO delaybar WITH '','',5
    DO WHILE .T.
      DO esc_check
      m.loop_obj=.F.
      SCAN ALL FOR .NOT.DELETED()
        IF wordsearch(m.c_delete)==m.null
          LOOP
        ENDIF
        =delrec()
        REPLACE COMMENT WITH strtranc(COMMENT,m.c_delete,m.m_delete)
      ENDSCAN
      IF .NOT.m.ignrbraces.AND..NOT.m.lib_mode
        SCAN ALL FOR .NOT.DELETED()
          DO CASE
            CASE m.braces=='ON'
              =evlrec()
            CASE OBJTYPE#1.AND..NOT.wordsearch(m.c_evltxt)==m.null
              =evlrec()
            CASE OBJTYPE=1.AND..NOT.wordsearch(m.c_evltxt,.T.)==m.null
              =evlrec()
          ENDCASE
        ENDSCAN
      ENDIF
      IF m.r_scxdata>RECCOUNT()
        EXIT
      ENDIF
      GOTO m.r_scxdata
      m.match_drv=.F.
      IF m.gen_mode.AND..NOT.m.loop_flag.AND.a_scxdrvs(2)>0
        m.drv_no=2
        FOR m.drv_cnt = 1 TO a_scxdrvs(2)
          IF ASCAN(a_drvoff,FULLPATH(a_scxdrv(m.drv_cnt,2)))>0
            LOOP
          ENDIF
          m.msg3='['+ALLTRIM(m.platform_)+'] '+trimpath(a_scxdrv(m.drv_cnt,2),.F.,.T.)
          DO delaybar WITH '',m.msg3,90*m.drv_cnt/a_scxdrvs(2)+5
          SCAN ALL FOR .NOT.DELETED()
            m.match_drv=.T.
            DO (a_scxdrv(m.drv_cnt,2))
            DO esc_check
          ENDSCAN
          LOCATE
          SCATTER MEMVAR MEMO
          DO restoreenv
        ENDFOR
      ENDIF
      IF m.match_drv
        DO delaybar WITH '',m.msg2,5
      ENDIF
      m.match_drv=.F.
      IF m.gen_mode.AND.a_scxdrvs(3)>0
        m.drv_no=3
        FOR m.drv_cnt = 1 TO a_scxdrvs(3)
          IF ASCAN(a_drvoff,FULLPATH(a_scxdrv(m.drv_cnt,3)))>0
            LOOP
          ENDIF
          m.msg3='['+ALLTRIM(m.platform_)+'] '+trimpath(a_scxdrv(m.drv_cnt,3),.F.,.T.)
          DO delaybar WITH '',m.msg3,90*m.drv_cnt/a_scxdrvs(3)+5
          SCAN ALL FOR .NOT.DELETED()
            m.match_drv=.T.
            DO (a_scxdrv(m.drv_cnt,3))
            DO esc_check
          ENDSCAN
          LOCATE
          SCATTER MEMVAR MEMO
          DO restoreenv
        ENDFOR
      ENDIF
      IF m.match_drv
        DO delaybar WITH '',m.msg2,5
      ENDIF
      IF m.r_scxdata>RECCOUNT()
        EXIT
      ENDIF
      LOCATE
      m.obj_name=SPACE(LEN(FOXSCX.OBJNAME_))
      m.obj_base=SPACE(LEN(FOXSCX.OBJBASE_))
      m.obj_field=SPACE(LEN(FOXSCX.OBJFIELD_))
      m.obj_lib=SPACE(LEN(FOXSCX.OBJLIB_))
      SCAN ALL FOR .NOT.DELETED()
        m.obj_name=SPACE(LEN(FOXSCX.OBJNAME_))
        m.obj_base=SPACE(LEN(FOXSCX.OBJBASE_))
        m.obj_field=SPACE(LEN(FOXSCX.OBJFIELD_))
        m.obj_lib=SPACE(LEN(FOXSCX.OBJLIB_))
        IF m.memvarmode.AND.OBJTYPE#1
          m.old_text=ALLTRIM(MLINE(NAME,1))
          m.at_pos=AT('.',m.old_text)
          m.new_text='m'+SUBSTR(m.old_text,m.at_pos)
          IF m.at_pos>0.AND.(m.at_pos#2.OR.;
             .NOT.UPPER(LEFT(m.old_text,2))=='M.').AND.;
             .NOT.m.old_text==m.new_text
            REPLACE NAME WITH m.new_text,;
                    WHEN WITH strtranc(WHEN,m.old_text,m.new_text),;
                    VALID WITH strtranc(VALID,m.old_text,m.new_text),;
                    MESSAGE WITH strtranc(MESSAGE,m.old_text,m.new_text),;
                    ERROR WITH strtranc(ERROR,m.old_text,m.new_text),;
                    RANGELO WITH strtranc(RANGELO,m.old_text,m.new_text),;
                    RANGEHI WITH strtranc(RANGEHI,m.old_text,m.new_text)
          ENDIF
        ENDIF
        IF m.lib_mode.AND..NOT.m.loop_flag.AND.ATC(m.c_defobj,COMMENT)>0
          m.at_line=ATCLINE(m.c_defobj,COMMENT)
          IF m.at_line>0
            FOR m.i = m.at_line TO MEMLINES(COMMENT)
              m.memline=ALLTRIM(MLINE(COMMENT,m.i))
              IF m.i>m.at_line.AND..NOT.'*:'$m.memline
                m.at_pos=AT(m.cr,COMMENT,m.i)+1
                IF m.at_pos=1.OR.ATC(m.c_defobj,SUBSTR(COMMENT,m.at_pos))=0
                  EXIT
                ENDIF
                LOOP
              ENDIF
              m.at_pos=ATC(m.c_defobj,m.memline)
              IF m.at_pos=1
                m.obj_name=PADR(CHRTRAN(ALLTRIM(SUBSTR(m.memline,m.at_pos+;
                           LEN(m.c_defobj))),m.badchars,m.stdascii),;
                           LEN(FOXSCX.OBJNAME_))
                EXIT
              ENDIF
            ENDFOR
          ENDIF
        ENDIF
        m.at_line=ATCLINE(m.c_basobj,COMMENT)
        IF m.at_line>0
          FOR m.i = m.at_line TO MEMLINES(COMMENT)
            m.memline=ALLTRIM(MLINE(COMMENT,m.i))
            IF m.i>m.at_line.AND..NOT.'*:'$m.memline
              m.at_pos=AT(m.cr,COMMENT,m.i)+1
              IF m.at_pos=1.OR.ATC(m.c_basobj,SUBSTR(COMMENT,m.at_pos))=0
                EXIT
              ENDIF
              LOOP
            ENDIF
            m.at_pos=ATC(m.c_basobj,m.memline)
            IF m.at_pos=1
              m.obj_base=PADR(ALLTRIM(SUBSTR(m.memline,m.at_pos+;
                         LEN(m.c_basobj))),LEN(FOXSCX.OBJBASE_))
              EXIT
            ENDIF
          ENDFOR
        ENDIF
        IF OBJTYPE>=11
          m.obj_field=MLINE(NAME,1)
          m.obj_field=PADR(ALLTRIM(UPPER(SUBSTR(m.obj_field,AT('.',;
                      m.obj_field)+1))),LEN(FOXSCX.OBJFIELD_))
          IF m.baslibs>0.AND..NOT.EMPTY(m.obj_field)
            m.r=RECNO()
            SELECT FOXSCX
            SET ORDER TO OBJFIELD_
            m.lastexac=SET('EXACT')
            SET EXACT ON
            FOR m.i = 1 TO m.baslibs
              SEEK PADR(m.obj_field,LEN(OBJFIELD_))+;
                   PADR(a_baslib(m.i),LEN(OBJLIB_))
              IF .NOT.EOF()
                m.obj_base=OBJNAME_
                m.obj_lib=OBJLIB_
                EXIT
              ENDIF
            ENDFOR
            IF m.lastexac=='ON'
              SET EXACT ON
            ELSE
              SET EXACT OFF
            ENDIF
            SELECT SCXDATA
            GOTO m.r
            IF EMPTY(m.obj_base).OR.ATC(m.m_basobj,COMMENT)>0.OR.;
               EMPTY(wordsearch(m.c_basobj))
              LOOP
            ENDIF
            REPLACE COMMENT WITH m.c_basobj+' '+m.obj_base+m.cr_lf+COMMENT
          ENDIF
        ENDIF
        IF .NOT.m.lib_mode.OR.EMPTY(m.obj_name)
          LOOP
        ENDIF
        m.lib_upd=.T.
        m.i=m.r_scxdata-2
        m.msg3='['+ALLTRIM(m.platform_)+'] '+ALLTRIM(m.lib_name)+'.'+;
               m.obj_name
        DO delaybar WITH '',m.msg3,90*(RECNO()-m.i)/m.rec_total+5
        IF ATC(m.c_defobj,SETUPCODE)>0
          REPLACE SETUPCODE WITH strtranc(SETUPCODE,m.c_defobj,m.m_defobj)
        ENDIF
        REPLACE COMMENT WITH IIF(OBJTYPE=1,'',strtranc(COMMENT,m.c_defobj,m.m_defobj))
        DIMENSION a_fields(1)
        =AFIELDS(a_fields)
        RELEASE a_scatter
        SCATTER TO a_scatter MEMO
        SELECT FOXSCX
        SET ORDER TO OBJNAME_
        SEEK UPPER(m.obj_name+m.lib_name)
        IF EOF()
          INSERT BLANK
        ENDIF
        IF ALEN(a_scatter)=(FCOUNT()-m.fcountadj)
          GATHER FROM a_scatter MEMO
        ELSE
          m.lastexac=SET('EXACT')
          SET EXACT ON
          FOR m.i = 1 TO (FCOUNT()-m.fcountadj)
            m.j=ASCAN(a_fields,FIELD(m.i))
            IF m.j=0
              LOOP
            ENDIF
            REPLACE (FIELD(m.i)) WITH a_scatter(INT(m.j/4)+1)
          ENDFOR
          IF m.lastexac=='ON'
            SET EXACT ON
          ELSE
            SET EXACT OFF
          ENDIF
        ENDIF
        REPLACE PLATFORM WITH m.platform_, OBJNAME_ WITH m.obj_name,;
                OBJBASE_ WITH m.obj_base, OBJFIELD_ WITH m.obj_field,;
                OBJLIB_ WITH m.lib_name, OBJSCX_ WITH m.scx_name,;
                OBJFLAG_ WITH .T.
        SELECT SCXDATA
      ENDSCAN
      SELECT SCXDATA
      IF m.r_scxdata>RECCOUNT()
        EXIT
      ENDIF
      GOTO m.r_scxdata
      IF .NOT.m.gen_mode
        EXIT
      ENDIF
      IF m.lib_upd.AND..NOT.m.loop_def
        DO delaybar WITH '',m.msg2,5
      ENDIF
      m.loop_def=.T.
      GOTO m.r_scxdata
      SCAN REST FOR .NOT.DELETED()
        m.at_pos=ATC(m.c_trntxt,COMMENT)
        IF m.at_pos=0
          LOOP
        ENDIF
        m.str_data=SUBSTR(COMMENT,m.at_pos)
        FOR m.i = 1 TO MEMLINES(m.str_data)
          m.memline=ALLTRIM(MLINE(m.str_data,m.i))
          m.at_pos=ATC(m.c_trntxt,m.memline)
          IF m.at_pos=1
            m.at_pos=AT('||',m.memline)
            IF m.at_pos=0
              LOOP
            ENDIF
            m.old_text=ALLTRIM(SUBSTR(m.memline,LEN(m.c_trntxt)+1,m.at_pos-;
                       LEN(m.c_trntxt)-1))
            IF LEN(m.old_text)=0
              LOOP
            ENDIF
            m.old_text=STRTRAN(STRTRAN(STRTRAN(STRTRAN(m.old_text,'\\',;
                       '\'),'\t',CHR(9)),'\n',CHR(10)),'\r',CHR(13))
            m.at_pos2=AT('||',m.memline,2)
            m.new_text=ALLTRIM(SUBSTR(m.memline,m.at_pos+2,;
                       IIF(m.at_pos2=0,LEN(m.memline),m.at_pos2-m.at_pos-2)))
            m.new_text=STRTRAN(STRTRAN(STRTRAN(STRTRAN(m.new_text,'\\',;
                       '\'),'\t',CHR(9)),'\n',CHR(10)),'\r',CHR(13))
            m.match_pos=.F.
            m.match_no=.F.
            IF m.at_pos2>0
              m.at_pos=AT('||',m.memline,3)
              m.match_pos=VAL(SUBSTR(m.memline,m.at_pos2+2,;
                          IIF(m.at_pos=0,LEN(m.memline),m.at_pos-m.at_pos2-2)))
              IF m.at_pos>0
                m.match_no=VAL(SUBSTR(m.memline,m.at_pos+2))
              ENDIF
            ENDIF
            FOR m.j = 1 TO FCOUNT()
              m.field_name=FIELD(m.j)
              IF TYPE(m.field_name)#'M'
                LOOP
              ENDIF
              m.field_eval=EVALUATE(m.field_name)
              IF m.field_name=='COMMENT'
                m.at_pos=OCCURS('||',m.field_eval)
                IF m.at_pos>0
                  m.at_pos=AT('||',m.field_eval,m.at_pos)
                  IF m.at_pos>0
                    REPLACE (m.field_name) WITH LEFT(m.field_eval,m.at_pos-1)+;
                            strtranc(SUBSTR(m.field_eval,m.at_pos),m.old_text,;
                            m.new_text,m.match_pos,m.match_no)
                  ENDIF
                ENDIF
                LOOP
              ENDIF
              IF ATC(m.old_text,m.field_eval)>0
                REPLACE (m.field_name) WITH strtranc(m.field_eval,m.old_text,;
                                            m.new_text,m.match_pos,m.match_no)
              ENDIF
            ENDFOR
            IF .NOT.m.ignrbraces.AND.m.braces=='ON'
              =evlrec()
            ENDIF
          ENDIF
        ENDFOR
      ENDSCAN
      IF m.r_scxdata>RECCOUNT()
        EXIT
      ENDIF
      GOTO m.r_scxdata
      SCAN REST FOR .NOT.DELETED()
        m.at_line=ATCLINE(m.c_if,COMMENT)
        IF m.at_line=0
          LOOP
        ENDIF
        FOR m.i = m.at_line TO MEMLINES(COMMENT)
          m.memline=ALLTRIM(MLINE(COMMENT,m.i))
          IF m.i>m.at_line.AND..NOT.'*:'$m.memline
            m.at_pos=AT(m.cr,COMMENT,m.i)+1
            IF m.at_pos=1.OR.ATC(m.c_if,SUBSTR(COMMENT,m.at_pos))=0
              EXIT
            ENDIF
            LOOP
          ENDIF
          m.at_pos=ATC(m.c_if,m.memline)
          IF m.at_pos=1
            m.obj_expr=ALLTRIM(SUBSTR(m.memline,m.at_pos+LEN(m.c_if)))
            IF EMPTY(m.obj_expr)
              LOOP
            ENDIF
            =insif2(m.obj_expr)
            REPLACE COMMENT WITH strtranc(COMMENT,m.c_if,m.m_if)
            EXIT
          ENDIF
        ENDFOR
      ENDSCAN
      IF m.r_scxdata>RECCOUNT()
        EXIT
      ENDIF
      m.match_drv=.F.
      IF m.gen_mode.AND.a_scxdrvs(4)>0
        m.drv_no=4
        FOR m.drv_cnt = 1 TO a_scxdrvs(4)
          IF ASCAN(a_drvoff,FULLPATH(a_scxdrv(m.drv_cnt,4)))>0
            LOOP
          ENDIF
          m.msg3='['+ALLTRIM(m.platform_)+'] '+trimpath(a_scxdrv(m.drv_cnt,4),.F.,.T.)
          DO delaybar WITH '',m.msg3,90*m.drv_cnt/a_scxdrvs(4)+5
          SCAN ALL FOR .NOT.DELETED()
            m.match_drv=.T.
            DO (a_scxdrv(m.drv_cnt,4))
            DO esc_check
          ENDSCAN
          LOCATE
          SCATTER MEMVAR MEMO
          DO restoreenv
        ENDFOR
      ENDIF
      IF m.match_drv
        DO delaybar WITH '',m.msg2,5
      ENDIF
      IF m.r_scxdata>RECCOUNT()
        EXIT
      ENDIF
      GOTO m.r_scxdata
      SCAN REST FOR .NOT.DELETED()
        m.str_data=wordsearch(m.c_setupmthd)
        IF m.str_data==m.null
          LOOP
        ENDIF
        =setupmthd(IIF(EMPTY(m.str_data),.F.,m.str_data))
      ENDSCAN
      GOTO m.r_scxdata
      SCAN REST FOR (OBJTYPE=5.OR.BETWEEN(OBJTYPE,11,22)).AND..NOT.DELETED()
        IF ATC(m.c_size,COMMENT)=0.AND.ATC(m.c_nosize,COMMENT)=0)
          LOOP
        ENDIF
        FOR m.i = 1 TO MEMLINES(COMMENT)
          m.memline=ALLTRIM(MLINE(COMMENT,m.i))
          m.at_pos=ATC(m.c_size,m.memline)
          IF m.at_pos=1
            m.obj_expr=ALLTRIM(SUBSTR(m.memline,m.at_pos+LEN(m.c_size)))
            IF EMPTY(m.obj_expr)
              LOOP
            ENDIF
            REPLACE SHOW WITH 'SIZE '+m.obj_expr, HEIGHT WITH m.scxcount+;
                    IIF(OBJTYPE#15.OR.OBJCODE#2,-100,800),;
                    WIDTH WITH RECNO()+256, SPACING WITH 0,;
                    COMMENT WITH strtranc(COMMENT,m.c_size,m.m_size)
            a_scxupd(m.scxcount)='*'
            EXIT
          ELSE
            m.at_pos=ATC(m.c_nosize,m.memline)
            IF m.at_pos=1
              IF OBJTYPE#15.OR.OBJCODE#2
                REPLACE SHOW WITH '', HEIGHT WITH m.scxcount-100,;
                        WIDTH WITH RECNO()+256, SPACING WITH 0,;
                        COMMENT WITH strtranc(COMMENT,m.c_nosize,m.m_nosize)
                a_scxupd(m.scxcount)='*'
              ENDIF
              EXIT
            ENDIF
          ENDIF
        ENDFOR
      ENDSCAN
      IF m.r_scxdata>RECCOUNT()
        EXIT
      ENDIF
      GOTO m.r_scxdata
      SCAN REST FOR BETWEEN(OBJTYPE,11,22).AND..NOT.DELETED()
        m.at_line=ATCLINE(m.c_default,COMMENT)
        IF m.at_line=0
          LOOP
        ENDIF
        FOR m.i = m.at_line TO MEMLINES(COMMENT)
          m.memline=ALLTRIM(MLINE(COMMENT,m.i))
          IF m.i>m.at_line.AND..NOT.'*:'$m.memline
            m.at_pos=AT(m.cr,COMMENT,m.i)+1
            IF m.at_pos=1.OR.ATC(m.c_default,SUBSTR(COMMENT,m.at_pos))=0
              EXIT
            ENDIF
            LOOP
          ENDIF
          m.at_pos=ATC(m.c_default,m.memline)
          IF m.at_pos=1
            m.obj_expr=ALLTRIM(SUBSTR(m.memline,m.at_pos+LEN(m.c_default)))
            IF EMPTY(m.obj_expr)
              LOOP
            ENDIF
            DO CASE
              CASE BETWEEN(OBJTYPE,12,14)
                REPLACE INITIALNUM WITH VAL(m.obj_expr)
              CASE OBJTYPE#11.AND.OBJTYPE#20
                REPLACE INITIALVAL WITH m.obj_expr
            ENDCASE
            REPLACE COMMENT WITH strtranc(COMMENT,m.c_default,m.m_default)
            EXIT
          ENDIF
        ENDFOR
      ENDSCAN
      GOTO m.r_scxdata
      SCAN REST FOR .NOT.DELETED()
        m.at_line=ATCLINE(m.c_picture,COMMENT)
        IF m.at_line=0
          LOOP
        ENDIF
        FOR m.i = m.at_line TO MEMLINES(COMMENT)
          m.memline=ALLTRIM(MLINE(COMMENT,m.i))
          IF m.i>m.at_line.AND..NOT.'*:'$m.memline
            m.at_pos=AT(m.cr,COMMENT,m.i)+1
            IF m.at_pos=1.OR.ATC(m.c_picture,SUBSTR(COMMENT,m.at_pos))=0
              EXIT
            ENDIF
            LOOP
          ENDIF
          m.at_pos=ATC(m.c_picture,m.memline)
          IF m.at_pos=1
            m.obj_expr=ALLTRIM(SUBSTR(m.memline,m.at_pos+LEN(m.c_picture)))
            IF EMPTY(m.obj_expr).OR.(OBJTYPE=17.AND.STYLE#0)
              LOOP
            ENDIF
            DO CASE
              CASE OBJTYPE=17
                IF (ATC('.BMP',m.obj_expr)>0.OR.ATC('.ICO',m.obj_expr)>0).AND.;
                   ((.NOT.LEFT(m.obj_expr,1)=="'".AND.;
                   .NOT.LEFT(m.obj_expr,1)=='"').OR.;
                   (.NOT.RIGHT(m.obj_expr,1)=="'".AND.;
                   .NOT.RIGHT(m.obj_expr,1)=='"')).AND..NOT.'+'$m.obj_expr
                  m.obj_expr='"'+m.obj_expr+'"'
                ENDIF
                REPLACE PICTURE WITH m.obj_expr,;
                        NAME WITH PICTURE+' BITMAP', STYLE WITH 1
              CASE BETWEEN(OBJTYPE,12,14).AND.;
                   'B'$SUBSTR(PICTURE,1,AT(' ',PICTURE))
                DO CASE
                  CASE LEFT(m.obj_expr,1)==','
                    m.j=1
                  CASE LEFT(m.obj_expr,2)=="',"
                    m.j=2
                  CASE LEFT(m.obj_expr,2)=='",'
                    m.j=2
                  OTHERWISE
                    m.j=0
                ENDCASE
                IF m.j>0.AND.(','$m.obj_expr.OR.ATC('.BMP',m.obj_expr)>0.OR.;
                   ATC('.ICO',m.obj_expr)>0)
                  m.str_data=ALLTRIM(SUBSTR(PICTURE,AT(' ',PICTURE)))
                  m.str_data=LEFT(m.str_data,LEN(m.str_data)-1)
                  IF ';'$m.str_data
                    m.str_data=LEFT(m.str_data,AT(';',m.str_data)-1)
                  ENDIF
                  m.str_data=casefile(FULLPATH(m.str_data))
                  DO WHILE RIGHT(m.obj_expr,1)==','
                    m.obj_expr=ALLTRIM(LEFT(m.obj_expr,LEN(m.obj_expr)-1))
                  ENDDO
                  m.obj_expr=LEFT(m.obj_expr,m.j-1)+m.str_data+;
                             SUBSTR(m.obj_expr,m.j)
                  m.obj_expr=STRTRAN(m.obj_expr,',,',','+m.str_data+',')
                ENDIF
                DO CASE
                  CASE (LEFT(m.obj_expr,1)=="'".OR.;
                       LEFT(m.obj_expr,1)=='"').AND.;
                       (RIGHT(m.obj_expr,1)=="'".OR.;
                       RIGHT(m.obj_expr,1)=='"').AND..NOT.'+'$m.obj_expr
                    m.str_data=ALLTRIM(SUBSTR(m.obj_expr,2,LEN(m.obj_expr)-2))+'"'
                  CASE ','$m.obj_expr.OR.ATC('.BMP',m.obj_expr)>0.OR.;
                       ATC('.ICO',m.obj_expr)>0
                    m.str_data=m.obj_expr+'"'
                  OTHERWISE
                    m.str_data='"+'+m.obj_expr
                ENDCASE
                REPLACE PICTURE WITH STRTRAN(SUBSTR(PICTURE,1,;
                                     AT(' ',PICTURE)),'B','b')+m.str_data
              OTHERWISE
                REPLACE PICTURE WITH m.obj_expr
            ENDCASE
            EXIT
          ENDIF
        ENDFOR
      ENDSCAN
      GOTO m.r_scxdata
      SCAN REST FOR .NOT.DELETED()
        IF (OBJTYPE=15.AND.OBJCODE=0).OR.EMPTY(NAME)
          LOOP
        ENDIF
        m.disable=wordsearch(m.c_disable)
        IF m.disable==m.null
          m.disable=''
        ENDIF
        m.enable=wordsearch(m.c_enable)
        IF m.enable==m.null
          m.enable=''
        ENDIF
        IF EMPTY(m.disable).AND.EMPTY(m.enable)
          LOOP
        ENDIF
        m.visible=wordsearch(m.c_visible)
        IF m.visible==m.null
          m.visible=''
        ENDIF
        m.str_data=MLINE(NAME,1)
        m.dsblcode="  SHOW GET "+m.str_data+" DISABLE"
        m.enblcode="  SHOW GET "+m.str_data+" ENABLE"
        m.codedata=''
        IF .NOT.EMPTY(m.disable)
          IF .NOT.EMPTY(m.visible)
            m.disable='('+m.disable+').OR..NOT.('+m.visible+')'
          ENDIF
          m.codedata=m.codedata+"IF "+m.disable+m.cr_lf+m.dsblcode+m.cr_lf
          IF EMPTY(m.enable)
            m.codedata=m.codedata+"ELSE"+m.cr_lf+m.enblcode+m.cr_lf
          ENDIF
          m.codedata=m.codedata+"ENDIF"+m.cr_lf
        ENDIF
        IF .NOT.EMPTY(m.enable)
          IF .NOT.EMPTY(m.visible)
            m.enable='('+m.enable+').AND.('+m.visible+')'
          ENDIF
          m.codedata=m.codedata+"IF "+m.enable+m.cr_lf+m.enblcode+m.cr_lf
          IF EMPTY(m.disable)
            m.codedata=m.codedata+"ELSE"+m.cr_lf+m.dsblcode+m.cr_lf
          ENDIF
          m.codedata=m.codedata+"ENDIF"+m.cr_lf
        ENDIF
        REPLACE COMMENT WITH strtranc(strtranc(COMMENT,m.c_disable,m.m_disable),;
                             m.c_enable,m.m_enable)
        m.r2=RECNO()
        LOCATE
        REPLACE SHOW WITH SHOW+m.cr_lf+m.codedata
        GOTO m.r2
      ENDSCAN
      GOTO m.r_scxdata
      SCAN REST FOR .NOT.DELETED()
        m.visible=wordsearch(m.c_visible)
        IF m.visible==m.null
          m.visible=''
        ENDIF
        IF EMPTY(m.visible)
          LOOP
        ENDIF
        m.codedata=''
        m.dsblcode=''
        m.enblcode=''
        m.str_data=ALLTRIM(MLINE(NAME,1))
        IF OBJTYPE=15.OR.(OBJTYPE#20.AND..NOT.EMPTY(m.str_data))
          m.dsblcode="  @ "+objpos()+" CLEAR TO "+objend()
        ENDIF
        IF .NOT.EMPTY(m.str_data).AND.wordsearch(m.m_disable)==m.null.AND.;
           wordsearch(m.m_enable)==m.null
          m.dsblcode="  SHOW GET "+m.str_data+" DISABLE"+m.cr_lf+m.dsblcode
          m.enblcode="  SHOW GET "+m.str_data+" ENABLE"
        ENDIF
        IF .NOT.EMPTY(m.dsblcode).OR..NOT.EMPTY(m.enblcode)
          IF EMPTY(m.enblcode)
            m.codedata="IF .NOT.("+m.visible+")"+m.cr_lf+m.dsblcode+m.cr_lf+;
                       "ENDIF"+m.cr_lf
          ELSE
            m.codedata="IF "+m.visible+m.cr_lf+m.enblcode+m.cr_lf+;
                       "ELSE"+m.cr_lf+m.dsblcode+m.cr_lf+;
                       "ENDIF"+m.cr_lf
          ENDIF
        ENDIF
        m.i=IIF(checkclick(),-2,0)
        m.r2=RECNO()
        REPLACE COMMENT WITH strtranc(COMMENT,m.c_visible,m.m_visible)
        IF OBJTYPE=15.AND.OBJCODE=0.AND.EMPTY(m.enblcode)
          =insif2(m.visible)
        ENDIF
        IF .NOT.EMPTY(m.codedata)
          LOCATE
          REPLACE SHOW WITH SHOW+m.cr_lf+m.codedata
        ENDIF
        GOTO (m.r2+m.i)
      ENDSCAN
      m.obj_name=SPACE(LEN(FOXSCX.OBJNAME_))
      m.obj_base=SPACE(LEN(FOXSCX.OBJBASE_))
      SCAN ALL FOR .NOT.DELETED()
        RELEASE a_basobj
        DIMENSION a_basobj(1)
        m.basobjs=0
        m.at_line=1
        DO WHILE .T.
          m.at_line=ATCLINE(m.c_basobj,COMMENT)
          IF .NOT.BETWEEN(m.at_line,1,MEMLINES(COMMENT))
            EXIT
          ENDIF
          m.obj_lib=''
          m.obj_base=SPACE(LEN(FOXSCX.OBJBASE_))
          FOR m.i = m.at_line TO MEMLINES(COMMENT)
            m.memline=ALLTRIM(MLINE(COMMENT,m.i))
            IF m.i>m.at_line.AND..NOT.'*:'$m.memline
              m.at_pos=AT(m.cr,COMMENT,m.i)+1
              IF m.at_pos=1.OR.ATC(m.c_basobj,SUBSTR(COMMENT,m.at_pos))=0
                EXIT
              ENDIF
              LOOP
            ENDIF
            m.at_pos=ATC(m.c_basobj,m.memline)
            IF m.at_pos=0
              LOOP
            ENDIF
            REPLACE COMMENT WITH strtranc(COMMENT,m.c_basobj,m.m_basobj,1,1)
            IF m.at_pos=1
              m.obj_base=PADR(ALLTRIM(SUBSTR(m.memline,m.at_pos+;
                         LEN(m.c_basobj))),LEN(FOXSCX.OBJBASE_))
              m.at_pos=AT('.',m.obj_base)
              IF m.at_pos>0
                m.obj_lib=PADR(UPPER(CHRTRAN(ALLTRIM(LEFT(m.obj_base,m.at_pos-1)),;
                          m.badchars,m.stdascii)),LEN(FOXSCX.OBJLIB_))
                m.obj_base=ALLTRIM(SUBSTR(m.obj_base,m.at_pos+1))
              ENDIF
              m.obj_base=PADR(CHRTRAN(m.obj_base,m.badchars,m.stdascii),;
                         LEN(FOXSCX.OBJBASE_)-LEN(FOXSCX.OBJLIB_)-1)
              EXIT
            ENDIF
          ENDFOR
          IF EMPTY(m.obj_base)
            LOOP
          ENDIF
          m.match=.F.
          m.r=RECNO()
          RELEASE a_fields
          DIMENSION a_fields(1)
          =AFIELDS(a_fields)
          RELEASE a_scatter
          SCATTER TO a_scatter MEMO
          SELECT FOXSCX
          SET ORDER TO OBJNAME_
          IF m.inclibs=0.AND.EMPTY(m.obj_lib)
            =warning(m.c_basobj,m.obj_base)
            LOOP
          ENDIF
          RELEASE a_size,a_pict
          DO WHILE .NOT.EMPTY(m.obj_base).AND.(m.inclibs>0.OR.;
                   .NOT.EMPTY(m.obj_lib))
            DO esc_check
            m.j=0
            m.at_pos=AT('.',m.obj_base)
            IF m.at_pos>0
              m.obj_lib=PADR(UPPER(ALLTRIM(LEFT(m.obj_base,m.at_pos-1))),;
                        LEN(FOXSCX.OBJLIB_))
              m.obj_base=ALLTRIM(SUBSTR(m.obj_base,m.at_pos+1))
            ENDIF
            m.obj_base=PADR(m.obj_base,LEN(FOXSCX.OBJBASE_)-;
                       LEN(FOXSCX.OBJLIB_)-1)
            IF EMPTY(m.obj_lib)
              m.lastexac=SET('EXACT')
              SET EXACT ON
              FOR m.i = 1 TO m.inclibs
                SEEK UPPER(PADR(m.obj_base,LEN(OBJNAME_))+PADR(a_inclib(m.i),;
                           LEN(OBJLIB_)))
                IF .NOT.EOF()
                  m.j=RECNO()
                  m.obj_lib=OBJLIB_
                  m.obj_base=OBJBASE_
                  EXIT
                ENDIF
              ENDFOR
              IF m.lastexac=='ON'
                SET EXACT ON
              ELSE
                SET EXACT OFF
              ENDIF
            ELSE
              SEEK UPPER(m.obj_base+m.obj_lib)
              IF .NOT.EOF()
                m.j=RECNO()
                m.obj_base=OBJBASE_
              ENDIF
            ENDIF
            IF m.j=0.OR.(UPPER(OBJNAME_)==PADR(m.obj_base,LEN(OBJNAME_)).AND.;
               (OBJLIB_==m.obj_lib.OR.EMPTY(m.obj_lib)))
              =warning(m.c_basobj,m.obj_lib+'.'+m.obj_base)
              m.obj_lib=''
              m.obj_base=SPACE(LEN(OBJBASE_))
              EXIT
            ENDIF
            IF m.basobjs>0.AND.ASCAN(a_basobj,OBJLIB_+'.'+UPPER(OBJNAME_))>0
              m.obj_lib=''
              m.obj_base=SPACE(LEN(OBJBASE_))
              EXIT
            ENDIF
            m.j=RECCOUNT('SCXDATA')
            IF m.rec_count#m.j
              m.rec_total=m.rec_total+(m.j-m.rec_count)
              m.rec_count=m.j
            ENDIF
            m.i=m.r_scxdata-2
            m.msg3='['+ALLTRIM(m.platform_)+'] '+ALLTRIM(OBJLIB_)+'.'+;
                   OBJNAME_
            DO delaybar WITH '',m.msg3,85*(RECNO('SCXDATA')-m.i)/m.rec_total+10
            m.basobjs=m.basobjs+1
            DIMENSION a_basobj(m.basobjs)
            a_basobj(m.basobjs)=OBJLIB_+'.'+UPPER(OBJNAME_)
            m.basbefore=.F.
            m.old_text=''
            m.new_text=''
            FOR m.i = 1 TO ALEN(a_scatter)
              IF ALEN(a_scatter)=(FCOUNT()-m.fcountadj)
                m.j=m.i
              ELSE
                m.j=0
                FOR m.k = 1 TO (FCOUNT()-m.fcountadj)
                  IF FIELD(m.k)==a_fields(4*m.i-3)
                    m.j=m.k
                    EXIT
                  ENDIF
                ENDFOR
              ENDIF
              m.field_name=FIELD(m.j)
              IF m.field_name=='NAME'
                m.old_text=NAME
                m.new_text=a_scatter(m.i)
              ENDIF
              m.field_type=TYPE(FIELD(m.j))
              m.snpttype=-1
              IF m.i>6
                IF ATC('TYPE',FIELD(m.j-1))>0.AND..NOT.EMPTY(a_scatter(m.i))
                  m.snpttype=a_scatter(m.i-1)
                ENDIF
                IF RIGHT(m.field_name,4)=='BLUE'
                  m.field_eval=EVALUATE(m.field_name)
                  IF m.field_eval#-1.AND.a_scatter(m.i)=-1.AND.;
                     a_scatter(m.i-1)=-1.AND.a_scatter(m.i-2)=-1
                    a_scatter(m.i)=m.field_eval
                    a_scatter(m.i-1)=EVALUATE(FIELD(m.j-1))
                    a_scatter(m.i-2)=EVALUATE(FIELD(m.j-2))
                  ENDIF
                  LOOP
                ENDIF
                IF SCXDATA.OBJTYPE=1.AND.SCXDATA.STYLE>1.AND.;
                   INLIST(m.field_name,'SCHEME','SCHEME2','FLOAT','CLOSE',;
                          'MINIMIZE','BORDER','SHADOW')
                  LOOP
                ENDIF
                IF 'PEN'$m.field_name.OR.'FILL'$m.field_name
                  LOOP
                ENDIF
                IF LEFT(m.field_name,4)=='FONT'
                  m.str_data=IIF(ALLTRIM(m.platform_)=='MAC','Geneva','MS Sans Serif')
                  IF m.field_name=='FONTSIZE'.AND.a_scatter(m.i)=8.AND.;
                    a_scatter(m.i-1)<1.AND.;
                    a_scatter(m.i-2)==m.str_data
                    a_scatter(m.i)=EVALUATE(m.field_name)
                    a_scatter(m.i-1)=EVALUATE(FIELD(m.j-1))
                    a_scatter(m.i-2)=EVALUATE(FIELD(m.j-2))
                  ENDIF
                  LOOP
                ENDIF
                IF 'FONT'$m.field_name
                  LOOP
                ENDIF
              ENDIF
              IF (EMPTY(a_scatter(m.i)).OR.m.snpttype#-1.OR.;
                 (FIELD(m.j)=='PICTURE'.AND.UPPER(a_scatter(m.i))=='"@K"').OR.;
                 (FIELD(m.j)=='PICTURE'.AND.UPPER(a_scatter(m.i))=='"@3K"').OR.;
                 m.field_type=='L'.OR.(FIELD(m.j)=='COMMENT'.AND.;
                 ATC(m.c_instxt,a_scatter(m.i))=0)).AND.;
                 ATC('TYPE',FIELD(m.j))=0.AND.;
                 .NOT.INLIST(FIELD(m.j),'VPOS','HPOS','HEIGHT','WIDTH').AND.;
                 (RECNO()>=m.r_scxdata.OR..NOT.INLIST(FIELD(m.j),'STYLE',;
                 'ORDER','UNIQUE','ENVIRON','TAG','TAG2'))
                m.match=.T.
                IF m.i>6.AND.ATC('TYPE',FIELD(m.j-1))>0.AND.;
                   .NOT.EMPTY(EVALUATE(FIELD(m.j)))
                  a_scatter(m.i-1)=EVALUATE(FIELD(m.j-1))
                ENDIF
                m.field_eval=EVALUATE(m.field_name)
                IF m.i>5.AND.m.snpttype#-1.AND..NOT.EMPTY(m.field_eval).AND.;
                   m.snpttype#EVALUATE(FIELD(m.j-1))
                  SELECT SCXDATA
                  m.r2=RECNO()
                  LOCATE
                  m.memline=SYS(2015)
                  IF m.snpttype=1
                    REPLACE PROCCODE WITH PROCCODE+m.cr_lf+;
                           'FUNCTION '+m.memline+m.cr_lf+m.cr_lf+;
                           strtranc(a_scatter(m.i),m.old_text,;
                                    m.new_text)+m.cr_lf
                    a_scatter(m.i)=m.memline+'()'
                  ELSE
                    REPLACE PROCCODE WITH PROCCODE+m.cr_lf+;
                           'FUNCTION '+m.memline+m.cr_lf+m.cr_lf+;
                           strtranc(m.field_eval,m.old_text,;
                                    m.new_text)+m.cr_lf
                    m.field_eval=m.memline+'()'
                  ENDIF
                  GOTO m.r2
                  SELECT FOXSCX
                  a_scatter(m.i-1)=0
                  m.snpttype=0
                ENDIF
                DO CASE
                  CASE EMPTY(m.field_eval)
                    =.F.
                  CASE (m.snpttype=-1.OR..NOT.m.field_type=='M').AND.;
                       .NOT.FIELD(m.j)=='COMMENT'
                    a_scatter(m.i)=m.field_eval
                  CASE m.snpttype=0.AND..NOT.FIELD(m.j)=='COMMENT'
                    IF LEFT(FIELD(m.j),5)=='RANGE'
                      =.F.
                    ELSE
                      m.field_eval=STRTRAN(STRTRAN(ALLTRIM(m.field_eval),;
                                   m.cr,''),m.lf,'')
                      a_scatter(m.i)=STRTRAN(STRTRAN(ALLTRIM(a_scatter(m.i)),;
                                   m.cr,''),m.lf,'')
                      DO CASE
                        CASE LEFT(m.field_eval,7)=='.T..OR.'.OR.;
                             LEFT(m.field_eval,7)=='.T. OR '
                          m.str_data=a_scatter(m.i)
                          m.str_data2=').OR.('
                          m.str_data3=SUBSTR(m.field_eval,8)
                        CASE RIGHT(m.field_eval,7)=='.OR..T.'.OR.;
                             RIGHT(m.field_eval,7)==' OR .T.'
                          m.str_data=a_scatter(m.i)
                          m.str_data2=').OR.('
                          m.str_data3=LEFT(m.field_eval,LEN(m.field_eval)-7)
                        CASE LEFT(a_scatter(m.i),7)=='.T..OR.'.OR.;
                             LEFT(a_scatter(m.i),7)=='.T. OR '
                          m.str_data=SUBSTR(a_scatter(m.i),8)
                          m.str_data2=').OR.('
                          m.str_data3=m.field_eval
                        CASE RIGHT(a_scatter(m.i),7)=='.OR..T.'.OR.;
                             RIGHT(a_scatter(m.i),7)==' OR .T.'
                          m.str_data=LEFT(a_scatter(m.i),LEN(a_scatter(m.i))-7)
                          m.str_data2=').OR.('
                          m.str_data3=m.field_eval
                        OTHERWISE
                          m.str_data=a_scatter(m.i)
                          m.str_data2=').AND.('
                          m.str_data3=m.field_eval
                      ENDCASE
                      IF m.basbefore
                        a_scatter(m.i)='('+m.str_data3+m.str_data2+;
                                       m.str_data+')'
                      ELSE
                        a_scatter(m.i)='('+m.str_data+m.str_data2+;
                                       m.str_data3+')'
                      ENDIF
                    ENDIF
                  OTHERWISE
                    SELECT SCXDATA
                    IF m.basbefore.AND..NOT.FIELD(m.j)=='COMMENT'
                      IF .NOT.RIGHT(m.field_eval,2)==m.cr_lf
                        m.field_eval=m.field_eval+m.cr_lf
                      ENDIF
                      a_scatter(m.i)=m.field_eval+a_scatter(m.i)
                    ELSE
                      IF .NOT.RIGHT(a_scatter(m.i),2)==m.cr_lf
                        a_scatter(m.i)=a_scatter(m.i)+m.cr_lf
                      ENDIF
                      a_scatter(m.i)=a_scatter(m.i)+m.field_eval
                    ENDIF
                    SELECT FOXSCX
                ENDCASE
                DO CASE
                  CASE FIELD(m.j)=='COMMENT'
                    SELECT SCXDATA
                    REPLACE COMMENT WITH a_scatter(m.i)
                    IF .NOT.wordsearch(m.c_basbefore)==m.null
                      m.basbefore=.T.
                      REPLACE COMMENT WITH strtranc(COMMENT,m.c_basbefore,;
                                           m.m_basbefore)
                      a_scatter(m.i)=COMMENT
                    ENDIF
                    IF .NOT.wordsearch(m.c_svsize)==m.null
                      RELEASE a_size
                      DIMENSION a_size(4)
                      a_size(1)=FOXSCX.HEIGHT
                      a_size(2)=FOXSCX.WIDTH
                      a_size(3)=FOXSCX.INITIALNUM
                      a_size(4)=FOXSCX.SPACING
                      REPLACE COMMENT WITH strtranc(COMMENT,m.c_svsize,;
                                           m.m_svsize)
                      a_scatter(m.i)=COMMENT
                    ENDIF
                    IF .NOT.wordsearch(m.c_svpict)==m.null
                      RELEASE a_pict
                      DIMENSION a_pict(3)
                      a_pict(1)=FOXSCX.PICTURE
                      a_pict(2)=FOXSCX.INITIALVAL
                      a_pict(3)=STR(FOXSCX.INITIALNUM,9,3)
                      REPLACE COMMENT WITH strtranc(COMMENT,m.c_svpict,;
                                           m.m_svpict)
                      a_scatter(m.i)=COMMENT
                    ENDIF
                    m.loop_obj=.T.
                    SELECT FOXSCX
                  CASE m.field_type=='M'.AND..NOT.m.old_text==m.new_text
                    IF .NOT.EMPTY(a_scatter(m.i))
                      a_scatter(m.i)=strtranc(a_scatter(m.i),m.old_text,;
                                     m.new_text)
                    ENDIF
                ENDCASE
              ENDIF
            ENDFOR
          ENDDO
          SELECT SCXDATA
          GOTO m.r
          IF m.match
            GATHER FROM a_scatter MEMO
            IF TYPE('a_size')=='N'
              REPLACE HEIGHT WITH a_size(1)
              REPLACE WIDTH WITH a_size(2)
              IF OBJTYPE=15
                REPLACE INITIALNUM WITH a_size(3)
              ENDIF
              REPLACE SPACING WITH a_size(4)
            ENDIF
            IF TYPE('a_pict')=='C'
              REPLACE PICTURE WITH a_pict(1)
              IF BETWEEN(OBJTYPE,12,14)
                REPLACE INITIALVAL WITH a_pict(2),;
                        INITIALNUM WITH VAL(a_pict(3))
              ENDIF
            ENDIF
            RELEASE a_size,a_pict
            IF .NOT.m.ignrbraces.AND.m.braces=='ON'
              =evlrec()
            ENDIF
          ENDIF
        ENDDO
      ENDSCAN
      m.match_drv=.F.
      IF m.gen_mode.AND.a_scxdrvs(5)>0
        m.drv_no=5
        FOR m.drv_cnt = 1 TO a_scxdrvs(5)
          IF ASCAN(a_drvoff,FULLPATH(a_scxdrv(m.drv_cnt,5)))>0
            LOOP
          ENDIF
          m.msg3='['+ALLTRIM(m.platform_)+'] '+trimpath(a_scxdrv(m.drv_cnt,5),.F.,.T.)
          DO delaybar WITH '',m.msg3,90*m.drv_cnt/a_scxdrvs(5)+5
          SCAN ALL FOR .NOT.DELETED()
            m.match_drv=.T.
            DO (a_scxdrv(m.drv_cnt,5))
            DO esc_check
          ENDSCAN
          LOCATE
          SCATTER MEMVAR MEMO
          DO restoreenv
        ENDFOR
      ENDIF
      IF m.match_drv
        DO delaybar WITH '',m.msg2,5
      ENDIF
      GOTO m.r_scxdata
      SCAN REST FOR .NOT.DELETED()
        m.at_line=ATCLINE(m.c_insobj,COMMENT)
        IF m.at_line=0
          LOOP
        ENDIF
        FOR m.i = MEMLINES(COMMENT) TO m.at_line STEP -1
          =esc_check()
          m.memline=ALLTRIM(UPPER(MLINE(COMMENT,m.i)))
          m.at_pos=ATC(m.c_insobj,m.memline)
          IF m.at_pos=1
            m.obj_lib=''
            m.obj_name=PADR(ALLTRIM(SUBSTR(m.memline,m.at_pos+;
                       LEN(m.c_insobj))),LEN(FOXSCX.OBJNAME_))
            m.at_pos=AT('.',m.obj_name)
            IF m.at_pos>0
              m.obj_lib=PADR(UPPER(CHRTRAN(ALLTRIM(LEFT(m.obj_name,m.at_pos-1)),;
                        m.badchars,m.stdascii)),LEN(FOXSCX.OBJLIB_))
              m.obj_name=ALLTRIM(SUBSTR(m.obj_name,m.at_pos+1))
            ENDIF
            m.obj_name=PADR(CHRTRAN(m.obj_name,m.badchars,m.stdascii),;
                       LEN(FOXSCX.OBJNAME_))
            IF m.inclibs>0.AND.EMPTY(m.obj_lib)
              SELECT FOXSCX
              SET ORDER TO OBJNAME_
              m.lastexac=SET('EXACT')
              SET EXACT ON
              FOR m.j = 1 TO m.inclibs
                SEEK UPPER(PADR(m.obj_name,LEN(OBJNAME_))+;
                     PADR(a_inclib(m.j),LEN(OBJLIB_)))
                IF .NOT.EOF()
                  m.obj_lib=OBJLIB_
                  EXIT
                ENDIF
              ENDFOR
              IF m.lastexac=='ON'
                SET EXACT ON
              ELSE
                SET EXACT OFF
              ENDIF
              SELECT SCXDATA
            ENDIF
            IF insobj(ALLTRIM(m.obj_lib)+'.'+ALLTRIM(m.obj_name))
              m.loop_obj=.T.
            ENDIF
          ENDIF
        ENDFOR
      ENDSCAN
      IF m.r_scxdata>RECCOUNT()
        EXIT
      ENDIF
      GOTO m.r_scxdata
      SCAN REST FOR .NOT.DELETED()
        m.at_line=ATCLINE(m.c_insscx,COMMENT)
        IF m.at_line=0
          LOOP
        ENDIF
        FOR m.i = MEMLINES(COMMENT) TO m.at_line STEP -1
          =esc_check()
          m.memline=ALLTRIM(MLINE(COMMENT,m.i))
          m.at_pos=ATC(m.c_insscx,m.memline)
          IF m.at_pos=1
            m.scx_file=ALLTRIM(SUBSTR(m.memline,m.at_pos+LEN(m.c_insscx)))
            DO CASE
              CASE m.insscxs>=256
                =delrec()
              CASE insscx(m.scx_file)>0
                m.loop_obj=.T.
                m.insscxs=m.insscxs+1
              OTHERWISE
                m.memline=m.scx_file
                IF .NOT.'.'$m.memline
                  m.memline=m.memline+'.SCX'
                ENDIF
            ENDCASE
          ENDIF
        ENDFOR
      ENDSCAN
      IF .NOT.m.loop_obj
        EXIT
      ENDIF
      IF .NOT.m.loop_flag
        m.loop_flag=.T.
        m.setfilter='(DEACTTYPE<=1.OR.OBJTYPE<=1)'
        IF .NOT.EMPTY(m.lastfilter)
          m.setfilter=m.lastfilter+'.AND.'+m.setfilter
        ENDIF
        LOCATE
      ENDIF
      SCAN ALL FOR .NOT.DELETED()
        DO CASE
          CASE RECNO()<m.r_scxdata
            IF DEACTTYPE<=1
              REPLACE ACTIVTYPE WITH ACTIVTYPE+2, DEACTTYPE WITH DEACTTYPE+2
            ENDIF
          CASE ACTIVTYPE=2
            REPLACE ACTIVTYPE WITH 0, DEACTTYPE WITH 0
          CASE ATC(m.c_basobj,COMMENT)=0.AND.ATC(m.c_trntxt,COMMENT)=0.AND.;
               ATC(m.c_insscx,COMMENT)=0.AND.ATC(m.c_insobj,COMMENT)=0.AND.;
               ATC(m.c_if,COMMENT)=0.AND.ATC(m.c_size,COMMENT)=0.AND.;
               ATC(m.c_nosize,COMMENT)=0.AND.ATC(m.c_default,COMMENT)=0.AND.;
               ATC(m.c_evltxt,COMMENT)=0.AND.ATC(m.c_visible,COMMENT)=0.AND.;
               ATC(m.c_disable,COMMENT)=0.AND.ATC(m.c_enable,COMMENT)=0
            REPLACE DEACTTYPE WITH 2
        ENDCASE
      ENDSCAN
      SET FILTER TO &setfilter
      LOCATE
      IF EOF()
        EXIT
      ENDIF
      m.match_drv=.F.
      IF m.gen_mode.AND.a_scxdrvs(6)>0
        m.drv_no=6
        FOR m.drv_cnt = 1 TO a_scxdrvs(6)
          IF ASCAN(a_drvoff,FULLPATH(a_scxdrv(m.drv_cnt,6)))>0
            LOOP
          ENDIF
          m.msg3='['+ALLTRIM(m.platform_)+'] '+trimpath(a_scxdrv(m.drv_cnt,6),.F.,.T.)
          DO delaybar WITH '',m.msg3,90*m.drv_cnt/a_scxdrvs(6)+5
          SCAN ALL FOR .NOT.DELETED()
            m.match_drv=.T.
            DO (a_scxdrv(m.drv_cnt,6))
            DO esc_check
          ENDSCAN
          LOCATE
          SCATTER MEMVAR MEMO
          DO restoreenv
        ENDFOR
      ENDIF
      IF m.match_drv
        DO delaybar WITH '',m.msg2,5
      ENDIF
    ENDDO
    IF m.gen_mode
      DO delaybar WITH '',m.msg2,95
    ENDIF
    IF m.loop_flag
      IF EMPTY(m.lastfilter)
        SET FILTER TO
      ELSE
        SET FILTER TO &lastfilter
      ENDIF
      REPLACE ALL ACTIVTYPE WITH MAX(ACTIVTYPE-2,0),;
                  DEACTTYPE WITH MAX(DEACTTYPE-2,0)
    ENDIF
    SCAN ALL FOR .NOT.DELETED()
      IF wordsearch(m.c_delete)==m.null
        LOOP
      ENDIF
      =delrec()
      REPLACE COMMENT WITH strtranc(COMMENT,m.c_delete,m.m_delete)
    ENDSCAN
    IF m.r_scxdata>RECCOUNT()
      EXIT
    ENDIF
    IF m.gen_mode
      GOTO m.r_scxdata
      SCAN REST FOR .NOT.DELETED()
        m.at_pos=ATC(m.c_trntxt,COMMENT)
        IF m.at_pos=0
          LOOP
        ENDIF
        m.str_data=SUBSTR(COMMENT,m.at_pos)
        FOR m.i = 1 TO MEMLINES(m.str_data)
          m.memline=ALLTRIM(MLINE(m.str_data,m.i))
          m.at_pos=ATC(m.c_trntxt,m.memline)
          IF m.at_pos=1
            m.at_pos=AT('||',m.memline)
            IF m.at_pos=0
              LOOP
            ENDIF
            m.old_text=ALLTRIM(SUBSTR(m.memline,LEN(m.c_trntxt)+1,m.at_pos-;
                       LEN(m.c_trntxt)-1))
            IF LEN(m.old_text)=0
              LOOP
            ENDIF
            m.old_text=STRTRAN(STRTRAN(STRTRAN(STRTRAN(m.old_text,'\\',;
                       '\'),'\t',CHR(9)),'\n',CHR(10)),'\r',CHR(13))
            m.at_pos2=AT('||',m.memline,2)
            m.new_text=ALLTRIM(SUBSTR(m.memline,m.at_pos+2,;
                       IIF(m.at_pos2=0,LEN(m.memline),m.at_pos2-m.at_pos-2)))
            m.new_text=STRTRAN(STRTRAN(STRTRAN(STRTRAN(m.new_text,'\\',;
                       '\'),'\t',CHR(9)),'\n',CHR(10)),'\r',CHR(13))
            m.match_pos=.F.
            m.match_no=.F.
            IF m.at_pos2>0
              m.at_pos=AT('||',m.memline,3)
              m.match_pos=VAL(SUBSTR(m.memline,m.at_pos2+2,;
                          IIF(m.at_pos=0,LEN(m.memline),m.at_pos-m.at_pos2-2)))
              IF m.at_pos>0
                m.match_no=VAL(SUBSTR(m.memline,m.at_pos+2))
              ENDIF
            ENDIF
            REPLACE COMMENT WITH STRTRAN(COMMENT,m.memline+m.cr_lf,'')
            IF m.memline$COMMENT
              REPLACE COMMENT WITH STRTRAN(COMMENT,m.memline,'')
            ENDIF
            FOR m.j = 1 TO FCOUNT()
              m.field_name=FIELD(m.j)
              IF TYPE(m.field_name)#'M'
                LOOP
              ENDIF
              m.field_eval=EVALUATE(m.field_name)
              IF ATC(m.old_text,m.field_eval)>0
                REPLACE (m.field_name) WITH strtranc(m.field_eval,m.old_text,;
                                            m.new_text,m.match_pos,m.match_no)
              ENDIF
            ENDFOR
          ENDIF
        ENDFOR
      ENDSCAN
    ENDIF
    IF m.gen_mode.AND.m.name_mode
      SCAN ALL FOR .NOT.DELETED()
        FOR m.j = 1 TO FCOUNT()
          m.field_name=FIELD(m.j)
          m.field_type=TYPE(m.field_name)
          IF m.field_type#'M'
            LOOP
          ENDIF
          m.field_eval=EVALUATE(m.field_name)
          m.at_line=ATCLINE(m.p_name,m.field_eval)
          IF m.at_line=0
            LOOP
          ENDIF
          FOR m.i = m.at_line TO MEMLINES(m.field_eval)
            m.memline=ALLTRIM(MLINE(m.field_eval,m.i))
            IF m.i>m.at_line.AND..NOT.'*:'$m.memline
              m.at_pos=AT(m.cr,m.field_eval,m.i)+1
              IF m.at_pos=1.OR.ATC(m.p_name,SUBSTR(m.field_eval,m.at_pos))=0
                EXIT
              ENDIF
              LOOP
            ENDIF
            m.at_pos=ATC(m.p_name,m.memline)
            IF m.at_pos=1
              m.snptname=ALLTRIM(UPPER(LEFT(CHRTRAN(STRTRAN(SUBSTR(m.memline,;
                         m.at_pos+LEN(m.p_name)),CHR(9),' '),m.badchars,;
                         m.stdascii),9)))
              IF EMPTY(m.snptname)
                EXIT
              ENDIF
              m.snptname_=m.snptname+IIF(TYPE('PLATFORM')#'C','D',;
                          LEFT(PLATFORM,1))
              REPLACE (m.field_name) WITH STRTRAN(m.field_eval,m.memline,;
                                          m.p_name+' '+m.snptname_)
              m.fnctname='FUNCTION '+m.snptname+m.cr_lf
              m.r=RECNO()
              LOCATE
              IF m.fnctname$PROCCODE
                GOTO m.r
                EXIT
              ENDIF
              m.paramlist=''
              m.at_line=ATCLINE(m.s_para,m.field_eval)
              IF m.at_line>0
                FOR m.k = m.at_line TO MEMLINES(m.field_eval)
                  m.memline=ALLTRIM(STRTRAN(MLINE(m.field_eval,m.k),;
                            CHR(9),' '))
                  IF m.k>m.at_line.AND..NOT.'*:'$m.memline
                    m.at_pos=AT(m.cr,m.field_eval,m.k)+1
                    IF m.at_pos=1.OR.ATC(m.c_s_para,;
                       SUBSTR(m.field_eval,m.at_pos))=0
                      EXIT
                    ENDIF
                    LOOP
                  ENDIF
                  m.at_pos=ATC(m.s_para,m.memline)
                  IF m.at_pos=1
                    m.at_pos=AT(' ',m.memline)
                    IF m.at_pos>0
                      m.paramlist=ALLTRIM(SUBSTR(m.memline,m.at_pos))
                      DO WHILE .T.
                        IF .NOT.RIGHT(m.paramlist,1)==';'
                          EXIT
                        ENDIF
                        m.paramlist=LEFT(m.paramlist,LEN(m.paramlist)-1)
                        m.k=m.k+1
                        IF m.k>MEMLINES(m.field_eval)
                          EXIT
                        ENDIF
                        m.paramlist=m.paramlist+ALLTRIM(STRTRAN(MLINE(;
                                    m.field_eval,m.k),CHR(9),' '))
                      ENDDO
                    ENDIF
                    EXIT
                  ENDIF
                ENDFOR
              ENDIF
              m.new_text=m.cr_lf+m.cr_lf+m.fnctname+;
                         IIF(EMPTY(m.paramlist),'','PARAMETERS '+;
                         m.paramlist+m.cr_lf)+m.cr_lf+'DO CASE'+m.cr_lf
              FOR m.k = 1 TO 4
                DO CASE
                  CASE m.k=1
                    m.new_text=m.new_text+'  CASE _DOS'+m.cr_lf+;
                               '    RETURN '+m.snptname+;
                               'D('+m.paramlist+')'+m.cr_lf
                  CASE m.k=2
                    m.new_text=m.new_text+'  CASE _WINDOWS'+m.cr_lf+;
                               '    RETURN '+m.snptname+;
                               'W('+m.paramlist+')'+m.cr_lf
                  CASE m.k=3
                    m.new_text=m.new_text+'  CASE _MAC'+m.cr_lf+;
                               '    RETURN '+m.snptname+;
                               'M('+m.paramlist+')'+m.cr_lf
                  CASE m.k=4
                    m.new_text=m.new_text+'  CASE _UNIX'+m.cr_lf+;
                               '    RETURN '+m.snptname+;
                               'U('+m.paramlist+')'+m.cr_lf
                ENDCASE
              ENDFOR
              FOR m.k = 1 TO 4
                m.fnctnames=m.fnctnames+1
                DIMENSION a_fnctname(m.fnctnames,2)
                a_fnctname(m.fnctnames,1)=m.snptname+SUBSTR('DWMU',m.k,1)
                a_fnctname(m.fnctnames,2)=m.paramlist
              ENDFOR
              m.new_text=m.new_text+'ENDCASE'+m.cr_lf+'RETURN .F.'+m.cr_lf
              REPLACE PROCCODE WITH PROCCODE+m.new_text
              GOTO m.r
              EXIT
            ENDIF
          ENDFOR
        ENDFOR
      ENDSCAN
    ENDIF
    m.match_drv=.F.
    IF m.gen_mode.AND.a_scxdrvs(7)>0
      m.drv_no=7
      FOR m.drv_cnt = 1 TO a_scxdrvs(7)
        IF ASCAN(a_drvoff,FULLPATH(a_scxdrv(m.drv_cnt,7)))>0
          LOOP
        ENDIF
        m.msg3='['+ALLTRIM(m.platform_)+'] '+trimpath(a_scxdrv(m.drv_cnt,7),.F.,.T.)
        DO delaybar WITH '',m.msg3,90*m.drv_cnt/a_scxdrvs(7)+5
        SCAN ALL FOR .NOT.DELETED()
          m.match_drv=.T.
          DO (a_scxdrv(m.drv_cnt,7))
          DO esc_check
        ENDSCAN
        LOCATE
        SCATTER MEMVAR MEMO
        DO restoreenv
      ENDFOR
    ENDIF
    IF m.match_drv
      DO delaybar WITH '',m.msg2,96
    ENDIF
    IF m.gen_mode.OR.m.lib_mode
      GOTO m.r_scxdata
      IF .NOT.m.lib_mode
        IF .NOT.EMPTY(m.section3)
          LOCATE
          GOTO BOTTOM
          IF insrec()
            =instxt2(m.section3)
          ENDIF
          m.section3=m.null
        ENDIF
        DO delaybar WITH '',m.msg2,96
      ENDIF
      RECALL ALL WHILE RECNO()<m.r_scxdata
      IF m.r_scxdata>RECCOUNT()
        m.i=0
      ELSE
        GOTO m.r_scxdata
        COUNT REST FOR DELETED() TO m.i
      ENDIF
      IF m.i>0
        DO packscx
      ENDIF
      IF m.r_scxdata>RECCOUNT()
        EXIT
      ENDIF
      GOTO m.r_scxdata
      IF m.gen_mode
        SCAN REST FOR .NOT.DELETED()
          IF OBJTYPE>=32
            LOOP
          ENDIF
          m.i=ATCLINE(m.c_instxt,COMMENT)
          IF m.i=0
            LOOP
          ENDIF
          IF ATC(m.c_instxt,MLINE(COMMENT,m.i))#1
            LOOP
          ENDIF
          IF OBJTYPE<32
            REPLACE STYLE WITH 0
          ENDIF
          REPLACE OBJTYPE WITH 15, OBJCODE WITH 0, EXPR WITH '',;
                  VPOS WITH -m.scxcount, HPOS WITH RECNO()+256,;
                  HEIGHT WITH 0, WIDTH WITH 0, PICTURE WITH '',;
                  BOXCHAR WITH '', FILLCHAR WITH '', SCHEME WITH 0,;
                  SCHEME2 WITH -1, COLORPAIR WITH ''
          IF TYPE('PLATFORM')=='C'
            REPLACE PENRED WITH -1, PENGREEN WITH -1, PENBLUE WITH -1,;
                    FILLRED WITH -1, FILLGREEN WITH -1, FILLBLUE WITH -1,;
                    PENSIZE WITH -1, PENPAT WITH -1, FONTFACE WITH '',;
                    FONTSTYLE WITH 0, FONTSIZE WITH 0
          ENDIF
          a_scxupd(m.scxcount)='*'
          REPLACE COMMENT WITH strtranc(COMMENT,m.c_instxt,m.m_instxt)
        ENDSCAN
      ENDIF
      IF .NOT.m.lib_mode
        DO delaybar WITH '',m.msg2,97
      ENDIF
      SELECT FOXSCX
      SET ORDER TO OBJSCX_
      m.i=0
      SEEK m.scx_name+m.lib_name
      SCAN REST FOR .NOT.OBJFLAG_;
           WHILE OBJSCX_==m.scx_name.AND.OBJLIB_==m.lib_name
        m.i=1
        DELETE
      ENDSCAN
      IF m.i>0
        DO delaybar WITH '','Packing:  '+m.ffoxscx,99
        PACK
      ENDIF
      LOCATE
    ENDIF
    SELECT SCXDATA
    IF m.gen_mode
      GOTO m.r_scxdata
      SCAN REST
        =checkclick()
      ENDSCAN
      GOTO m.r_scxdata
      SCAN REST FOR .NOT.REFRESH.AND..NOT.DELETED()
        m.str_data=wordsearch(m.c_refresh)
        IF m.str_data=m.null
          LOOP
        ENDIF
        REPLACE REFRESH WITH .T.
      ENDSCAN
      GOTO m.r_scxdata
      m.new_text=''
      SCAN REST FOR .NOT.DELETED()
        m.old_text=COMMENT
        DO WHILE .T.
          m.at_pos=ATC(m.c_function,m.old_text)
          IF m.at_pos=0
            EXIT
          ENDIF
          m.old_text=SUBSTR(m.old_text,m.at_pos+2)
          m.at_pos=ATC(m.c_endfnct,m.old_text)
          IF m.at_pos=0
            m.new_text=m.new_text+m.cr_lf+m.old_text+m.cr_lf
            EXIT
          ENDIF
          m.new_text=m.new_text+m.cr_lf+LEFT(m.old_text,m.at_pos-1)+m.cr_lf
          m.old_text=SUBSTR(m.old_text,m.at_pos+2)
          =esc_check()
        ENDDO
      ENDSCAN
      IF .NOT.EMPTY(m.new_text)
        LOCATE
        IF ATC('FUNCTION '+m.str_data+m.cr_lf,m.cr_lf+PROCCODE+m.cr_lf)=0
          REPLACE PROCCODE WITH PROCCODE+m.new_text
        ELSE
          =warning(m.c_function+" '"+m.str_data+"' duplicated")
        ENDIF
      ENDIF
      LOCATE
      IF m.scnobj=='ON'.AND..NOT.wordsearch('#NOREAD',.T.)==m.null
        m.scnobj='OFF'
      ENDIF
      IF m.scnobj=='ON'
        GOTO m.r_scxdata
        LOCATE REST FOR BETWEEN(OBJTYPE,11,14).OR.;
                        (OBJTYPE=15.AND.OBJCODE#0).OR.OBJTYPE=16.OR.;
                        OBJTYPE=20.OR.OBJTYPE=22
        IF EOF()
          m.scnobj='OFF'
        ENDIF
      ENDIF
      IF m.scnobj=='ON'
        GOTO m.r_scxdata
        m.str_data='m.scnobj'+ALLTRIM(STR(m.scxcount,2))
        IF .NOT.UPPER(MLINE(NAME,1))==UPPER(m.str_data).AND.insrec(-1)
          REPLACE OBJTYPE WITH 20, OBJCODE WITH 1,;
                  NAME WITH m.str_data, EXPR WITH '',;
                  PICTURE WITH '"@*IHN "',;
                  WHENTYPE WITH 0, WHEN WITH '.F.',;
                  INITIALVAL WITH '', INITIALNUM WITH 0, COMMENT WITH ''
          IF _FOX25
            IF ALLTRIM(m.platform_)=='MAC'
              REPLACE FONTFACE WITH 'Geneva',;
                      FONTSTYLE WITH 0, FONTSIZE WITH 10
            ELSE
              REPLACE FONTFACE WITH 'MS Sans Serif',;
                      FONTSTYLE WITH 0, FONTSIZE WITH 8
            ENDIF
          ENDIF
        ENDIF
        GOTO BOTTOM
        IF .NOT.EMPTY(m.section3)
          SKIP -1
        ENDIF
        m.str_data='m.scnend'+ALLTRIM(STR(m.scxcount,2))
        IF .NOT.UPPER(MLINE(NAME,1))==UPPER(m.str_data).AND.insrec()
          REPLACE OBJTYPE WITH 20, OBJCODE WITH 1,;
                  NAME WITH m.str_data, EXPR WITH '',;
                  PICTURE WITH '"@*IHN "',;
                  WHENTYPE WITH 0, WHEN WITH '.F.',;
                  INITIALVAL WITH '', INITIALNUM WITH 0, COMMENT WITH ''
          IF _FOX25
            IF ALLTRIM(m.platform_)=='MAC'
              REPLACE FONTFACE WITH 'Geneva',;
                      FONTSTYLE WITH 0, FONTSIZE WITH 10
            ELSE
              REPLACE FONTFACE WITH 'MS Sans Serif',;
                      FONTSTYLE WITH 0, FONTSIZE WITH 8
            ENDIF
          ENDIF
        ENDIF
      ENDIF
      GOTO m.r_scxdata
    ENDIF
    m.match_drv=.F.
    IF m.gen_mode.AND.a_scxdrvs(8)>0
      m.drv_no=8
      FOR m.drv_cnt = 1 TO a_scxdrvs(8)
        IF ASCAN(a_drvoff,FULLPATH(a_scxdrv(m.drv_cnt,8)))>0
          LOOP
        ENDIF
        m.msg3='['+ALLTRIM(m.platform_)+'] '+trimpath(a_scxdrv(m.drv_cnt,8),.F.,.T.)
        DO delaybar WITH '',m.msg3,90*m.drv_cnt/a_scxdrvs(8)+5
        SCAN ALL FOR .NOT.DELETED()
          m.match_drv=.T.
          DO (a_scxdrv(m.drv_cnt,8))
          DO esc_check
        ENDSCAN
        LOCATE
        SCATTER MEMVAR MEMO
        DO restoreenv
      ENDFOR
    ENDIF
    IF m.match_drv
      DO delaybar WITH '',m.msg2,95
    ENDIF
    IF .NOT.m.gen_mode.AND..NOT.m.lib_mode
      EXIT
    ENDIF
    IF m.gen_mode
      m.i=0
      SCAN ALL FOR .NOT.DELETED()
        IF wordsearch(m.c_delobj)==m.null
          LOOP
        ENDIF
        m.i=m.i+1
        =delrec()
      ENDSCAN
      IF m.i>0
        DO packscx
      ENDIF
      IF m.r_scxdata>RECCOUNT()
        EXIT
      ENDIF
      LOCATE
      IF '*:'$SETUPCODE
        REPLACE SETUPCODE WITH STRTRAN(m.cr_lf+SETUPCODE,m.lf+'*:',m.lf+'*-:')
      ENDIF
      IF '*:'$SETUPCODE
        REPLACE SETUPCODE WITH STRTRAN(SETUPCODE,m.cr+'*:',m.cr+'*-:')
      ENDIF
    ENDIF
  ENDDO
  IF _WINDOWS.OR._MAC
    SET MESSAGE TO ' '
  ENDIF
  RELEASE a_scatter
  IF USED('SCXBASE')
    SCATTER MEMVAR MEMO BLANK
    USE IN SCXBASE
  ENDIF
  IF .NOT.USED('SCXDATA')
    EXIT
  ENDIF
  SELECT SCXDATA
  SET FILTER TO
  LOCATE
  IF .NOT.USED('PJXDATA')
    EXIT
  ENDIF
  IF m.comp_flag
    DO delaybar WITH '',m.msg2,100
  ENDIF
  SELECT PJXDATA
  m.fscxbase=STRTRAN(m.fscxbase,m.null,'')
  IF m.fromproj
    LOCATE FOR TYPE=='s'.AND.trimpath(STRTRAN(MLINE(NAME,1),;
               m.null,''),.F.,.T.)==trimpath(m.fscxbase,.F.,.T.)
  ELSE
    LOCATE FOR TYPE=='s'.AND.trimpath(FULLPATH(STRTRAN(STRTRAN(MLINE(NAME,1),;
               '..\',''),m.null,'')),.F.,.T.)==trimpath(m.fscxbase,.F.,.T.)
  ENDIF
  IF EOF()
    EXIT
  ENDIF
  IF .NOT.EMPTY(m.fscxdata)
    REPLACE NAME WITH FULLPATH(m.fscxdata,NAME)
  ENDIF
  REPLACE TIMESTAMP WITH -1
  LOCATE FOR TYPE=='s'.AND.TIMESTAMP>=0.AND.;
             ASCAN(a_scxalias,trimpath(STRTRAN(MLINE(NAME,1),CHR(0),'')))=0
  IF EOF()
    EXIT
  ENDIF
  m.screenset=.T.
  m.fscxdata=''
  IF _FOX25
    m.platform_=''
  ENDIF
ENDDO
m.platform_=PADR(m.cplatform_,8)
IF USED('PJXBASE')
  USE IN PJXBASE
ENDIF
IF USED('PJXDATA')
  USE IN PJXDATA
ENDIF
SELECT (m.lastslct)
IF m.comp_flag
  DO delaybar WITH '','',0,.T.
ENDIF
DO esc_check
RETURN .T.

* END genscx



FUNCTION updspr
PARAMETER m.projdbf,m.recno
PRIVATE memline,memline2,at_pos,at_pos2,at_pos3
PRIVATE lastslct,decimals,find_str,i,j,k,n,scx_no,ascstr
PRIVATE finsert,insfiles,inscount,inspos,fnameold,fnamenew
PRIVATE scx_alias,new_text,match,rplatform_,inserttop
PRIVATE winname,str_data,factor

IF .NOT.TYPE('a_scxalias')=='C'
  RETURN .F.
ENDIF
m.lastslct=SELECT()
FOR m.i = 1 TO m.screens
  IF USED(a_scxalias(m.i))
    USE IN (a_scxalias(m.i))
  ENDIF
ENDFOR
IF USED('SCXDATA')
  USE IN SCXDATA
ENDIF
IF USED('SPRDATA')
  SELECT SPRDATA
  USE
ENDIF
IF m.scxcount=0
  SELECT (m.lastslct)
  RETURN .F.
ENDIF
CREATE CURSOR SPRDATA (SPR M, INS M)
INSERT BLANK
APPEND MEMO SPR FROM (m.fsprout) OVERWRITE
FOR m.scx_no = 1 TO m.scxcount
  IF TYPE('a_fscxdata(m.scx_no)')=='C'
    m.fscxdata=a_fscxdata(m.scx_no)
  ENDIF
  m.fnameold=ALLTRIM(UPPER(trimpath(m.fscxdata,.T.)))
  m.fnamenew=PADL(UPPER(trimpath(m.fsprout,.T.)),LEN(m.fnameold))
  IF m.fnameold$SPR
    REPLACE SPR WITH STRTRAN(SPR,m.fnameold,m.fnamenew)
  ENDIF
ENDFOR
IF .NOT.m.ignrbraces.AND.'{{'$SPR
  REPLACE SPR WITH evltxt(SPR)
ENDIF
m.j=0
FOR m.i = 1 TO 6
  IF a_sprdrvs(m.i)>0
    m.j=m.i
    EXIT
  ENDIF
ENDFOR
IF .NOT.m.updsprflag.AND.m.j=0.AND.m.fnctnames=0.AND.;
   AT(m.lf+'@ -',SPR)=0.AND.ATC(m.p_insert,SPR)=0.AND.;
   ASCAN(a_scxupd,'*')=0.AND..NOT.m.c_insert$SPR.AND.;
   .NOT.m.c_section3$SPR
  COPY MEMO SPR TO (m.fsprout)
  SELECT (m.lastslct)
  RETURN .F.
ENDIF
IF _WINDOWS.OR._MAC
  m.fsprout=LOWER(m.fsprout)
  SET MESSAGE TO LEFT('Updating Screen Code: '+m.fsprout,79)
ELSE
  m.fsprout=UPPER(m.fsprout)
ENDIF
m.msg1='Updating Screen Code...'
m.msg2=m.fsprout
DO delaybar WITH m.msg1,m.msg2,0,.T.
DO esc_check
SELECT SPRDATA
IF a_sprdrvs(1)>0
  m.drv_no=-1
  FOR m.drv_cnt = 1 TO a_sprdrvs(1)
    IF ASCAN(a_drvoff,FULLPATH(a_sprdrv(m.drv_cnt,1)))>0
      LOOP
    ENDIF
    DO (a_sprdrv(m.drv_cnt,1))
    DO esc_check
    LOCATE
    DO restoreenv
  ENDFOR
ENDIF
SELECT SPRDATA
IF m.fnctnames>0
  FOR m.i = 1 TO m.fnctnames
    m.find_str=m.lf+'FUNCTION '+ALLTRIM(a_fnctname(m.i,1))+' '
    IF ATC(m.find_str,SPR)>0
      LOOP
    ENDIF
    m.memline=ALLTRIM(a_fnctname(m.i,2))
    REPLACE SPR WITH SPR+m.cr_lf+m.cr_lf+m.find_str+m.cr_lf+;
                     IIF(EMPTY(m.memline),'','PARAMETERS '+m.memline+;
                     m.cr_lf)+'RETURN .F.'+m.cr_lf
  ENDFOR
ENDIF
FOR m.scx_no = 1 TO m.scxcount
  m.factor=m.scx_no/m.scxcount
  IF USED('SCXDATA')
    SELECT SCXDATA
    USE
  ELSE
    SELECT 0
  ENDIF
  m.fscxdata=a_fscxdata(m.scx_no)
  USE (m.fscxdata) ALIAS SCXDATA
  SET FILTER TO .NOT.DELETED().AND.OBJTYPE#2.AND.OBJTYPE#10.AND.OBJTYPE#23
  LOCATE
  IF a_sprdrvs(2)>0
    m.drv_no=-2
    FOR m.drv_cnt = 1 TO a_sprdrvs(2)
      IF ASCAN(a_drvoff,FULLPATH(a_sprdrv(m.drv_cnt,2)))>0
        LOOP
      ENDIF
      m.msg3=trimpath(a_sprdrv(m.drv_cnt,2),.F.,.T.)
      DO delaybar WITH '',m.msg3,90*m.drv_cnt/a_sprdrvs(2)+5
      SCAN ALL
        DO (a_sprdrv(m.drv_cnt,2))
        DO esc_check
      ENDSCAN
      LOCATE
      SCATTER MEMVAR MEMO
      DO restoreenv
    ENDFOR
  ENDIF
  IF m.scx_no=1
    DO delaybar WITH '',m.msg2,5
  ENDIF
  SCAN ALL
    IF ATC(m.m_size,COMMENT)=0.AND.ATC(m.m_nosize,COMMENT)=0
      LOOP
    ENDIF
    IF m.scxcount=1
      DO delaybar WITH '','',20*RECNO()/RECCOUNT()
    ENDIF
    DO esc_check
    IF TYPE('PLATFORM')=='C'
      m.rplatform=ALLTRIM(PLATFORM)
    ELSE
      m.rplatform='DOS'
    ENDIF
    DO CASE
      CASE m.rplatform=='DOS'
        m.decimals=0
      CASE m.rplatform=='WINDOWS'
        m.decimals=3
      CASE m.rplatform=='MAC'
        m.decimals=3
      CASE m.rplatform=='UNIX'
        m.decimals=0
      OTHERWISE
        m.decimals=0
    ENDCASE
    FOR m.n = 1 TO IIF(REFRESH,2,1)
      FOR m.j = 1 TO 3
        DO CASE
          CASE m.j=1
            m.ascstr=' '
          CASE m.j=2
            m.ascstr=','
          OTHERWISE
            m.ascstr=''
        ENDCASE
        m.find_str='SIZE '+ALLTRIM(STR(m.scx_no+IIF(OBJTYPE#15.OR.;
                   OBJCODE#2,-100,800),4))+IIF(m.decimals=0,'','.'+;
                   REPLICATE('0',m.decimals))+','+;
                   ALLTRIM(STR(RECNO()+256,10,m.decimals))+m.ascstr
        m.i=ATCLINE(m.find_str,SPRDATA.SPR)
        IF m.i=0
          LOOP
        ENDIF
        m.at_pos=ATC(m.find_str,SPRDATA.SPR)
        _MLINE=m.at_pos-5
        m.memline=MLINE(SPRDATA.SPR,1,_MLINE)
        m.memline=MLINE(SPRDATA.SPR,1,_MLINE)
        m.k=0
        IF EMPTY(SHOW)
          IF RIGHT(m.memline,1)==';'
            m.memline=m.memline+m.cr_lf
          ELSE
            m.memline=';'+m.cr_lf+m.memline+m.cr_lf
            m.at_pos=m.at_pos-OCCURS(CHR(9),m.memline)-3
            m.k=1
          ENDIF
        ELSE
          m.memline=STRTRAN(m.memline,CHR(9),'')
          IF RIGHT(m.memline,1)==';'
            m.memline=LEFT(m.memline,LEN(m.memline)-1)
          ENDIF
        ENDIF
        m.new_text=IIF(EMPTY(SHOW),'',ALLTRIM(MLINE(SHOW,1))+' ')+;
                   IIF(m.k=0,'',m.cr_lf)
        REPLACE SPRDATA.SPR WITH LEFT(SPRDATA.SPR,m.at_pos-1)+m.new_text+;
                                 SUBSTR(SPRDATA.SPR,m.at_pos+LEN(m.memline))
        EXIT
      ENDFOR
    ENDFOR
  ENDSCAN
  m.match=.F.
  IF a_sprdrvs(3)>0
    m.drv_no=-3
    FOR m.drv_cnt = 1 TO a_sprdrvs(3)
      IF ASCAN(a_drvoff,FULLPATH(a_sprdrv(m.drv_cnt,3)))>0
        LOOP
      ENDIF
      m.msg3=trimpath(a_sprdrv(m.drv_cnt,3),.F.,.T.)
      DO delaybar WITH '',m.msg3,90*m.drv_cnt/a_sprdrvs(3)+5
      SCAN ALL
        m.match=.T.
        DO (a_sprdrv(m.drv_cnt,3))
        DO esc_check
      ENDSCAN
      LOCATE
      SCATTER MEMVAR MEMO
      DO restoreenv
    ENDFOR
  ENDIF
  IF m.match.AND.m.scxcount=1
    DO delaybar WITH '',m.msg2,50
  ENDIF
  SCAN ALL
    IF ATC(m.m_instxt,COMMENT)=0
      LOOP
    ENDIF
    IF m.scxcount=1
      DO delaybar WITH '','',70*RECNO()/RECCOUNT()+20
    ENDIF
    DO esc_check
    IF TYPE('PLATFORM')=='C'
      m.rplatform=ALLTRIM(PLATFORM)
    ELSE
      m.rplatform='DOS'
    ENDIF
    DO CASE
      CASE m.rplatform=='DOS'
        m.decimals=0
      CASE m.rplatform=='WINDOWS'
        m.decimals=3
      CASE m.rplatform=='MAC'
        m.decimals=3
      CASE m.rplatform=='UNIX'
        m.decimals=0
      OTHERWISE
        m.decimals=0
    ENDCASE
    FOR m.n = 1 TO IIF(REFRESH,2,1)
      m.find_str='@ '+ALLTRIM(STR(-m.scx_no,4))+IIF(m.decimals=0,'','.'+;
                 REPLICATE('0',m.decimals))
      m.find_str=m.find_str+','+ALLTRIM(STR(RECNO()+256,10,m.decimals))+' '
      m.i=ATCLINE(m.find_str,SPRDATA.SPR)
      IF m.i=0
        LOOP
      ENDIF
      m.at_pos=ATC(m.find_str,SPRDATA.SPR)
      _MLINE=m.at_pos-5
      m.memline=MLINE(SPRDATA.SPR,1,_MLINE)
      m.memline=MLINE(SPRDATA.SPR,1,_MLINE)+m.cr_lf
      FOR m.j = 1 TO 5
        m.memline2=ALLTRIM(MLINE(SPRDATA.SPR,1,_MLINE))
        IF INLIST(UPPER(LEFT(STRTRAN(m.memline2,CHR(9),''),4)),'SIZE','PEN ',;
                  'STYL','FONT','COLO')
          m.memline=m.memline+m.memline2+m.cr_lf
        ELSE
          EXIT
        ENDIF
      ENDFOR
      m.find_str=m.m_instxt
      m.str_data=wordsearch(m.find_str)
      IF m.str_data=m.null
        m.str_data=''
      ENDIF
      m.at_pos2=ATC(m.find_str,COMMENT)
      IF m.at_pos2=0
        m.new_text=''
      ELSE
        m.memline2=ALLTRIM(SUBSTR(COMMENT,m.at_pos2+LEN(m.find_str)+;
                   LEN(m.str_data)+1))
        m.at_pos3=ATC(m.c_endtxt,m.memline2)
        IF m.at_pos3>0
          m.memline2=LEFT(m.memline2,m.at_pos3-1)
        ENDIF
        DO WHILE LEFT(m.memline2,1)==m.cr.OR.LEFT(m.memline2,1)==m.lf
          m.memline2=SUBSTR(m.memline2,2)
        ENDDO
        DO WHILE RIGHT(m.memline2,1)==m.cr.OR.RIGHT(m.memline2,1)==m.lf
          m.memline2=LEFT(m.memline2,LEN(m.memline2)-1)
        ENDDO
        IF m.outtxt=='ON'
          m.new_text=m.cr+'** Start of inserted text'+m.cr+;
                     m.memline2+m.cr+m.cr+'** End of inserted text'+m.cr
        ELSE
          m.new_text=m.memline2+SPACE(5)+m.cr
        ENDIF
      ENDIF
      REPLACE SPRDATA.SPR WITH LEFT(SPRDATA.SPR,m.at_pos-1)+m.new_text+;
                               SUBSTR(SPRDATA.SPR,m.at_pos+LEN(m.memline)-1)
    ENDFOR
  ENDSCAN
  SELECT SPRDATA
  FOR m.i = 1 TO 4
    m.str_data=a_nowclaus(m.scx_no,m.i)
    IF EMPTY(m.str_data)
      LOOP
    ENDIF
    m.winname=ALLTRIM(LEFT(m.str_data,11))
    m.str_data=UPPER(ALLTRIM(SUBSTR(m.str_data,12)))
    IF EMPTY(m.winname).OR.EMPTY(m.str_data)
      LOOP
    ENDIF
    m.at_pos3=ATC('DEFINE WINDOW '+m.winname+' ',SPR)
    IF m.at_pos3=0
      =warning(m.c_nowclaus+" 'DEFINE WINDOW "+m.winname+"' not found")
      LOOP
    ENDIF
    m.memline=SUBSTR(SPR,m.at_pos3,2048)
    m.new_text=''
    DO WHILE .T.
      m.at_pos=AT(m.cr_lf,m.memline)
      IF m.at_pos<2
        EXIT
      ENDIF
      m.new_text=m.new_text+LEFT(m.memline,m.at_pos+1)
      IF .NOT.SUBSTR(m.memline,m.at_pos-1,1)==';'.OR.;
         AT(CHR(9)+'COLOR',LEFT(m.memline,m.at_pos+1))>0
        EXIT
      ENDIF
      m.memline=SUBSTR(m.memline,m.at_pos+2)
    ENDDO
    m.memline=m.new_text
    DO WHILE .T.
      m.at_pos=AT(' ',m.str_data)
      DO CASE
        CASE EMPTY(m.str_data)
          EXIT
        CASE m.at_pos=0
          m.find_str=ALLTRIM(m.str_data)
          m.str_data=''
        OTHERWISE
          m.find_str=ALLTRIM(LEFT(m.str_data,m.at_pos-1))
          m.str_data=ALLTRIM(SUBSTR(m.str_data,m.at_pos+1))
      ENDCASE
      IF m.find_str=='COLOR'
        LOOP
      ENDIF
      m.find_str=CHR(9)+m.find_str+' '
      m.at_pos=AT(m.find_str,m.new_text)
      IF m.at_pos=0
        LOOP
      ENDIF
      m.at_pos2=m.at_pos
      DO WHILE .NOT.SUBSTR(m.new_text,m.at_pos,1)==';'
        m.at_pos=m.at_pos-1
        IF m.at_pos<=0
          EXIT
        ENDIF
      ENDDO
      DO WHILE .NOT.SUBSTR(m.new_text,m.at_pos2,1)==';'
        m.at_pos2=m.at_pos2+1
        IF m.at_pos2>=LEN(m.new_text)
          EXIT
        ENDIF
      ENDDO
      m.new_text=LEFT(m.new_text,m.at_pos)+SUBSTR(m.new_text,m.at_pos2+1)
    ENDDO
    REPLACE SPR WITH strtranc(LEFT(SPR,m.at_pos3-1)+m.new_text+;
                     SUBSTR(SPR,m.at_pos3+LEN(m.memline)),m.winname,;
                     ALLTRIM(LEFT(m.winname,10)))
  ENDFOR
  SELECT SCXDATA
  IF a_sprdrvs(4)>0
    m.drv_no=-4
    FOR m.drv_cnt = 1 TO a_sprdrvs(4)
      IF ASCAN(a_drvoff,FULLPATH(a_sprdrv(m.drv_cnt,4)))>0
        LOOP
      ENDIF
      m.msg3=trimpath(a_sprdrv(m.drv_cnt,4),.F.,.T.)
      DO delaybar WITH '',m.msg3,90*m.drv_cnt/a_sprdrvs(4)+5
      SCAN ALL
        DO (a_sprdrv(m.drv_cnt,4))
        DO esc_check
      ENDSCAN
      LOCATE
      SCATTER MEMVAR MEMO
      DO restoreenv
    ENDFOR
  ENDIF
  DO delaybar WITH '','',90*m.factor
  IF USED('SCXDATA')
    SELECT SCXDATA
    USE
  ENDIF
ENDFOR
SELECT SPRDATA
m.match=.F.
IF a_sprdrvs(5)>0
  m.drv_no=-5
  FOR m.drv_cnt = 1 TO a_sprdrvs(5)
    IF ASCAN(a_drvoff,FULLPATH(a_sprdrv(m.drv_cnt,5)))>0
      LOOP
    ENDIF
    m.msg3=trimpath(a_sprdrv(m.drv_cnt,5),.F.,.T.)
    DO delaybar WITH '',m.msg3,90*m.drv_cnt/a_sprdrvs(5)+5
    SCAN ALL
      m.match=.T.
      DO (a_sprdrv(m.drv_cnt,5))
      DO esc_check
    ENDSCAN
    LOCATE
    SCATTER MEMVAR MEMO
    DO restoreenv
  ENDFOR
ENDIF
IF m.match
  DO delaybar WITH '',m.msg2,90
ENDIF
DIMENSION a_insfile(1)
m.insfiles=0
m.at_pos2=1
FOR m.k = 1 TO 2
  m.find_str=IIF(m.k=1,m.c_insert,m.p_insert)
  DO WHILE .T.
    DO esc_check
    m.at_pos=ATC(m.find_str,SUBSTR(SPR,m.at_pos2))
    IF m.at_pos=0
      EXIT
    ENDIF
    m.at_pos=m.at_pos+m.at_pos2-1
    m.inserttop=(m.k=1.AND.UPPER(SUBSTR(SPR,m.at_pos,11))==m.c_insert+'TOP')
    m.at_pos=m.at_pos-2
    m.ascstr=ASC(SUBSTR(SPR,m.at_pos-1,1))
    IF m.ascstr=10.OR.m.ascstr=13
      m.at_pos=m.at_pos-1
    ENDIF
    m.j=LEN(m.find_str)
    FOR m.i = 1 TO 2
      IF EMPTY(SUBSTR(SPR,m.at_pos+m.i,1))
        EXIT
      ENDIF
      m.j=m.j+1
    ENDFOR
    m.at_pos3=0
    FOR m.i = -m.j TO m.j
      m.memline=MLINE(SPR,1,m.at_pos)
      m.at_pos3=ATC(m.find_str,m.memline)
      IF m.at_pos3>0
        EXIT
      ENDIF
      m.at_pos=m.at_pos+1
    ENDFOR
    m.memline2=IIF(m.at_pos3>0,ALLTRIM(STRTRAN(m.memline,CHR(9),' ')),'')
    IF ATC(m.find_str,m.memline2)#1
      m.at_pos2=m.at_pos+LEN(m.memline)+2
      LOOP
    ENDIF
    IF m.ascstr=10.OR.m.ascstr=13
      m.memline=m.memline+' '
    ENDIF
    m.at_pos=m.at_pos+1
    m.j=0
    FOR m.i = 1 TO 256
      m.ascstr=ASC(SUBSTR(SPR,m.at_pos-m.i,1))
      IF m.ascstr=10.OR.m.ascstr=13.OR.(m.at_pos-m.i)<=0
        EXIT
      ENDIF
      m.j=-1
    ENDFOR
    IF m.j=-1.OR.m.i>256
      m.at_pos2=m.at_pos+LEN(m.memline)+2
      LOOP
    ENDIF
    m.finsert=ALLTRIM(SUBSTR(m.memline2,AT(' ',m.memline2)))
    DO WHILE RIGHT(m.finsert,1)==m.cr.OR.RIGHT(m.finsert,1)==m.lf
      m.finsert=LEFT(m.finsert,LEN(m.finsert)-1)
    ENDDO
    IF FILE(m.finsert)
      m.inscount=0
      m.inspos=ASCAN(a_insfile,m.finsert)
      DO WHILE m.inspos>0.AND.m.inscount<256
        m.inscount=m.inscount+1
        m.inspos=ASCAN(a_insfile,m.finsert,m.inspos+1)
      ENDDO
      IF m.inscount>256
        REPLACE SPR WITH LEFT(SPR,m.at_pos-1)+'*'+SUBSTR(SPR,m.at_pos)
        m.at_pos2=m.at_pos+LEN(m.memline)+2
        LOOP
      ENDIF
      m.insfiles=m.insfiles+1
      DIMENSION a_insfile(m.insfiles)
      a_insfile(m.insfiles)=m.finsert
      APPEND MEMO INS FROM (m.finsert) OVERWRITE
      m.new_text=INS
      m.new_text='** Start of inserted file '+m.finsert+;
                 ' start'+m.cr_lf+;
                 m.new_text+m.cr_lf+'** End of inserted file '+;
                 m.finsert+' end'+;
                 m.cr_lf
    ELSE
      =warning(m.c_insert,m.finsert)
      m.new_text='*'+m.cr_lf+'* Inserted file '+m.finsert+' not found!'+;
                 cr_lf+'*'+m.cr_lf
    ENDIF
    m.i=LEN(m.memline)
    IF m.inserttop
      m.memline=ALLTRIM(m.memline)+m.cr_lf
      REPLACE SPR WITH LEFT(SPR,m.at_pos-1)+m.cr_lf+;
                       strtranc(SUBSTR(SPR,m.at_pos+m.i+1),m.memline,m.cr_lf)
      m.at_pos3=ATC(m.cr_lf+m.cr_lf,SPR)
      IF m.at_pos3=0.OR.m.at_pos3>=m.at_pos.OR.;
         (m.at_pos3>=ATC(m.cr_lf+'DO CASE',SPR).AND.;
         m.at_pos3>=ATC(m.cr_lf+'#REGION 1',SPR))
        m.at_pos3=1
      ELSE
        m.at_pos3=m.at_pos3+2
      ENDIF
      REPLACE SPR WITH LEFT(SPR,m.at_pos3-1)+m.cr_lf+m.new_text+;
                       SUBSTR(SPR,m.at_pos3)
      m.at_pos2=1
    ELSE
      REPLACE SPR WITH LEFT(SPR,m.at_pos-1)+m.new_text+;
                       SUBSTR(SPR,m.at_pos+m.i+1)
    ENDIF
  ENDDO
ENDFOR
DO delaybar WITH '','',95
IF .NOT.m.ignrbraces.AND.'{{'$SPR
  REPLACE SPR WITH evltxt(SPR)
ENDIF
m.match=.F.
IF a_sprdrvs(6)>0
  m.drv_no=-6
  FOR m.drv_cnt = 1 TO a_sprdrvs(6)
    IF ASCAN(a_drvoff,FULLPATH(a_sprdrv(m.drv_cnt,6)))>0
      LOOP
    ENDIF
    m.msg3=trimpath(a_sprdrv(m.drv_cnt,6),.F.,.T.)
    DO delaybar WITH '',m.msg3,90*m.drv_cnt/a_sprdrvs(6)+5
    SCAN ALL
      m.match=.T.
      DO (a_sprdrv(m.drv_cnt,6))
      DO esc_check
    ENDSCAN
    LOCATE
    SCATTER MEMVAR MEMO
    DO restoreenv
  ENDFOR
ENDIF
IF m.match
  DO delaybar WITH '',m.msg2,95
ENDIF
COPY MEMO SPR TO (m.fsprout)
DO delaybar WITH '','',100
IF _WINDOWS.OR._MAC
  SET MESSAGE TO ' '
ENDIF
SELECT (m.lastslct)
DO delaybar WITH '','',0,.T.
DO esc_check
RETURN .T.

* END updspr



FUNCTION openfoxscx
PRIVATE i,configfile,lastonerr2

IF USED('FOXSCX')
  SELECT FOXSCX
  LOCATE
  RETURN .T.
ENDIF
IF FILE(m.ffoxscx)
  SELECT 0
  USE (m.ffoxscx) ALIAS FOXSCX
  IF (.NOT._FOX25.OR..NOT.USED('SCXBASE').OR.;
     FCOUNT('SCXBASE')=(FCOUNT()-m.fcountadj)).AND.;
     LEN(OBJFIELD_)=24
    USE
  ELSE
    m.ffoxscx2=FULLPATH(uniqueflnm(),m.ffoxscx)
    SELECT * FROM FOXSCX INTO TABLE (m.ffoxscx2)
    USE
    SELECT FOXSCX
    USE
    =erasedbf(m.ffoxscx,'FOXSCX')
  ENDIF
ENDIF
IF FILE(m.ffoxscx).OR..NOT.USED('SCXBASE')
  IF USED('FOXSCX')
    SELECT FOXSCX
  ELSE
    IF .NOT.FILE(m.ffoxscx)
      RETURN .F.
    ENDIF
    SELECT 0
    USE (m.ffoxscx) ALIAS FOXSCX
  ENDIF
ELSE
  SELECT SCXBASE
  m.i=AFIELDS(a_fscatter)
  IF .NOT._FOX25
    m.i=AFIELDS(a_fscatter)
    DIMENSION a_fscatter(m.i+1,4)
    a_fscatter(m.i+1,1)='PLATFORM'
    a_fscatter(m.i+1,2)='C'
    a_fscatter(m.i+1,3)=8
    a_fscatter(m.i+1,4)=0
    m.i=m.i+1
  ENDIF
  DIMENSION a_fscatter(m.i+8,4)
  a_fscatter(m.i+1,1)='OBJNAME_'
  a_fscatter(m.i+1,2)='C'
  a_fscatter(m.i+1,3)=24
  a_fscatter(m.i+1,4)=0
  a_fscatter(m.i+2,1)='OBJBASE_'
  a_fscatter(m.i+2,2)='C'
  a_fscatter(m.i+2,3)=35
  a_fscatter(m.i+2,4)=0
  a_fscatter(m.i+3,1)='OBJFIELD_'
  a_fscatter(m.i+3,2)='C'
  a_fscatter(m.i+3,3)=24
  a_fscatter(m.i+3,4)=0
  a_fscatter(m.i+4,1)='OBJLIB_'
  a_fscatter(m.i+4,2)='C'
  a_fscatter(m.i+4,3)=10
  a_fscatter(m.i+4,4)=0
  a_fscatter(m.i+5,1)='OBJSCX_'
  a_fscatter(m.i+5,2)='C'
  a_fscatter(m.i+5,3)=8
  a_fscatter(m.i+5,4)=0
  a_fscatter(m.i+6,1)='OBJFLAG_'
  a_fscatter(m.i+6,2)='L'
  a_fscatter(m.i+6,3)=1
  a_fscatter(m.i+6,4)=0
  a_fscatter(m.i+7,1)='OBJCMNT_'
  a_fscatter(m.i+7,2)='M'
  a_fscatter(m.i+7,3)=10
  a_fscatter(m.i+7,4)=0
  a_fscatter(m.i+8,1)='OBJMEMO_'
  a_fscatter(m.i+8,2)='M'
  a_fscatter(m.i+8,3)=10
  a_fscatter(m.i+8,4)=0
  m.lastonerr2=ON('ERROR')
  ON ERROR =warning("_FOXSCX='"+m.ffoxscx+"' file could not be created")
  CREATE TABLE (m.ffoxscx) FROM ARRAY a_fscatter
  ON ERROR &lastonerr2
  IF .NOT.FILE(m.ffoxscx)
    RETURN .F.
  ENDIF
  USE
  RELEASE a_fscatter
  SELECT 0
  USE (m.ffoxscx) ALIAS FOXSCX
  IF FILE(m.ffoxscx2+'.DBF')
    APPEND FROM (m.ffoxscx2)
    =erasedbf(m.ffoxscx2,m.ffoxscx2)
  ENDIF
ENDIF
SELECT FOXSCX
m.i=0
IF .NOT.TAG(1)=='OBJNAME_'.OR..NOT.KEY(1)=='UPPER(OBJNAME_)+OBJLIB_'
  m.i=1
ENDIF
IF .NOT.TAG(2)=='OBJBASE_'.OR..NOT.KEY(2)=='OBJBASE_+OBJLIB_'
  m.i=2
ENDIF
IF .NOT.TAG(3)=='OBJFIELD_'.OR..NOT.KEY(3)=='OBJFIELD_+OBJLIB_'
  m.i=3
ENDIF
IF .NOT.TAG(4)=='OBJLIB_'.OR..NOT.KEY(4)=='OBJLIB_+UPPER(OBJNAME_)'
  m.i=4
ENDIF
IF .NOT.TAG(5)=='OBJSCX_'.OR..NOT.KEY(5)=='OBJSCX_+OBJLIB_+UPPER(OBJNAME_)'
  m.i=5
ENDIF
IF m.i>0
  DELETE TAG ALL
  INDEX ON UPPER(OBJNAME_)+OBJLIB_ TAG OBJNAME_
  INDEX ON OBJBASE_+OBJLIB_ TAG OBJBASE_
  INDEX ON OBJFIELD_+OBJLIB_ TAG OBJFIELD_
  INDEX ON OBJLIB_+UPPER(OBJNAME_) TAG OBJLIB_
  INDEX ON OBJSCX_+OBJLIB_+UPPER(OBJNAME_) TAG OBJSCX_
ENDIF
IF EMPTY(FILTER()).AND.TYPE('PLATFORM')=='C'
  IF TYPE('m.platform_')#'C'.OR.EMPTY(m.platform_)
    SET FILTER TO PLATFORM==m.cplatform_
  ELSE
    SET FILTER TO PLATFORM==m.platform_
  ENDIF
ENDIF
LOCATE
RETURN .T.

* END openfoxscx



FUNCTION strtranc
PARAMETERS expc1,expc2,expc3,expn1,expn2
PRIVATE expr,at_pos,at_pos2,i,j

IF EMPTY(m.expc1).OR.EMPTY(m.expc2)
  RETURN m.expc1
ENDIF
m.expr=m.expc1
IF TYPE('m.expn1')#'N'
  m.expn1=1
ENDIF
IF TYPE('m.expn2')#'N'
  m.expn2=LEN(m.expc1)
ENDIF
IF m.expn1<1.OR.m.expn2<1
  RETURN m.expc1
ENDIF
m.i=0
m.j=0
m.at_pos2=1
DO WHILE .T.
  m.at_pos=ATC(m.expc2,SUBSTR(m.expr,m.at_pos2))
  IF m.at_pos=0
    EXIT
  ENDIF
  m.i=m.i+1
  IF m.i<m.expn1
    m.at_pos2=m.at_pos+m.at_pos2+LEN(m.expc2)-1
    LOOP
  ENDIF
  m.expr=LEFT(m.expr,m.at_pos+m.at_pos2-2)+m.expc3+;
         SUBSTR(m.expr,m.at_pos+m.at_pos2+LEN(m.expc2)-1)
  m.j=m.j+1
  IF m.j>=m.expn2
    EXIT
  ENDIF
  m.at_pos2=m.at_pos+m.at_pos2+LEN(m.expc3)-1
  IF m.at_pos2>LEN(m.expr)
    EXIT
  ENDIF
ENDDO
RETURN m.expr

* END strtranc



FUNCTION nobrackets
PARAMETER expc

IF .NOT.'['$m.expc.OR..NOT.']'$m.expc
  RETURN m.expc
ENDIF
RETURN STRTRAN(STRTRAN(m.expc,'[','('),']',')')

* END nobrackets



FUNCTION erasedbf
PARAMETERS dbf_name,dbf_alias
PRIVATE ferase

IF USED(m.dbf_alias)
  USE IN (m.dbf_alias)
ENDIF
m.dbf_name=trimext(m.dbf_name)
m.ferase=m.dbf_name+'.DBF'
IF FILE(m.ferase)
  ERASE (m.ferase)
ENDIF
m.ferase=m.dbf_name+'.FPT'
IF FILE(m.ferase)
  ERASE (m.ferase)
ENDIF
RETURN .T.

* END erasedbf



FUNCTION packscx
PRIVATE lastfilter,r

m.lastfilter=FILTER()
SET FILTER TO
GOTO m.r_scxdata
SCAN REST FOR OBJTYPE#1.AND.DELETED()
  m.r=RECNO()
  SCAN REST FOR .NOT.DELETED().AND.(VPOS<0.OR.HEIGHT<0.OR.;
                HEIGHT>=256)
    IF VPOS<0
      REPLACE HPOS WITH HPOS-1
    ENDIF
    IF HEIGHT<0.OR.HEIGHT>=256
      REPLACE WIDTH WITH WIDTH-1
    ENDIF
  ENDSCAN
  GOTO m.r
ENDSCAN
PACK
IF EMPTY(m.lastfilter)
  SET FILTER TO
ELSE
  SET FILTER TO &lastfilter
ENDIF
LOCATE
RETURN .T.

* END packscx



FUNCTION configfp
PARAMETERS find_opt,find_dflt,occurrence
PRIVATE cnfg_opt,config_str,memline,at_pos,at_pos2,i

IF TYPE('m.find_dflt')#'C'
  m.find_dflt=''
ENDIF
IF EMPTY(m.find_opt).OR.EMPTY(m.fconfigfp)
  RETURN UPPER(ALLTRIM(m.find_dflt))
ENDIF
m.config_str=CONFIGFP.FP
m.find_opt=UPPER(m.find_opt)
m.cnfg_opt=m.find_dflt
IF TYPE('m.occurrence')#'N'
  m.occurrence=1
ENDIF
FOR m.i = m.occurrence TO 255
  m.at_pos=ATC(m.find_opt,m.config_str,m.i)
  IF m.at_pos=0
    EXIT
  ENDIF
  IF m.at_pos>1
    m.memline=SUBSTR(m.config_str,m.at_pos-1,1)
    IF .NOT.INLIST(m.memline,m.lf,m.cr,' ',CHR(9))
      EXIT
    ENDIF
  ENDIF
  m.memline=trimdelim(STRTRAN(STRTRAN(ALLTRIM(UPPER(SUBSTR(m.config_str,m.at_pos))),;
            CHR(9),' '),CHR(34),''))
  IF _MAC
    DO WHILE .T.
      m.at_pos2=AT(' =',m.memline)
      IF m.at_pos2=0
        EXIT
      ENDIF
      m.memline=STRTRAN(m.memline,' =','=')
    ENDDO
  ELSE
    m.memline=STRTRAN(STRTRAN(STRTRAN(STRTRAN(m.memline,CHR(39),''),;
              '[',''),']',''),' ','')
  ENDIF
  m.at_pos2=AT(m.cr,m.memline)
  IF m.at_pos2>0
    m.memline=LEFT(m.memline,m.at_pos2-1)
  ENDIF
  m.at_pos=AT('=',m.memline)
  IF m.at_pos=(LEN(m.find_opt)+1)
    m.cnfg_opt=SUBSTR(m.memline,m.at_pos+1)
    EXIT
  ENDIF
ENDFOR
RETURN UPPER(ALLTRIM(m.cnfg_opt))

* END configfp



FUNCTION trimdelim
PARAMETERS str_data,i

m.str_data=ALLTRIM(m.str_data)
m.i=LEN(m.str_data)-2
IF LEFT(m.str_data,1)=='"'.AND.RIGHT(m.str_data,1)=='"'
  RETURN SUBSTR(m.str_data,2,m.i)
ENDIF
IF LEFT(m.str_data,1)=="'".AND.RIGHT(m.str_data,1)=="'"
  RETURN SUBSTR(m.str_data,2,m.i)
ENDIF
IF LEFT(m.str_data,1)=='['.AND.RIGHT(m.str_data,1)==']'
  RETURN SUBSTR(m.str_data,2,m.i)
ENDIF
RETURN m.str_data

* END trimdelim



FUNCTION trimext
PARAMETERS filename,plattype
PRIVATE at_pos,at_pos2

m.at_pos=RAT('.',m.filename)
IF m.at_pos>0
  m.at_pos2=MAX(RAT('T',m.filename),RAT(':',m.filename))
  IF m.at_pos>m.at_pos2
    m.filename=LEFT(m.filename,m.at_pos-1)
  ENDIF
ENDIF
IF m.plattype
  m.filename=IIF(_DOS.OR._UNIX,UPPER(m.filename),LOWER(m.filename))
ENDIF
RETURN ALLTRIM(m.filename)

* END trimext



FUNCTION trimpath
PARAMETERS filename,trim_ext,plattype
PRIVATE at_pos

IF EMPTY(m.filename)
  RETURN ''
ENDIF
m.at_pos=AT(':',m.filename)
IF m.at_pos>0
  m.filename=SUBSTR(m.filename,m.at_pos+1)
ENDIF
IF m.trim_ext
  m.filename=trimext(m.filename)
ENDIF
IF m.plattype
  m.filename=IIF(_DOS.OR._UNIX,UPPER(m.filename),LOWER(m.filename))
ENDIF
m.filename=ALLTRIM(SUBSTR(m.filename,AT('\',m.filename,;
           MAX(OCCURS('\',m.filename),1))+1))
DO WHILE LEFT(m.filename,1)=='.'
  m.filename=ALLTRIM(SUBSTR(m.filename,2))
ENDDO
DO WHILE RIGHT(m.filename,1)=='.'
  m.filename=ALLTRIM(LEFT(m.filename,LEN(m.filename)-1))
ENDDO
RETURN m.filename

* END trimpath



FUNCTION trimfile
PARAMETERS filename,plattype
PRIVATE at_pos

m.at_pos=RAT('\',m.filename)
m.filename=ALLTRIM(IIF(m.at_pos=0,m.filename,LEFT(m.filename,m.at_pos)))
IF m.plattype
  m.filename=IIF(_DOS.OR._UNIX,UPPER(m.filename),LOWER(m.filename))
ENDIF
RETURN m.filename

* END trimfile



FUNCTION casefile
PARAMETERS filename

RETURN IIF(_DOS.OR._UNIX,UPPER(m.filename),LOWER(m.filename))

* END casefile



FUNCTION uniqueflnm
PRIVATE filename

DO WHILE .T.
  m.filename='_'+ALLTRIM(SUBSTR(SYS(3),2,7))
  IF .NOT.FILE(m.filename+'.DBF')
    EXIT
  ENDIF
ENDDO
RETURN m.filename

* END uniqueflnm



FUNCTION add_fext
PARAMETERS filename
PRIVATE i

IF EMPTY(m.filename).OR.'.'$m.filename
  m.filename=IIF(_WINDOWS.OR._MAC,LOWER(m.filename),UPPER(m.filename))
  RETURN m.filename
ENDIF
FOR m.i = 1 TO ALEN(a_file_ext)
  IF FILE(m.filename+a_file_ext(m.i))
    m.filename=m.filename+a_file_ext(m.i)
    m.filename=IIF(_WINDOWS.OR._MAC,LOWER(m.filename),UPPER(m.filename))
    RETURN m.filename
  ENDIF
ENDFOR
m.filename=m.filename+'.PRG'
m.filename=IIF(_WINDOWS.OR._MAC,LOWER(m.filename),UPPER(m.filename))
RETURN m.filename

* END add_fext



PROCEDURE delaybar
PARAMETERS msg1,msg2,percent,flag
PRIVATE center_row,col,delay_cols,delay_bar

DO CASE
  CASE .NOT.m.flag
    IF _WINDOWS.OR._MAC
      DO updthrm WITH (m.msg1),(m.msg2),(m.percent)
      RETURN
    ENDIF
    IF .NOT.WEXIST('_wdelaybar')
      RETURN
    ENDIF
    ACTIVATE WINDOW _wdelaybar
    IF .NOT.EMPTY(m.msg1)
      @ 0,3 SAY PADR(m.msg1,50)
    ENDIF
    IF .NOT.EMPTY(m.msg2)
      @ 1,3 SAY PADR(m.msg2,50)
    ENDIF
    m.delay_cols=INT(MIN(m.percent,100)/2)
    IF m.percent>0
      m.delay_bar=REPLICATE('',m.delay_cols)
      IF MOD(ROUND(MIN(m.percent,100)-.5,0),2)=1
        m.delay_bar=m.delay_bar+''
      ENDIF
      @ 3,3 SAY m.delay_bar
      IF LEN(m.delay_bar)<50
        ?? SPACE(50-LEN(m.delay_bar))
      ENDIF
    ENDIF
    RETURN
  CASE .NOT.EMPTY(m.msg1)
    IF _WINDOWS.OR._MAC
      DO actthrm WITH (m.msg1),(m.msg2)
      RETURN
    ENDIF
    m.center_row=INT(SROWS()/2)
    m.col=INT((SCOLS()-58)/2)
    DEFINE WINDOW _wdelaybar FROM m.center_row-3,m.col;
                             TO m.center_row+3,m.col+57;
                  DOUBLE COLOR SCHEME 5
    ACTIVATE WINDOW _wdelaybar
    @ 0,3 SAY PADR(m.msg1,50)
    @ 1,3 SAY PADR(m.msg2,50)
    @ 2,1 TO 4,54
    @ 3,3 SAY SPACE(50) COLOR SCHEME 5
    RETURN
  OTHERWISE
    IF _WINDOWS.OR._MAC
      DO deactthrmo
      RETURN
    ENDIF
    RELEASE WINDOW _wdelaybar
    RETURN
ENDCASE
RETURN

* END delaybar



PROCEDURE actthrm
PARAMETER text,prompt
PRIVATE rgb_color,maxcols,clauses_

m.rgb_color='RGB(0, 0, 0, 192, 192, 192)'
clauses_="SIZE 5.615,63.833 FONT '"+m.c_dlgface+"',"+STR(m.c_dlgsize,10,5)+;
         " STYLE '"+m.c_dlgstyle+"'"
DEFINE WINDOW thrmomete;
      AT INT((SROW() - (( 5.615 *;
      FONTMETRIC(1, m.c_dlgface, m.c_dlgsize, m.c_dlgstyle )) /;
      FONTMETRIC(1, WFONT(1,""), WFONT( 2,""), WFONT(3,"")))) / 2),;
      INT((SCOL() - (( 63.833 *;
      FONTMETRIC(6, m.c_dlgface, m.c_dlgsize, m.c_dlgstyle )) /;
      FONTMETRIC(6, WFONT(1,""), WFONT( 2,""), WFONT(3,"")))) / 2);
      &clauses_;
      NOFLOAT;
      NOCLOSE;
      NONE;
      COLOR (m.rgb_color)
m.maxcols=WCOLS()-4
clauses_='CENTER'
MOVE WINDOW thrmomete &clauses_
ACTIVATE WINDOW thrmomete NOSHOW
clauses_="FONT '"+m.c_dlgface+"',"+STR(m.c_dlgsize,10,5)+;
         " STYLE '"+m.c_dlgstyle+"'"
DO WHILE (TXTWIDTH(m.text)+3)>m.maxcols
  m.text=LEFT(m.text,LEN(m.text)-2)
ENDDO
DO WHILE (TXTWIDTH(m.prompt)+3)>m.maxcols
  m.prompt=LEFT(m.prompt,LEN(m.prompt)-2)
ENDDO
@ 0.5,3 SAY m.text &clauses_
@ 0.5,TXTWIDTH(m.text)+3 CLEAR TO 1.5,m.maxcols
@ 1.5,3 SAY m.prompt &clauses_
@ 1.5,TXTWIDTH(m.prompt)+3 CLEAR TO 2.5,m.maxcols
m.rgb_color='RGB(255, 255, 255, 255, 255, 255)'
@ 0.000,0.000 TO 0.000,63.833;
                 COLOR (m.rgb_color)
m.rgb_color='RGB(255, 255, 255, 255, 255, 255)'
@ 0.000,0.000 TO 5.615,0.000;
                 COLOR (m.rgb_color)
m.rgb_color='RGB(128, 128, 128, 128, 128, 128)'
@ 0.385,0.667 TO 5.231,0.667;
                 COLOR (m.rgb_color)
m.rgb_color='RGB(128, 128, 128, 128, 128, 128)'
@ 0.308,0.667 TO 0.308,63.167;
                 COLOR (m.rgb_color)
m.rgb_color='RGB(255, 255, 255, 255, 255, 255)'
@ 0.385,63.000 TO 5.308,63.000;
                 COLOR (m.rgb_color)
m.rgb_color='RGB(255, 255, 255, 255, 255, 255)'
@ 5.231,0.667 TO 5.231,63.167;
                 COLOR (m.rgb_color)
m.rgb_color='RGB(128, 128, 128, 128, 128, 128)'
@ 5.538,0.000 TO 5.538,63.833;
                 COLOR (m.rgb_color)
m.rgb_color='RGB(128, 128, 128, 128, 128, 128)'
@ 0.000,63.667 TO 5.615,63.667;
                 COLOR (m.rgb_color)
m.rgb_color='RGB(128, 128, 128, 128, 128, 128)'
@ 3.000,3.333 TO 4.231,3.333;
                 COLOR (m.rgb_color)
m.rgb_color='RGB(255, 255, 255, 255, 255, 255)'
@ 3.000,60.333 TO 4.308,60.333;
                 COLOR (m.rgb_color)
m.rgb_color='RGB(128, 128, 128, 128, 128, 128)'
@ 3.000,3.333 TO 3.000,60.333;
                 COLOR (m.rgb_color)
m.rgb_color='RGB(255, 255, 255, 255, 255, 255)'
@ 4.231,3.333 TO 4.231,60.500;
                 COLOR (m.rgb_color)
SHOW WINDOW thrmomete TOP
RETURN

* END actthrm



PROCEDURE updthrm
PARAMETER text,prompt,percent
PRIVATE nblocks,percent,rgb_color,maxcols,clauses_

ACTIVATE WINDOW thrmomete
m.maxcols=WCOLS()-4
clauses_="FONT '"+m.c_dlgface+"',"+STR(m.c_dlgsize,10,5)+;
         " STYLE '"+m.c_dlgstyle+"'"
DO WHILE (TXTWIDTH(m.text)+3)>m.maxcols
  m.text=LEFT(m.text,LEN(m.text)-2)
ENDDO
DO WHILE (TXTWIDTH(m.prompt)+3)>m.maxcols
  m.prompt=LEFT(m.prompt,LEN(m.prompt)-2)
ENDDO
IF .NOT.EMPTY(m.text)
  @ 0.5,3 SAY m.text &clauses_
  @ 0.5,TXTWIDTH(m.text)+3 CLEAR TO 1.5,m.maxcols
ENDIF
IF .NOT.EMPTY(m.prompt)
  @ 1.5,3 SAY m.prompt &clauses_
  @ 1.5,TXTWIDTH(m.prompt)+3 CLEAR TO 2.5,m.maxcols
ENDIF
m.percent=MIN(m.percent,100)
m.nblocks=(m.percent/100) * 56.269
clauses_='PATTERN 1'
m.rgb_color='RGB(128, 128, 128, 128, 128, 128)'
@ 3.000,3.333 TO 4.231,m.nblocks + 3.333 &clauses_;
                 COLOR (m.rgb_color)
IF m.percent<100
  @ 3.100,m.nblocks + 3.333 CLEAR TO 4.231,59.602
ENDIF
RETURN

* END updthrm



PROCEDURE deactthrmo

IF WEXIST("thrmomete")
  RELEASE WINDOW thrmomete
ENDIF
RETURN

* END deactthrmo



FUNCTION dispmsg
PARAMETERS msg

WAIT CLEAR
IF EMPTY(m.msg)
  RETURN .F.
ENDIF
WAIT m.msg WINDOW NOWAIT
RETURN .T.

* END dispmsg



FUNCTION warning
PARAMETERS cmnd_str,operand

m.warnings=m.warnings+1
IF TYPE('m.cmnd_str')#'C'
  RETURN m.warnings
ENDIF
IF TYPE('m.operand')=='C'
  m.operand=STRTRAN(m.operand,' ','')
  IF LEFT(m.operand,1)=='.'
    m.operand=SUBSTR(m.operand,2)
  ENDIF
  m.cmnd_str=m.cmnd_str+" '"+m.operand+"' not found"
ENDIF
IF TYPE('m.fscxbase')=='C'.AND..NOT.EMPTY(m.fscxbase)
  m.cmnd_str=m.cmnd_str+'  ['+trimpath(m.fscxbase)+']'
ENDIF
WAIT CLEAR
IF TYPE('m.autohalt')=='C'.AND.m.autohalt=='OFF'
  WAIT LEFT(m.cmnd_str,254) WINDOW NOWAIT
  RETURN m.warnings
ENDIF
IF _FOX26.OR..NOT.EMPTY(_FOX25REV)
  m.cmnd_str='GENSCRNX Warning Mode - {C}ancel  {S}uspend  {I}gnore'+CHR(13)+;
             CHR(13)+m.cmnd_str
ENDIF
CLEAR TYPEAHEAD
WAIT LEFT(m.cmnd_str,254) WINDOW
DO CASE
  CASE MDOWN()
    =.F.
  CASE UPPER(CHR(LASTKEY()))=='I'
    RETURN m.warnings
  CASE UPPER(CHR(LASTKEY()))=='S'
    m.lasterror=ON('ERROR')
    ON ERROR
    WAIT CLEAR
    CLEAR TYPEAHEAD
    m.lastcursr=SET('CURSOR')
    ACTIVATE WINDOW Command
    SET ESCAPE ON
    SUSPEND
    SET ESCAPE OFF
    SET CURSOR &lastcursr
    ON ERROR &lasterror
    RETURN m.warnings
ENDCASE
m.autorun='OFF'
DO cleanup
CANCEL

* END warning



PROCEDURE errorhnd
PARAMETER error_no,msg,prg_name,line_no,codeline
PRIVATE colright,row,col,lasterror,lastcursr,prompt,maxcols
PRIVATE prg_name2,prg_name3,prg_nameno,prg_flag

m.lasterror=ON('ERROR')
ON ERROR
SET ESCAPE OFF
WAIT CLEAR
CLEAR GETS
CLEAR TYPEAHEAD
m.lastcursr=SET('CURSOR')
SET CURSOR OFF
m.prg_flag=.F.
m.prg_name2=m.prg_name
FOR m.prg_nameno = 32 TO 1 STEP -1
  m.prg_name3=PROGRAM(m.prg_nameno)
  IF EMPTY(m.prg_name3)
    LOOP
  ENDIF
  IF m.prg_name3=m.prg_name
    m.prg_flag=.T.
    LOOP
  ENDIF
  IF m.prg_flag
    m.prg_name2=m.prg_name2+', '+m.prg_name3
  ENDIF
ENDFOR
m.row=IIF(_DOS.OR._UNIX,INT((SROWS()-20)/2),0)
m.col=IIF(_DOS.OR._UNIX,INT((SCOLS()-69)/2),0)
DEFINE WINDOW win_prompt FROM m.row,m.col;
                         TO m.row+20,m.col+69;
              TITLE ' GENSCRNX Error Mode ';
              DOUBLE FLOAT SHADOW COLOR SCHEME 7
ACTIVATE WINDOW win_prompt
m.maxcols=WCOLS()-2
m.colright=WCOLS()-19
IF LEN(m.prg_name2)>(m.colright-12)
  m.prg_name2=LEFT(LEFT(m.prg_name2,m.colright-12),RAT(',',m.prg_name2)-1)
ENDIF
m.codeline=ALLTRIM(m.codeline)
m.colorschm=IIF(_WINDOWS.OR._MAC,2,1)
@ 1,1 EDIT m.codeline;
      SIZE 8,m.maxcols;
      NOMODIFY SCROLL;
      COLOR SCHEME (m.colorschm)
@ 9,1 TO 9,m.maxcols
@ 10,1 SAY 'Error message :  '
?? PADR(ALLTRIM(m.msg),m.colright)
@ 11,1 SAY 'Error number  :  '
?? LTRIM(STR(m.error_no))
@ 12,1 SAY 'Procedure name:  '
?? PADR(ALLTRIM(m.prg_name2),m.colright)
@ 13,1 SAY 'Line number   :  '
?? IIF(m.line_no>0,LTRIM(STR(m.line_no)),'Unknown')
IF .NOT.EMPTY(ALIAS())
  @ 14,1 SAY 'Data source   :  '
  ?? PADR(m.fscxbase+'  [SCXBASE]',m.colright)
  @ 15,1 SAY 'Data current  :  '
  ?? PADR(ALLTRIM(DBF())+'  ['+ALIAS()+']',m.colright)
  @ 16,1 SAY 'Record number :  '
  ?? LTRIM(STR(RECNO()))
ENDIF
@ 17,1 TO 17,m.maxcols
@ 18,9 GET m.prompt ;
       PICTURE "@*HT \!\<Cancel;\<Suspend;\<Ignore" ;
       SIZE 1,11,8 ;
       DEFAULT 1
SET CURSOR ON
READ CYCLE MODAL OBJECT 2
DO CASE
  CASE m.prompt=2
    @ 18,0 CLEAR
    ACTIVATE SCREEN
    ACTIVATE WINDOW Command
    SET ESCAPE ON
    SUSPEND
    SET ESCAPE OFF
    RELEASE WINDOW win_prompt
    SET CURSOR &lastcursr
    ON ERROR &lasterror
    RETURN
  CASE m.prompt=3
    RELEASE WINDOW win_prompt
    SET CURSOR &lastcursr
    ON ERROR &lasterror
    RETURN
ENDCASE
RELEASE WINDOW win_prompt
m.gen_mode=.F.
DO cleanup
CANCEL

* END errorhnd



PROCEDURE esc_check
PRIVATE i

IF CHRSAW()
  m.i=INKEY('H')
  IF m.i=27
    DO cleanup
    CANCEL
  ENDIF
ENDIF
RETURN

* END esc_check



PROCEDURE cleanup
PARAMETERS sprcheck
PRIVATE range1,range2,wchilds,winontop1,winontop2,lastslct

m.lastslct=SELECT()
RELEASE WINDOWS _wdelaybar,thrmomete
IF USED('_TEMPFILE')
  USE IN _TEMPFILE
ENDIF
IF USED('CONFIGFP')
  USE IN CONFIGFP
ENDIF
IF USED('FOXSCX')
  USE IN FOXSCX
ENDIF
IF USED('SCXINSERT')
  USE IN SCXINSERT
ENDIF
IF USED('SCXBASE')
  SELECT SCXBASE
  SCATTER MEMVAR MEMO BLANK
  USE IN SCXBASE
ENDIF
IF USED('SCXDATA')
  USE IN SCXDATA
ENDIF
IF USED('SCXDATA2')
  USE IN SCXDATA2
ENDIF
IF USED('PJXBASE')
  USE IN PJXBASE
ENDIF
IF USED('PJXDATA')
  USE IN PJXDATA
ENDIF
IF USED('INSERTFILE')
  USE IN INSERTFILE
ENDIF
IF TYPE('m.fscxdata')#'C'
  IF USED('SPRDATA')
    USE IN SPRDATA
  ENDIF
  ON ERROR
  ACTIVATE SCREEN
  IF _WINDOWS.OR._MAC
    SET MESSAGE TO
  ENDIF
  SET COMPATIBLE OFF
  SET EXACT OFF
  SET SAFETY OFF
  SET EXCLUSIVE ON
  SET UDFPARMS TO VALUE
  SET CURSOR ON
  SET MEMOWIDTH TO 50
  SET ESCAPE ON
  WAIT CLEAR
  CLEAR TYPEAHEAD
  CANCEL
ENDIF
=erasedbf(m.projdbf,'PJXDATA')
IF TYPE('m.scxcount')=='N'.AND.m.scxcount>0
  FOR m.i = 1 TO m.scxcount
    IF TYPE('a_fscxdata(m.i)')=='C'
      m.fscxdata=a_fscxdata(m.i)
    ENDIF
    =erasedbf(m.fscxdata,'SCXDATA')
  ENDFOR
ENDIF
m.range1=0
m.range2=0
IF gen_mode.AND.m.sprcheck.AND..NOT.m.fromproj.AND.;
   m.compspr=='ON'.AND.FILE(m.fsprout)
  IF _WINDOWS.OR._MAC
    SET MESSAGE TO LEFT('Compiling Screen Code: '+LOWER(m.fsprout),79)
  ENDIF
  IF errcheck()
    m.i=SROWS()-25-IIF(_WINDOWS.OR._MAC.AND.SET('STATUS BAR')=='ON',1,0)
    DEFINE WINDOW _weditfile FROM 17+m.i,0 TO 24+m.i,SCOLS()-1;
                  SYSTEM CLOSE FLOAT GROW MINIMIZE SHADOW ZOOM;
                  COLOR SCHEME 8
    MODIFY FILE (m.fsprerr) NOWAIT;
                RANGE 1,1 WINDOW _weditfile
    ZOOM WINDOW _weditfile NORM FROM 1+m.i,0 TO 15+m.i,SCOLS()-1
    MODIFY FILE (m.fsprout) NOWAIT;
                RANGE m.range1,m.range2 WINDOW _weditfile
    RELEASE WINDOW _weditfile
  ENDIF
  IF _WINDOWS.OR._MAC
    SET MESSAGE TO
  ENDIF
ENDIF
IF USED('SPRDATA')
  USE IN SPRDATA
ENDIF
SELECT (m.lastslct)
WAIT CLEAR
IF m.warnings>0
  WAIT ALLTRIM(STR(m.warnings,8))+' warning'+IIF(m.warnings>1,'s','');
       WINDOW NOWAIT
ENDIF
DO restoreset
CLEAR TYPEAHEAD
IF .NOT.gen_mode.OR.m.fromproj
  RETURN
ENDIF
m.wchilds=WCHILD()-IIF(m.range1=0,0,2)
IF m.wchilds<=1
  IF m.range1=0.AND.m.autorun=='ON'.AND.FILE(m.fsprout)
    =autorunkeys()
  ENDIF
  RETURN
ENDIF
m.winontop1=''
FOR m.i = 1 TO m.wchilds
  m.winontop2=m.winontop1
  m.winontop1=WCHILD(m.i-1)
ENDFOR
IF ATC('.PRO',m.winontop2)=0.OR.;
   .NOT.UPPER(trimext(m.winontop1))==UPPER(trimext(m.winontop2))
  IF m.range1=0.AND.m.autorun=='ON'.AND.FILE(m.fsprout)
    =autorunkeys()
  ENDIF
  RETURN
ENDIF
IF m.range1=0
  KEYBOARD '{Ctrl+W}' PLAIN
  IF m.autorun=='ON'.AND.FILE(m.fsprout)
    =autorunkeys()
  ENDIF
ELSE
  KEYBOARD '{Ctrl+F1}{Ctrl+F1}{Ctrl+W}' PLAIN
  FOR m.i = 1 TO m.wchilds-1
    KEYBOARD '{Ctrl+F1}' PLAIN
  ENDFOR
ENDIF
RETURN

* END cleanup



FUNCTION autorunkeys

IF .NOT.m.autorunsave
  KEYBOARD '{Ctrl+W}'
ENDIF
KEYBOARD '{Ctrl+F2}DO '+UPPER(m.fsprout)+CHR(13)
RETURN .T.

* END autorunkeys



FUNCTION errcheck
PRIVATE memline,find_str,at_pos,i,j,len_adj,lastmemowd

COMPILE (m.fsprout)
IF .NOT.m.dispspr=='ON'.OR..NOT.FILE(m.fsprerr)
  RETURN .F.
ENDIF
m.lastmemowd=SET('MEMOWIDTH')
SET MEMOWIDTH TO 254
m.find_str=''
m.range1=1
m.range2=1
IF .NOT.USED('SPRDATA')
  CREATE CURSOR SPRDATA (SPR M, INS M)
  INSERT BLANK
  APPEND MEMO SPR FROM (m.fsprout) OVERWRITE
ENDIF
SELECT SPRDATA
m.len_adj=LEN(SPR)
REPLACE SPR WITH STRTRAN(SPR,m.lf+';',';')+m.cr_lf
m.len_adj=m.len_adj-LEN(SPR)+2
APPEND MEMO INS FROM (m.fsprerr) OVERWRITE
m.at_pos=ATC('Error in line ',INS)
IF m.at_pos>0
  m.i=VAL(SUBSTR(INS,m.at_pos+14))
  m.find_str=MLINE(SPR,m.i)
  IF .NOT.m.find_str$MLINE(INS,1)
    m.find_str=MLINE(INS,1)
  ENDIF
  FOR m.j = (m.i-1) TO 1 STEP -1
    m.memline=MLINE(SPR,m.j)
    IF .NOT.RIGHT(m.memline,1)==';'
      EXIT
    ENDIF
    m.find_str=m.memline+m.cr_lf+m.find_str
  ENDFOR
  FOR m.j = m.i TO (MEMLINES(SPR)-1)
    m.memline=MLINE(SPR,m.j)
    IF .NOT.RIGHT(m.memline,1)==';'
      EXIT
    ENDIF
    m.find_str=m.find_str+m.cr_lf+m.memline
  ENDFOR
  IF .NOT.EMPTY(m.find_str)
    IF m.i=1
      m.at_pos=0
    ELSE
      m.at_pos=AT(m.lf+m.find_str+m.cr,SPR)
      IF m.at_pos=-1
        m.at_pos=AT(m.cr+m.find_str+m.cr,SPR)
      ENDIF
    ENDIF
    IF m.at_pos>0.OR.m.i=1
      m.range1=m.at_pos+1
      m.range2=m.at_pos+LEN(m.find_str)+m.len_adj+1
    ENDIF
  ENDIF
ENDIF
SET MEMOWIDTH TO (m.lastmemowd)
RETURN .T.

* END errcheck



PROCEDURE restoreset

m.drv_no=0
IF TYPE('m.lastselect')=='N'
  SELECT (m.lastselect)
ENDIF
SET MEMOWIDTH TO (m.lastmemow)
_MLINE=0
ACTIVATE SCREEN
@ 0,0 SAY ''
IF EMPTY(m.lastpoint)
  SET POINT TO
ELSE
  SET POINT TO (m.lastpoint)
ENDIF
IF m.lastsetudfp=='VALUE'
  SET UDFPARMS TO VALUE
ELSE
  SET UDFPARMS TO REFERENCE
ENDIF
IF m.lastsetexac=='ON'
  SET EXACT ON
ELSE
  SET EXACT OFF
ENDIF
IF m.lastsetexcl=='ON'
  SET EXCLUSIVE ON
ELSE
  SET EXCLUSIVE OFF
ENDIF
IF EMPTY(m.lastsetpath)
  SET PATH TO
ELSE
  SET PATH TO (m.lastsetpath)
ENDIF
SET DECIMALS TO (m.lastsetdec)
IF m.lastsetnear=='ON'
  SET NEAR ON
ELSE
  SET NEAR OFF
ENDIF
IF m.lastsetcry=='ON'
  SET CARRY ON
ELSE
  SET CARRY OFF
ENDIF
IF m.lastsetdel=='ON'
  SET DELETED ON
ELSE
  SET DELETED OFF
ENDIF
IF m.lastsetsfty=='ON'
  SET SAFETY ON
ELSE
  SET SAFETY OFF
ENDIF
IF m.lastsetcomp=='ON'
  SET COMPATIBLE ON
ELSE
  SET COMPATIBLE OFF
ENDIF
ON ERROR
IF _WINDOWS.OR._MAC
  SET MESSAGE TO
ENDIF
SET CURSOR ON
SET ESCAPE ON
RETURN

* END restoreset



PROCEDURE restoreenv

SET COMPATIBLE OFF
SET EXACT OFF
SET PATH TO (m.newsetpath)
SET SAFETY OFF
SET EXCLUSIVE ON
SET UDFPARMS TO VALUE
SET CURSOR OFF
SET MEMOWIDTH TO 254
SET POINT TO '.'
RETURN

* END restoreenv



FUNCTION evltxt
PARAMETERS old_text
PRIVATE new_text,eval_str,eval_str1,eval_str2,var_type
PRIVATE at_pos,at_pos2,at_pos3,at_pos4,at_pos5,old_str,new_str
PRIVATE i,j,at_line,onerror,cr_lf,evlmode,mthd_str,sellast

IF TYPE('m.ignrbraces')=='L'.AND.m.ignrbraces
  RETURN m.old_text
ENDIF
m.cr_lf=CHR(13)+CHR(10)
m.onerror=ON('ERROR')
m.new_text=m.old_text
m.at_pos3=1
DO WHILE .T.
  m.at_pos=AT('{{',SUBSTR(m.old_text,m.at_pos3))
  IF m.at_pos=0
    EXIT
  ENDIF
  m.at_pos2=AT('}}',SUBSTR(m.old_text,m.at_pos+m.at_pos3-1))
  IF m.at_pos2=0
    EXIT
  ENDIF
  m.at_pos4=AT('{{',SUBSTR(m.old_text,m.at_pos+m.at_pos3+1))
  IF m.at_pos4>0.AND.m.at_pos4<m.at_pos2
    m.at_pos4=OCCURS('{{',SUBSTR(m.old_text,m.at_pos+m.at_pos3-1,;
              m.at_pos2-m.at_pos4))
    m.at_pos4=AT('{{',SUBSTR(m.old_text,m.at_pos+m.at_pos3-1),m.at_pos4)
    m.old_str=SUBSTR(m.old_text,m.at_pos+m.at_pos3-1,m.at_pos2+1)
    m.eval_str=SUBSTR(m.old_str,3,LEN(m.old_str)-2)
    m.old_str=evltxt(m.eval_str)
    m.old_text=STRTRAN(m.old_text,m.eval_str,m.old_str)
    m.new_text=STRTRAN(m.new_text,m.eval_str,m.old_str)
    LOOP
  ENDIF
  m.old_str=SUBSTR(m.old_text,m.at_pos+m.at_pos3-1,m.at_pos2+1)
  m.eval_str=ALLTRIM(SUBSTR(m.old_str,3,LEN(m.old_str)-4))
  DO esc_check
  m.evlmode=.F.
  ON ERROR DO errorhnd WITH ERROR(),MESSAGE(),PROGRAM(),LINENO(),;
                            m.old_str+m.cr_lf+''+;
                            ''+;
                            m.cr_lf+MESSAGE(1)
  DO CASE
    CASE EMPTY(m.eval_str).OR.(TYPE('m.braces')=='C'.AND.m.braces=='OFF')
      m.eval_str=''
    CASE LEFT(m.eval_str,2)=='&.'
      m.eval_str=SUBSTR(m.eval_str,3)
      &eval_str &&;
      ;
      Error occured during macro substitution of {{&. <expC> }}.
      m.eval_str=''
    CASE LEFT(m.eval_str,1)=='<'
      m.eval_str=insert(SUBSTR(m.eval_str,2)) &&;
      ;
      Error occured during evaluation of {{< <file> }}.
    CASE LEFT(m.eval_str,1)=='@'
      m.eval_str=wordsearch(SUBSTR(MLINE(m.eval_str,1),2))
      IF m.eval_str==m.null
        m.eval_str=''
      ENDIF
    CASE '::'$m.eval_str
      m.eval_str1=''
      m.eval_str2=''
      m.at_pos4=AT('||',m.eval_str)
      IF m.at_pos4>0
        m.eval_str2=IIF(m.at_pos4>0,SUBSTR(m.eval_str,m.at_pos4+2),'')
        m.eval_str=LEFT(m.eval_str,m.at_pos4-1)
      ENDIF
      FOR m.i = 1 TO 2
        m.at_pos4=AT('::',m.eval_str)
        m.evlmode=.T.
        m.eval_str=objdata(LEFT(m.eval_str,m.at_pos4-1),;
                   SUBSTR(m.eval_str,m.at_pos4+2)) &&;
        ;
        Error occured during evaluation of {{ <expC1> :: <expC2> }}.
        IF m.i=1.AND..NOT.EMPTY(m.eval_str2)
          m.eval_str1=m.eval_str
          m.eval_str=m.eval_str2
          LOOP
        ENDIF
        m.evlmode=.F.
        IF m.i=2
          m.eval_str2=m.eval_str
          IF EMPTY(m.eval_str2)
            m.eval_str=m.eval_str1
            EXIT
          ENDIF
          IF EMPTY(m.eval_str1)
            m.eval_str=m.eval_str2
            EXIT
          ENDIF
          m.sellast=SELECT()
          IF .NOT.USED('_TEMPFILE')
            CREATE CURSOR _TEMPFILE (COMMENT M, SETUPCODE M)
            INSERT BLANK
          ENDIF
          SELECT _TEMPFILE
          LOCATE
          REPLACE COMMENT WITH m.eval_str2, SETUPCODE WITH m.eval_str1
          m.eval_str1=''
          m.eval_str2=''
          DO WHILE .T.
            =esc_check()
            m.mthd_str=wordsearch(m.c_method)
            IF m.mthd_str==m.null
              m.eval_str=COMMENT+m.cr_lf+SETUPCODE
              EXIT
            ENDIF
            IF EMPTY(m.mthd_str)
              REPLACE COMMENT WITH strtranc(m.c_method,m.m_method,1,1)
              LOOP
            ENDIF
            m.at_pos4=ATC(m.c_method+' '+m.mthd_str+m.cr,COMMENT+m.cr)
            IF m.at_pos4=0
              REPLACE COMMENT WITH strtranc(m.c_method,m.m_method,1,1)
              LOOP
            ENDIF
            m.at_pos5=ATC(m.c_endmthd,SUBSTR(COMMENT,m.at_pos4))
            IF m.at_pos5>0
              m.at_pos5=m.at_pos5+LEN(m.c_endmthd)
            ELSE
              m.at_pos5=LEN(COMMENT)+1
            ENDIF
            m.eval_str1=SUBSTR(COMMENT,m.at_pos4,m.at_pos5)+m.cr_lf
            REPLACE COMMENT WITH LEFT(COMMENT,m.at_pos4-1)+;
                                 SUBSTR(COMMENT,m.at_pos4+m.at_pos5)
            m.at_pos4=ATC(m.c_method+' '+m.mthd_str+m.cr,SETUPCODE+m.cr)
            IF m.at_pos4=0
              LOOP
            ENDIF
            m.at_pos5=ATC(m.c_endmthd,SUBSTR(SETUPCODE,m.at_pos4))
            IF m.at_pos5>0
              m.at_pos5=m.at_pos5+LEN(m.c_endmthd)
            ELSE
              m.at_pos5=LEN(SETUPCODE)+1
            ENDIF
            REPLACE SETUPCODE WITH LEFT(SETUPCODE,m.at_pos4-1)+m.eval_str1+;
                                   SUBSTR(SETUPCODE,m.at_pos4+m.at_pos5)
          ENDDO
          m.eval_str=SETUPCODE
          SELECT (m.sellast)
        ENDIF
        EXIT
      ENDFOR
      m.eval_str1=''
      m.eval_str2=''
    OTHERWISE
      m.eval_str=EVALUATE(m.eval_str) &&;
      ;
      Error occured during evaluation of {{ <expC> }}.
  ENDCASE
  IF EMPTY(m.onerror)
    ON ERROR
  ELSE
    ON ERROR &onerror
  ENDIF
  m.var_type=TYPE('m.eval_str')
  DO CASE
    CASE m.var_type=='C'
      m.new_str=m.eval_str
    CASE m.var_type=='N'
      m.new_str=ALLTRIM(STR(m.eval_str,24,12))
      DO WHILE RIGHT(m.new_str,1)=='0'
        m.new_str=LEFT(m.new_str,LEN(m.new_str)-1)
        IF RIGHT(m.new_str,1)=='.'
          m.new_str=LEFT(m.new_str,LEN(m.new_str)-1)
          EXIT
        ENDIF
      ENDDO
    CASE m.var_type=='D'
      m.new_str=DTOC(m.eval_str)
    CASE m.var_type=='L'
      m.new_str=IIF(m.eval_str,'.T.','.F.')
    OTHERWISE
      m.new_str=m.old_str
  ENDCASE
  m.new_text=STRTRAN(m.new_text,m.old_str,m.new_str)
  m.at_pos2=m.at_pos+LEN(m.new_str)
  IF m.at_pos2<=0
    EXIT
  ENDIF
  m.at_pos3=m.at_pos3+m.at_pos2
ENDDO
m.j=0
DO WHILE '{{'$m.new_text.AND.'}}'$m.new_text
  =esc_check()
  m.i=LEN(m.new_text)
  m.new_text=evltxt(m.new_text)
  IF m.i=LEN(m.new_text)
    IF m.j>=2
      EXIT
    ENDIF
    m.j=m.j+1
  ENDIF
ENDDO
RETURN m.new_text

* END evltxt



FUNCTION evlstr
PARAMETERS eval_str

IF EMPTY(m.eval_str)
  RETURN m.eval_str
ENDIF
IF .NOT.LEFT(m.eval_str,1)=='@'
  RETURN EVALUATE(m.eval_str)
ENDIF
m.eval_str=wordsearch(SUBSTR(m.eval_str,2))
IF m.eval_str==m.null
  m.eval_str=''
ENDIF
RETURN m.eval_str

* END evlstr



FUNCTION evlmsg
PARAMETERS old_str
PRIVATE new_text,eval_str,var_type

IF TYPE('m.old_str')#'C'
  RETURN ''
ENDIF
IF .NOT.LEFT(m.old_str,1)=='@'
  RETURN m.old_str
ENDIF
m.eval_str=EVALUATE(SUBSTR(MLINE(m.old_str,1),2))
m.var_type=TYPE('m.eval_str')
DO CASE
  CASE m.var_type=='C'
    m.new_str=m.eval_str
  CASE m.var_type=='N'
    m.new_str=ALLTRIM(STR(m.eval_str,24,12))
    DO WHILE RIGHT(m.new_str,1)=='0'
      m.new_str=LEFT(m.new_str,LEN(m.new_str)-1)
      IF RIGHT(m.new_str,1)=='.'
        m.new_str=LEFT(m.new_str,LEN(m.new_str)-1)
        EXIT
      ENDIF
    ENDDO
  CASE m.var_type=='D'
    m.new_str=DTOC(m.eval_str)
  CASE m.var_type=='L'
    m.new_str=IIF(m.eval_str,'.T.','.F.')
  OTHERWISE
    m.new_str=m.old_str
ENDCASE
RETURN m.new_str

* END evlmsg



FUNCTION strexpr
PARAMETERS eval_str
PRIVATE new_text,var_type

IF PARAMETERS()=0
  RETURN ''
ENDIF
m.var_type=TYPE('m.eval_str')
DO CASE
  CASE m.var_type=='C'
    m.new_str=m.eval_str
  CASE m.var_type=='N'
    m.new_str=ALLTRIM(STR(m.eval_str,24,12))
    DO WHILE RIGHT(m.new_str,1)=='0'
      m.new_str=LEFT(m.new_str,LEN(m.new_str)-1)
      IF RIGHT(m.new_str,1)=='.'
        m.new_str=LEFT(m.new_str,LEN(m.new_str)-1)
        EXIT
      ENDIF
    ENDDO
  CASE m.var_type=='D'
    m.new_str=DTOC(m.eval_str)
  CASE m.var_type=='L'
    m.new_str=IIF(m.eval_str,'.T.','.F.')
ENDCASE
RETURN m.new_str

* END strexpr



FUNCTION evlrec
PRIVATE evlflag,evlloop,i,field_name,field_type,field_eval

IF TYPE('m.ignrbraces')=='L'.AND.m.ignrbraces
  RETURN .F.
ENDIF
m.evlflag=.F.
m.evlloop=.T.
DO WHILE m.evlloop
  m.evlloop=.F.
  FOR m.i = 1 TO FCOUNT()
    m.field_name=FIELD(m.i)
    m.field_type=TYPE(m.field_name)
    IF m.field_type#'M'
      LOOP
    ENDIF
    m.field_eval=EVALUATE(m.field_name)
    IF '{{'$m.field_eval
      REPLACE (m.field_name) WITH evltxt(m.field_eval)
      m.evlflag=.T.
      m.evlloop=.T.
    ENDIF
  ENDFOR
  EXIT
ENDDO
RETURN m.evlflag

* END evlrec



FUNCTION stripcmnt
PRIVATE newcomment,str_data,usercmd,i

m.newcomment=''
FOR m.i = 1 TO 2
  m.str_data=IIF(m.i=1,m.c_precmd,m.c_postcmd)
  m.usercmd=wordsearch(m.str_data)
  IF m.usercmd==m.null
    m.usercmd=''
  ENDIF
  IF EMPTY(m.usercmd)
    LOOP
  ENDIF
  m.newcomment=m.cr_lf+m.newcomment+m.str_data+' '+m.usercmd+m.cr_lf
ENDFOR
RETURN m.newcomment

* END stripcmnt



FUNCTION insblank
PARAMETERS skiprec
PRIVATE lastfilter,r,pltfrmflag,ifexpr

m.ifexpr=IIF(_FOX26,wordsearch(m.m_if),'')
m.lastfilter=FILTER()
m.pltfrmflag=(TYPE(ALIAS()+'.PLATFORM')=='C')
IF m.pltfrmflag
  SET FILTER TO PLATFORM==m.platform_
ELSE
  SET FILTER TO
ENDIF
IF RECNO()<m.r_scxdata
  m.r=RECNO()
  LOCATE FOR OBJTYPE#1.AND..NOT.EMPTY(PLATFORM)
  m.r_scxdata=IIF(EOF(),m.r_scxdata,RECNO())
  IF EOF()
    GOTO m.r
    IF EMPTY(m.lastfilter)
      SET FILTER TO
    ELSE
      SET FILTER TO &lastfilter
    ENDIF
    RETURN .F.
  ENDIF
ENDIF
IF TYPE('m.skiprec')#'N'
  m.skiprec=0
ENDIF
SKIP m.skiprec
IF m.skiprec>0.OR.EOF()
  SKIP -1
ENDIF
SET FILTER TO
INSERT BLANK
IF m.pltfrmflag
  REPLACE PLATFORM WITH m.platform_
ENDIF
IF .NOT.EMPTY(m.ifexpr).AND..NOT.m.ifexpr==m.null
  REPLACE COMMENT WITH m.c_precmd+' IF '+m.ifexpr+m.cr_lf+;
                       m.c_postcmd+' ENDIF'+m.cr_lf+COMMENT
ENDIF
m.r=RECNO()
SCAN REST
  IF VPOS<0
    REPLACE HPOS WITH HPOS+1
  ENDIF
  IF HEIGHT<0.OR.HEIGHT>=256
    REPLACE WIDTH WITH WIDTH+1
  ENDIF
ENDSCAN
IF m.pltfrmflag
  SET FILTER TO PLATFORM==m.platform_
  LOCATE FOR OBJTYPE#1.AND..NOT.EMPTY(PLATFORM)
ELSE
  SET FILTER TO
  LOCATE FOR OBJTYPE#1
ENDIF
m.r_scxdata=IIF(EOF(),m.r_scxdata,RECNO())
GOTO m.r
IF EMPTY(m.lastfilter)
  SET FILTER TO
ELSE
  SET FILTER TO &lastfilter
ENDIF
RETURN .T.

* END insblank



FUNCTION insrec
PARAMETERS skiprec

IF TYPE('m.skiprec')#'N'
  m.skiprec=0
ENDIF
IF .NOT.insblank(m.skiprec)
  RETURN .F.
ENDIF
REPLACE OBJTYPE WITH 15, OBJCODE WITH 0, EXPR WITH '',;
        VPOS WITH 0, HPOS WITH 0,;
        HEIGHT WITH 0, WIDTH WITH 0, PICTURE WITH '',;
        BOXCHAR WITH '', FILLCHAR WITH '', SCHEME WITH 0,;
        SCHEME2 WITH -1, COLORPAIR WITH ''
IF TYPE('PLATFORM')=='C'
  REPLACE PLATFORM WITH m.platform_,;
          PENRED WITH -1, PENGREEN WITH -1, PENBLUE WITH -1,;
          FILLRED WITH -1, FILLGREEN WITH -1, FILLBLUE WITH -1,;
          PENSIZE WITH -1, PENPAT WITH -1, FONTFACE WITH '',;
          FONTSTYLE WITH 0, FONTSIZE WITH 0
ENDIF
RETURN .T.

* END insrec



FUNCTION duprec
PARAMETERS skiprec

IF RECNO()<m.r_scxdata
  RETURN .F.
ENDIF
IF TYPE('m.skiprec')#'N'
  m.skiprec=0
ENDIF
RELEASE a_fscatter
SCATTER TO a_fscatter MEMO
IF .NOT.insblank(m.skiprec)
  RELEASE a_fscatter
  RETURN .F.
ENDIF
GATHER FROM a_fscatter MEMO
RELEASE a_fscatter
RETURN .T.

* END duprec



FUNCTION insobj
PARAMETERS match_str,deldirect
PRIVATE objlib,objname,row,col,rows,cols
PRIVATE row_offset,col_offset,lastexac,old_text,new_text
PRIVATE memline,at_pos,at_line,trntxt_str,i,j

IF m.deldirect
  DELETE
ELSE
  REPLACE COMMENT WITH COMMENT+m.cr_lf+m.c_delete
ENDIF
m.objlib=''
m.objname=PADR(ALLTRIM(m.match_str),LEN(FOXSCX.OBJLIB_)+LEN(FOXSCX.OBJNAME_))
m.at_pos=AT('.',m.objname)
IF m.at_pos>0
  m.objlib=PADR(UPPER(CHRTRAN(ALLTRIM(LEFT(m.objname,m.at_pos-1)),;
           m.badchars,m.stdascii)),LEN(FOXSCX.OBJLIB_))
  m.objname=ALLTRIM(SUBSTR(m.objname,m.at_pos+1))
ENDIF
m.objlib=PADR(ALLTRIM(m.objlib),LEN(FOXSCX.OBJLIB_))
m.objname=PADR(ALLTRIM(m.objname),LEN(FOXSCX.OBJNAME_))
IF TYPE('m.inclibs')#'N'
  m.inclibs=0
ENDIF
IF m.inclibs=0.AND.EMPTY(m.objlib)
  =warning(m.c_insobj,m.match_str)
  RETURN .F.
ENDIF
m.objname=PADR(CHRTRAN(m.objname,m.badchars,m.stdascii),;
           LEN(FOXSCX.OBJNAME_))
m.row=VPOS
m.col=HPOS
m.rows=HEIGHT
m.cols=WIDTH
m.trntxt_str=''
m.at_line=ATCLINE(m.c_trntxt,COMMENT)
IF m.at_line>0
  FOR m.i = m.at_line TO MEMLINES(COMMENT)
    m.memline=ALLTRIM(MLINE(COMMENT,m.i))
    IF m.i>m.at_line.AND..NOT.'*:'$m.memline
      m.at_pos=AT(m.cr,COMMENT,m.i)+1
      IF m.at_pos=1.OR.ATC(m.c_trntxt,SUBSTR(COMMENT,m.at_pos))=0
        EXIT
      ENDIF
      LOOP
    ENDIF
    m.at_pos=ATC(m.c_trntxt,m.memline)
    IF m.at_pos=1
      m.trntxt_str=m.trntxt_str+m.memline+m.cr_lf
    ENDIF
  ENDFOR
ENDIF
SELECT FOXSCX
m.lstorder=ORDER()
SET ORDER TO OBJNAME_
IF EMPTY(m.objlib)
  m.lstexac=SET('EXACT')
  SET EXACT ON
  FOR m.i = 1 TO m.inclibs
    SEEK UPPER(PADR(m.objname,LEN(OBJNAME_))+PADR(a_inclib(m.i),LEN(OBJLIB_)))
    IF .NOT.EOF()
      m.objlib=OBJLIB_
      EXIT
    ENDIF
  ENDFOR
  IF m.lstexac=='ON'
    SET EXACT ON
  ELSE
    SET EXACT OFF
  ENDIF
ENDIF
m.lastorder=ORDER()
SEEK UPPER(m.objname+m.objlib)
IF EOF()
  =warning(m.c_insobj,m.match_str)
  SET ORDER TO (m.lastorder)
  SELECT SCXDATA
  RETURN .F.
ENDIF
IF .NOT.EOF().AND.OBJTYPE#1.AND.OBJTYPE#2.AND.OBJTYPE#10.AND.OBJTYPE#23
  m.row_offset=ROW-VPOS
  m.col_offset=COL-HPOS
  RELEASE a_fields
  DIMENSION a_fields(1)
  =AFIELDS(a_fields)
  SCATTER TO a_fscatter MEMO
  SELECT SCXDATA
  =insblank()
  IF ALEN(a_fscatter)=(FCOUNT()-m.fcountadj)
    GATHER FROM a_fscatter MEMO
  ELSE
    m.lastexac=SET('EXACT')
    SET EXACT ON
    FOR m.i = 1 TO (FCOUNT()-m.fcountadj)
      m.j=ASCAN(a_fields,FIELD(m.i))
      IF m.j=0
        LOOP
      ENDIF
      REPLACE (FIELD(m.i)) WITH a_fscatter(INT(m.j/4)+1)
    ENDFOR
    IF m.lastexac=='ON'
      SET EXACT ON
    ELSE
      SET EXACT OFF
    ENDIF
  ENDIF
  REPLACE VPOS WITH VPOS+m.row_offset, HPOS WITH HPOS+m.col_offset,;
                    ACTIVTYPE WITH 2, DEACTTYPE WITH 0
  IF TYPE('PLATFORM')=='C'
    REPLACE PLATFORM WITH m.platform_
  ENDIF
  IF ATC(m.c_basobj,COMMENT)=0
    =basobj2('')
  ENDIF
  IF TYPE('m.memvarmode')=='L'.AND.m.memvarmode
    m.old_text=ALLTRIM(MLINE(NAME,1))
    m.at_pos=AT('.',m.old_text)
    m.new_text='m'+SUBSTR(m.old_text,m.at_pos)
    IF m.at_pos>0.AND.(m.at_pos#2.OR.;
       .NOT.UPPER(LEFT(m.old_text,2))=='M.').AND.;
       .NOT.m.old_text==m.new_text
      REPLACE NAME WITH m.new_text,;
              WHEN WITH strtranc(WHEN,m.old_text,m.new_text),;
              VALID WITH strtranc(VALID,m.old_text,m.new_text),;
              MESSAGE WITH strtranc(MESSAGE,m.old_text,m.new_text),;
              ERROR WITH strtranc(ERROR,m.old_text,m.new_text),;
              RANGELO WITH strtranc(RANGELO,m.old_text,m.new_text),;
              RANGEHI WITH strtranc(RANGEHI,m.old_text,m.new_text)
    ENDIF
  ENDIF
  IF .NOT.EMPTY(m.trntxt_str)
    REPLACE COMMENT WITH m.trntxt_str+COMMENT
  ENDIF
  RELEASE a_fscatter
  =evlrec()
  SKIP -1
ELSE
  =warning(m.c_insobj,m.match_str)
ENDIF
SELECT FOXSCX
SET ORDER TO (m.lastorder)
LOCATE
SELECT SCXDATA
RETURN .T.

* END insobj



FUNCTION insscx
PARAMETERS scxname,deldirect
PRIVATE row,col,rows,cols,row_offset,col_offset,lastexac,old_text,new_text
PRIVATE memline,at_pos,at_line,trntxt_str,inscount,i,j,r

m.inscount=0
IF m.deldirect
  DELETE
ELSE
  REPLACE COMMENT WITH COMMENT+m.cr_lf+m.c_delete
ENDIF
IF .NOT.'.'$m.scxname
  m.scxname=m.scxname+'.SCX'
ENDIF
IF .NOT.FILE(m.scxname)
  =warning(m.c_insscx,m.scxname)
  RETURN m.inscount
ENDIF
m.r=RECNO()
m.row=VPOS
m.col=HPOS
m.rows=INT(objheight()-1)
m.cols=INT(objwidth()-1)
m.trntxt_str=''
m.at_line=ATCLINE(m.c_trntxt,COMMENT)
IF m.at_line>0
  FOR m.i = m.at_line TO MEMLINES(COMMENT)
    m.memline=ALLTRIM(MLINE(COMMENT,m.i))
    IF m.i>m.at_line.AND..NOT.'*:'$m.memline
      m.at_pos=AT(m.cr,COMMENT,m.i)+1
      IF m.at_pos=1.OR.ATC(m.c_trntxt,SUBSTR(COMMENT,m.at_pos))=0
        EXIT
      ENDIF
      LOOP
    ENDIF
    m.at_pos=ATC(m.c_trntxt,m.memline)
    IF m.at_pos=1
      m.trntxt_str=m.trntxt_str+m.memline+m.cr_lf
    ENDIF
  ENDFOR
ENDIF
IF USED('SCXINSERT')
  SELECT SCXINSERT
  USE
ELSE
  SELECT 0
ENDIF
USE (m.scxname) ALIAS SCXINSERT
IF TYPE('PLATFORM')=='C'
  SET FILTER TO PLATFORM==m.platform_
ELSE
  SET FILTER TO
ENDIF
LOCATE
m.row_offset=m.row-VPOS
m.col_offset=m.col-HPOS
SCAN ALL FOR OBJTYPE#1.AND.OBJTYPE#2.AND.OBJTYPE#10.AND.OBJTYPE#23.AND.;
             INT(VPOS)<=m.rows.AND.INT(HPOS)<=m.cols
  RELEASE a_fields
  DIMENSION a_fields(1)
  =AFIELDS(a_fields)
  SCATTER TO a_fscatter MEMO
  SELECT SCXDATA
  IF .NOT.insblank()
    EXIT
  ENDIF
  m.inscount=m.inscount+1
  IF ALEN(a_fscatter)=FCOUNT()
    GATHER FROM a_fscatter MEMO
  ELSE
    m.lastexac=SET('EXACT')
    SET EXACT ON
    FOR m.i = 1 TO FCOUNT()
      m.j=ASCAN(a_fields,FIELD(m.i))
      IF m.j=0
        LOOP
      ENDIF
      REPLACE (FIELD(m.i)) WITH a_fscatter(INT(m.j/4)+1)
    ENDFOR
    IF m.lastexac=='ON'
      SET EXACT ON
    ELSE
      SET EXACT OFF
    ENDIF
  ENDIF
  RELEASE a_fields
  REPLACE VPOS WITH VPOS+m.row_offset, HPOS WITH HPOS+m.col_offset,;
          ACTIVTYPE WITH 2, DEACTTYPE WITH 0
  IF TYPE('PLATFORM')=='C'
    REPLACE PLATFORM WITH m.platform_
  ENDIF
  IF TYPE('m.memvarmode')=='L'.AND.m.memvarmode
    m.old_text=ALLTRIM(MLINE(NAME,1))
    m.at_pos=AT('.',m.old_text)
    m.new_text='m'+SUBSTR(m.old_text,m.at_pos)
    IF m.at_pos>0.AND.(m.at_pos#2.OR.;
       .NOT.UPPER(LEFT(m.old_text,2))=='M.').AND.;
       .NOT.m.old_text==m.new_text
      REPLACE NAME WITH 'm'+SUBSTR(NAME,m.at_pos)
      m.new_text=ALLTRIM(MLINE(NAME,1))
      REPLACE WHEN WITH strtranc(WHEN,m.old_text,m.new_text),;
              VALID WITH strtranc(VALID,m.old_text,m.new_text),;
              MESSAGE WITH strtranc(MESSAGE,m.old_text,m.new_text),;
              ERROR WITH strtranc(ERROR,m.old_text,m.new_text),;
              RANGELO WITH strtranc(RANGELO,m.old_text,m.new_text),;
              RANGEHI WITH strtranc(RANGEHI,m.old_text,m.new_text)
    ENDIF
  ENDIF
  IF .NOT.EMPTY(m.trntxt_str)
    REPLACE COMMENT WITH m.trntxt_str+COMMENT
  ENDIF
  =evlrec()
  SELECT SCXINSERT
ENDSCAN
RELEASE a_fscatter
USE IN SCXINSERT
SELECT SCXDATA
GOTO m.r
RETURN m.inscount

* END insscx



FUNCTION defobj1
PARAMETERS objname

RETURN defobj2(m.objname)

* END defobj1



FUNCTION defobj2
PARAMETERS objname

REPLACE COMMENT WITH m.c_defobj+' '+m.objname+m.cr_lf+COMMENT
RETURN .T.

* END defobj2



FUNCTION basobj1
PARAMETERS objname

RETURN defobj2(m.objname)

* END basobj1



FUNCTION basobj2
PARAMETERS objname

REPLACE COMMENT WITH COMMENT+m.cr_lf+m.c_basobj+' '+m.objname

* END basobj2



FUNCTION delobj1

RETURN delobj2()

* END delobj1



FUNCTION delobj2

REPLACE COMMENT WITH m.c_delobj+m.cr_lf+COMMENT
RETURN .T.

* END delobj2



FUNCTION delete1

RETURN delete2()

* END delete1



FUNCTION delete2

REPLACE COMMENT WITH m.c_delete+m.cr_lf+COMMENT
RETURN .T.

* END delete2



FUNCTION insobj1
PARAMETERS textstr

RETURN insobj2(m.textstr)

* END insobj1



FUNCTION insobj2
PARAMETERS textstr

REPLACE COMMENT WITH m.c_insobj+' '+m.textstr+m.cr_lf+COMMENT
RETURN .T.

* END insobj2



FUNCTION insscx1
PARAMETERS textstr

RETURN insscx2(m.textstr)

* END insscx1



FUNCTION insscx2
PARAMETERS textstr

REPLACE COMMENT WITH m.c_insscx+' '+m.textstr+m.cr_lf+COMMENT
RETURN .T.

* END insscx2



FUNCTION instxt1
PARAMETERS textstr,skiprec
PRIVATE r

RETURN instxt2(m.textstr,m.skiprec)

* END instxt1



FUNCTION instxt2
PARAMETERS textstr,skiprec
PRIVATE r,sayrefresh

IF RECNO()<m.r_scxdata
  RETURN .F.
ENDIF
m.sayrefresh=REFRESH
m.r=RECNO()
IF TYPE('m.skiprec')#'N'
  m.skiprec=0
ENDIF
IF m.skiprec#0
  IF .NOT.insrec(m.skiprec)
    RETURN .F.
  ENDIF
ENDIF
REPLACE COMMENT WITH COMMENT+m.cr+m.c_instxt+m.cr+m.textstr,;
        REFRESH WITH m.sayrefresh
GOTO m.r
IF m.skiprec<0
  SKIP
ENDIF
RETURN .T.

* END instxt2



FUNCTION clrtxt1

RETURN clrtxt2()

* END clrtxt1



FUNCTION clrtxt2

IF RECNO()<m.r_scxdata
  RETURN .F.
ENDIF
REPLACE COMMENT WITH ''
RETURN .T.

* END clrtxt2



FUNCTION insif1
PARAMETERS textstr

RETURN insif2(m.textstr)

* END insif1



FUNCTION insif2
PARAMETERS textstr

RETURN inscmd('IF '+m.textstr,-1).AND.inscmd('ENDIF',1)

* END insif2



FUNCTION inscmd
PARAMETERS textstr,skiprec,delflag
PRIVATE sayrefresh,str_data,usercmd

m.sayrefresh=REFRESH
m.textstr=ALLTRIM(m.textstr)
IF TYPE('m.skiprec')#'N'
  m.skiprec=0
ENDIF
IF _FOX26.AND..NOT.sayrefresh.AND.BETWEEN(m.skiprec,-1,1)
  REPLACE DEACTTYPE WITH 0
  IF m.skiprec=0
    m.skiprec=-1
  ENDIF
  m.str_data=IIF(m.skiprec=1,m.c_postcmd,m.c_precmd)
  IF m.delflag
    SKIP -m.skiprec
  ENDIF
  m.usercmd=wordsearch(m.str_data)
  IF m.usercmd==m.null
    m.usercmd=''
  ENDIF
  IF m.delflag
    SKIP m.skiprec
  ENDIF
  IF .NOT.EMPTY(m.usercmd)
    m.textstr=m.usercmd+'{{m.cr}}'+m.textstr
  ENDIF
  IF m.delflag
    SKIP -m.skiprec
  ENDIF
  REPLACE COMMENT WITH m.str_data+' '+m.textstr+m.cr+COMMENT
  IF m.delflag
    SKIP m.skiprec
    DELETE
  ENDIF
  RETURN .T.
ENDIF
IF .NOT.instxt2(m.textstr,m.skiprec)
  RETURN .F.
ENDIF
IF m.skiprec=0
  m.skiprec=-1
ENDIF
REPLACE REFRESH WITH m.sayrefresh
RETURN .T.

* END inscmd




FUNCTION size1
PARAMETERS textstr

RETURN size2(m.textstr)

* END size1



FUNCTION size2
PARAMETERS textstr

IF TYPE('m.textstr')#'C'.OR.EMPTY(m.textstr)
  REPLACE COMMENT WITH m.c_nosize+m.cr_lf+COMMENT
ELSE
  REPLACE COMMENT WITH m.c_size+' '+m.textstr+m.cr_lf+COMMENT
ENDIF
IF m.drv_no>=5.AND..NOT.m.loop_flag
  m.loop_obj=.T.
ENDIF
RETURN .T.

* END size2



FUNCTION default1
PARAMETERS textstr

RETURN default2(m.textstr)

* END default1



FUNCTION default2
PARAMETERS textstr

REPLACE COMMENT WITH m.c_default+' '+m.textstr+m.cr_lf+COMMENT
IF m.drv_no>=5.AND..NOT.m.loop_flag
  m.loop_obj=.T.
ENDIF
RETURN .T.

* END default2



FUNCTION function1
PARAMETERS textstr

RETURN function2(m.textstr)

* END function1



FUNCTION function2
PARAMETERS textstr

REPLACE COMMENT WITH m.c_function+' '+m.textstr+m.cr_lf+;
                     '*:ENDFNCT'+m.cr_lf+COMMENT
RETURN .T.

* END function2




FUNCTION insfnct
PARAMETERS textstr

GOTO m.r_scxdata
IF .NOT.insrec(-1)
  RETURN .F.
ENDIF
IF .NOT.function2(m.textstr)
  RETURN .F.
ENDIF
IF .NOT.delobj2()
  RETURN .F.
ENDIF
RETURN .T.

* END insfnct



FUNCTION click1
PARAMETERS textstr

RETURN click2(m.textstr)

* END click1



FUNCTION click2
PARAMETERS textstr

REPLACE COMMENT WITH m.c_click+' '+m.textstr+m.cr_lf+COMMENT
RETURN .T.

* END click2



FUNCTION button1
PARAMETERS textstr

RETURN button2(m.textstr)

* END button1



FUNCTION button2
PARAMETERS textstr

REPLACE COMMENT WITH m.c_button+' '+m.textstr+m.cr_lf+COMMENT
RETURN .T.

* END button2



FUNCTION delrec

DELETE
RETURN .T.

* END delrec



FUNCTION drvobj

DO CASE
  CASE RECNO()<m.r_scxdata
    RETURN .F.
  CASE DELETED()
    RETURN .F.
ENDCASE
RETURN .T.

* drvobj



FUNCTION drvenable
PARAMETERS prog_name
PRIVATE var_name

m.var_name='_'+UPPER(m.prog_name)
IF IIF(TYPE('EVALUATE(m.var_name)')=='C',EVALUATE(m.var_name),;
   configfp(m.prog_name,'ON'))=='OFF'
  RETURN .F.
ENDIF
RETURN .T.

* drvenable



FUNCTION objsay

RETURN '@ '+objpos()+' SAY '+EXPR

* END objsay



FUNCTION objpos

IF INLIST(ALLTRIM(m.platform_),'WINDOWS','MAC')
  RETURN ALLTRIM(STR(VPOS,7,3))+','+ALLTRIM(STR(HPOS,7,3))
ENDIF
RETURN ALLTRIM(STR(VPOS,3))+','+ALLTRIM(STR(HPOS,3))

* END objpos



FUNCTION objend

IF INLIST(ALLTRIM(m.platform_),'WINDOWS','MAC')
  RETURN ALLTRIM(STR(VPOS+objheight(),7,3))+','+ALLTRIM(STR(HPOS+objwidth(),7,3))
ENDIF
RETURN ALLTRIM(STR(VPOS+objheight()-1,3))+','+ALLTRIM(STR(HPOS+objwidth()-1,3))

* END objend



FUNCTION objdata
PARAMETERS match_str,eval_str
PRIVATE new_str,mthd_str,at_pos,r

m.new_str=''
IF '.'$m.match_str.OR..NOT.USED('SCXDATA')
  RETURN libdata(m.match_str,m.eval_str)
ENDIF
m.match_str=PADR(CHRTRAN(ALLTRIM(m.match_str),m.badchars,m.stdascii),24)
m.r=RECNO()
GOTO m.r_scxdata
LOCATE REST FOR PADR(UPPER(CHRTRAN(wordsearch(m.c_defobj),;
                m.badchars,m.stdascii)),24)==UPPER(m.match_str)
IF EOF()
  IF TYPE('m.evlmode')=='L'.AND.m.evlmode
    m.new_str=libdata(m.match_str,m.eval_str)
  ELSE
    =warning('objdata()',m.match_str)
  ENDIF
ELSE
  IF TYPE('m.eval_str')#'C'.OR.EMPTY(m.eval_str).OR.;
     UPPER(m.eval_str)=='COMMENT'
    m.eval_str=m.eval_cmnt
  ENDIF
  IF '::'$m.eval_str
    m.at_pos=AT('::',m.eval_str)
    m.mthd_str=SUBSTR(m.eval_str,m.at_pos+2)
    m.eval_str=LEFT(m.eval_str,m.at_pos-1)
    IF EMPTY(m.eval_str)
      m.eval_str=m.eval_cmnt
    ENDIF
    m.new_str=evlstr(m.eval_str)
    m.at_pos=ATC(m.c_method+' '+m.mthd_str+m.cr,m.new_str+m.cr)
    IF m.at_pos=0
      =warning('objdata()',m.match_str+'::'+m.eval_str+'::'+m.mthd_str)
      m.new_str=''
    ELSE
      m.new_str=SUBSTR(m.new_str,m.at_pos)
      m.at_pos=ATC(m.c_endmthd,m.new_str)
      IF m.at_pos>0
        m.new_str=LEFT(m.new_str,m.at_pos+LEN(m.c_endmthd)-1)
      ENDIF
      m.new_str=m.new_str+m.cr_lf
    ENDIF
  ELSE
    m.new_str=evlstr(m.eval_str)
  ENDIF
ENDIF
GOTO m.r
RETURN m.new_str

* END objdata



FUNCTION libdata
PARAMETERS match_str,eval_str
PRIVATE new_str,mthd_str,at_pos,i,objlib,objname,lstselect,lstorder,lstexac

m.new_str=''
m.lstselect=SELECT()
IF .NOT.openfoxscx()
  RETURN m.new_str
ENDIF
m.objlib=''
m.objname=PADR(ALLTRIM(m.match_str),LEN(FOXSCX.OBJLIB_)+LEN(FOXSCX.OBJNAME_))
m.at_pos=AT('.',m.objname)
IF m.at_pos>0
  m.objlib=PADR(UPPER(CHRTRAN(ALLTRIM(LEFT(m.objname,m.at_pos-1)),;
           m.badchars,m.stdascii)),LEN(FOXSCX.OBJLIB_))
  m.objname=ALLTRIM(SUBSTR(m.objname,m.at_pos+1))
ENDIF
IF TYPE('m.inclibs')#'N'
  m.inclibs=0
ENDIF
IF m.inclibs=0.AND.EMPTY(m.objlib)
  =warning('libdata()',m.match_str)
  RETURN m.new_str
ENDIF
m.objname=PADR(CHRTRAN(m.objname,m.badchars,m.stdascii),;
          LEN(FOXSCX.OBJNAME_))
SELECT FOXSCX
m.lstorder=ORDER()
SET ORDER TO OBJNAME_
IF EMPTY(m.objlib)
  m.lstexac=SET('EXACT')
  SET EXACT ON
  FOR m.i = 1 TO m.inclibs
    SEEK UPPER(PADR(m.objname,LEN(OBJNAME_))+PADR(a_inclib(m.i),LEN(OBJLIB_)))
    IF .NOT.EOF()
      m.objlib=OBJLIB_
      EXIT
    ENDIF
  ENDFOR
  IF m.lstexac=='ON'
    SET EXACT ON
  ELSE
    SET EXACT OFF
  ENDIF
ENDIF
SEEK UPPER(m.objname+m.objlib)
IF EOF()
  =warning('libdata()',m.match_str)
ELSE
  IF TYPE('m.eval_str')#'C'.OR.EMPTY(m.eval_str).OR.;
     UPPER(m.eval_str)=='COMMENT'
    m.eval_str=m.eval_cmnt
  ENDIF
  IF '::'$m.eval_str
    m.at_pos=AT('::',m.eval_str)
    m.mthd_str=SUBSTR(m.eval_str,m.at_pos+2)
    m.eval_str=LEFT(m.eval_str,m.at_pos-1)
    IF EMPTY(m.eval_str)
      m.eval_str=m.eval_cmnt
    ENDIF
    m.new_str=evlstr(m.eval_str)
    m.at_pos=ATC(m.c_method+' '+m.mthd_str+m.cr,m.new_str+m.cr)
    IF m.at_pos=0
      =warning('libdata()',m.match_str+'::'+m.eval_str+'::'+m.mthd_str)
      m.new_str=''
    ELSE
      m.new_str=SUBSTR(m.new_str,m.at_pos)
      m.at_pos=ATC(m.c_endmthd,m.new_str)
      IF m.at_pos>0
        m.new_str=LEFT(m.new_str,m.at_pos+LEN(m.c_endmthd)-1)+m.cr_lf
      ENDIF
    ENDIF
  ELSE
    m.new_str=evlstr(m.eval_str)
  ENDIF
ENDIF
SET ORDER TO (m.lstorder)
LOCATE
SELECT (m.lstselect)
RETURN m.new_str

* END libdata



FUNCTION checkclick
PRIVATE click,button,visible,r,vpos2,hpos2,height2,width2

IF DELETED()
  RETURN .F.
ENDIF
IF OBJTYPE#5.AND.OBJTYPE#7.AND.OBJTYPE#17.AND.(OBJTYPE#15.OR.OBJCODE#0)
  RETURN .F.
ENDIF
m.click=nobrackets(wordsearch(m.c_click))
m.button=nobrackets(wordsearch(m.c_button))
IF m.click==m.null.AND.m.button==m.null
  RETURN .F.
ENDIF
m.visible=wordsearch(m.c_visible)
IF m.visible==m.null
  m.visible=''
ENDIF
REPLACE COMMENT WITH strtranc(strtranc(COMMENT,m.c_click,m.m_click),;
                     m.c_button,m.m_button)
DO CASE
  CASE m.click==m.null
    m.click=''
  CASE .NOT.EMPTY(m.click).AND..NOT.RIGHT(m.click,1)==')'
    m.click=m.click+'()'
ENDCASE
IF .NOT.EMPTY(m.click)
  m.click="MDOWN().AND.BETWEEN(MROW(),"+ALLTRIM(STR(VPOS,9,3))+","+;
             ALLTRIM(STR(VPOS+objheight(),9,3))+").AND.BETWEEN(MCOL(),"+;
             ALLTRIM(STR(HPOS,9,3))+","+ALLTRIM(STR(HPOS+objwidth(),9,3))+;
             ").AND."+m.click
ENDIF
IF .NOT.EMPTY(m.click).AND.m.button==m.null
  m.click=m.click+".AND..F."
ENDIF
IF m.button==m.null
  m.button=''
ELSE
  IF .NOT.EMPTY(m.click)
    m.click=".NOT.MDOWN().OR.("+m.click+")"
  ENDIF
  IF .NOT.EMPTY(m.button).AND..NOT.RIGHT(m.button,1)==')'
    m.button=m.button+'()'
  ENDIF
ENDIF
m.r=RECNO()
m.vpos2=VPOS
m.hpos2=HPOS
m.height2=objheight()
m.width2=objwidth()
IF .NOT.insrec(-1)
  GOTO m.r
  RETURN .F.
ENDIF
REPLACE VPOS WITH m.vpos2, HPOS WITH m.hpos2,;
HEIGHT WITH m.height2, WIDTH WITH m.width2
REPLACE OBJTYPE WITH 20, OBJCODE WITH 1,;
        NAME WITH 'm.null'+ALLTRIM(STR(RECNO(),6)), EXPR WITH '',;
        PICTURE WITH '"@*IHN "',;
        WHENTYPE WITH 0, WHEN WITH m.click,;
        VALIDTYPE WITH 0, VALID WITH m.button,;
        INITIALVAL WITH '', INITIALNUM WITH 0, COMMENT WITH ''
IF _FOX25
  REPLACE FONTFACE WITH m.fontface,;
          FONTSTYLE WITH m.fontstyle, FONTSIZE WITH m.fontsize
ENDIF
IF .NOT.EMPTY(m.visible)
  REPLACE COMMENT WITH m.c_visible+' '+m.visible+m.cr_lf+COMMENT
ENDIF
GOTO m.r
SKIP
RETURN .T.

* END checkclick



FUNCTION insert
PARAMETERS filename
PRIVATE mlstselect

IF .NOT.FILE(m.filename)
  =warning('insert()',m.filename)
  RETURN ''
ENDIF
m.lstselect=SELECT()
IF USED('INSERTFILE')
  SELECT INSERTFILE
  LOCATE
ELSE
  CREATE CURSOR INSERTFILE (FILEINFO M)
  SELECT INSERTFILE
  INSERT BLANK
ENDIF
APPEND MEMO FILEINFO FROM (m.filename) OVERWRITE
SELECT (m.lstselect)
RETURN INSERTFILE.FILEINFO

* END insert



FUNCTION objheight
PRIVATE height2,picture2

m.height2=HEIGHT
IF (OBJTYPE=12.OR.OBJTYPE=13).AND.';'$PICTURE
  m.picture2=UPPER(ALLTRIM(SUBSTR(MLINE(PICTURE,1),2,5)))
  IF (OBJTYPE=12.AND.m.picture2=='@*VN').OR.;
     (OBJTYPE=13.AND.m.picture2=='@*RVN')
    m.height2=m.height2+(m.height2+SPACING)*OCCURS(';',PICTURE)
  ENDIF
ENDIF
RETURN m.height2*objfactor()

* END objheight



FUNCTION objwidth
PRIVATE width2,picture2

m.width2=WIDTH
IF (OBJTYPE=12.OR.OBJTYPE=13).AND.';'$PICTURE
  m.picture2=UPPER(ALLTRIM(SUBSTR(MLINE(PICTURE,1),2,5)))
  IF (OBJTYPE=12.AND.m.picture2=='@*HN').OR.;
     (OBJTYPE=13.AND.m.picture2=='@*RHN')
    m.width2=m.width2+(m.width2+SPACING)*OCCURS(';',PICTURE)
  ENDIF
ENDIF
RETURN m.width2*objfactor(.T.)

* END objwidth




FUNCTION objfactor
PARAMETERS widthflag
PRIVATE cfontstylm,cfontstyl,vfontratio,hfontratio

IF TYPE('_WINDOWS')#'L'.OR.(.NOT._WINDOWS.AND..NOT._MAC).OR.;
   TYPE('PLATFORM')#'C'.OR.EMPTY(FONTFACE).OR.;
   .NOT.INLIST(ALLTRIM(m.platform_),'WINDOWS','MAC')
  RETURN 1
ENDIF
IF TYPE('m.fontface')=='U'
  m.fontface='MS Sans Serif'
  m.fontsize=8
  m.fontstyle=0
ENDIF
m.cfontstylm=IIF(m.fontstyle=1.OR.m.fontstyle=3,'B','')
m.cfontstyl=IIF(FONTSTYLE=1.OR.FONTSTYLE=3,'B','')
m.vfontratio=FONTMETRIC(1,m.fontface,m.fontsize,m.cfontstylm)/;
             (FONTMETRIC(1,m.fontface,m.fontsize,m.cfontstylm)+;
             FONTMETRIC(5,m.fontface,m.fontsize,m.cfontstylm))*;
             (FONTMETRIC(1,WFONT(1,''),WFONT(2,''),WFONT(3,''))+;
             FONTMETRIC(5,WFONT(1,''),WFONT(2,''),WFONT(3,'')))/;
             FONTMETRIC(1,'FoxFont',9,'N')
m.hfontratio=FONTMETRIC(6,m.fontface,m.fontsize,m.cfontstylm)/;
             FONTMETRIC(6,m.fontface,m.fontsize,m.cfontstylm)*;
             FONTMETRIC(6,WFONT(1,''),WFONT(2,''),WFONT(3,''))/;
             FONTMETRIC(6,'FoxFont',9,'N')
IF m.widthflag
  RETURN FONTMETRIC(6,FONTFACE,FONTSIZE,m.cfontstyl)/;
         FONTMETRIC(6,m.fontface,m.fontsize,m.cfontstylm)/(m.hfontratio*;
         (FONTMETRIC(6,'FoxFont',9,'N')/FONTMETRIC(6,WFONT(1,''),WFONT(2,''),;
         WFONT(3,''))))
ENDIF
RETURN (FONTMETRIC(1,FONTFACE,FONTSIZE,m.cfontstyl)+;
       FONTMETRIC(5,FONTFACE,FONTSIZE,m.cfontstyl))/;
       (FONTMETRIC(1,m.fontface,m.fontsize,m.cfontstylm)+;
       FONTMETRIC(5,m.fontface,m.fontsize,m.cfontstylm))/(m.vfontratio*;
       (FONTMETRIC(1,'FoxFont',9,'N')/FONTMETRIC(1,WFONT(1,''),WFONT(2,''),;
       WFONT(3,''))))

* END objfactor



FUNCTION setupmthd
PARAMETERS methodname
PRIVATE r,objname,codedata

m.objname=wordsearch(m.c_defobj)
IF EMPTY(m.objname).OR.m.objname==m.null
  m.objname=SYS(3)+ALLTRIM(STR(SECONDS(),9))
  REPLACE COMMENT WITH m.c_defobj+' '+m.objname+m.cr_lf+COMMENT
ENDIF
IF TYPE('m.methodname')#'C'.OR.EMPTY(m.methodname)
  m.methodname='SETUP'
ENDIF
IF ATC(m.c_method+' '+m.methodname+m.cr,COMMENT)=0
  =warning(m.c_method,'Setup')
  RETURN ''
ENDIF
m.r=RECNO()
LOCATE
m.codedata=IIF(wordsearch('#SECTION 2')==m.null,'#SECTION 2'+m.cr_lf,'')
m.codedata=m.codedata+evltxt('{{'+m.objname+'::::'+m.methodname+'}}')
REPLACE SETUPCODE WITH SETUPCODE+m.cr_lf+m.codedata
GOTO m.r
RETURN ''

* END setupmthd



FUNCTION dfltfld

IF TYPE('NAMECHANGE')=='L'.AND.OBJTYPE=1
  RETURN 'SETUP'
ENDIF
IF TYPE('OUTFILE')=='M'.OR.TYPE('PTXDATA')=='M'
  RETURN 'NAME'
ENDIF
RETURN 'COMMENT'

* END dfltfld



FUNCTION wordstuff
PARAMETERS stuff_str,insflag,insbefore,searchfld,occurance
PRIVATE var_type,memodata,memline,snptname,at_pos,lf_pos,str_len,remove_str
PRIVATE null,cr,lf,cr_lf

m.null=CHR(0)
m.cr=CHR(13)
m.lf=CHR(10)
m.cr_lf=m.cr+m.lf
IF TYPE('m.insflag')=='N'
  m.insflag=(m.insflag=1)
ENDIF
IF PARAMETERS()<=3
  IF TYPE('OBJTYPE')=='N'.AND.TYPE('CENTER')=='L'
    m.searchfld=(OBJTYPE=1)
  ELSE
    m.searchfld=dfltfld()
  ENDIF
ENDIF
m.var_type=TYPE('m.searchfld')
DO CASE
  CASE m.var_type=='L'
    IF m.searchfld
      m.memodata=SETUPCODE
      m.searchfld='SETUPCODE'
    ELSE
      m.memodata=COMMENT
      m.searchfld='COMMENT'
    ENDIF
  CASE m.var_type=='C'
    m.memodata=EVALUATE(m.searchfld)
  OTHERWISE
    RETURN .F.
ENDCASE
m.stuff_str=ALLTRIM(m.stuff_str)
DO WHILE LEFT(m.memodata,1)==m.cr.OR.LEFT(m.memodata,1)==m.lf
  m.memodata=SUBSTR(m.memodata,2)
ENDDO
m.remove_str=m.stuff_str
m.at_pos=AT(' ',m.remove_str)
IF m.at_pos>0
  m.remove_str=ALLTRIM(LEFT(m.remove_str,m.at_pos-1))
ENDIF
m.str_len=0
m.at_pos=wordsearch(m.remove_str,m.searchfld,.F.,@m.str_len,m.occurance)
IF m.at_pos=0.OR.m.str_len=0
  m.at_pos=0
ENDIF
IF m.at_pos>0
  m.memline=SUBSTR(m.memodata,m.at_pos,m.str_len)
  m.lf_pos=AT(m.lf,m.memline)
  IF m.lf_pos>0
    m.str_len=m.lf_pos
  ENDIF
  m.memodata=LEFT(m.memodata,m.at_pos-1)+SUBSTR(m.memodata,m.at_pos+m.str_len)
ENDIF
IF .NOT.m.insflag
  IF m.at_pos=0
    RETURN .F.
  ENDIF
  IF UPPER(LEFT(m.searchfld,2))=='M.'
    &searchfld=m.memodata
  ELSE
    REPLACE (m.searchfld) WITH m.memodata
  ENDIF
  RETURN .T.
ENDIF
DO CASE
  CASE m.at_pos>0
    m.stuff_str=LEFT(m.memodata,m.at_pos-1)+m.stuff_str+m.cr_lf+;
                SUBSTR(m.memodata,m.at_pos)
  CASE m.insbefore
    IF .NOT.EMPTY(m.memodata)
      m.memodata=m.cr_lf+m.memodata
    ENDIF
    m.stuff_str=m.stuff_str+m.memodata
  OTHERWISE
    IF .NOT.EMPTY(m.memodata).AND..NOT.RIGHT(m.memodata,1)==m.cr_lf.AND.;
       .NOT.RIGHT(m.memodata,1)==m.lf
      m.memodata=m.memodata+m.cr_lf
    ENDIF
    DO WHILE RIGHT(m.memodata,1)==m.cr.OR.RIGHT(m.memodata,1)==m.lf
      m.memodata=LEFT(m.memodata,LEN(m.memodata)-1)
    ENDDO
    m.stuff_str=m.memodata+m.cr_lf+m.stuff_str+m.cr
ENDCASE
DO WHILE RIGHT(m.stuff_str,1)==m.cr.OR.RIGHT(m.stuff_str,1)==m.lf
  m.stuff_str=LEFT(m.stuff_str,LEN(m.stuff_str)-1)
ENDDO
m.stuff_str=m.stuff_str+m.cr
IF UPPER(LEFT(m.searchfld,2))=='M.'
  &searchfld=m.stuff_str
ELSE
  REPLACE (m.searchfld) WITH m.stuff_str
ENDIF
RETURN .T.

* END wordstuff



FUNCTION linesearch
PARAMETERS find_str,searchfld

RETURN wordsearch(m.find_str,m.searchfld,.T.)

* END linesearch



FUNCTION wordsearch
PARAMETERS find_str,searchfld,ignoreword,returnmline,occurance
PRIVATE var_type,memodata,memline,memline2,str_data,lastmline
PRIVATE matchcount,linecount,linecount2,at_mline,at_mline2,mline2
PRIVATE null,cr,lf,lf_pos,lf_pos2,at_pos

m.null=CHR(0)
m.cr=CHR(13)
m.lf=CHR(10)
IF PARAMETERS()<=1
  IF TYPE('OBJTYPE')=='N'.AND.TYPE('CENTER')=='L'
    m.searchfld=(OBJTYPE=1)
  ELSE
    m.searchfld=dfltfld()
  ENDIF
ENDIF
IF TYPE('m.returnmline')=='N'
  m.returnmline=.T.
ENDIF
DO CASE
  CASE TYPE('m.occurance')#'N'
    m.occurance=1
  CASE m.occurance<0
    RETURN IIF(m.returnmline,0,m.null)
ENDCASE
m.var_type=TYPE('m.searchfld')
DO CASE
  CASE m.var_type=='L'
    IF m.searchfld
      IF EMPTY(SETUPCODE)
        RETURN IIF(m.returnmline,0,m.null)
      ENDIF
      m.memodata=SETUPCODE
      m.searchfld='SETUPCODE'
    ELSE
      IF EMPTY(COMMENT)
        RETURN IIF(m.returnmline,0,m.null)
      ENDIF
      m.memodata=COMMENT
      m.searchfld='COMMENT'
    ENDIF
  CASE m.var_type=='C'
    m.memodata=EVALUATE(m.searchfld)
    IF EMPTY(m.searchfld)
      RETURN IIF(m.returnmline,0,m.null)
    ENDIF
  OTHERWISE
    RETURN IIF(m.returnmline,0,m.null)
ENDCASE
m.find_str=ALLTRIM(m.find_str)
IF EMPTY(m.find_str).OR.EMPTY(m.memodata).OR.m.memodata==m.null
  RETURN IIF(m.returnmline,0,m.null)
ENDIF
m.memline2=''
m.lastmline=_MLINE
m.at_mline=0
m.at_mline2=0
m.mline2=0
m.lf_pos=0
m.lf_pos2=0
m.matchcount=0
m.linecount=0
m.linecount2=0
m.memodata=m.lf+m.memodata
_MLINE=ATC(m.lf+m.find_str,m.memodata)
IF _MLINE=0
  m.memodata=m.cr+SUBSTR(m.memodata,2)
  _MLINE=ATC(m.cr+m.find_str,m.memodata)
  IF _MLINE=0
    _MLINE=m.lastmline
    RETURN IIF(m.returnmline,0,m.null)
  ENDIF
ENDIF
DO WHILE .T.
  DO CASE
    CASE m.occurance>0.AND._MLINE>=LEN(m.memodata)
      EXIT
    CASE _MLINE>=LEN(m.memodata)
      m.occurance=-1
    OTHERWISE
      m.at_mline=_MLINE
      m.memline=ALLTRIM(MLINE(m.memodata,1,_MLINE))
      m.lf_pos=AT(m.lf,SUBSTR(m.memodata,m.at_mline+1,LEN(m.memline)))
      IF m.lf_pos>0
        m.memline=ALLTRIM(LEFT(m.memline,m.lf_pos-1))
      ENDIF
      m.str_data=SUBSTR(m.memline,LEN(m.find_str)+1,1)
      m.at_pos=ATC(m.find_str,m.memline)
      IF m.at_pos#1.OR.(.NOT.m.ignoreword.AND..NOT.EMPTY(m.str_data))
        m.at_pos=0
        m.memodata=m.lf+SUBSTR(m.memodata,_MLINE)
        _MLINE=ATC(m.lf+m.find_str,m.memodata)
        IF _MLINE>0
          LOOP
        ENDIF
        m.memodata=m.cr+SUBSTR(m.memodata,2)
        _MLINE=ATC(m.cr+m.find_str,m.memodata)
        IF _MLINE>0
          LOOP
        ENDIF
        IF m.occurance>0
          EXIT
        ENDIF
      ENDIF
      m.matchcount=m.matchcount+1
      IF m.matchcount<m.occurance.OR.m.occurance=0
        IF m.at_pos=1.AND.(m.ignoreword.OR.EMPTY(m.str_data))
          m.mline2=_MLINE
          m.at_mline2=m.at_mline
          m.memline2=m.memline
          m.lf_pos2=m.lf_pos
          m.linecount2=m.linecount
        ENDIF
        IF BETWEEN(_MLINE,1,LEN(m.memodata))
          _MLINE=_MLINE-2
          m.linecount=m.linecount+_MLINE
          LOOP
        ENDIF
      ENDIF
  ENDCASE
  IF m.occurance<=0
    IF m.mline2=0
      RETURN IIF(m.returnmline,0,m.null)
    ENDIF
    _MLINE=m.mline2
    m.at_mline=m.at_mline2
    m.memline=m.memline2
    m.lf_pos=m.lf_pos2
    m.linecount=m.linecount2
    m.occurance=1
  ENDIF
  m.mline2=_MLINE
  _MLINE=m.lastmline
  m.at_pos=0
  m.str_data=SUBSTR(m.memline,LEN(m.find_str)+1)
  IF m.ignoreword.AND..NOT.LEFT(m.str_data,1)==' '
    m.at_pos=AT(' ',m.str_data)
    IF m.at_pos>0
      m.str_data=SUBSTR(m.str_data,m.at_pos+1)
    ENDIF
  ENDIF
  m.str_data=ALLTRIM(m.str_data)
  IF .NOT.m.returnmline
    RETURN m.str_data
  ENDIF
  m.returnmline=m.mline2-m.at_mline+1-IIF(m.lf_pos>0,1,0)
  RETURN m.at_mline+m.linecount
ENDDO
_MLINE=m.lastmline
RETURN IIF(m.returnmline,0,m.null)

* END wordsearch
