*****************************
* This function opens a table.
* The optional parameters are:
* FILENAME (string,not optional)
* ALIAS (string, defaults to filename if omitted)
* NOSELE (boolean, causes the entry select to be reselected if .T.
* EXTENSION (defaults to .dbf, can be altered)
*
*
* Normal usage would be IF NOT DOPEN('myfile')
*						WAIT WINDOW "we got a problem"
*
* or just plain =dopen('anyfile')
*
*
*
******************************


PARAMETERS fname,falias,nosele,extension
PRIVATE sele,file,dbf 
IF PARAMETERS() = 0
	WAIT WINDOW "No File Selected!"
	RETURN .F.
ENDIF
IF PARAMETERS() = 1
	m.falias = m.fname
	IF AT('\',m.falias) > 0
		IF AT('.',m.falias) = 0
			m.falias = m.falias + '.dbf'
		ENDIF
		m.falias = SUBSTR(m.falias,RAT('\',m.falias)+1,LEN(TRIM(m.falias)))
		m.falias = SUBSTR(m.falias,1,LEN(TRIM(m.falias))-4)
	ENDIF
ENDIF
IF PARAMETERS() < 4
	m.extension = 'DBF'
ENDIF

m.sele = SELECT()

IF USED((m.falias))
	SELECT (m.falias)
	SET ORDER TO 0
ELSE
	SELECT 0
	IF ATC('.',m.fname) = 0
		m.dbf = m.fname + '.'+m.extension
	ELSE
		m.dbf = m.fname
	ENDIF
	IF NOT FILE((m.dbf))
		m.file =GETFILE(m.extension,"Where is "+m.dbf+'?')
	ELSE
		m.file = m.dbf
	ENDIF
	IF EMPTY(m.file)
		RETURN .F.
	ELSE
		USE (m.file) AGAIN ALIAS (m.falias) ORDER 0
	ENDIF
ENDIF
IF PARAMETERS() > 2
	IF m.nosele
		SELECT (m.sele)
	ENDIF
ENDIF
RETURN .T.
