PARAMETERS m.zapGASP
PRIVATE m.csele,m.tsele,m.cnt;
	m.curpheight,m.curpwidth, ;
	m_error,m.infile,m.ok,;
	m.depth,m.effect,;
	m.topleft,m.botright,m.filemiss,;
	m.gaspdir,m.talkstat,;
	m.safeset,m.lmodifont,m.is_a_drop,m.delonly,m.curplat

IF NOT (_windows OR _mac)
	WAIT WINDOW "This is a Windows or Macintosh program only. Press any key." 
	RETURN
ENDIF
DO CASE
	CASE _windows
		m.curplat = 'WINDOWS'
	CASE _mac
		m.curplat = 'MAC'
	OTHERWISE
		m.curplat = 'UNKNOWN'
ENDCASE
IF SET("TALK") = "ON"
	SET TALK OFF
	m.talkstat = "ON"
ELSE
	m.talkstat = "OFF"
ENDIF
m.delonly = .F.					&&default is to not DELETE ONLY
IF PARAMETERS() > 0
	IF m.zapGASP = 'DELETE'		&&allow for more parameters later...
		m.delonly = .T.
	ENDIF
ENDIF
m.safeset = SET("SAFETY")
SET SAFETY OFF  				&&for zap of scx...
*==================================================================
*NOTE!!! If you want to change the gasp directory from sys(2004)
*this is one of the places you'll need to alter the code
*
m.gaspdir = SYS(2004)			&&foxprow startup directory
*
*==================================================================
*Initialize some private vars
m.depth = 0						
m.curpwidth = 0
m.curpheight = 0
m.csele = SELECT()
m.infile = WONTOP()
IF VAL(m.infile) > 0
	?? CHR(7)
	WAIT WINDOW "GASP can't process screens that start with numbers. "+;
		" <sorry>. Rename and try again."
*This is a Foxpro thing. You can't DEFINE WINDOW with a leading number,
*but the SCX can be named one.
*WONTOP() still works OK, but RELEASE WINDOW won't.
*
	RETURN
ENDIF
m.ans=alert4("Save changes to the SCX?")
IF m.ans = 1	&&Means they responded YES to the alert.
	* If they said YES, stuff the keyboard with two Y's to catch
	* both built-in alerts (save changes and save environment
	*
	KEYBOARD "YY"	
ELSE
	?? CHR(7)
	WAIT WINDOW "GASP has to close the SCX in order to process. Press any key"
	RETURN
ENDIF
DO WHILE WONTOP() = m.infile
	WAIT WINDOW NOWAIT "Closing all windows named "+WONTOP()+"..."
	RELEASE WINDOW (m.infile)
ENDDO
CLEAR TYPEAHEAD  &&get rid of the Y's if we don't need them anymore..
WAIT CLEAR
=topen(m.gaspdir+'gasppref','gasppref')  &&Open the gasppref table
SELE 0
m.tsele = SELECT()
m.ok = .T.

m_error = ON('ERROR')
ON ERROR m.ok = .F.
IF NOT EMPTY(TRIM(gasppref.subdirect))
	m.scxopen = TRIM(gasppref.subdirect)+'\'+m.infile
ELSE
	m.scxopen = m.infile
ENDIF
USE (m.scxopen) ALIAS gaspscx EXCLUSIVE
ON ERROR &m_error

* User could have pressed NO, yielding ERROR 3
* or, it might be a new SCX
m.filemiss = .F.
IF NOT FILE((m.scxopen))  &&no objects were on - blank screen or in subdirectory
	DO setnew	&&m.filemiss turns true if new screen was added
ELSE
	m.filemiss = .F.
ENDIF

IF NOT m.ok AND NOT m.filemiss
	IF ERROR() = 1
		?? CHR(7)
		WAIT WINDOW "GASP can't locate the screen."
	ENDIF
	WAIT WINDOW NOWAIT "GASP cancelled..."
	SELECT (m.csele)
	RETURN	&&Early Exit
ENDIF
*Gasppref.warnings is a preference item that isn't fully implemented.
*permanently set to .T. for now. You could change it manually if you 
*wanted.

IF gasppref.warnings AND gasppref.fieldfx = 'Drop Shadow'
	WAIT WINDOW "Drop shadows cause grouping to be removed... Press any key."
	*Have to get the shadows up to top, which will mess up
	*object type 10 grouping records. If you get tired of this message,
	*just change GASPPREF.WARNINGS (manually) to be .F.
	*I was reluctant to do that on the preferences screen...seemed like
	*an easy way to confuse folks. This the only destructive action
	*that GASP ever takes.
ENDIF

DO heads.spr			&&Just a logo screen
SELECT gaspscx
IF gasppref.clearall OR m.delonly
	WAIT WINDOW NOWAIT "Removing previous GASP objects..."
	DELETE FOR ATC(';;GASP',comment) > 0
	WAIT CLEAR
ENDIF
** environment means CLEAR environment here, opposite SCX meaning
IF gasppref.environ AND NOT (m.delonly)
	DELETE FOR objtype > 1 AND objtype < 5	&&enviroment records
ENDIF
PACK
WAIT CLEAR
SELE gaspscx
IF m.delonly		&&bail out here for REMOVE ALL GASP menu...
	RELEASE WINDOW wheads
	USE IN gaspscx
	USE IN gasppref
	SELECT (m.csele)
	MODIFY SCREEN (m.scxopen) NOWAIT
	IF m.talkstat = "ON"
		SET TALK ON
	ENDIF
	IF m.safeset = "ON"
		SET SAFETY ON
	ELSE
		SET SAFETY OFF
	ENDIF
	RETURN			&&EARLY EXIT!
ENDIF

GO TOP
* Don't change screen font if there are objects
* (have to recalc location before and after for all
* records that don't have font information)
IF RECCOUNT() < 2 AND gasppref.modifont
	m.lmodifont = .T.
ELSE
	m.lmodifont = .F.
ENDIF
DO scxpref1		&&knock in the default pref checkboxes and such
s_fontface = TRIM(gaspscx.fontface)
s_fontsize = gaspscx.fontsize
s_fontstyle = gaspscx.fontstyle
s_foxrow = FONTMETRIC(1,s_fontface,s_fontsize,cvtstyle(s_fontstyle));
	+FONT(5,s_fontface,s_fontsize,cvtstyle(s_fontstyle))
s_foxcol = FONTMETRIC(6,s_fontface,s_fontsize,cvtstyle(s_fontstyle))
DO scxpref2	&&set grid to above sizes if requested...
m.is_a_drop = .F.
SCAN FOR platform = m.curplat ;
		AND ATC(';;NOT',comment) = 0 ;
		AND ATC(';;GASP',comment) = 0
		*type 7 with a non-zero style is an oval/circle
		*we're avoiding those for now.
		*
	IF 	(gaspscx.objtype = 7 AND gaspscx.style = 0 );
		 OR gaspscx.objtype = 15  &&might add more objects later
		*ATC() finds the FIRST occurence only - which is why
		*multiple ;;'s are ignored if they conflict.
		DO CASE
			CASE ATC(';;R',comment) > 0
				m.effect = 'R'
			CASE ATC(';;S',comment) > 0
				m.effect = 'S'
			CASE ATC(';;D',comment) > 0
				m.effect = 'D'
			OTHERWISE
				m.effect = ''
		ENDCASE
		IF EMPTY(m.effect)
			DO CASE
				CASE gaspscx.objtype = 7  &&box, no ovals!
					m.effect = SUBSTR(gasppref.boxfx,1,1)
				CASE gaspscx.objtype = 15 &&field
					m.effect = SUBSTR(gasppref.fieldfx,1,1)
			ENDCASE
		ENDIF
		IF ATC(';;X',comment) > 0
			m.depth = VAL(SUBSTR(gaspscx.comment,;
				ATC(';;X',gaspscx.comment)+3,1))
			IF m.depth < 1 OR m.depth > 9
				m.depth = 1
			ENDIF
		ELSE
			DO CASE
				CASE gaspscx.objtype = 15
					m.depth = gasppref.fielddepth
				CASE gaspscx.objtype = 7
					m.depth = gasppref.boxdepth
				OTHERWISE
					m.depth = 1
			ENDCASE
		ENDIF
		IF m.effect <> 'P'  &&plain
			IF m.effect = 'D'
				m.is_a_drop = .T.	&&this means we'll have to sort the output
				DO dropshadow
			ELSE
				DO add3d
			ENDIF
		ENDIF
	ENDIF
	SELE gaspscx
	m.depth = 0 &&reset so defaults kick in...
ENDSCAN
RELEASE WINDOW wheads
DO sortscx
USE IN gaspscx
USE IN gasppref
SELECT (m.csele)
MODIFY SCREEN (m.scxopen) NOWAIT  &&reopen the SCX file
*--------------------------Clean up
IF m.talkstat = "ON"
	SET TALK ON
ENDIF
IF m.safeset = "ON"
	SET SAFETY ON
ELSE
	SET SAFETY OFF
ENDIF

*--------------------------END OF MAINLINE


PROCEDURE sortscx
PRIVATE m.sortfile,m.sortdrops
m.sortfile = 'G'+SUBSTR(SYS(3),1,7)		&&have to chop it down for auto alias
m.sortdrops = 'D'+SUBSTR(SYS(3),1,7)		&&have to chop it down for auto alias
IF m.is_a_drop		&&some drop shadows to process
	SELECT * ;
		FROM (m.scxopen);
		INTO TABLE (m.sortdrops);
		WHERE ATC('DROPSHADOW',comment) > 0
	SELECT * ;
		FROM (m.scxopen);
		INTO TABLE (m.sortfile);
		ORDER BY platform DESCENDING
	SELE gaspscx
	ZAP
	APPEND FROM (m.sortfile) FOR objtype <= 4 AND platform = m.curplat
	APPEND FROM (m.sortdrops)
	APPEND FROM (m.sortfile) FOR objtype > 4;
		AND ATC('DROPSHADOW',comment) = 0 AND platform = m.curplat;
		AND objtype <> 10
	APPEND FROM (m.sortfile) FOR platform = 'DOS'  &&have to upgrade later for Mac & Unix!
	USE IN (m.sortfile)
	DELETE FILE m.sortfile+".dbf"
	DELETE FILE m.sortfile+".fpt"
	USE IN (m.sortdrops)
	DELETE FILE m.sortdrops+".dbf"
	DELETE FILE m.sortdrops+".fpt"
ELSE
	SELECT * ;
		FROM (m.scxopen) ;
		INTO TABLE (m.sortfile);
		ORDER BY platform DESCENDING
	SELE gaspscx
	ZAP
	APPEND FROM (m.sortfile)
	USE IN (m.sortfile)
	DELETE FILE m.sortfile+".dbf"
	DELETE FILE m.sortfile+".fpt"
ENDIF
RETURN

PROCEDURE dropshadow
PRIVATE m.pixheight,m.pixwidth,m.tvpos,m.thpos,m.rec,m.targid
m.targid = gaspscx.uniqueid
m.rec = RECNO()  &&where we are now

m.tvpos = gaspscx.vpos
m.thpos = gaspscx.hpos
m.pixwidth = gaspscx.width * ;
	FONT(6,gaspscx.fontface,gaspscx.fontsize,cvtstyle(gaspscx.fontstyle))
m.pixheight = gaspscx.height*;
	(FONT(1,gaspscx.fontface,gaspscx.fontsize,cvtstyle(gaspscx.fontstyle))+;
	FONT(5,gaspscx.fontface,gaspscx.fontsize,cvtstyle(gaspscx.fontstyle)))
SCATTER MEMO MEMVAR BLANK
APPEND BLANK
m.vpos = m.tvpos + (m.depth/s_foxrow)
m.hpos = m.thpos + (m.depth/s_foxcol)
IF gasppref.readborder
	m.height = (m.pixheight/s_foxrow) + (2/s_foxrow)
	m.width = (m.pixwidth/s_foxcol) + (5/s_foxcol)
ELSE
	m.height = (m.pixheight/s_foxrow)
	m.width = (m.pixwidth/s_foxcol)
ENDIF
m.pensize = 1
m.penpat = 8
m.fillpat = 1
m.mode = 1
m.objtype = 7
m.objcode = 4
m.style = 0
m.platform = m.curplat
m.comment = SUBSTR(m.curplat,1,3)+'OBJ;;GASP;;UID'+m.targid+';;DROPSHADOW'
IF m.vpos < 0
	m.vpos = 0
ENDIF
IF m.hpos < 0
	m.hpos = 0
ENDIF
GATHER MEMO MEMVAR
=setcolors(m.effect,'')
SELE gaspscx
GOTO m.rec
RETURN


PROCEDURE add3d
PRIVATE m.tvpos,m.thpos,m.twidth,m.height,m.rec,m.pixwidth,m.pixheight,;
	m.cnt
IF gaspscx.objtype = 15 && a field - not a box...
	m.tvpos = gaspscx.vpos - (1/s_foxrow)
	m.thpos = gaspscx.hpos - (1/s_foxcol)
	m.pixwidth = gaspscx.width * ;
		FONT(6,gaspscx.fontface,gaspscx.fontsize,cvtstyle(gaspscx.fontstyle))
	m.twidth = m.pixwidth / s_foxcol + (2/s_foxcol)
	m.pixheight = gaspscx.height*;
		(FONT(1,gaspscx.fontface,gaspscx.fontsize,cvtstyle(gaspscx.fontstyle))+;
		FONT(5,gaspscx.fontface,gaspscx.fontsize,cvtstyle(gaspscx.fontstyle)))
	m.theight = m.pixheight/ s_foxrow + (1/s_foxrow)
	m.tbvpos = m.tvpos + m.theight + (1/s_foxrow)
ELSE
	m.tvpos = gaspscx.vpos
	m.thpos = gaspscx.hpos
	*  pixwidth is set by screen font for boxes - no need to convert to local font.
	m.twidth = gaspscx.width
	m.theight = gaspscx.height
	m.tbvpos = m.tvpos + m.theight
ENDIF
SELE gaspscx
m.targid = gaspscx.uniqueid
m.rec = RECNO()  &&where we are now
*Left-------------------------------------------------------------------------------------------------------
FOR m.cnt = 0 TO (m.depth -1)
	SCATTER MEMO MEMVAR BLANK
	APPEND BLANK
	m.vpos = m.tvpos -(m.cnt/s_foxrow)
	m.hpos = m.thpos - (m.cnt/s_foxcol)
	m.height = m.theight+ ((2*m.cnt)/s_foxrow)
	m.width = (1/s_foxcol)
	m.pensize = 1
	m.penpat = 8
	m.objtype = 6
	m.objcode = 0
	m.style = 0
	m.platform = m.curplat
	m.comment = SUBSTR(m.platform,1,3)+'OBJ;;GASP;;UID'+m.targid+';;'
	IF m.vpos < 0
		m.vpos = 0
	ENDIF
	IF m.hpos < 0
		m.hpos = 0
	ENDIF
	GATHER MEMO MEMVAR
	=setcolors(m.effect,'NW')
ENDFOR
*---------------------------------------------------------
*RIGHT
FOR m.cnt = 0 TO (m.depth - 1)
	SCATTER MEMO MEMVAR BLANK
	APPEND BLANK
	m.vpos = m.tvpos - (m.cnt/s_foxrow)
	m.hpos = m.thpos + m.twidth  + ((m.cnt-1)/s_foxcol)
	m.height = m.theight + ((2*m.cnt)/s_foxrow)
	m.width = (1/s_foxcol)
	m.pensize = 1
	m.penpat = 8
	m.objtype = 6
	m.objcode = 0
	m.style = 0
	m.platform = m.curplat
	m.comment = SUBSTR(m.platform,1,3)+'OBJ;;GASP;;UID'+m.targid+';;'
	IF m.vpos < 0
		m.vpos = 0
	ENDIF
	IF m.hpos < 0
		m.hpos = 0
	ENDIF

	GATHER MEMO MEMVAR
	=setcolors(m.effect,'SE')
ENDFOR
*bottom---------------------------------------------------------------
FOR m.cnt = 0 TO (m.depth - 1)
	SCATTER MEMO MEMVAR BLANK
	SELE gaspscx
	APPEND BLANK
	m.vpos = m.tbvpos - ((1-m.cnt)/s_foxrow)
	m.hpos = m.thpos - (m.cnt/s_foxcol)
	m.width = m.twidth + ((m.cnt*2)/s_foxcol)
	m.height = (1/s_foxrow)
	m.pensize = 1
	m.penpat = 8
	m.objtype = 6
	m.objcode = 0
	m.style = 1
	m.platform = m.curplat
	m.comment = SUBSTR(m.platform,1,3)+'OBJ;;GASP;;UID'+m.targid+';;'
	IF m.vpos < 0
		m.vpos = 0
	ENDIF
	IF m.hpos < 0
		m.hpos = 0
	ENDIF

	GATHER MEMO MEMVAR
	=setcolors(m.effect,'SE')
ENDFOR
*top-----------------------------------------------------------------------------
FOR m.cnt = 0 TO (m.depth -1)
	SCATTER MEMO MEMVAR BLANK
	APPEND BLANK
	m.vpos = m.tvpos - (m.cnt/s_foxrow)
	m.hpos = m.thpos -(m.cnt/s_foxcol)
	m.width = m.twidth + ((2*m.cnt)/s_foxcol)
	m.height = (1/s_foxrow)
	m.pensize = 1
	m.penpat = 8
	m.objtype = 6
	m.objcode = 0
	m.style = 1
	m.platform = m.curplat
	m.comment = SUBSTR(m.curplat,1,3)+'OBJ;;GASP;;UID'+m.targid+';;'
	IF m.vpos < 0
		m.vpos = 0
	ENDIF
	IF m.hpos < 0
		m.hpos = 0
	ENDIF

	GATHER MEMO MEMVAR
	=setcolors(m.effect,'NW')
ENDFOR
*------------------------------------------------------------------------------------
SELE gaspscx
GOTO m.rec
RETURN
* END OF PROCEDURE ADD3D

PROCEDURE setcolors
PARAMETERS m.effect,m.location
PRIVATE m.red,m.green,m.blue
DO CASE
	CASE m.effect = 'S' AND m.location = 'NW'	&&Sunken, North West
		m.red 		= gasppref.darkred
		m.green	= gasppref.darkgreen
		m.blue		= gasppref.darkblue
	CASE m.effect = 'S' AND m.location = 'SE'	&&Sunken, South East
		m.red 		= gasppref.lightred
		m.green	= gasppref.lightgreen
		m.blue		= gasppref.lightblue
	CASE m.effect = 'R' AND m.location = 'NW'	&&Raised, North West
		m.red 		= gasppref.lightred
		m.green	= gasppref.lightgreen
		m.blue		= gasppref.lightblue
	CASE m.effect = 'R' AND m.location = 'SE'	&&Raised, South East
		m.red 		= gasppref.darkred
		m.green	= gasppref.darkgreen
		m.blue		= gasppref.darkblue
	CASE m.effect = 'D' AND m.location = '' 	&&Drop Shadow (location fixed)
		m.red = gasppref.darkred
		m.green = gasppref.darkgreen
		m.blue = gasppref.darkblue
	OTHERWISE
		m.red = 20
		m.green = 20
		m.blue = 20
ENDCASE
REPLACE 	gaspscx.fillred WITH m.red,;
	gaspscx.fillblue WITH m.blue,;
	gaspscx.fillgreen WITH m.green,;
	gaspscx.penred WITH m.red,;
	gaspscx.penblue WITH m.blue,;
	gaspscx.pengreen WITH m.green
RETURN


PROCEDURE scxpref1
SCATTER MEMO MEMVAR
IF gasppref.modibgrnd
	m.fillred = gasppref.backred
	m.fillgreen = gasppref.backgreen
	m.fillblue = gasppref.backblue
	m.penred = -1
	m.penblue = -1
	m.pengreen = -1
ENDIF
IF gasppref.rulertopix
	m.ruler = 3
ENDIF

m.environ = NOT(gasppref.environ)

IF gasppref.rulerlines
	m.rulerlines = 1
ELSE
	m.rulerlines = 0
ENDIF
IF gasppref.gridon
	m.grid = .T.
ELSE
	m.grid = .F.
ENDIF
IF gasppref.showpos
	m.curpos = .T.
ELSE
	m.curpos = .F.
ENDIF

IF m.lmodifont
	m.curpwidth = gaspscx.width * ;
		FONT(6,gaspscx.fontface,gaspscx.fontsize,cvtstyle(gaspscx.fontstyle))
	m.curpheight = gaspscx.height*;
		(FONT(1,gaspscx.fontface,gaspscx.fontsize,cvtstyle(gaspscx.fontstyle))+;
		FONT(5,gaspscx.fontface,gaspscx.fontsize,cvtstyle(gaspscx.fontstyle)))
	m.fontface = gasppref.fontface
	m.fontsize = gasppref.fontsize
	m.fontstyle = gasppref.fontstyle
ENDIF
GATHER MEMO MEMVAR
RETURN

PROCEDURE scxpref2
SCATTER MEMO MEMVAR
IF m.lmodifont		&&if the font was altered, recalc screen size
	m.width = m.curpwidth /s_foxcol
	m.height = m.curpheight/s_foxrow
ENDIF
IF gasppref.gridtofont
	m.gridv = s_foxrow
	IF m.gridv > 99
		m.gridv = 99
	ENDIF
	m.gridh = s_foxcol
	IF m.gridh > 99
		m.gridh =99
	ENDIF
ENDIF
GATHER MEMO MEMVAR
RETURN



PROCEDURE setnew
PRIVATE m.ans
m.ans = alert4("Make new screen with GASP defaults in ";
	+SYS(2003)+"\"+TRIM(gasppref.subdirect)+" ?")
IF m.ans = 1
	=topen(m.gaspdir+'gaspsrc.scx','GASPSRC')  &&BLANK SCREEN - RECORD HEADER ONLY
	IF NOT EMPTY(TRIM(gasppref.subdirect))
		m.newscx = TRIM(gasppref.subdirect)+m.infile
	ELSE
		m.newscx = m.infile
	ENDIF
	COPY TO (m.newscx)
	SELECT (m.tsele)
	USE (m.newscx) ALIAS gaspscx EXCLUSIVE  &&didn't exist, or was still open
	m.filemiss =.T.
ELSE
	WAIT WINDOW "Select the proper SCREENS SUBDIRECTORY in preferences. Press any key."
ENDIF
RETURN
