* -- PROGRAM NAME: .......... CI_FUVAL.PRG
* -- PROGRAM TITLE: ......... Compound Interest: Future Value
* -- AUTHOR: ................ Venkat Penugonde, Irvine Micro Arts, Irvine, CA
* -- DATE FIRST CREATED .............. 05/10/86
* -- DATE MOST RECENTLY MODIFIED .....
*
*  This program calculates the future value and the interest amount paid in a
*   compound interest calculation given the following:
*
*    principal =  Present value or principal
*    ann_rate  =  Nominal annual interest rate in %
*    y_period  =  Number of compounding periods per year
*    t_period  =  Total number of time periods
*
SET TALK OFF
CLEAR
 principal = 0.00
 ann_rate  = 0.00
 y_period  = 0
 t_period  = 0
*
@  2, 17 SAY '            COMPOUND INTEREST'
@  3, 17 SAY '              FUTURE VALUE'
@  5, 17 SAY 'PRINCIPAL [enter zero to exit]: . '
@  7, 17 SAY 'ANNUAL INTEREST RATE [in % ]: ... '
@  9, 17 SAY 'COMPOUNDING PERIODS PER YEAR: ... '
@ 11, 17 SAY 'NUMBER OF COMPOUNDING PERIODS: .. '
*
DO WHILE .t.
 @ 5, 51 GET principal
 READ
 IF principal <= 0
   EXIT
  ELSE
   @  7, 51 GET ann_rate
   @  9, 51 GET y_period
   @ 11, 51 GET t_period
   READ
 ENDIF
 * ----- Compute interest rate per period
 int_rate = ann_rate/y_period
  *
 * ----- Compute final value at the end of total period
 m_old = principal
 n = 1
 DO WHILE  n <= t_period
   m_new = m_old*(1 + int_rate/100)
   m_old = m_new
   n = n + 1
 ENDDO WHILE n <= t_period
 *
 int_amount = m_new - principal
 @ 15, 17 SAY 'Future Value -->             ' + STR(m_new, 10 ,2)
 @ 17, 17 SAY 'Amount Paid as Interest -->  ' + STR(int_amount, 10, 2)
 *
ENDDO WHILE .t.
RETURN
* -- EOF CI_FUVAL