*       ķ
*                                                                
*        03/20/92            DBFSELEC.PRG               09:16:44 
*                                                                
*       Ķ
*                                                                
*        Author's Name                                           
*                                                                
*        Copyright (c) 1992 Company Name                         
*        Address                                                 
*        City,     Zip                                           
*                                                                
*        Description:                                            
*        This program was automatically generated by GENSCRN.    
*                                                                
*       Ľ


#REGION 0
REGIONAL m.currarea, m.talkstat, m.compstat

IF SET("TALK") = "ON"
	SET TALK OFF
	m.talkstat = "ON"
ELSE
	m.talkstat = "OFF"
ENDIF
m.compstat = SET("COMPATIBLE")
SET COMPATIBLE FOXPLUS

*       ķ
*                                                                
*                           Window definitions                   
*                                                                
*       Ľ
*

IF NOT WEXIST("dbfselec")
	DEFINE WINDOW dbfselec ;
		FROM INT((SROW()-17)/2),INT((SCOL()-36)/2) ;
		TO INT((SROW()-17)/2)+16,INT((SCOL()-36)/2)+35 ;
		TITLE " Related Databases " ;
		FLOAT ;
		NOCLOSE ;
		SHADOW ;
		DOUBLE ;
		COLOR SCHEME 5
ENDIF

IF NOT WEXIST("_q440jvysz")
	DEFINE WINDOW _q440jvysz ;
		FROM INT((SROW()-11)/2),INT((SCOL()-40)/2) ;
		TO INT((SROW()-11)/2)+10,INT((SCOL()-40)/2)+39 ;
		FLOAT ;
		NOCLOSE ;
		SHADOW ;
		DOUBLE ;
		COLOR SCHEME 5
ENDIF


*       ķ
*                                                                
*                    DBFSELEC Setup Code - SECTION 2             
*                                                                
*       Ľ
*

#REGION 1
* Save the databases, etc. that are open so that we can restore
* the environment properly if the user opens a lot of databases
* (by adding them to the relations) and then presses cancel.
CREATE VIEW dbfselec.vue

IF TYPE('DBFLIST') = 'U'
   IF m.nextdbf = 0

      DO initdbflist

      * Default main database to the one that is currently open
      IF !EMPTY(ALIAS())
         dbflist[1,m.cstemnum] = ALIAS()
         dbflist[1,m.cdbfnum]  = FULLPATH(DBF())
         m.nextdbf = 2
      ELSE
         * If none currently open (shouldn't happen), prompt for one
         m.newdbf = GETFILE("DBF","Database to open:")
         IF !EMPTY(m.newdbf)
            dbflist[1,m.cstemnum] = juststem(m.newdbf)
            dbflist[1,m.cdbfnum] = m.newdbf

            IF USED(dbflist[1,m.cstemnum])
               SELECT (dbflist[1,m.cstemnum])
            ELSE
               SELECT 0
               USE (m.newdbf)
            ENDIF
         ELSE
            RETURN
         ENDIF
         m.nextdbf = 1
      ENDIF
      m.dbfselec = 1
   ENDIF
ELSE   && figure out which is the next available DBFlist slot
   FOR i = 1 TO m.numareas
      IF EMPTY(dbflist[i,m.cstemnum]) OR dbflist[i,m.cstemnum] = '\'
         m.nextdbf = i
         EXIT
      ENDIF
   ENDFOR
ENDIF

* Store the current dbflist in "origdbflist" so that we can restore it
* if "cancel" is pressed.  Also store the current "nextdbf" value.
RELEASE origdbflist                        && if it already exists
PUBLIC origdbflist[m.numareas,m.numcols]
=ACOPY(dbflist,origdbflist)
orignextdbf = nextdbf



*       ķ
*                                                                
*                    GETDEST Setup Code - SECTION 2              
*                                                                
*       Ľ
*

#REGION 2
skipvar = .T.
repbut = 1   && default button choice
repdest = SPACE(40)
okbut = 1


*       ķ
*                                                                
*                        DBFSELEC Screen Layout                  
*                                                                
*       Ľ
*

#REGION 1
IF WVISIBLE("dbfselec")
	ACTIVATE WINDOW dbfselec SAME
ELSE
	ACTIVATE WINDOW dbfselec NOSHOW
ENDIF
@ 0,1 GET dbfselec ;
	PICTURE "@&N" ;
	FROM dbflist ;
	SIZE 14,16 ;
	DEFAULT 1 ;
	WHEN _q440jvz5n() ;
	VALID _q440jvz95() ;
	COLOR SCHEME 6
@ 1,22 GET addclr ;
	PICTURE "@*VN \<Add;C\<lear" ;
	SIZE 1,10,1 ;
	DEFAULT 1 ;
	VALID _q440jvzf6()
@ 11,22 GET okbut ;
	PICTURE "@*VT \!\<OK;\?\<Cancel" ;
	SIZE 1,10,1 ;
	DEFAULT 1 ;
	VALID _q440jvzwt()
@ 5,22 TO 5,31
@ 7,22 GET arrange ;
	PICTURE "@*HN A\<rrange" ;
	SIZE 1,10,1 ;
	DEFAULT 1 ;
	VALID _q440jw038()
@ 9,22 TO 9,31
@ 14,4 GET tree1 ;
	PICTURE "@*HN \<Show Tree" ;
	SIZE 1,11,1 ;
	DEFAULT 1 ;
	VALID _q440jw0q9()




*       ķ
*                                                                
*                         GETDEST Screen Layout                  
*                                                                
*       Ľ
*

#REGION 2
IF WVISIBLE("_q440jvysz")
	ACTIVATE WINDOW _q440jvysz SAME
ELSE
	ACTIVATE WINDOW _q440jvysz NOSHOW
ENDIF
@ 1,13 GET repbut ;
	PICTURE "@*RVN \<Screen;\<Printer;\<File" ;
	SIZE 1,11,0 ;
	DEFAULT 1 ;
	VALID _q440jw0wi()
@ 4,9 GET repdest ;
	SIZE 1,28 ;
	DEFAULT " " ;
	VALID _q440jw0zx()
@ 6,13 GET okbut ;
	PICTURE "@*VT \!\<OK" ;
	SIZE 1,10,1 ;
	DEFAULT 1
@ 0,9 SAY "Report destination:"
@ 8,13 GET canclbut ;
	PICTURE "@*HT \?\<Cancel" ;
	SIZE 1,10,1 ;
	DEFAULT 1
@ 4,2 GET rfile ;
	PICTURE "@*HN \<File" ;
	SIZE 1,6,1 ;
	DEFAULT 1

IF NOT WVISIBLE("_q440jvysz")
	ACTIVATE WINDOW _q440jvysz
ENDIF
IF NOT WVISIBLE("dbfselec")
	ACTIVATE WINDOW dbfselec
ENDIF


READ CYCLE MODAL ;
	ACTIVATE _q440jw0v5() ;
	DEACTIVATE _q440jw14p() ;
	SHOW _q440jw0v8()

RELEASE WINDOW _q440jvysz
RELEASE WINDOW dbfselec

#REGION 0
IF m.talkstat = "ON"
	SET TALK ON
ENDIF
IF m.compstat = "ON"
	SET COMPATIBLE ON
ENDIF


*       ķ
*                                                                
*                         DBFSELEC Cleanup Code                  
*                                                                
*       Ľ
*

#REGION 1
* Get rid of the tree window if it is still around
IF WEXIST('treewind')
   RELEASE WINDOW treewind
ENDIF

*!*****************************************************************
*!
*!      Procedure: ARRSAVE
*!
*!*****************************************************************
PROCEDURE arrsave
* Save arrangement of windows and return to dbfselect screen

* Set exit flag for READ VALID
arrexflg = .T.

* Record window coordinates and release all the application windows
m.ctrlrow = WLROW('CTRL')
m.ctrlcol = WLCOL('CTRL')
RELEASE WINDOW ctrl

FOR i = 1 TO m.numareas
   IF !EMPTY(dbflist[i,m.cstemnum]) AND dbflist[i,m.cstemnum] <> '\'
      dbflist[i,m.srownum] = ALLTRIM(STR(WLROW(dbflist[i,m.cstemnum]),3))
      dbflist[i,m.scolnum] = ALLTRIM(STR(WLCOL(dbflist[i,m.cstemnum]),3))
      dbflist[i,m.erownum] = ;
         ALLTRIM(STR(VAL(dbflist[i,m.srownum]);
         +1+wrow(dbflist[i,m.cstemnum]),3))
      dbflist[i,m.ecolnum] = ;
         ALLTRIM(STR(VAL(dbflist[i,m.scolnum]);
         +1+wcol(dbflist[i,m.cstemnum]),3))
      RELEASE WINDOW (dbflist[i,m.cstemnum])
   ENDIF
   dbflist[i,m.arranged] = "Y"
ENDFOR

* Restore environment
POP MENU _msysmenu
SHOW WINDOW appgen, dbfselec
ACTIVATE WINDOW dbfselec

CLEAR READ

RETURN



*!*****************************************************************
*!
*!      Procedure: ARREXIT
*!
*!*****************************************************************
PROCEDURE arrexit
* Exit without saving window positions

* Set exit flag for READ VALID
arrexflg = .T.

* Release all the application windows
RELEASE WINDOW ctrl
FOR i = 1 TO m.numareas
   IF !EMPTY(dbflist[i,m.cstemnum]) AND dbflist[i,m.cstemnum] <> '\'
      RELEASE WINDOW (dbflist[i,m.cstemnum])
   ENDIF
ENDFOR

* Restore environment
POP MENU _msysmenu
SHOW WINDOW appgen, dbfselec
ACTIVATE WINDOW dbfselec

CLEAR READ

RETURN


*!*****************************************************************
*!
*!      Procedure: HASCHILD
*!
*!*****************************************************************
FUNCTION haschild
* Does the database at position "dbfnum" of DBFLIST have a child
* table?
parameter dbfnum
PRIVATE dbfnum, i

* See if another database has this one as its parent
FOR m.i = 1 TO m.numareas
   IF ALLTRIM(dbflist[m.i,m.pdbfnum]) ;
         == ALLTRIM(dbflist[m.dbfnum,m.cstemnum])
      RETURN .T.
   ENDIF
ENDFOR
RETURN .F.

*!*****************************************************************
*!
*!      Procedure: SHOWTREE
*!
*!*****************************************************************
PROCEDURE showtree
parameter dbfnum, indent
PRIVATE dbfnum, indent
* Recursive routine to display a tree diagram of database relationships.

* The window in which to display the tree must be activated before
* calling showtree.

* First display this database in its correct position on the tree.
IF WEXIST('treewind')
   treestr = SPACE(m.indent*3);
      +IIF(m.indent<>0,CHR(192)+CHR(196)+CHR(26),'');
      +dbflist[m.dbfnum,m.cstemnum]
   end_row = MIN(WLROW('treewind') + 2 + m.nextdbf, SROWS()-1)
   IF LEN(treestr) >= WCOLS() - 2
      s_col = WLCOL('treewind')
      * Move the window to the left if necessary
      IF s_col + LEN(treestr) + 3 >= SCOLS() - 3
         s_col = SCOLS() - LEN(treestr) - 6
      ENDIF
      ZOOM WINDOW treewind NORM ;
         FROM WLROW('treewind'),s_col TO end_row, s_col+LEN(treestr)+4
   ENDIF
   ? treestr
ELSE
   RETURN
ENDIF

* Find any children of this database and display them
FOR i = 1 TO m.numareas
   IF ALLTRIM(dbflist[m.i,m.pdbfnum]) ;
         == ALLTRIM(dbflist[m.dbfnum,m.cstemnum])
      DO showtree WITH i, indent + 1
   ENDIF
ENDFOR



*       ķ
*                                                                
*                         GETDEST Cleanup Code                   
*                                                                
*       Ľ
*

#REGION 2
skipvar = .F.


*       ķ
*                                                                
*        _Q440JVZ5N           dbfselec WHEN                      
*                                                                
*        Function Origin:                                        
*                                                                
*        From Screen:         DBFSELEC,     Record Number:    2  
*        Variable:            dbfselec                           
*        Called By:           WHEN Clause                        
*        Object Type:         List                               
*        Snippet Number:      1                                  
*                                                                
*       Ľ
*
FUNCTION _q440jvz5n     &&  dbfselec WHEN
#REGION 1
IF dbfselec = 0
   dbfselec = m.nextdbf - 1
   SHOW GET dbfselec
ENDIF

DO CASE
CASE dbfselec = 1
   SHOW GET addclr,2 DISABLE
CASE haschild(dbfselec)
   SHOW GET addclr,2 DISABLE
OTHERWISE
   SHOW GET addclr,2 ENABLE
ENDCASE


*       ķ
*                                                                
*        _Q440JVZ95           dbfselec VALID                     
*                                                                
*        Function Origin:                                        
*                                                                
*        From Screen:         DBFSELEC,     Record Number:    2  
*        Variable:            dbfselec                           
*        Called By:           VALID Clause                       
*        Object Type:         List                               
*        Snippet Number:      2                                  
*                                                                
*       Ľ
*
FUNCTION _q440jvz95     &&  dbfselec VALID
#REGION 1
DO CASE
CASE m.dbfselec = 0  && ignore a null selection
   * This shouldn't be possible because of the WHEN code,
   * but put the validation test in just to be sure.
   RETURN .F.
CASE m.dbfselec = 1
   WAIT WINDOW "Main database." NOWAIT
CASE m.dbfselec > 1
   m.newdbf     = dbflist[m.dbfselec,m.cstemnum]
   m.childfld   = dbflist[m.dbfselec,m.cfldnum]
   m.childdbf   = dbflist[m.dbfselec,m.cdbfnum]
   m.parentfld  = dbflist[m.dbfselec,m.pfldnum]
   m.igncase    = .T.
   m.relstr     = dbflist[m.dbfselec,m.relstrnum]
   m.parentdbf  = dbflist[m.dbfselec,m.pdbfnum]
   m.addmode    = .F.    && we're editing an existing one

   * Find out how this database relates to the other ones.
   * Relselec will return an empty "childfld" if cancel was
   * pressed.
   DO relselec.spr WITH m.newdbf, m.childdbf, m.childfld, m.parentfld, ;
      m.igncase, m.relstr, m.parentdbf, m.addmode
   IF !EMPTY(m.childfld)
      * Record data about this child DBF on the DBFLIST
      dbflist[m.dbfselec,m.cstemnum]  = juststem(m.newdbf)
      dbflist[m.dbfselec,m.relstrnum] = m.relstr
      dbflist[m.dbfselec,m.pfldnum]   = m.parentfld
      dbflist[m.dbfselec,m.cfldnum]   = m.childfld
      dbflist[m.dbfselec,m.cdbfnum]   = m.childdbf
      dbflist[m.dbfselec,m.pdbfnum]   = m.parentdbf
   ENDIF
ENDCASE


*       ķ
*                                                                
*        _Q440JVZF6           addclr VALID                       
*                                                                
*        Function Origin:                                        
*                                                                
*        From Screen:         DBFSELEC,     Record Number:    3  
*        Variable:            addclr                             
*        Called By:           VALID Clause                       
*        Object Type:         Push Button                        
*        Snippet Number:      3                                  
*                                                                
*       Ľ
*
FUNCTION _q440jvzf6     &&  addclr VALID
#REGION 1
DO CASE
CASE m.addclr = 1   && add another database to the pot
   IF m.nextdbf >= m.numareas
      WAIT WINDOW "There are no available work areas left." NOWAIT
      RETURN
   ENDIF

   * Only accept DBF files, unless user cancels
   m.newdbf = "XXX"   && any value other than blank or a DBF file
   DO WHILE !EMPTY(m.newdbf) AND justext(m.newdbf) <> 'DBF'
      m.newdbf = GETFILE('DBF','Database to open:')
   ENDDO

   IF !EMPTY(m.newdbf)
      * Check for duplicate DBF stem name
      FOR i = 1 TO m.numareas
         IF juststem(m.newdbf) == dbflist[i,m.cstemnum]
            WAIT WINDOW "Duplicate database names are not allowed." NOWAIT
            RETURN
         ENDIF
      ENDFOR

      m.childfld   = ""
      m.childdbf   = m.newdbf
      m.newdbf     = juststem(m.newdbf)
      m.parentfld  = ""
      m.igncase    = .T.
      m.relstr     = ""
      m.parentdbf  = ""

      * Find out how this database relates to the other ones.
      * Relselec will return an empty "childfld" if cancel was
      * pressed.
      DO relselec.spr WITH m.newdbf, m.childdbf, m.childfld, m.parentfld, ;
         m.igncase, m.relstr, m.parentdbf, .T.

      IF !EMPTY(m.childfld)  && true unless user cancelled RelSelec
         * Open the new child database
         IF USED(m.newdbf)
            SELECT (m.newdbf)
         ELSE
            SELECT 0
            USE (m.childdbf)
         ENDIF

         * See if we need to add a CDX or a tag on the relation field
         DO makecdx WITH (m.childdbf), (m.childfld)

         * Record data about this child DBF on the DBFLIST
         dbflist[m.nextdbf,m.cstemnum]  = juststem(m.newdbf)
         dbflist[m.nextdbf,m.relstrnum] = m.relstr
         dbflist[m.nextdbf,m.pfldnum]   = m.parentfld
         dbflist[m.nextdbf,m.cfldnum]   = m.childfld
         dbflist[m.nextdbf,m.cdbfnum]   = m.childdbf
         dbflist[m.nextdbf,m.pdbfnum]   = m.parentdbf

         * Come up with reasonable default positions for the database
         * browse window.  The "Arrange" option is how they will
         * usually be set.
         IF m.nextdbf > 2
            dbflist[m.nextdbf,m.srownum] ;
               = ALLTRIM(STR(VAL(dbflist[m.nextdbf-1,m.srownum])+1,3))
            dbflist[m.nextdbf,m.scolnum] ;
               = ALLTRIM(STR(VAL(dbflist[m.nextdbf,m.scolnum])+1,3))
         ELSE
            dbflist[m.nextdbf,m.srownum] = "1"
            dbflist[m.nextdbf,m.scolnum] = "1"
         ENDIF
         dbflist[m.nextdbf,m.erownum] ;
            = ALLTRIM(STR(VAL(dbflist[m.nextdbf,m.srownum])+5,3))
         dbflist[m.nextdbf,m.ecolnum] ;
            = ALLTRIM(STR(SCOLS()-1,3))

         m.nextdbf  = m.nextdbf + 1
         m.dbfselec = m.nextdbf - 1
         SHOW GET arrange ENABLE
         SHOW GET addclr,2 ENABLE    && enable the "Clear" button
      ENDIF
   ENDIF
CASE m.addclr = 2    && clear this dbf
   DO CASE
   CASE m.dbfselec = 0   && choice was invalid
      RETURN .F.
   CASE m.dbfselec = 1
      WAIT WINDOW "You cannot clear the main database." NOWAIT
      RETURN
   ENDCASE

   * See if this database has a child.  If so, don't allow it to be
   * cleared.  The clear button is also usually dimmed if the current
   * dbflist item has a child.
   IF haschild(m.dbfselec) AND !EMPTY(m.dbfselec)
      WAIT WINDOW "You cannot clear a database that has related databases." NOWAIT
      RETURN
   ENDIF

   * Clear the DBF, assuming we are pointed at a valid DBF name.
   IF !EMPTY(dbflist[m.dbfselec,m.cstemnum]) AND dbflist[m.dbfselec,m.cstemnum] <> '\'
      * Close the database, if it is open (it should be)
      IF USED((TRIM(dbflist[m.dbfselec,m.cstemnum])))
         SELECT (TRIM(dbflist[m.dbfselec,m.cstemnum]))
         USE
      ENDIF
      dbflist[m.dbfselec,m.cstemnum] = SPACE(25)
      DO CASE
      CASE m.nextdbf = 1                && no databases to close
      CASE m.dbfselec = m.nextdbf       && close the last one in the list
         m.nextdbf = m.nextdbf - 1
      OTHERWISE                         && close some other database
         = ADEL(dbflist,m.dbfselec)
         dbflist[m.numareas,m.cstemnum] = '\'  && disable this list item
         FOR i = 2 TO numcols
            dbflist[m.numareas,i] = ''
         ENDFOR
         m.nextdbf = m.nextdbf - 1
      ENDCASE
      m.dbfselec = m.nextdbf - 1

      SHOW GET dbfselec
   ENDIF
   IF m.nextdbf = 1
      SHOW GET arrange DISABLE
   ENDIF
ENDCASE
SHOW GETS


*       ķ
*                                                                
*        _Q440JVZWT           okbut VALID                        
*                                                                
*        Function Origin:                                        
*                                                                
*        From Screen:         DBFSELEC,     Record Number:    4  
*        Variable:            okbut                              
*        Called By:           VALID Clause                       
*        Object Type:         Push Button                        
*        Snippet Number:      4                                  
*                                                                
*       Ľ
*
FUNCTION _q440jvzwt     &&  okbut VALID
#REGION 1
IF okbut = 1
   IF relateddbfs()
      * Save the database relationships
      IF m.storersc
         * Tell user what is going on
         WAIT WINDOW "Saving database relations and window positions." NOWAIT

         DO putdbflist WITH dbflist[1,m.cstemnum]
      ENDIF

      WAIT CLEAR
   ENDIF
ELSE
   * Restore original DBFLIST array
   =ACOPY(origdbflist,dbflist)
   m.nextdbf = m.orignextdbf
   RELEASE origdbflist

   * Restore incoming environment
   IF FILE('dbfselec.vue')
      SET VIEW TO dbfselec.vue
   ENDIF
ENDIF

* Drop the view file
IF FILE('dbfselec.vue')
   DELETE FILE dbfselec.vue
ENDIF


*       ķ
*                                                                
*        _Q440JW038           arrange VALID                      
*                                                                
*        Function Origin:                                        
*                                                                
*        From Screen:         DBFSELEC,     Record Number:    6  
*        Variable:            arrange                            
*        Called By:           VALID Clause                       
*        Object Type:         Push Button                        
*        Snippet Number:      5                                  
*                                                                
*       Ľ
*
FUNCTION _q440jw038     &&  arrange VALID
#REGION 1
PUSH MENU _msysmenu

RELEASE arrexflg   && causes upcoming Foundation read to terminate
PUBLIC  arrexflg
arrexflg = .F.

tree_up = WVISIBLE('treewind')

HIDE WINDOW appgen, dbfselec
IF WEXIST('treewind')
   HIDE WINDOW treewind
ENDIF

* Set up "arrange" pad on main menu
DEFINE PAD arrange OF _msysmenu PROMPT "\<Arrange" KEY ALT+A,"" COLOR SCHEME 3
ON PAD arrange OF _msysmenu ACTIVATE POPUP arngpop

DEFINE POPUP arngpop MARGIN RELATIVE SHADOW COLOR SCHEME 4
DEFINE BAR 1 OF arngpop PROMPT "\<Save"
DEFINE BAR 2 OF arngpop PROMPT "\<Exit"

* Disable the Window and Edit pads while we're in Arrange
DEFINE PAD _mwindow OF _msysmenu PROMPT "\Window"
DEFINE PAD _medit OF _msysmenu PROMPT "\Edit"

ON SELECTION BAR 1 OF arngpop DO arrsave
ON SELECTION BAR 2 OF arngpop DO arrexit

* Save the screen and start the arranging from a blank screen
SAVE SCREEN TO arr_scrn
ACTIVATE SCREEN
CLEAR

* Define window for control panel
IF m.ctrlrow <> 1 OR m.ctrlcol <> 1
   DEFINE WINDOW ctrl ;
      FROM m.ctrlrow,m.ctrlcol TO m.ctrlrow+2,m.ctrlcol+72 ;
      TITLE "Control panel" ;
      GROW FLOAT NOZOOM NOCLOSE
ELSE
   DEFINE WINDOW ctrl FROM SROWS()-3,3 TO SROWS()-1,scol()-3 GROW FLOAT NOZOOM NOCLOSE ;
      TITLE "Control panel"
ENDIF
ACTIVATE WINDOW ctrl

* Figure out how wide the main database screen will be
IF EMPTY(m.scxname) OR !FILE(m.scxname)
   * If a screen hasn't been defined yet, look at the database fields
   SELECT (dbflist[1,m.cstemnum])
   m.maxlen  = 0
   m.maxheight = FCOUNT() + 4
   m.maxcapt = 0
   FOR i = 1 TO FCOUNT()
      m.maxlen  = MAX(m.maxlen,FSIZE(FIELD(i)))  && max field length
      m.maxcapt = MAX(m.maxcapt,LEN(FIELD(i))+2) && max field name length
   ENDFOR
   m.maxlen = m.maxlen + m.maxcapt + 4   && allow for borders
ELSE         && otherwise, look to the SCX itself
   SELECT 0
   USE (scxname) AGAIN ALIAS fxscxnme
   maxlen    = fxscxnme->WIDTH
   maxheight = fxscxnme->HEIGHT
   USE
ENDIF

* Determine position for main database window and define window
DO CASE
CASE UPPER(dbflist[1,m.arranged]) = "N"
   * No screen position yet defined for the main database.  Center it,
   * unless there are lots of related databases.  If there are, put
   * it closer to the top of the screen.
   IF m.nextdbf < 3
      start_row = SROWS()/2-m.maxheight/2
      end_row   = m.start_row + m.maxheight - 1
      start_col = SCOLS()/2-m.maxlen/2
      end_col   = m.start_col + m.maxlen - 1
   ELSE
      start_row = 1
      end_row   = m.start_row + m.maxheight - 1
      start_col = SCOLS()/2-m.maxlen/2
      end_col   = m.start_col + m.maxlen - 1
   ENDIF
OTHERWISE   && show it where the user put it last
   start_row = VAL(dbflist[1,m.srownum])
   end_row   = m.start_row + m.maxheight - 1
   start_col = VAL(dbflist[1,m.scolnum])
   end_col   = m.start_col + m.maxlen - 1
ENDCASE

* Define the blank window for the main database
DEFINE WINDOW (dbflist[1,m.cstemnum]) ;
   FROM m.start_row,m.start_col TO m.end_row,m.end_col ;
   TITLE dbflist[1,m.cstemnum] ;
   NOGROW FLOAT NOZOOM NOCLOSE ;
   COLOR SCHEME 1

* Define windows for child databases
FOR i = 2 TO m.numareas
   IF !EMPTY(dbflist[i,m.cstemnum]) AND dbflist[i,m.cstemnum] <> '\'
      IF dbflist[i,m.arranged] = "N"
         * Try to place browse windows immediately beneath main screen
         win_height = 6   && minimum height of a BROWSE window
         IF end_row + (i-2)*(m.win_height+1) + 2 < SROWS() - 3
            ws_row = m.end_row + (i-2)*(m.win_height+1) + 2
            ws_col = 1
            we_row = m.ws_row + m.win_height - 1
            we_col = SCOLS()-2
         ELSE     && put the browse windows in the upper left of the screen
            ws_row = i
            ws_col = i
            we_row = MIN(m.ws_row+m.win_height,SROWS())
            we_col = SCOLS()-1
         ENDIF
      ELSE
         ws_row = VAL(dbflist[i,m.srownum])
         ws_col = VAL(dbflist[i,m.scolnum])
         we_row = VAL(dbflist[i,m.erownum])
         we_col = VAL(dbflist[i,m.ecolnum])
      ENDIF
      DEFINE WINDOW (dbflist[i,m.cstemnum]) ;
         FROM m.ws_row,m.ws_col TO m.we_row,m.we_col ;
         SYSTEM ;
         TITLE dbflist[i,m.cstemnum] ;
         GROW FLOAT NOZOOM NOCLOSE ;
         COLOR SCHEME 10
      ACTIVATE WINDOW (dbflist[i,m.cstemnum])
   ENDIF
ENDFOR

* Activate the main window
ACTIVATE WINDOW (dbflist[1,m.cstemnum])

* The read terminates when the user selects "Save" or "Exit" from the menu
READ VALID m.arrexflg

IF tree_up AND WEXIST('treewind')
   SHOW WINDOW treewind
ENDIF
RELEASE arrexflg

RESTORE SCREEN FROM arr_scrn


*       ķ
*                                                                
*        _Q440JW0Q9           tree1 VALID                        
*                                                                
*        Function Origin:                                        
*                                                                
*        From Screen:         DBFSELEC,     Record Number:    8  
*        Variable:            tree1                              
*        Called By:           VALID Clause                       
*        Object Type:         Push Button                        
*        Snippet Number:      6                                  
*                                                                
*       Ľ
*
* Hide the tree diagram if it is visible; display it if it isn't
FUNCTION _q440jw0q9     &&  tree1 VALID
#REGION 1
IF WVISIBLE('treewind')
   RELEASE WINDOW treewind
   SHOW GET tree1,1 PROMPT "\<Show tree"
ELSE
   IF m.nextdbf <= 1
      WAIT WINDOW "No tree to show!" NOWAIT
   ELSE
      start_row = 3
      end_row   = MIN(start_row + 2 + m.nextdbf, SROWS()-1)
      start_col = 1
      end_col   = 20
      DEFINE WINDOW treewind ;
         FROM start_row,start_col TO end_row,end_col ;
         TITLE "Database tree" ;
         SYSTEM FLOAT NOZOOM NOCLOSE NOGROW ;
         COLOR SCHEME 10
      ACTIVATE WINDOW treewind NOSHOW
      SET CURSOR OFF
      DO showtree WITH 1,0
      ACTIVATE WINDOW treewind
      SHOW GET tree1,1 PROMPT "\<Hide tree"
   ENDIF
ENDIF


*       ķ
*                                                                
*        _Q440JW0WI           repbut VALID                       
*                                                                
*        Function Origin:                                        
*                                                                
*        From Screen:         GETDEST,     Record Number:    2   
*        Variable:            repbut                             
*        Called By:           VALID Clause                       
*        Object Type:         Radio Button                       
*        Snippet Number:      7                                  
*                                                                
*       Ľ
*
FUNCTION _q440jw0wi     &&  repbut VALID
#REGION 2
IF repbut <> 3
   SHOW GET rfile DISABLE
   SHOW GET repdest DISABLE
ELSE
   SHOW GET rfile ENABLE
   SHOW GET repdest ENABLE
ENDIF
SHOW GETS


*       ķ
*                                                                
*        _Q440JW0ZX           repdest VALID                      
*                                                                
*        Function Origin:                                        
*                                                                
*        From Screen:         GETDEST,     Record Number:    3   
*        Variable:            repdest                            
*        Called By:           VALID Clause                       
*        Object Type:         Field                              
*        Snippet Number:      8                                  
*                                                                
*       Ľ
*
FUNCTION _q440jw0zx     &&  repdest VALID
#REGION 2
m.repdest = PADR(ALLTRIM(UPPER(m.repdest)),40)

IF EMPTY(m.repdest)
   SHOW GET okbut DISABLE
ELSE
   SHOW GET okbut ENABLE
ENDIF
SHOW GETS


*       ķ
*                                                                
*        _Q440JW0V5           Read Level Activate                
*                                                                
*        Function Origin:                                        
*                                                                
*        From Screen:         Multiple Screens                   
*        Called By:           READ Statement                     
*        Snippet Number:      9                                  
*                                                                
*       Ľ
*
FUNCTION _q440jw0v5     && Read Level Activate
*
* Activate Code from screen: DBFSELEC
*
#REGION 1
IF nextdbf = 1
   SHOW GET arrange DISABLE
ELSE
   SHOW GET arrange ENABLE
ENDIF

*
* Activate Code from screen: GETDEST
*
#REGION 2
IF repbut = 3
   SHOW GET repdest ENABLE
ELSE
   SHOW GET repdest DISABLE
ENDIF


*       ķ
*                                                                
*        _Q440JW14P           Read Level Deactivate              
*                                                                
*        Function Origin:                                        
*                                                                
*        From Screen:         Multiple Screens                   
*        Called By:           READ Statement                     
*        Snippet Number:      10                                 
*                                                                
*       Ľ
*
FUNCTION _q440jw14p     && Read Level Deactivate
*
* Deactivate Code from screen: GETDEST
*
#REGION 2
?? CHR(7)
RETURN .F.


*       ķ
*                                                                
*        _Q440JW0V8           Read Level Show                    
*                                                                
*        Function Origin:                                        
*                                                                
*        From Screen:         Multiple Screens                   
*        Called By:           READ Statement                     
*        Snippet Number:      11                                 
*                                                                
*       Ľ
*
FUNCTION _q440jw0v8     && Read Level Show
PRIVATE currwind
STORE WOUTPUT() TO currwind
*
* Show Code from screen: DBFSELEC
*
#REGION 1
IF WVISIBLE('treewind')
   ACTIVATE WINDOW treewind NOSHOW
   CLEAR
   SET CURSOR OFF
   DO showtree WITH 1,0
   ACTIVATE WINDOW treewind
ENDIF

*
* Show Code from screen: GETDEST
*
#REGION 2
IF repbut = 3
   SHOW GET repdest ENABLE
ELSE
   SHOW GET repdest DISABLE
ENDIF

IF repbut = 3 AND EMPTY(repdest)
   SHOW GET okbut DISABLE
ELSE
   SHOW GET okbut ENABLE
ENDIF

IF NOT EMPTY(currwind)
	ACTIVATE WINDOW (currwind) SAME
ENDIF