*-------------------------------------------------------------------*
*----                        Boolean.prg                        ----*
*-------------------------------------------------------------------*
* Program  : Boolean.prg
* Author   : Colin R. Keeler
*            colink@doh.state.sd.us
*            71034.1256@compuserve.com
*            http://www.state.sd.us/people/colink/colink.htm
* Copyright: none (Public Domain)
* Date     : 11/03/94
* Updated  : 01/23/95
* Purpose  : Provides set of functions for performing Boolean
*            operations in FoxPro, something previously neglected.
*
* Usage    : BOOLEAN( <expC> , <expN1> | <expC1> [ , <expN2> ] )
*
*    <expC> is one of the supported functions to be performed:
* AND, OR, XOR, NOT, EQV, BIN2INT, or INT2BIN.
*
*    <expN1> or <expC1> is the first or only value being passed to
* <expC>.  Only AND, OR and EQV require 2 parameters.  The other
* functions use only one.
*
*    <expN2> is the second numeric parameter for AND, OR, XOR or EQV.
*
*    The return value is an integer result of the operation, unless
* invalid parameters are passed, then the return value is .F.
*-------------------------------------------------------------------*
PARAMETERS cFunction,parm1,parm2
PRIVATE ALL
IF SET('TALK')="ON"
   SET TALK OFF
   oldtalk="ON"
ELSE
   oldtalk="OFF"
ENDIF
#DEFINE cr CHR(13)
IF TYPE('cFunction')="C"
   cFunction=UPPER(cFunction)
ENDIF
rtn=.F.
DO CASE
   CASE PARAMETERS()=0
      emssg=""
      DO about
   CASE cFunction="INT2BIN"
      IF TYPE('parm1')<>"N" OR parm1<0 OR parm1>255
         emssg="The INT2BIN function requires that"+cr
         emssg=emssg+"a numeric value between 0 and 255"+cr
         emssg=emssg+"be passed to it."
         DO about
      ELSE
         rtn=int2bin(parm1)
      ENDIF
   CASE cFunction="BIN2INT"
      IF TYPE('parm1')<>"C"
         emssg="The BIN2INT function requires that a"+cr
         emssg=emssg+"character value be passed to it."
         DO about
      ELSE
         rtn=bin2int(parm1)
      ENDIF
   CASE cFunction="AND"
      IF TYPE('parm1')<>"N" OR TYPE('parm2')<>"N"
         emssg="The AND function requires that two numeric"+cr
         emssg="values between 0 and 255 be passed to it."
         DO about
      ELSE
         rtn=booland(parm1,parm2)
      ENDIF
   CASE cFunction="OR"
      IF TYPE('parm1')<>"N" OR TYPE('parm2')<>"N"
         emssg="The OR function requires that two numeric"+cr
         emssg=emssg+"values between 0 and 255 be passed to it."
         DO about
      ELSE
         rtn=boolor(parm1,parm2)
      ENDIF
   CASE cFunction="XOR"
      IF TYPE('parm1')<>"N" OR TYPE('parm2')<>"N"
         emssg="The XOR function requires that two numeric"+cr
         emssg=emssg+"values between 0 and 255 be passed to it."
         DO about
      ELSE
         rtn=boolxor(parm1,parm2)
      ENDIF
   CASE cFunction="NOT"
      IF TYPE('parm1')<>"N" OR TYPE('parm2')<>"L"
         emssg="The NOT function accepts only one numeric argument."
         DO about
      ELSE
         rtn=boolnot(parm1)
      ENDIF
   CASE cFunction="EQV"
      IF TYPE('parm1')<>"N" OR TYPE('parm2')<>"N"
         emssg="The EQV function requires that two numeric"+cr
         emssg=emssg+"values between 0 and 255 be passed to it."
         DO about
      ELSE
         rtn=booleqv(parm1,parm2)
      ENDIF
   OTHERWISE
      emssg="Invalid parameters passed"
      DO about
ENDCASE
IF oldtalk="ON"
   SET TALK ON
ENDIF
RETURN rtn

FUNCTION int2bin
PARAMETERS integer
mask=128
rtnval=""
FOR t=1 TO 8
   IF integer>=mask
      rtnval=rtnval+"1"
      integer=integer-mask
   ELSE
      rtnval=rtnval+"0"
   ENDIF
   mask=mask/2
ENDFOR
RETURN rtnval

FUNCTION bin2int
PARAMETER binary
IF LEN(binary)>8
   binary=RIGHT(binary,8)
ENDIF
mask=128
decimal=0
binary=PADL(binary,8)
FOR t=1 TO 8
   IF SUBSTR(binary,t,1)="1"
      decimal=decimal+mask
   ENDIF
   mask=mask/2
ENDFOR
RETURN decimal

FUNCTION booland
PARAMETERS val1,val2
val1=int2bin(val1)
val2=int2bin(val2)
output=""
FOR t=1 TO 8
   IF SUBSTR(val1,t,1)="1" AND SUBSTR(val2,t,1)="1"
      output=output+"1"
   ELSE
      output=output+"0"
   ENDIF
ENDFOR
RETURN bin2int(output)

FUNCTION boolor
PARAMETERS val1,val2
val1=int2bin(val1)
val2=int2bin(val2)
output=""
FOR t=1 TO 8
   IF SUBSTR(val1,t,1)="1" OR SUBSTR(val2,t,1)="1"
      output=output+"1"
   ELSE
      output=output+"0"
   ENDIF
ENDFOR
RETURN bin2int(output)

FUNCTION boolxor
PARAMETERS val1,val2
val1=int2bin(val1)
val2=int2bin(val2)
output=""
FOR t=1 TO 8
   IF SUBSTR(val1,t,1)<>SUBSTR(val2,t,1)
      output=output+"1"
   ELSE
      output=output+"0"
   ENDIF
ENDFOR
RETURN bin2int(output)

FUNCTION boolnot
PARAMETER val1
val1=int2bin(val1)
output=""
FOR t=1 TO 8
   output=output+IIF(SUBSTR(val1,t,1)="1","0","1")
ENDFOR
RETURN bin2int(output)

FUNCTION booleqv
PARAMETER val1,val2
val1=int2bin(val1)
val2=int2bin(val2)
output=""
FOR t=1 TO 8
   output=output+IIF(SUBSTR(val1,t,1)=SUBSTR(val2,t,1),"1","0")
ENDFOR
RETURN bin2int(output)

PROCEDURE about
DEFINE WINDOW boolean ;
   FROM INT((SROW()-21)/2),INT((SCOL()-64)/2) ;
   TO INT((SROW()-21)/2)+20,INT((SCOL()-64)/2)+63 ;
   FLOAT NOCLOSE SHADOW NOMINIMIZE DOUBLE COLOR SCHEME 5
ACTIVATE WINDOW boolean
@ 2,7 SAY "by Colin R. Keeler" SIZE 1,18, 0
@ 3,5 SAY "colink@doh.state.sd.us" SIZE 1,22, 0 COLOR W/RB    
@ 1,8 SAY "Boolean v.950123" SIZE 1,16, 0 COLOR GR+/RB  
@ 4,8 SAY "CIS:  71034,1256" SIZE 1,16, 0 COLOR W/RB    
@ 0,1 TO 5,29 COLOR W/RB    
@ 1,33 SAY "This program allows FoxPro" SIZE 1,26, 0 COLOR W/RB    
@ 2,33 SAY "to perform Boolean algebra" SIZE 1,26, 0 COLOR W/RB    
@ 0,31 TO 5,60 COLOR W/RB    
@ 4,33 SAY "return an integer value." SIZE 1,24, 0 COLOR W/RB    
@ 3,33 SAY "operations on numbers and" SIZE 1,25, 0 COLOR W/RB    
@ 6,2 SAY "The currently supported functions are:"
@ 8,6 SAY "1st parm  2nd parm  3rd parm  return value"
@ 9,6 SAY "--------  --------  --------  ------------"
@ 13,8 SAY "'EQV'     int1      int2    int1 EQV int2"
@ 14,6 SAY "'INT2BIN'   int1              'binary of int1'"
@ 10,8 SAY "'AND'     int1      int2    int1 AND int2"
@ 11,8 SAY "'OR'      int1      int2    int1 OR int2"
@ 12,8 SAY "'NOT'     int1              NOT int1"
@ 15,6 SAY "'BIN2INT' 'binary1'"
@ 15,36 SAY "int. value of 'binary1'"
@ 16,8 SAY "'XOR'     int1      int2    int1 XOR int2"
@ 18,28 GET nulbut PICTURE "@*HT \!Ok" SIZE 1,6,1 DEFAULT 1
ACTIVATE WINDOW boolean
WAIT WINDOW emssg NOWAIT
READ CYCLE
DEACTIVATE WINDOW boolean
RELEASE WINDOW boolean
RETURN

*Eof: Boolean.prg
