*:*********************************************************************
*:
*: Procedure file: H:\FTCL\CLMAKDBF.PRG
*:
*:         System: FoxPro 2.0 Change Log Database
*:         Author: Maurice Frank
*:      Copyright (c) 1991, Maurice Frank
*:  Last modified: 11/11/91     21:00
*:
*:  Procs & Fncts: CLMAKDBF()
*:
*:        Indexes: FILENAME               (tag)
*:               : COMMFUNC               (tag)
*:               : CATEGORY               (tag)
*:
*:      Documented 11/11/91 at 21:01               FoxDoc  version 2.10b
*:*********************************************************************

* Create FoxPro 2 Change Log dbf if it does not exist

PARAMETERS mdbf_name

* use default filename if user did not pass one in
mdbf_name = IIF(PARAMETERS()=0,"FP2CL",mdbf_name)

* does the change log dbf exist already?

IF !FILE( mdbf_name + ".dbf" )
   
   WAIT WINDOW "Creating FoxPro 2 change log database: " ;
      + mdbf_name NOWAIT
   
   CREATE TABLE (mdbf_name) ( ;
      filename C(12), ;
      item_no  N(3,0), ;
      commfunc  C(30), ;
      category C(15), ;
      dt_fixed D(8), ;
      details  m )
   
   INDEX ON filename+STR(item_no,3) TAG filename
   INDEX ON commfunc+DTOS(dt_fixed) TAG commfunc
   INDEX ON category+commfunc+filename TAG category
   
   mcreated = .T.
   
ELSE
   
   mcreated = .F.
   
ENDIF

RETURN mcreated
*: EOF: CLMAKDBF.PRG
