This is a small collection of FoxPro for Windows functions that utilitize FOXTOOLS.FLL.
These routines take advantage of some of the most used Windows API calls.

I've written these functions and use them daily on all of my FoxPro development.

If you have any comments, please feel free to contact me at (201)643-4386.

Good Luck!



John Romero
CompuServe 76244,3722

*==========================================================================*
*-- Function.......INIPutValue                                             *
*-- Author.........John Romero                                             *
*-- Date...........02/13/95                                                *
*-- Description....Writes a character string into the specified section    *
*--                of the WIN.INI file or that of the specified INI file.  *
*--------------------------------------------------------------------------*
*-- Syntax.........INIPutValue( <m.cSection>, <m.cEntry>, <m.cValue>,      *
*--                            [<m.cIniFile>] )                            *
*-- Returns........Logical                                                 *
*--                .T. if successful                                       *
*--                .F. not successful                                      *
*-- Remarks........This function copies a character string into the        *
*--                specified section of the WIN.INI file or that of the    *
*--                specified initialization file.                          *
*--                If [<m.cIniFile>] is not specified, it is assumed that  *
*--                WIN.INI will be used.  If [<m.cIniFile>] is specified   *
*--                and it does not contain a fully qualified path and      *
*--                file, this function then searches the Windows directory *
*--                for the file.  If the file does not exist, it will      *
*--                create it in the Windows directory.                     *
*--                If [<m.cIniFile>] contains a fully qualified path and   *
*--                filename and the file does not exist, this function     *
*--                creates the file.  The specified directory must already *
*--                exist.                                                  *
*--                                                                        *
*-- Example........&& Write to WIN.INI                                     *
*--                =INIPutValue("windows","load","nwpopup.exe")            * 
*--                ... Write to a specific INI file.                       *
*--                =INIPutValue("start","message","hello world!",          *
*--                             "john.ini")                                *
*--                                                                        *
*-- Requirements...FOXTOOLS.FLL                                            *
*==========================================================================*
FUNCTION INIPutValue
PARAMETERS m.cSection, m.cEntry, m.cValue, m.cIniFile

IF !("FOXTOOLS.FLL" $ SET("LIBRARY"))			&& Load FoxTools Library.
	SET LIBRARY TO FOXTOOLS.FLL ADDITIVE
ENDIF	

*-- Perform the appropriate Windows API function call based on whether [m.cIniFile] was passed or not.
IF TYPE( "m.cIniFile" )	!= "C"			&&  m.cIniFile must be of Character type.
	nRetVal = CallFn(  RegFn("WriteProfileString","CCCC","I" ), m.cSection, m.cEntry, m.cValue )
ELSE
	nRetVal	= CallFn( RegFn("WritePrivateProfileString","CCCC","I" ), m.cSection, m.cEntry, m.cValue, m.cIniFile ) 
ENDIF	

RETURN( nRetVal != 0 )

*==========================================================================*
*-- Function.......INIGetInt                                               *
*-- Author.........John Romero                                             *
*-- Date...........02/13/95                                                *
*-- Description....Retrieves the value of an integer from an entry within  *
*--                a specified section of WIN.INI or that of a specified   *
*--                INI file.                                               *
*--------------------------------------------------------------------------*
*-- Syntax.........INIGetInt( <m.cSection>, <m.cEntry>, [<m.cIniFile>] )   *
*-- Returns........Numeric                                                 *
*--                The integer value of the specified entry if successful. *
*--                0 if the value that corresponds to the specified entry  *
*--                is not an integer.                                      *
*--                -1 if otherwise.                                        *
*-- Remarks........This function searches WIN.INI or [<m.cIniFile>] (if    *
*--                specified) for an entry that matches the name specified *
*--                in the <m.cEntry> parameter under the section heading   *
*--                <m.cSection> parameter. The Search is not case-specific.*
*--                                                                        *
*-- Example........&& Get integer value from WIN.INI                       *
*--                =INIGetInt("windows","BorderWidth")                     * 
*--                ... Get integer from a specific INI file.               *
*--                =INIGetInt("start","MaxUsers","john.ini")               *
*--                                                                        *
*-- Requirements...FOXTOOLS.FLL                                            *
*==========================================================================*
FUNCTION INIGetInt
PARAMETERS m.cSection, m.cEntry, m.cIniFile
PRIVATE m.nRetVal

IF !("FOXTOOLS.FLL" $ SET("LIBRARY"))			&& Load FoxTools Library.
	SET LIBRARY TO FOXTOOLS.FLL ADDITIVE
ENDIF	

*-- Perform the appropriate Windows API function call based on whether [m.cIniFile] was passed or not.
IF TYPE( "m.cIniFile" )	!= "C"			&&  m.cIniFile must be of Character type.
	m.nRetVal	=	CallFn( RegFn("GetProfileInt","CCI" , "I"), m.cSection, m.cEntry, -1 ) 
ELSE
	m.nRetVal	=	CallFn( RegFn("GetPrivateProfileInt","CCIC" , "I"), m.cSection, m.cEntry, -1, m.cIniFile )
ENDIF

RETURN ( m.nRetVal )


*==========================================================================*
*-- Function.......INIGetString                                            *
*-- Author.........John Romero                                             *
*-- Date...........02/13/95                                                *
*-- Description....Retrieves a string value an entry within a specified    *
*--                section of WIN.INI or that of a specified INI file.     *
*--------------------------------------------------------------------------*
*-- Syntax.........INIGetString(<m.cSection>,<m.cEntry>,[<m.cIniFile>])    *
*-- Returns........Character                                               *
*--                The value that corresponds to the specified entry.      *
*-- Remarks........This function searches WIN.INI or [<m.cIniFile>] (if    *
*--                specified) for an entry that matches the name specified *
*--                in the <m.cEntry> parameter under the section heading   *
*--                <m.cSection> parameter. The Search is not case-specific.*
*--                                                                        *
*-- Example........&& Get string from WIN.INI                              *
*--                =INIGetString("windows","load")                         * 
*--                ... Get string from a specific INI file.                *
*--                =INIGetString("start","message","john.ini")             *
*--                                                                        *
*-- Requirements...FOXTOOLS.FLL                                            *
*==========================================================================*
FUNCTION INIGetString
PARAMETERS m.cSection, m.cEntry, m.cIniFile
PRIVATE m.cRetVal, m.nRetLen

IF !("FOXTOOLS.FLL" $ UPPER(SET("LIBRARY")))			&& Load FoxTools Library.
	SET LIBRARY TO FOXTOOLS.FLL ADDITIVE
ENDIF	

m.cRetVal	= SPACE(80)

*-- Perform the appropriate Windows API function call based on whether [m.cIniFile] was passed or not.
IF TYPE( "m.cIniFile" )	!= "C"			&&  m.cIniFile must be of Character type.
	=CallFn( RegFn("GetProfileString","CCC@CI" , "I"), m.cSection, m.cEntry, "", @cRetVal, LEN(m.cRetVal))
ELSE
	=CallFn( RegFn("GetPrivateProfileString","CCC@CIC" , "I"), m.cSection, m.cEntry, "", @cRetVal, LEN(m.cRetVal), m.cIniFile )
ENDIF

RETURN ( m.cRetVal )

*==========================================================================*
*-- Function.......WinGetDir                                               *
*-- Author.........John Romero                                             *
*-- Date...........02/13/95                                                *
*-- Description....Retrieves the path of the Windows directory.            *
*--------------------------------------------------------------------------*
*-- Syntax.........WinGetDir()                                             *
*-- Returns........Character                                               *
*--                The path of the Windows directory.                      *
*-- Remarks........This function retrieves the path of the Windows         *
*--                directory.  This directory contains such files as       *
*--                Windows applications, INI files, and help files.        *
*--                                                                        *
*-- Example........? WinGetDir()    && C:\WIN31                            *
*--                                                                        *
*-- Requirements...FOXTOOLS.FLL                                            *
*==========================================================================*
FUNCTION WinGetDir
PRIVATE m.cString, m.nLength
#DEFINE	BUFFER_WIDTH	144

IF !("FOXTOOLS.FLL" $ SET("library"))			&& Load FoxTools Library.
	SET LIBRARY TO FOXTOOLS.FLL ADDITIVE
ENDIF	

m.cString	=	SPACE( BUFFER_WIDTH )
m.nLength	= 	CallFn( RegFn("GetWindowsDirectory", "@CI", "I"), @m.cString, BUFFER_WIDTH )

RETURN LEFT( m.cString, m.nLength )

*==========================================================================*
*-- Function.......WinGetSysDir                                            *
*-- Author.........John Romero                                             *
*-- Date...........02/13/95                                                *
*-- Description....Retrieves the path of the Windows system directory.     *
*--------------------------------------------------------------------------*
*-- Syntax.........WinGetSysDir()                                          *
*-- Returns........Character                                               *
*--                The path of the Windows system directory.               *
*-- Remarks........This function retrieves the path of the Windows system  *
*--                directory.  This directory contains such files as       *
*--                Windows libraries, drivers, and fonts                   *
*--                                                                        *
*-- Example........? WinGetSysDir()    && C:\WIN31\SYSTEM                  *
*--                                                                        *
*-- Requirements...FOXTOOLS.FLL                                            *
*==========================================================================*
PROCEDURE WinGetSysDir
#DEFINE	BUFFER_WIDTH	144

IF !("FOXTOOLS.FLL" $ SET("library"))			&& Load FoxTools Library.
	SET LIBRARY TO FOXTOOLS.FLL ADDITIVE
ENDIF	

m.cBuffer		= SPACE( BUFFER_WIDTH )   					
m.nRetLen		= CallFn( RegFn("GetSystemDirectory", "@CI", "I"), @m.cBuffer, BUFFER_WIDTH)

RETURN LEFT(m.cBuffer, m.nRetLen)

*==========================================================================*
*-- Function.......PushCursor                                              *
*-- Author.........John Romero                                             *
*-- Date...........02/10/95                                                *
*-- Description....Changes cursor to the desired cursor shape.             *
*--------------------------------------------------------------------------*
*-- Syntax.........PushCursor(<cCursorShape>)                              *
*-- Returns........Nothing                                                 *
*-- Remarks........Changes the windows cursor to the desired shape.        *
*--                In order to set the cursor back to its previous shape   *
*--                you must call PopCursor().                              *
*--                                                                        *
*--                The <cCursorShape>s are the following:                  *
*--                    IDC_ARROW                                           *
*--                    IDC_IBEAM                                           *
*--                    IDC_WAIT                                            *
*--                    IDC_CROSS                                           *
*--                    IDC_UPARROW                                         *
*--                    IDC_SIZE                                            *
*--                    IDC_ICON                                            *
*--                    IDC_SIZENWSE                                        *
*--                    IDC_SIZENESW                                        *
*--                    IDC_SIZEWE                                          *
*--                    IDC_SIZENS                                          *
*--                                                                        *
*-- Example........=PushCursor("IDC_WAIT") && Changes cursor to hourglass. * 
*==========================================================================*
PROCEDURE PushCursor
PARAMETERS cCursorShape
PRIVATE m.nRetType
m.nRetType	=	(32514)			&& Default if no parameter passed.
IF PARAMETERS() == 1
	cCursorShape = ALLTRIM(UPPER(cCursorShape))
	DO CASE
		CASE cCursorShape == "IDC_ARROW"
			m.nRetType	=	(32512)
		CASE cCursorShape == "IDC_IBEAM"
			m.nRetType	=	(32513)		
		CASE cCursorShape == "IDC_WAIT"				
			m.nRetType	=	(32514)		
		CASE cCursorShape == "IDC_CROSS"
			m.nRetType	=	(32515)		
		CASE cCursorShape == "IDC_UPARROW"
			m.nRetType	=	(32516)		
		CASE cCursorShape == "IDC_SIZE"
			m.nRetType	=	(32640)		
		CASE cCursorShape == "IDC_ICON"
			m.nRetType	=	(32641)		
		CASE cCursorShape == "IDC_SIZENWSE"										
			m.nRetType	=	(32642)		
		CASE cCursorShape == "IDC_SIZENESW"		
			m.nRetType	=	(32643)		
		CASE cCursorShape == "IDC_SIZEWE"		
			m.nRetType	=	(32644)		
		CASE cCursorShape == "IDC_SIZENS"		
			m.nRetType	=	(32645)		
		OTHERWISE
			RETURN 
	ENDCASE
ENDIF

*-- Need the next variables to be global for reference
*-- call during PopCursor()
PUBLIC m.gnOldCursor, m.gnSetCsr

IF !("FOXTOOLS.FLL" $ SET("LIBRARY"))			&& Load FoxTools Library.
	SET LIBRARY TO FOXTOOLS.FLL ADDITIVE
ENDIF	

nLoadCsr 		= 	RegFn("LoadCursor","IL","I")
m.gnSetCsr		=	RegFn("SetCursor","I","I")
m.glOldCursor 	= 	CallFn( m.gnSetCsr, CallFn( nLoadCsr, 0, m.nRetType ))

RETURN

*==========================================================================*
*-- Function.......PopCursor                                               *
*-- Author.........John L. Romero                                          *
*-- Date...........02/10/95                                                *
*-- Description....Changes cursor back to the previous cursor shape before *
*--                PushCursor() was called.                                *
*--------------------------------------------------------------------------*
*-- Syntax.........PopCursor()                                             *
*-- Returns........Nothing                                                 *
*-- Remarks........Changes the windows cursor back to the state it was in  *
*--                before the PushCursor() function was called.            *
*-- Example........=PushCursor("IDC_WAIT") && Changes cursor to hourglass. *	
*--					 COUNT TO nRecs FOR employee.active                    *
*--                =PopCursor()            && Set cursor back              * 
*==========================================================================*
PROCEDURE PopCursor
IF !("FOXTOOLS.FLL" $ SET("LIBRARY"))			&& Load FoxTools Library.
	SET LIBRARY TO FOXTOOLS.FLL ADDITIVE
ENDIF	
IF TYPE("m.gnSetCsr" ) != "U" .AND. TYPE("m.gnOldCursor" ) != "U"
	=CallFn( m.gnSetCsr, m.gnOldCursor )
ENDIF	
RETURN
