
**************************************************************************
**  EasySystem, Inc.
**  Richmond, VA   4/1/92
                        
** FUNCTION UINT WAITON

** draw attractive shadow msg box on screen// automatically adjusts to
** msg length//pass colors for box and msg
**
** Centers vertically at top=row 11 if parameter int tt isn't passed
** __new_std and __new_enhcd are colors passed for box/msg
** old colors are saved and restored upon exit
** byte mshad is attribute for shadow color (0=solid black, 2,3,or4 = patterned
** dark color, etc.)
**
** waiton() is paired with waitoff(), which removes box and restores screen
**
**
**
**  Apologies to the Grumpmeister for appropriating the waiton and waitoff names
**************************************************************************************
** Example usage of waiton()/waitoff()
**   mbox3 = waiton("Program shows book balance of $"+str((prem1-prem2),8,4),(096+128),(096+128),18,4,mbox3)
**   delay(15)
**   waitoff(mbox3)
**              or
**  mbox2 = waiton("Report of discrepancies is printing now",__new_std,__new_enhcd,15,4,mbox2)
**   do printstuff
**   eject
**   waitoff(mbox2)
************************************************************************************
**   declare external variables & functions
VARDEF    EXTERN
    BYTE     __color_enhcd      && (112) This is the attribute of the inverse
                                &&   video (used in GETS, etc..).

    BYTE     __color_std        && (7) This is the attribute used
                                &&   when writing to the screen via the ?,
                                &&   ACCEPT, INPUT or WAIT commands.
                                &&   (see the IBM technical reference)
ENDDEF


PROCEDURE cursor_on PROTOTYPE

PROCEDURE cursor_off PROTOTYPE

PROCEDURE restorescrn PROTOTYPE
    PARAMETERS VALUE INT saved_scrn

FUNCTION UINT len PROTOTYPE
    PARAMETERS CONST CHAR source_string
FUNCTION CHAR replicate PROTOTYPE
    PARAMETERS CONST CHAR c_expression, VALUE UINT repeat_count
FUNCTION UINT savescrn PROTOTYPE
    PARAMETERS VALUE UINT ur, VALUE UINT uc, VALUE UINT lr, VALUE UINT lc
**************************************************************************************
**    OK, here's the function waiton() itself
**   the function  waitoff()   follows immediately below


FUNCTION UINT WAITON
parameters  value char msg, value byte __new_std ,value byte __new_enhcd,  VALUE int tt, value byte mshad, uint xxuint




VARDEF
        INT     kk
        INT     cc
        BYTE __old_std
        BYTE __old_enhcd
        INT     ll
        INT     bb
        INT     rr
        INT     i
ENDDEF
kk = 40-(len( msg ) / 2)

if tt=0
        tt=11
endif
        ll=(kk-2)
        bb=(tt+2)
        rr=(kk+len(msg)+2)

__old_std = __color_std
__color_std = __new_std
__old_enhcd = __color_enhcd
__color_enhcd = __new_enhcd
Cursor_off
xxuint = savescrn( tt-1, ll-1,bb+2, rr+2 )
if mshad = 0
__color_std = mshad
for i = (tt+1) to (bb+1)
@ i, (ll+2) say replicate(" ",((rr+2)-(ll+1)))
next
else
__color_std = mshad
for i = (tt+1) to (bb+1)
@ i, (ll+2) say replicate("",((rr+2)-(ll+1)))
next
endif
__color_std = __new_std
@ tt, ll to bb, rr double
@ tt+1,ll+1 clear to bb-1,rr-1
@ (tt+1), (40-(len( msg ) / 2))  say msg
__color_std = __old_std
__color_enhcd = __old_enhcd
tt=0                             &&reset tlbr to 0 for next waiton() use
ll=0
bb=0
rr=0


return xxuint                    && return box to
endpro



*************************************************************************
*************************************************************************
** This function restores screen and removes msg box from screen
** example:    waitoff(mbox3)
**
FUNCTION UINT WAITOFF

parameters uint xxuint

restorescrn(xxuint)
cursor_on
endpro



