


**FUNCTION CHAR ELAPTIME
** Yhis is a handy little UDF that I hope is useful to anyone who wants it.
** Needless to say, a Forcified version of a Clipper 5.01 UDF

** It returns the elapsed time between time1(start time) and time2 (end time)
** formatted as a string-> "xx hours, xx minutes, xx seconds".
** If number of hours is 0, then returns string-> "xx minutes, xx seconds"
** NOTE: time1 and time2 are both timestrings initialized as time()
** You need to include pieces of string.hdr and math.hdr when using this.
**
**  This is handy in conjunction with the waiton() and waitoff() functions, as in:
**    mbox3 = waiton("Time required for reconciliation was "+ elaptime(time1,time2),__new_std,__new_enhcd,20,4,mbox3)
**    delay(10)
**    waitoff(mbox3)
**
*******************************************************************************
** declare external functions
FUNCTION DBL trunc PROTOTYPE
    PARAMETERS CONST DBL argument
FUNCTION CHAR substr PROTOTYPE
    PARAMETERS CONST CHAR source_string, VALUE UINT start_position,;
    VALUE UINT length
FUNCTION CHAR str PROTOTYPE
    PARAMETERS CONST DBL number, VALUE UINT string_length,;
    VALUE UINT decimal_places
FUNCTION LONG i_val PROTOTYPE
    PARAMETERS CONST CHAR str_number
FUNCTION CHAR i_str PROTOTYPE
    PARAMETERS VALUE LONG number

************************************************************************
**  OK here's the function elaptime() itself


FUNCTION CHAR ELAPTIME
PARAMETERS CONST CHAR time1, CONST CHAR time2



vardef
        int     nsecs1
        int     nsecs2
        int     nsecs3
        char    retstring
        char    minstring
enddef


nsecs1 = (i_val(substr(time1,1,2))*3600)+(i_val(substr(time1,4,2))*60)+i_val(substr(time1,7,2))
nsecs2 = (i_val(substr(time2,1,2))*3600)+(i_val(substr(time2,4,2))*60)+i_val(substr(time2,7,2))
nsecs3 = (nsecs2-nsecs1)
if nsecs3 < 60
        retstring = substr(i_str(nsecs3),3,2) + " seconds"
endif
if trunc(nsecs3/60)=1
        minstring = " minute, "
endif
if trunc(nsecs3/60)>1
        minstring = " minutes, "
endif
if (nsecs3/3600)<1
        retstring = (str(nsecs3/60,2,0)+minstring+str((nsecs3-((trunc(nsecs3/60))*60)),2,0)+" seconds")
endif
if  trunc(nsecs3/3600)=1
        retstring = ("1 hour, "+str(nsecs3/60,2,0)+minstring+str((nsecs3-((trunc(nsecs3/60))*60)),2,0)+" seconds")
endif
if trunc(nsecs3/3600)>1
        retstring = (str(nsecs3/3600,2,0)+" hours, "+str(nsecs3/60,2,0)+minstring+str((nsecs3-((trunc(nsecs3/60))*60)),2,0)+" seconds")
endif

return retstring
endpro


*****************************************************************************************************

