* Program: FixDbc.prg
*  Notice: The author releases all rights to the public domain
*        :    subject to the Warranty Disclaimer below.
*  Author: Tom Rettig
*        : Rettig Micro Corporation
*        : 2532 Lincoln Boulevard, Suite 110
*        : Marina del Rey, CA  90291-5978
*        :  Telephone: 310-301-0911
*        :        Fax: 310-821-1162
*        : CompuServe: 75066,352
*        :           : in FOXUSER forum's 3rd-Party section or MAIL
*  Action: Copy latest deleted View's User fields to new View records
*        :    as a work-around for bug in VFP 3.0 and 3.0b.
* Version: Version 1.0a -- December 5, 1995
*   Usage: DO FixDbc [WITH cDbcFileName [, lAddNotice]]
*        :    cDbcFileName may contain drive/path
*        :    lAddNotice true adds notice and timestamp to User field
*Requires: Visual FoxPro for Windows version 3.0 or later
*   Notes: - The bug: Any change to a DBC View causes the old view to be
*        : marked deleted and a new view created.  When this happens,
*        : all contents of the User field are not copied, although they
*        : do remain in the deleted records.
*        :
*        : - Work-around: Run FixDbc after changing a view and before you
*        : PACK the DBC or Clean Up Database from the Database Designer.
*        :
*        : - FixDbc scans the deleted views and their objects for contents
*        : in the User field.  If found and a matching undeleted object
*        : exists with an empty User field, the contents are copied.
*        :
*        : - FixDbc scans deleted views and objects in reverse order to
*        : always get the latest revision, and looks back through all
*        : available deletions.  This recovers lost data even where fields
*        : have been deleted from views and then added back in later.
*        :
*        : - Tip: Lots of deleted views in the DBC slow down this program,
*        : so clean up the DBC regularly but be sure to run FixDbc first.
*        :
*        : - FixDbc may be freely used, modified, and distributed in
*        : compiled and/or source code form.
*        :
*        : - For other free VFP utilities download the following files
*        : from where you got FixDbc.Zip.
*        :    TRUE.EXE, Tom Rettig's Utility Extensions
*        :    SLOB.EXE, Simple Little Old Builder
*        :
*        : - For free information on our commercial products for VFP,
*        : please contact us at the address listed above.
*        :
*        : - The author appreciates acknowledgment in commercial
*        : products and publications that use or learn from this program.
*        : - Acknowledgment to Iain Hall for first reporting this bug.
*        :
*        : - Technical support is not officially provided.  The
*        : author is very interested in hearing about problems
*        : or enhancement requests you have, and will try to be
*        : helpful within reasonable limits.  Email or fax preferred.
*        :
*        : - Warranty Disclaimer: NO WARRANTY!!!
*        : THE AUTHOR RELEASES TO THE PUBLIC DOMAIN ALL CLAIMS TO ANY
*        : RIGHTS IN THIS PROGRAM AND FREELY PROVIDES IT "AS IS" WITHOUT
*        : WARRANTY OF ANY KIND, EXPRESSED OR IMPLIED, INCLUDING, BUT NOT
*        : LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
*        : FOR A PARTICULAR PURPOSE.  IN NO EVENT SHALL THE AUTHOR, OR ANY
*        : OTHER PARTY WHO MAY MODIFY AND/OR REDISTRIBUTE THIS PROGRAM, BE
*        : LIABLE FOR ANY COMMERCIAL, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
*        : DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM
*        : INCLUDING, BUT NOT LIMITED TO, LOSS OF DATA OR DATA BEING
*        : RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR LOSSES
*        : SUSTAINED BY THIRD PARTIES OR A FAILURE OF THE PROGRAM TO
*        : OPERATE WITH ANY OTHER PROGRAMS, EVEN IF YOU OR OTHER PARTIES
*        : HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

*************************
* Precompiler directives
*************************
* General.
#DEFINE ccCRLF     CHR(13) + CHR(10)

* Language for localization.
#DEFINE ccNOTICE   PROGRAM()+;
                   " recovered this lost User field "+;
                   lcTimeStamp + ccCRLF
#DEFINE ccLOAD     PROGRAM()+;
                   " loading"
#DEFINE ccMBUSAGE  "Usage: DO "+;
                   PROGRAM()+;
                   " [WITH cDbcFileName [, lAddNotice]]"+;
                   ccCRLF+ccCRLF+;
                   "cDbcFileName may contain drive/path"+;
                   ccCRLF+;
                   "lAddNotice true adds notice and timestamp to User field"
#DEFINE ccMBNODBC  "Database container file not found: "+;
                   ccCRLF + FULLPATH(tcDbcFile)
#DEFINE ccMESSAGE  PROGRAM()+;
                   " processing view "+;
                   UPPER(TRIM(Dbc1.ObjectName))
#DEFINE ccRESULT   PROGRAM() + ": " + LTRIM(STR(lnFixed))+;
                   " lost User field" + IIF(lnFixed==1, "", "s")+;
                   " recovered" + ccCRLF+;
                   "in "+;
                   FULLPATH(DBC()) + ccCRLF+;
                   "in "+;
                   luElapsed + "."
#DEFINE ccSECONDS  "seconds"
#DEFINE ccMINUTES  "minutes"
#DEFINE ccHOURS    "hours"

*************************
* Program
*************************
LPARAMETERS tcDbcFile, tlAddNotice
LOCAL llDeleted,;
      lnElapsed,;
      luElapsed,;
      lnFixed,;
      lnGoodViewId,;
      lcObjectType,;
      lnSelect,;
      llTalk,;
      lcTimeStamp,;
      lnViewId
luElapsed = SECONDS()
SET MESSAGE TO ccLOAD

* Parameter check.
IF (NOT (EMPTY(tcDbcFile) OR TYPE("tcDbcFile") == "C")) OR;
      (NOT TYPE("tlAddNotice") == "L")
   =MESSAGEBOX(ccMBUSAGE, 64, PROGRAM())
   SET MESSAGE TO
   RETURN  && early exit
ENDIF

* Open DBC.
IF EMPTY(tcDbcFile)
   IF EMPTY(DBC())
      OPEN DATABASE ?
      luElapsed = SECONDS()  && do not count time in dialog
      IF EMPTY(DBC())
         SET MESSAGE TO
         RETURN  && early exit
      ENDIF
   ENDIF
ELSE
   IF FILE(tcDbcFile + IIF(BETWEEN(RAT(".", tcDbcFile), 1, 4),;
                           "", ".dbc"))
      OPEN DATABASE (tcDbcFile)
      IF EMPTY(DBC())
         SET MESSAGE TO
         RETURN  && early exit
      ENDIF
   ELSE
      =MESSAGEBOX(ccMBNODBC, 64, PROGRAM())
      SET MESSAGE TO
      RETURN  && early exit
   ENDIF
ENDIF

* Use DBC twice.  First for scan deleted, second for search and replace.
USE DBC() AGAIN ALIAS Dbc1 IN SELECT(1)
IF NOT USED("Dbc1")
   SET MESSAGE TO
   RETURN  && early exit
ENDIF
USE DBC() AGAIN ALIAS Dbc2 IN SELECT(1)
IF USED("Dbc2")
   SET ORDER TO ObjectName IN Dbc2
ELSE
   USE IN Dbc1
   SET MESSAGE TO
   RETURN  && early exit
ENDIF

* Set up.
lnSelect     = SELECT(0)
lnElapsed    = 0
lnFixed      = 0
lcObjectType = PADR("View", FSIZE("ObjectType", "Dbc1"))
lcTimeStamp  = TTOC(DATETIME())  && same for all in this pass
llDeleted    = SET("DELETED") == "ON"
llTalk       = SET("TALK") == "ON"
SET DELETED OFF
SET TALK OFF

* Scan deleted views in reverse natural order for latest revision.
* Cannot optimize because DBC tags are filtered on NOT DELETED().
SELECT Dbc1
GO RECCOUNT()
SET FILTER TO ObjectType == lcObjectType AND DELETED()
SKIP -1
DO WHILE NOT BOF()
   IF NOT SET("MESSAGE", 1) == ccMESSAGE
      SET MESSAGE TO ccMESSAGE
   ENDIF

   * Find undeleted view in Dbc2 that replaced this deleted one.
   * No need to re-SET DELETED because DBC tag is filtered on not deleted.
   IF SEEK(STR(1) + Dbc1.ObjectType + LOWER(Dbc1.ObjectName),;
           "Dbc2")
      lnViewId     = Dbc1.ObjectId
      lnGoodViewId = Dbc2.ObjectId
      IF (NOT EMPTY(Dbc1.User)) AND EMPTY(Dbc2.User)
         REPLACE Dbc2.User;
            WITH IIF(tlAddNotice, ccNOTICE, "") + Dbc1.User;
              IN Dbc2
         lnFixed = lnFixed + 1
      ENDIF

      * Loop forward through View's objects.
      SET FILTER TO
      SKIP
      SCAN REST WHILE ParentId == lnViewId
         IF (NOT EMPTY(Dbc1.User)) AND;
               SEEK(STR(lnGoodViewId)+;
                       Dbc1.ObjectType + LOWER(Dbc1.ObjectName),;
                    "Dbc2") AND;
               EMPTY(Dbc2.User)
            REPLACE Dbc2.User;
               WITH IIF(tlAddNotice, ccNOTICE, "") + Dbc1.User;
                 IN Dbc2
            lnFixed = lnFixed + 1
         ENDIF
      ENDSCAN
      SET FILTER TO ObjectType == lcObjectType AND DELETED()
      GO lnViewId
   ENDIF
   IF SECONDS() < luElapsed   && reset timer at midnight
      lnElapsed = lnElapsed + (86400 + SECONDS() - luElapsed)
      luElapsed = SECONDS()
   ENDIF
   SKIP -1
ENDDO

* Clean up.
USE IN Dbc1
USE IN Dbc2
IF llDeleted
   SET DELETED ON
ENDIF
IF llTalk
   SET TALK ON
ENDIF
SELECT (lnSelect)
luElapsed = SECONDS() + lnElapsed - luElapsed
DO CASE
   CASE luElapsed < 60
      luElapsed = LTRIM(TRANSFORM(luElapsed, "99.99 ")) + ccSECONDS
   CASE luElapsed < 3600
      luElapsed = LTRIM(TRANSFORM(luElapsed/60, "99.99 ")) + ccMINUTES
   OTHERWISE
      luElapsed = LTRIM(TRANSFORM(luElapsed/86400, "99.99 ")) + ccHOURS
ENDCASE
WAIT WINDOW NOWAIT ccRESULT
SET MESSAGE TO
RETURN
*** FixDbc.prg **********************************************
