* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* A simple program to repair a .APP that gives messages such as Invalid 
*         drive "D:", etc. These seem to be caused by generated
*         code when applications reside on a D: drive during development 
*         but are run on machines having no D: drive or an empty CD-ROM
*         drive for D:.
*
* It updates the .APP to avoid the errors. Originally created to solve
*         this problem for some CAPCON users.
*
* To use: Run this program with the directory containing the .APP as
*         the current directory.  Remember to backup the .APP first.
* Parms:  1 - The .APP name (including .APP)
*         2 - The string to find, such as "d:\projects" -- be cautious
*             about using just "d:\" since this could occur in other 
*             parts of the .APP than where you wish to change things...
*         3 - The string to replace with, such as "c:\projects"
*
* Roy L. Gerber, Ph.D.  12/94; revised 06/12/95.
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
Parameters cAppName, cFindStr, cReplStr
set talk off
set echo off
clear
close all
close data
private nStartPos, lDone, nLocPos, nCnt, aPos[1]
nCnt = 0     && count of references to D:\PROJECTS
lDone = .F.  && Finished flag

cAppName = Default( cAppName, "CAPCON.APP" )
cFindStr = Default( cFindStr, "d:\projects" )  && use a partial path 
                                               && where the build was done
cReplStr = Default( cReplStr, "c:\projects" )  && substitute the valid 
                                               && c: drive in the string

set step on
create cursor UPDT_APP (APP_FILE M)  && someplace to examine the .APP
append blank  && Load .APP into Memo for fairly quick search using atc()...
wait "Loading existing " + cAppName + " file..." window nowait
append memo app_file from ( cAppName )
wait "Locating D: Drive references..." window nowait
do while !lDone  && Search and record all occurrences
  nLocPos = atc( cFindStr, app_file, nCnt + 1 )  && Locate next
  if nLocPos > 0
    nCnt = nCnt + 1             && count occurrences
    Dimension aPos[ nCnt ]
    aPos[ nCnt ] = nLocPos - 1  && -1 for fseek() from 0 adjustment
  else
    lDone = .T.
  endif
enddo
use
Wait "Replacing " + str( nCnt, 3 ) + " references..." window nowait
nFh = fopen( cAppName, 2 )
if nFh > -1
  for nPos = 1 to nCnt
    if fseek( nFh, aPos[ nPos ] ) = aPos[ nPos ]
      =fwrite( nFh, cReplStr )  && replace with acceptable drive.
    else
      wait "Failed to seek to position " + str( aPos[ nPos ], 7 ) window
    endif
  next
else
  wait "Failed to Open .APP for update!  Press Enter." window
endif
=fclose( nFh )
wait "Done! " + str( nCnt, 3 ) + " replacements." window

function default
  parameter Var, Def
  return ( iif( type( "Var" ) = "L", Def, Var ) )
