*FUNCTION FindFile

*Architect: Bob Bartel, MBA
*   Notice: Copyright(c) 1995, Bob C. Bartel
*         : All Rights Reserved
*  Contact: Bob Bartel
*         : MarketWare, Inc.
*         : 2563 East Willow Hills Drive
*         : Sandy, Utah   84093-1801
*         : Telephone: 801-944-0876
*         :       FAX: 801-942-2385
*         : CompuServe: 74431,1122
*         : 
*   Syntax: FindFile(C FileName, C DriveList)
*   Action: Find the first occurance of a File on the drive(s) specified.
*   Return: <Expr C>
*    Notes: This function will return the complete path to any file
*         : you are searching for.  For example, if you want to find
*         : WINWORD.EXE on the "C" or "D" drive, call this 
*         : function as follows:
*         : 
*         : cWinWordPath = FindFile("WINWORD.EXE","CD")
*         : 
*         : The function will search all directories on the "C" drive
*         : until it finds WINWORD.EXE (up to 4 levels of subdirectories
*         : deep).  It will return the first occurance of WINWORD.EXE only,
*         : and if it does not find WINWORD.EXE, then it will search the
*         : "D" drive, if nothing found on "D" then it will return a
*         : null string ("").
*         : 
*         : This is freeware.  Take, enjoy, change, improve, I don't care.

PARAMETERS m.cFileName,m.cDriveList
PRIVATE m.j,m.k,m.l,m.n,m.cParent1,m.cParent2,m.cParent3,m.nDir
PRIVATE m.nFiles1,m.nFiles2,m.nFiles3,m.nFiles4,m.nFiles5

* We will look four levels deep for the file

FOR m.j = 1 TO LEN(m.cDriveList)	&& For each drive

	* Big assumption here: valid drive letters are passed to function!

	m.cParent1 = SUBSTR(m.cDriveList,m.j,1)+":\"
	SET DEFAULT TO (m.cParent1)
	m.nDir = ADIR(aDirList1,m.cFileName)
	
	IF m.nDir > 0	&& Found it!
		RETURN m.cParent1+aDirList1[1,1]
	ENDIF
	
	m.nDir = ADIR(aDirList1,"","D")		&& Total Dirs from root
	IF m.nDir > 0
		=ASORT(aDirList1)
	ENDIF	
	
	FOR m.k = 1 TO m.nDir		&& For each directory off of root

		* Level 1
		m.cParent2 = m.cParent1+aDirList1[m.k,1]+"\"
		SET DEFAULT TO (m.cParent2)
		m.nFiles1 = ADIR(aDirList2,m.cFileName)
		
		IF m.nFiles1 > 0	&& Found it!
			RETURN m.cParent2+aDirList2[1,1]
		ENDIF
		
		* Level 2
		m.nFiles2 = ADIR(aDirList2,"","D")
		
		FOR m.l = 1 TO m.nFiles2		&& For each subdirectory
			IF aDirList2[m.l,1] = "."	&& Disregard these: . ..
				LOOP
			ENDIF
			m.cParent3 = m.cParent2+aDirList2[m.l,1]+"\"			
			SET DEFAULT TO (m.cParent3)
			m.nFiles3 = ADIR(aDirList3,m.cFileName)
			
			IF m.nFiles3 > 0	&& Found it!
				RETURN m.cParent3+aDirList3[1,1]
			ENDIF
			
			* Level 3
			m.nFiles3 = ADIR(aDirList3,"","D")
			
			FOR m.n = 1 TO m.nFiles3 	&& For each sub-subdirectory
				IF aDirList3[m.n,1] = "."
					LOOP
				ENDIF
				m.cParent4 = m.cParent3+aDirList3[m.n,1]+"\"			
				SET DEFAULT TO (m.cParent4)
				m.nFiles4 = ADIR(aDirList4,m.cFileName)
				
				IF m.nFiles4 > 0	&& Found it!
					RETURN m.cParent4+aDirList4[1,1]
				ENDIF
				
				* Level 4
				m.nFiles4 = ADIR(aDirList4,"","D")
				
				FOR m.q = 1 TO m.nFiles4	&& For each sub-sub-subdirectory
					IF aDirList4[m.q,1] = "."
						LOOP
					ENDIF
					m.cParent5 = m.cParent4+aDirList4[m.q,1]+"\"			
					SET DEFAULT TO (m.cParent5)
					m.nFiles5 = ADIR(aDirList5,m.cFileName)
					
					IF m.nFiles5 > 0	&& Found it!
						RETURN m.cParent5+aDirList5[1,1]
					ENDIF
				NEXT
			NEXT
		NEXT
	NEXT
NEXT

RETURN ""