*  Program Ŀ
*   Application: FoxFire 2.5X Reindex all files outside of system           
*   Description: Created to replace cdx's deleted outside system            
*     File Name: FF_MKCDX.PRG                                               
*        Author: Geary F. Rachel                                            
*  Date created: 04-18-95              Date updated: 04-18-95              
*  Time created: 01:35:53pm            Time updated: 01:35:53pm            
*       Docs By: Geary F. Rachel                                            
*     Copyright: (c) 1995 by OMNI Micro Consultants    800-473-6664                     
* 

*\ Hello.
*\ I wrote this because I deleted all the cdx's off my hard drive to make
*\ room for a large project swap.  Then I found out that FF can't reindex
*\ it's files external to the system.  But I had to have indexes to get in
*\ the system.  But the index routine was buried deep in the system...
*\ So here you are:  a FF25X reindexing utility which works independent of
*\ FoxFire.  I hope someone besides me will apreciate this someday...

*\ Based (loosely) on code found in FFreindex.prg
*\ Thanks to all the MM development team for the great product,
*\ which needed just this one little addition<g,d&rvvvf>...

*\ I'm going to do some drastic things to your environment -
*\    turn off the error system
*\    close all your data
*\ and I'm not gonna set it back.  This is a crude tool for doing a
*\ quick and efficient job.  If you need this tool, this won't matter.

*\ Usage:  At the command window enter "do FF_mkcdx", no parameters
*\ It will work from anywhere,but will work best if located in and strted from
*\ the FF home directory.


set safety off
set talk off
on error *                                       && inhibits the cdx not found error

wait window nowait 'ffprefer'

*\ FF system files first...
IF ! file('ffprefer.dbf')
   set defa to getdir('', 'Where is FoxFixe Home Directory?')
   IF ! file('ffprefer.dbf')
      wait window 'Unable to locate FFPREFER.DBF, Program Canceled ' ;
         timeout 15
      retu
   endif
   IF ! used('ffprefer')
      use ffprefer
   else
      select ffprefer
   ENDIF
else
   IF ! used('ffprefer')
      use ffprefer
   else
      select ffprefer
   ENDIF
ENDIF

DELETE TAG ALL

*\ FFPREFER
INDEX ON  UPPER(PF_NAME)    TAG  PF_NAME
INDEX ON  DELETED()         TAG  DELETED

set path to dbfs,programs,


*\ FF_HELP
wait window nowait 'ffhelp'
selec 0
use ffmsghlp
INDEX ON  Msg_subsys + STR(MSG_NO,4);
   + STR(MSG_SUBNO,2)  TAG MSG_NO
INDEX ON  DELETED()         TAG DELETED
use

*\ FFSYSOBJ
wait window nowait 'ffsysobj'
select 0
use ffsysobj
INDEX ON OBJ_CLASS + OBJ_TYPE              TAG FFSYSOBJ
use


*\ now do all the preference set data files...
wait window nowait 'ffprefer'
select ffprefer
locate

llMakeFFStyleCdx = .T.

scan while ! eof()
   *\ RPT_DITEM
   IF ! empty(ffprefer.pf_ditemfl)
      jcThisItemFile = ffprefer.pf_ditemfl
      wait window nowait (jcThisItemFile)
      select 0
      use (jcThisItemFile)
      locate

      INDEX ON  UPPER(Rdi_Name)   TAG  RDI_NAME
      INDEX ON  Rdi_Filter        TAG  RDI_FILTER
      INDEX ON  Rdi_Fldnam        TAG  RDI_FLDNAM

      *Use a macro for the pad length so that index expression
      *Gets stored with a literal number.
      * Trim the Sort Prefix so that some data item can have prefixes and not
      * others so that they inter-mix as expected

      PRIVATE tmp_srtlen
      tmp_srtlen = ALLTRIM(STR(LEN(Rdi_Srtprf + Rdi_Name)))
      INDEX ON  PADR(UPPER(TRIM(Rdi_Srtprf) + Rdi_Name),&tmp_srtlen);
         TAG  RDI_SRTPRF

      INDEX ON  Rdi_Fldtyp        TAG  RDI_FLDTYP
      INDEX ON  EMPTY(Rdi_Views)  TAG  NO_VIEWS
      INDEX ON  Rdi_Misc          TAG  RDI_MISC
      INDEX ON  DELETED()         TAG  DELETED
      use
   ENDIF


   *\ RPT_JOIN
   IF ! empty(ffprefer.pf_joinfl)
      jcThisJoinFile = ffprefer.pf_joinfl
      wait window nowait (jcThisJoinFile)
      select 0
      use (jcThisJoinFile)
      locate

      REPLACE ALL Alias1 WITH UPPER(Alias1),;
         Alias2 WITH UPPER(Alias2);
         Alias1file WITH UPPER(Alias1file),;
         Alias2file WITH UPPER(Alias2file),;
         Join_views WITH UPPER(Join_views),;
         misc       WITH UPPER(misc);
         FOR (Alias1 + Alias2 + Alias1file + Alias2file + Join_views + misc);
            # UPPER(Alias1 + Alias2 + Alias1file + Alias2file + ;
            Join_views + misc)

         INDEX ON  Alias1 + Alias2   TAG  JOIN
         INDEX ON  Alias1            TAG  ALIAS1
         INDEX ON  Alias2            TAG  ALIAS2
         INDEX ON  EMPTY(Join_views) TAG  NO_VIEWS
         INDEX ON  Misc              TAG  MISC
         INDEX ON  DELETED()         TAG  DELETED
         use
      endif

      *\ RPT_RQST
      IF ! empty(ffprefer.pf_rqstfl)
         jcThisRqstFile = ffprefer.pf_rqstfl
         wait window nowait (jcThisRqstFile)
         select 0
         use (jcThisRqstFile)
         locate

         INDEX ON  UPPER(Rq_Name)    TAG  RQ_NAME
         INDEX ON  Rq_User           TAG  RQ_USER
         INDEX ON  Rq_Dept           TAG  RQ_DEPT
         INDEX ON  Rq_Misc           TAG  RQ_MISC
         INDEX ON  Out_Union         TAG  OUT_UNION
         INDEX ON  DELETED()         TAG  DELETED
         use
      endif

      *\ RPT_STYLE
      IF ! empty(ffprefer.pf_stylfl)
         jcThisStylFile = ffprefer.pf_stylfl
         IF ! "FFSTYLEF" $ jcThisStyleFile or ;
               ("FFSTYLE" $ jcThisStyleFile  and llMakeFFStyleCdx)
            wait window nowait (jcThisStylFile)
            select 0
            use (jcThisStylFile)
            locate

            INDEX ON UPPER(STYLE_NAME)  TAG  STYLE_NAME
            INDEX ON DELETED()          TAG  DELETED
            IF "FFSTYLEF" $ jcThisStyleFile
               llMakeFFStyleCdx = .F.
            endif

         ENDIF
         use
      endif


      select ffprefer
   endscan


   close data
   set safety on
   set talk on
   on error

RETURN
