PROCEDURE holiday
	PARAMETERS firstday,lastday
	*
	* validate, if only one date it's the last day
	*  and we assume firstdate is today
	*
	* If there's no firstday, then we assume lastday
	*  is the begining of the next week!
	*
	* If the firstday is NUMERIC the it's a number of days
	*  holiday...
	*
	DO CASE
		CASE TYPE('lastday')='L'
			*
			* We run from today unti following MONDAY
			*
			lastdate=DATE()+8-DOW(DATE())
			*
			* note that makes running it on Sunday fail !
			*
		CASE TYPE('lastday')='D'
			lastdate=lastday
		OTHERWISE RETURN
	ENDCASE

	DO CASE
		CASE TYPE('firstday')='L'
			*
			* We run from today until following MONDAY
			*
			firstdate=DATE()

		CASE TYPE('firstday')='D'
			*
			* firstday is a date!
			*
			IF TYPE('lastday')='L'
				*
				* We run until date given
				*
				firstdate=DATE()
			ELSE
				firstdate=firstday
			ENDIF

		CASE TYPE('firstday')='N'
			if firstday >=1
				*
				* firstday is number of days holiday
				*
				firstdate=DATE()
				lastdate=DATE()+firstday
			else
				*
				* probably someone typed 11/4/93 which is a small number
				*  expression  about 0.03 !
				*
				* so exit
				*
				return
			endif	

		OTHERWISE RETURN
	ENDCASE

	*
	SET TALK OFF
	CLEAR
	ON shutdown DO abend IN UPDATE WITH .T.
	SAFE = .F.
	*
	SET PATH TO C:\foxprow
	*
	* Safety code to get screen back!
	*
	ON KEY LABEL esc DO abend IN UPDATE WITH .T.
	ON ESCAPE DO abend IN UPDATE WITH .T.
	*
	* hide the screen so FPW can't be seen
	*
	IF NOT SAFE
		MODI WIND SCREEN FROM -15,-15 TO -5,-5
	ENDIF
	DO WHILE BETWEEN(DATE(),firstdate,lastdate)

		DO waitdef
		ACTI WIND waitwindow



		whentodo="19:15"
		pass1time = whentodo+":00"

		CLEAR
		@ 0,3 SAY "Waiting for cheap rate..."
		*
		* NOTE  ! /n1 ozcis.pif /1 /x   runs the program and continues FPW
		*
		* which is why we wait for completion...
		*
		DO waituntil WITH whentodo
		CLEAR
		@ 0,4 SAY "Running OzCIS pass 1"
		! /n1 ozcis.pif /1 /x /s
		WAIT "" TO dummy TIMEOUT 30
		pass1time = TIME()
		*
		CLEAR
		whentodo=LEFT(TIME(),5)
		whentodo=ALLTRIM(STR(VAL(LEFT(whentodo,2))+2)+SUBSTR(whentodo,3,3))
		*
		@ 0,4 SAY "Waiting for Download"
		DO waituntil WITH whentodo
		*
		CLEAR
		@ 0,3 SAY "Saving Session.log"
		WAIT "" TO dummy TIMEOUT 5
		if file('c:\ozcis\pass1.log')
			dele file c:\ozcis\pass1.log
		ENDIF
		if file('c:\ozcis\session.log')
			rename c:\ozcis\session.log to c:\ozcis\pass1.log
		endif

		*
		CLEAR
		@ 0,3 SAY "Starting PARSFF"
		WAIT "" TO dummy TIMEOUT 5

		*
		* preserve memory!
		*
		SAVE TO 'c:\foxprow\update'
		SET DEFA TO \foxprow\ff
		DO parsff WITH "c:\ozcis\foxforum\foxforum.msg","N"
		*
		* preserve memory!
		*
		RESTORE FROM 'c:\foxprow\update' ADDITIVE
		DELETE FILE 'c:\foxprow\update.mem'

		DO waitdef
		ACTI WIND waitwindow
		*
		CLEAR
		@ 0,5 SAY "Deleting .REP files"
		IF ADIR(fileinfo,'c:\ozcis\foxforum\foxforum.rep') <> 0
			IF (fileinfo(1,3) < DATE());
					OR ((fileinfo(1,3) = DATE()) AND (fileinfo(1,4) <= pass1time))
				COPY FILE C:\ozcis\foxforum\foxforum.rep TO C:\foxprow\foxforum.ser
				DELE FILE C:\ozcis\foxforum\foxforum.rep
			ENDIF
		ENDIF
		*
		IF DOW(DATE())=2						&& MONDAY
			CLEAR
			@ 0,5 SAY "Deleting OzCIS Purge files"
			*		DELETE FILE C:\ozcis\foxbeta\foxbeta.prg
			DELETE FILE C:\ozcis\foxforum\foxforum.prg
		ENDIF
		*
		CLEAR
		@ 0,4 SAY "Running OzCIS pass 2"
		! /n1 ozcis.pif /2 /x /s
		WAIT "" TO dummy TIMEOUT 5
		*

		CLEAR
		whentodo=LEFT(TIME(),5)
		whentodo=ALLTRIM(STR(VAL(LEFT(whentodo,2))+2)+SUBSTR(whentodo,3,3))
		*
		@ 0,4 SAY "Waiting for Download"
		DO waituntil WITH whentodo
		*
		CLEAR
		@ 0,3 SAY "Saving Session.log"
		WAIT "" TO dummy TIMEOUT 5
		if file('c:\ozcis\pass2.log')
			dele file c:\ozcis\pass2.log
		ENDIF
		if file('c:\ozcis\session.log')
			rename c:\ozcis\session.log to c:\ozcis\pass2.log
		endif

		CLEAR
		@ 0,3 SAY "Starting PARSFF"
		@ 1,3 SAY " nodelete"
		WAIT "" TO dummy TIMEOUT 5

		*
		* preserve memory!
		*
		SAVE TO 'c:\foxprow\update'
		SET DEFA TO C:\foxprow\ff
		DO parsff WITH "c:\ozcis\foxforum\foxforum.msg","N"
		SET DEFA TO C:\foxprow
		*
		* preserve memory!
		*
		RESTORE FROM 'c:\foxprow\update' ADDITIVE
		DELETE FILE 'c:\foxprow\update.mem'

		tomorrow=DATE()+1
		DO WHILE DATE() < tomorrow
			CLEAR
			@ 0,4 SAY "Waiting for "+ CDOW(tomorrow)
			@ 1,1 SAY CDOW(DATE())+" @ "+LEFT(TIME(),5)
			WAIT "" TO dummy TIMEOUT 3600
		ENDDO

	ENDDO
	DO abend IN UPDATE
	RETURN

PROCEDURE waituntil
	PARAMETER WHEN
	PRIVATE dummy
	DO waitdef
	*
	* pressing SPACEBAR makes it go off NOW
	*
	ON KEY LABEL spacebar DO fudge
	*
	target_hour = VAL(LEFT(WHEN,2))
	target_minute = VAL(RIGHT(WHEN,2))
	early=.T.
	dummy=""
	DO WHILE early
		IF dummy==" "
			DO fudge
		ENDIF
		IF dummy==CHR(27)
			DO abend IN UPDATE WITH .T.
		ENDIF
		IF VAL(RIGHT(TIME(),2))<= 10
			ACTI WIND waitwindow
			@ 1,1 SAY LEFT(TIME(),5)+" Waiting until "+WHEN
		ENDIF
		early=!(LEFT(TIME(),5) = WHEN)
		IF HOUR(TIME()) > target_hour
			early = .F.
		ELSE
			IF (HOUR(TIME()) = target_hour);
					AND (minute(TIME()) > target_minute)
				early=.F.
			ENDIF
		ENDIF
		WAIT "" TO dummy TIMEOUT 10
	ENDDO
	WAIT CLEAR
	ON KEY LABEL spacebar
	RETURN

PROCEDURE abend
	PARAMETERS whattodo
	IF TYPE("whattodo") # "L"
		whattodo=.F.
	ENDIF

	ON KEY LABEL esc
	ON KEY LABEL spacebar
	ON ESCAPE
	ON shutdown
	ACTI WIND SCREEN
	RELE WIND waitwindow
	MODI WIND SCREEN FROM 0,0 TO 54.5,125.8                && values for 1024x768 !
	SET TALK ON
	IF TYPE('safe')='U'
		CLOSE DATA
		QUIT
	ELSE
		IF whattodo OR SAFE
			SET STEP ON
			RELE WIND trace
			CLOSE DATA
			CANCEL
			RETURN
		ELSE
			CLOSE DATA
			QUIT
		ENDIF
	ENDIF
	RETURN

PROCEDURE fudge
	? CHR(7)
	ON KEY LABEL spacebar
	WHEN=LEFT(TIME(),5)
	RETURN


FUNCTION HOUR
	PARAMETER WHEN
	RETURN	VAL(LEFT(WHEN,2))

FUNCTION minute
	PARAMETER WHEN
	RETURN	VAL(SUBSTR(WHEN,4,2))

PROCEDURE waitdef
	IF !WEXIST('WaitWindow')
		DEFI WIND waitwindow FROM 1,1 SIZE 2,30;
			FONT "Arial",14;
			TITLE "FoxPro HOLIDAY Auto-Mail";
			IN DESKTOP;
			FLOAT CLOSE
	ENDIF
	RETURN
