* ͻ
* PROGLIST.PRG                                                             
* Load a table with all of the files of a designated type                  
* Files Needed to Run this Program:                                        
*      ProgList.prg - ProgList.Dbf - ProgList.MDX - Programs.dbf           
* 01/31/92                                                                 
* Author:  C.R. GROETZINGER                                                
* Copyright (C) 1992  Oak Tree Productions, Inc.  All rights reserved      
*                                                                          
* ͼ
*
CLEAR ALL
SET TALK OFF
SET CONFIRM ON
SET STATUS OFF
SET SCOREBOARD OFF
STORE SPACE(3) TO Extension
STORE SPACE(8) TO OutPut
DEFINE WINDOW TextScrn FROM 0,0 TO 16,79 COLOR +W/R
DEFINE WINDOW EntrScrn FROM 18,25 TO 21,55 COLOR N/W
CLEAR
ACTIVATE WINDOW TextScrn
TEXT
                              PROGLIST.PRG

  The purpose of this program is to load a table with all of the files, in
  the current directory, with one type of extension into a table.  

  With this completed, different actions may be taken to these files from
  within a program, sending the table through a "DO WHILE .NOT. EOF() LOOP".
  For instance, with .PRG files sent through a loop of COMPILE &FileName, all
  of the programs in the directory will be compiled.  

  At the Prompt, enter the extension name or type [END] to quit.
  You will also be asked to supply an output file name.
  Version Number defaults to 1.0 which can be changed in the Browse at the end.
ENDTEXT
STORE .F. TO AllRight
DO WHILE .NOT. AllRight 
   DEFINE WINDOW ErrScrn FROM 6,25 TO 15,55 COLOR +W/B
   ACTIVATE WINDOW EntrScrn
   @ 0,1 SAY 'Enter EXTension: 'GET Extension PICTURE '!!!'
   @ 1,1 SAY '      Filename.: 'GET OutPut PICTURE '!!!!!!!!'
   READ
   DEACTIVATE WINDOW EntrScrn
   STORE TRIM(OutPut)+'.dbf' TO OutPut
   STORE "'"+Output+"'" TO OutName
   IF FILE(&OutName)
      ?? CHR(7)
      ACTIVATE WINDOW ErrScrn
      STORE 'N' TO OverWrite
      @ 0,1 SAY 'This Filename is an Existing'
      @ 1,1 SAY 'data file. '
      @ 3,1 SAY 'Press [B] to Browse'
      @ 4,1 SAY '      [Y] to OverWrite '
      @ 5,1 SAY '      [N] to Rename'
      @ 7,1 SAY ' Your Choice: 'GET OverWrite PICTURE '@M B,N,Y'
      READ
      DEACTIVATE WINDOW ErrScrn
      IF OverWrite = 'B'
         USE &OutPut IN SELECT() ALIAS OutFile
         SELECT OutFile
         BROWSE NOEDIT NODELETE NOAPPEND
         SELECT OutFile
         USE
         ACTIVATE WINDOW ErrScrn
         STORE 'N' TO Overwrite
         @ 0,1 SAY 'This Filename is an Existing'
         @ 1,1 SAY 'data file. '
         @ 4,1 SAY '      [Y] to OverWrite '
         @ 5,1 SAY '      [N] to Rename'
         @ 7,1 SAY ' Your Choice: 'GET OverWrite PICTURE '@M B,N,Y'
         READ
      ENDIF
      IF OverWrite = 'N'
         STORE SPACE(8) TO OutPut
         LOOP
      ENDIF
      IF OverWrite = 'Y'
         ERASE &OutPut
         STORE .T. TO AllRight
      ENDIF
   ELSE
      STORE .T. TO AllRight
   ENDIF     
ENDDO
RELEASE WINDOW TextScrn
IF Extension = 'END' .OR. LEN(TRIM(OutPut)) = 0
   CLEAR ALL
   RETURN
ENDIF
RUN DIR *.&Extension > ProgList.TXT
SET TALK ON
SELECT 1
USE PROGRAMS ALIAS PRfile EXCLUSIVE
APPEND FROM ProgList.TXT SDF
IF RECCOUNT() = 0
   CLEAR
   @ 2,1 SAY 'No Files were found with the '+Extension+' extension name.'
   @ 3,0 SAY ''
   WAIT
   CLEAR ALL
   RETURN
ENDIF
STORE RECCOUNT() TO Recs
DELETE FOR RECNO() > Recs-2
DELETE FOR RECNO() < 5
PACK
SELECT 2
USE PROGLIST ALIAS PLfile
COPY STRUCTURE TO &OutPut WITH PRODUCTION
SELECT PLfile
USE
SELECT 2
USE &Output ALIAS PLfile
SET ORDER TO TAG FileName
SELECT PRfile
GO TOP
DO WHILE .NOT. EOF()
   STORE TRIM(SUBSTR(Line,1,8)) TO M_filename
   STORE SUBSTR(Line,10,3) TO M_fileext
   STORE CTOD(SUBSTR(Line,24,8)) TO M_filedate
   STORE 1.0 TO M_filevers
   SELECT PLfile
   APPEND BLANK
   REPLACE FileName WITH M_filename + '.'+M_fileext
   REPLACE FileDate WITH M_filedate
   REPLACE FileVers WITH M_filevers
   SELECT PRfile
   SKIP
ENDDO
SELECT PRfile
USE
SET SAFETY OFF
   ERASE PROGLIST.TXT
   USE Programs.dbf
   ZAP
SET SAFETY ON
SELECT PLfile
GO TOP
BROWSE
CLEAR
IF EXTENSION = 'PRG'
   ACTIVATE WINDOW ErrScrn
   SET TALK OFF
   CLEAR
   STORE 'C' TO Action
   @ 0,1 SAY 'You May now Compile all the '
   @ 1,1 SAY 'Programs in the Table.'
   @ 3,1 SAY '    [C] - Compile Now'
   @ 4,1 SAY '    [Q] - Exit'
   @ 6,1 SAY 'Your Choice: 'GET Action PICTURE '@M C,Q'
   READ
   IF Action = 'C'
      STORE .F. TO CompErrs
      STORE 0 TO ErrCnt
      USE ErrFile IN SELECT() ALIAS ErrFile EXCLUSIVE
      USE DBerror ORDER TAG DB_error IN SELECT() ALIAS DBerror
      SELECT ErrFile
      SET SAFETY OFF
         ZAP
      SET SAFETY ON
      ON ERROR DO ErrStore
      SET TALK OFF
      SELECT PLfile
      GO TOP
      CLEAR
      DO WHILE .NOT. EOF()
         STORE FileName TO M_file
         IF M_file = 'PROGLIST.PRG'
            SKIP
            LOOP
         ENDIF
         @ 6,1 SAY 'Compiling....'+M_file
         SET CONSOLE OFF
         COMPILE &M_file
         SET CONSOLE ON
         SKIP
      ENDDO
      ON ERROR
      IF CompErrs
         CLEAR
         @ 0,1 SAY ' ***COMPILATION ERRORS***'
         @ 2,1 SAY LTRIM(STR(ErrCnt))+' Errors found'
         @ 3,1 SAY 'while compiling this list.'
         @ 4,1 SAY 'Access the ErrFile.dbf for'
         @ 5,1 SAY 'details.'
         WAIT
      ELSE
         CLEAR
         @ 0,1 SAY 'No Compilation Errors were'
         @ 1,1 SAY 'encountered.  '
         @ 2,1 SAY ''
         WAIT
      ENDIF
   ENDIF
ENDIF
RELEASE WINDOW ErrScrn
RELEASE WINDOW EntrScrn
CLEAR ALL
SET TALK OFF
RETURN
* EOP ProgList.prg


PROCEDURE ErrStore
*
SELECT ErrFile
APPEND BLANK
REPLACE ProgName WITH M_file
IF CERROR() > 0
   REPLACE ErrNumber WITH CERROR()
ELSE
   REPLACE ErrNumber WITH ERROR()
ENDIF
SELECT DBerror
STORE CERROR() TO CompErr
SEEK CompErr
IF FOUND()
   SELECT ErrFile
   REPLACE ErrMessge WITH DBerror->DB_messg
ELSE
   SELECT ErrFile
   REPLACE ErrMessge WITH MESSAGE()
ENDIF
SELECT PLfile
STORE .T. TO CompErrs
ErrCnt = ErrCnt + 1
RETURN
