*****************************************************************
*
*  Create a directory output file from a coded input file
*  Outputs a two to four column document for a laserjet printer
*
* Format for input is *S*(state)
*                     *C*(city)
*                     *A*(address line)
*                     *P*(phone)
*                     *T*(title)
*                     *N*(name)
	set talk off
	set echo off
*
* Setup variables
*
	public utext(200), irow(100), margins(3), irowv(100), itype(200)
	public icol,page_type,col_type,esc_c,formfeed,page_number,first_head
	public last_head,page_output,readin,blank,file2,file1,top_mar
	public pn_row,pn_col,headrow,h_c_v,s_c_v,headoffset
	public col_mar1,col_mar2,col_mar3,col_mar4,f_error
	public num_cols,nameout

	icol = 1
	page_type = "R"
	col_type = "1"
	esc_c = chr(27)
	formfeed = chr(12)
	page_number = 0
	first_head = ""
	last_head = ""
	page_output = 0
	namein = " "
	nameout = " "

	num_cols = "4"
  	col_len = "9"
    col_mar1 = "0.5"
	col_mar2 = "2.375"
	col_mar3 = "4.25"
	col_mar4 = "6.0627"
	top_mar = "0.5"
	pnrow = "10"
	pncol = "3.75"
	headrow = "0"
	headoffset = "26"
	s_c_v = "14"
	header_text = " "
	h_c_v = "190"
	max_output = "99999"
	irpoint=0
	blank=' '
	f_error=0
*
	define window get_params from 2,3 to 24,76 double;
		title "Directory Generation Parameters"
	activate window get_params

	msg='Press <Ctrl><W> to Proceed, and <Esc> to Cancel'
	spc=space(int((73-len(msg))/2))
	f=73-(len(msg)+len(spc))
	msg=spc+msg+iif(f>0,space(f),'')
	@ 3, 1 say "Number of columns: "+num_cols
	@ 3,20 get num_cols size 1,1 picture '9' range '2','4' valid col_calc() color &out_color
	@ 4, 1 say "Maximum length of column in inches: "+col_len
	@ 4,37 get col_len size 1,2 picture '99' color &out_color
  	@ 5, 1 say "Margin of column one (inches): "+col_mar1
	@ 5,32 get col_mar1 size 1,6 picture '9.9999' color &out_color
  	@ 6, 1 say "Margin of column two (inches): "+col_mar2
	@ 6,32 get col_mar2 size 1,6 picture '9.9999'  color &out_color
	@ 7, 1 say "Margin of column three (inches): "+col_mar3
	@ 7,34 get col_mar3 size 1,6 picture '9.9999' when val(num_cols)>2 color &out_color
	@ 8, 1 say "Enter column four margin (inches): "+col_mar4
	@ 8,36 get col_mar4 size 1,6 picture '9.9999' when val(num_cols)=4 color &out_color
	@ 9, 1 say "Top margin (inches): "+top_mar
	@ 9,22 get top_mar size 1,6 picture '9.9999' color &out_color
	@10, 1 say "Page number row position (inches): "+pnrow
	@10,36 get pnrow size 1,6 picture '9.9999' color &out_color
	@11, 1 say "Page number column position (inches): "+pncol
	@11,39 get pncol size 1,6 picture '9.9999' color &out_color
	@12, 1 say "State header row position (inches): "+headrow
	@12,37 get headrow size 1,6 picture '9.9999' color &out_color
	@13, 1 say "Right page header offset (characters): "+headoffset
	@13,40 get headoffset size 1,3 picture '999' color &out_color
	@14, 1 say "State centering value (characters): "+s_c_v
	@14,37 get s_c_v size 1,3 picture '999' color &out_color
	@15, 1 say "Header text: "+header_text
	@15,14 get header_text size 2,50 color &out_color
	@17, 1 say "Header centering value (characters): "+h_c_v
	@17,38 get h_c_v size 1,3 picture '999' color &out_color
	@18, 1 say "Maximum number of pages to be output: "+max_output
	@18,39 get max_output size 1,6 picture '999999' color &out_color
	@20, 0 say msg color W+/R
	
	set default to (topath)
	namein = getfile('TXT','Name of file to process')
	IF lastkey()=27
		wait window 'No File Selected - Cancelling' nowait
		release window get_params
		return
	ENDIF
	nameout = putfile('Name of output file','direct.bin', 'BIN')
	IF lastkey()=27
		wait window 'No File Selected - Cancelling' nowait
		release window get_params
		return
	ENDIF

	@ 0, 0 say 'File to Process: '+namein
	@ 1, 0 say 'Output File: '+nameout

	set cursor on
	read cycle
	set cursor off
	
	release window get_params
	IF lastkey()=27
		return
	ENDIF

	irowmax = int(val(col_len) * 720)
	ir = 0
	header_text=alltrim(header_text)
	
	IF file(namein)
		file1=fopen(namein,0)
		IF file1 < 0
			wait window 'File already open - cannot continue'
			return
		ENDIF
		=fseek(file1,0) 
		IF feof(file1)
			wait window 'This file is empty!' nowait
			return
		ENDIF
	ELSE
		wait window 'File Does not Exist - Quitting'
		return
	ENDIF

	IF file(nameout)
		wait window 'Overwriting the File' nowait
		delete file (nameout)
	ENDIF

	file2=fcreate(nameout)
	IF file2<0
		wait window 'Unable to Open Output File'
		return
	ENDIF
	
* Beginning of main loop
	processing=.t.
	DO WHILE processing

		DO WHILE irpoint <= irowmax
		    readin=fgets(file1)
		    do trim_line
		    IF blank <> "Y" 
		    	IF at("*S*",readin) = 1 
		    		ir = ir + 1
		    	    IF ir <> 1 
		    	    	itype(ir) = 6
		    	    	utext(ir) = " "
		    	    	irow(ir) = irpoint
		    	    	irpoint = irpoint + 100
		    	    	irowv(ir) = 100
		    	    	ir = ir + 1
		    	    	itype(ir) = 6
		    	    	utext(ir) = " "
		    	    	irow(ir) = irpoint
		    	    	irpoint = irpoint + 100
		    	    	irowv(ir) = 100
		    	    	ir = ir + 1
		    	    ENDIF
		    	    itype(ir) = 1
		    	    utext(ir) = esc_c + "(1X" + space(int(val(s_c_v) - (len(substr(readin, 4)) / 2))) + alltrim(substr(readin, 4))
		    	    irow(ir) = irpoint
		    	    irpoint = irpoint + 120
		    	    irowv(ir) = 120
		    	    ir = ir + 1
		    	    itype(ir) = 6
		    	    utext(ir) = " "
		    	    irow(ir) = irpoint
		    	    irpoint = irpoint + 100
		    	    irowv(ir) = 100
		    	ENDIF
		
		      	IF at("*C*",readin) = 1 
		        	ir = ir + 1
		        	itype(ir) = 4
		        	utext(ir) = " "
		        	irow(ir) = irpoint
		        	irpoint = irpoint + 100
		        	irowv(ir) = 100
		        	ir = ir + 1
		        	itype(ir) = 2
		        	i = at("*R*",readin)
		        	IF i=0
		        		i=len(readin)+1
		        	ENDIF
		        	lastcity = esc_c + "(2X" + substr(readin, 4, i - 1 - 3) + esc_c + "(3X (cont.)"
		        	utext(ir) = esc_c + "(2X" + substr(readin, 4, i - 1 - 3) + esc_c + "(3X" + alltrim(substr(readin, i + 3))
		        	irow(ir) = irpoint
		        	irpoint = irpoint + 100
		        	irowv(ir) = 100
		      	ENDIF
			
		      	IF at("*A*",readin) = 1 
		        	ir = ir + 1
		        	itype(ir) = 3
		        	utext(ir) = esc_c + "(3X" + "  " + alltrim(substr(readin, 4))
		        	irow(ir) = irpoint
		        	irpoint = irpoint + 100
		        	irowv(ir) = 100
		      	ENDIF
		
		      	IF at("*P*",readin) = 1 
		        	ir = ir + 1
		        	itype(ir) = 3
		        	utext(ir) = esc_c + "(3X" + "  " + alltrim(substr(readin, 4))
		        	irow(ir) = irpoint
		        	irpoint = irpoint + 100
		        	irowv(ir) = 100
		      	ENDIF
		
		      	IF at("*T*",readin) = 1 
		        	ir = ir + 1
		        	itype(ir) = 5
		        	utext(ir) = " "
		        	irow(ir) = irpoint
		        	irpoint = irpoint + 50
		        	irowv(ir) = 50
		        	ir = ir + 1
		        	itype(ir) = 8
		        	utext(ir) = esc_c + "(2X" + "  " + alltrim(substr(readin, 4))
		        	irow(ir) = irpoint
		        	irpoint = irpoint + 100
		        	irowv(ir) = 100
		      	ENDIF
		
		      	IF at("*N*",readin) = 1 
		        	ir = ir + 1
		        	itype(ir) = 7
		        	utext(ir) = esc_c + "(3X" + "  " + alltrim(substr(readin, 4))
		        	irow(ir) = irpoint
		        	irpoint = irpoint + 100
		        	irowv(ir) = 100
		      	ENDIF
*		      	wait window utext(ir)
			ENDIF
			
*		    wait window iif(feof(namein),'end of file','not end of file')
			IF feof(file1)
				do print_last_page
				=fclose(file1)
				=fflush(file2)
				=fclose(file2)
				do print_it
				return
			ENDIF
		ENDDO
		
* Final breakpoint
		ilastir = ir
		DO WHILE irpoint > irowmax
			irpoint = irpoint - irowv(ir)
			ir = ir - 1
		ENDDO
		x = "N"
		DO WHILE x = "N"
			IF (itype(ir) = 7 .and. itype(ir - 1) = 7) .or. (itype(ir) = 7 .and. itype(ir - 1) = 8) .or. (itype(ir) = 3 .and. itype(ir - 1) = 3) 
		    	x = "Y"
		    ELSE
		    	irpoint = irpoint - irowv(ir)
		    	ir = ir - 1
		    ENDIF
		ENDDO
		ipdif = irowmax - irpoint
		 
* Count adjustments
		adj = 0
		FOR i = 2 TO ir
			IF itype(i) = 4 .and. itype(i - 1) = 7 
				adj = adj + 1
			ENDIF
		NEXT

* make vertical adjustment
		irpoint = 0
		adj = ipdif / adj
		FOR i = 1 TO ir
			IF i > 1 
				IF itype(i) = 4 .and. itype(i - 1) = 7 
					irow(i) = irpoint + adj
					irpoint = irpoint + irowv(i) + adj
				ELSE
					irow(i) = irpoint
					irpoint = irpoint + irowv(i)
				ENDIF
			ELSE
				irow(i) = irpoint
				irpoint = irpoint + irowv(i)
			ENDIF
		NEXT

* print out page
		DO CASE 
			CASE col_type = "1" 
				ilm = int(720 * val(col_mar1))
			CASE col_type = "2" 
				ilm = int(720 * val(col_mar2))
			CASE col_type = "3" 
				ilm = int(720 * val(col_mar3))
			CASE col_type = "4"
				ilm = int(720 * val(col_mar4))
		ENDCASE
		
		FOR i = 1 TO ir
			temp=esc_c+"&a"+alltrim(str(ilm))+"H"+esc_c+"&a"+alltrim(str(val(top_mar) * 720 + irow(i)))+"V"+utext(i)
			w_error=fwrite(file2,temp)
			IF itype(i) = 1 
				readin = substr(utext(i), at("X",utext(i)) + 1)
				do trim_line
				last_head = readin
			ENDIF
		NEXT

		IF col_type = "1" 
			IF itype(1) = 1 
				readin = substr(utext(1), at("X",utext(1)) + 1)
				do trim_line
				last_head = readin
			ENDIF
		ENDIF
		
		IF col_type = num_cols
			page_number = page_number + 1
			f_error=fwrite(file2,esc_c+"&a")
			f_error=fwrite(file2,(alltrim(str(val(pnrow) * 720))))
			f_error=fwrite(file2,"V")
			f_error=fwrite(file2,esc_c+"&a")
			f_error=fwrite(file2,(alltrim(str(val(pncol) * 720))))
			f_error=fwrite(file2,"H")
			f_error=fwrite(file2,esc_c+"(1X"+alltrim(str(page_number)))
			f_error=fwrite(file2,esc_c+"&a")
			f_error=fwrite(file2,"0")
			f_error=fwrite(file2,"V")
			f_error=fwrite(file2,esc_c+"&a")
			f_error=fwrite(file2,"0")
			f_error=fwrite(file2,"H")
			f_error=fwrite(file2,esc_c + "(2X" + space(int((val(h_c_v) - len(header_text)) / 2)) + header_text)

	    	IF page_type = "R" 
*		    	f_error=fwrite(file2,esc_c+"&a")
*		    	f_error=fwrite(file2,(alltrim(str(val(headrow) * 720))))
*		    	f_error=fwrite(file2,"V")
*		    	f_error=fwrite(file2,esc_c+"&a")
*		    	f_error=fwrite(file2,(alltrim(str(val(col_mar4) * 720))))
*		    	f_error=fwrite(file2,"H")

				temp=esc_c+"&a"+alltrim(str(val(headrow) * 720))+"V"+esc_c+"&a"+alltrim(str(val(col_mar4) * 720))+"H"
				f_error=fwrite(file2,temp)
		    	f_error=fwrite(file2,esc_c+"(1X"+space(int(val(headoffset)) - len(last_head))+last_head)
		    ELSE
*		    	f_error=fwrite(file2,esc_c+"&a")
*		    	f_error=fwrite(file2,(alltrim(str(val(headrow) * 720))))
*		    	f_error=fwrite(file2,"V")
*		    	f_error=fwrite(file2,esc_c+"&a")
*		    	f_error=fwrite(file2,(alltrim(str(val(col_mar1) * 720))))
*		    	f_error=fwrite(file2,"H")

				temp=esc_c+"&a"+alltrim(str(val(headrow) * 720))+"V"+esc_c+"&a"+alltrim(str(val(col_mar1) * 720))+"H"
				f_error=fwrite(file2,temp)
		    	f_error=fwrite(file2,esc_c+"(1X"+first_head)
		    ENDIF

		    first_head = last_head
		    wait window "Page "+alltrim(str(page_number))+" completed" nowait
		    page_output = page_output + 1

			IF page_output >= val(max_output) 
				=fclose(file1)
				=fflush(file2)
				=fclose(file2)
				do print_it
			    return
			ENDIF

		ENDIF

* Move up buffer
		irpoint = 0
		ir = ir + 1

		DO WHILE itype(ir) = 4 .or. itype(ir) = 6 .or. itype(ir) = 5
		  	ir = ir + 1
		ENDDO

		IF itype(ir) = 3 .or. itype(ir) = 7 .or. itype(ir) = 8 
			utext(1) = lastcity
			itype(1) = 3
			irowv(1) = 100
			irow(1) = irpoint
			irpoint = 100
			j = 2
		ELSE
			j = 1
		ENDIF

		FOR i = ir TO ilastir
			utext(i - ir + j) = utext(i)
			itype(i - ir + j) = itype(i)
			irowv(i - ir + j) = irowv(i)
			irow(i - ir + j) = irpoint
			irpoint = irpoint + irowv(i - ir + j)
		NEXT

		ir = ilastir - ir + j

		DO CASE
			CASE num_cols='2'
				DO CASE
					CASE col_type = "2" 
						col_type="1"
			      		f_error=fwrite(file2,formfeed)
			       		IF page_type = "L" 
			         		page_type = "R"
			       		ELSE
			         		page_type = "L"
			       		ENDIF
					CASE col_type = "1" 
						col_type="2"
				ENDCASE
			CASE num_cols='3'
				DO CASE
					CASE col_type = "3" 
						col_type="1"
			      		f_error=fwrite(file2,formfeed)
			       		IF page_type = "L" 
			         		page_type = "R"
			       		ELSE
			         		page_type = "L"
			       		ENDIF
					CASE col_type = "2" 
						col_type="3"
					CASE col_type = "1" 
						col_type="2"
				ENDCASE
			CASE num_cols='4'
				DO CASE
					CASE col_type = "4"
						col_type="1"
			      		f_error=fwrite(file2,formfeed)
			       		IF page_type = "L" 
			         		page_type = "R"
			       		ELSE
			         		page_type = "L"
			       		ENDIF
					CASE col_type = "3" 
						col_type="4"
					CASE col_type = "2" 
						col_type="3"
					CASE col_type = "1" 
						col_type="2"
				ENDCASE
		ENDCASE

* Error handling
*		IF f_error=0
*			wait window 'Unable to Write to File - Cancelling' nowait
*			=fclose(file1)
*			=fflush(file2)
*			=fclose(file2)
*		    return
*		ENDIF			

	ENDDO
*
RETURN
*************************************************************************
*
*  Print the last page
*
PROCEDURE print_last_page
*
	DO CASE 
		CASE col_type = "1" 
			ilm = int(720 * val(col_mar1))
		CASE col_type = "2" 
			ilm = int(720 * val(col_mar2))
		CASE col_type = "3" 
			ilm = int(720 * val(col_mar3))
		CASE col_type = "4"
			ilm = int(720 * val(col_mar4))
	ENDCASE

	FOR i = 1 TO ir
		f_error=fwrite(file2,esc_c+"&a")
		f_error=fwrite(file2,alltrim(str(ilm)))
		f_error=fwrite(file2,"H")
		f_error=fwrite(file2,esc_c+"&a")
		f_error=fwrite(file2,alltrim(str(val(top_mar) * 720 + irow(i))))
		f_error=fwrite(file2,"V")
		f_error=fwrite(file2,utext(i))
		IF itype(i) = 1 
			readin = substr(utext(i), at("X",utext(i)) + 1)
			do trim_line
			last_head = readin
		ENDIF
	NEXT
	page_number = page_number + 1
	f_error=fwrite(file2,esc_c+"&a")
	f_error=fwrite(file2,alltrim (str (val(pnrow) * 720) ) )
	f_error=fwrite(file2,"V")
	f_error=fwrite(file2,esc_c+"&a")
	f_error=fwrite(file2,alltrim (str (val(pncol) * 720) ) )
	f_error=fwrite(file2,"H")
	f_error=fwrite(file2,esc_c+"(1X"+alltrim(str(page_number)))
	f_error=fwrite(file2,esc_c+"&a")
	f_error=fwrite(file2,"0")
	f_error=fwrite(file2,"V")
	f_error=fwrite(file2,esc_c+"&a")
	f_error=fwrite(file2,"0")
	f_error=fwrite(file2,"H")
	f_error=fwrite(file2,esc_c + "(2X" + space(int((val(h_c_v) - len(header_text)) / 2)) + header_text)

	IF page_type = "R" 
		f_error=fwrite(file2,esc_c+"&a")
		f_error=fwrite(file2,alltrim(str(val(headrow) * 720)))
		f_error=fwrite(file2,"V")
		f_error=fwrite(file2,esc_c+"&a")
		f_error=fwrite(file2,alltrim(str(val(col_mar4) * 720)))
		f_error=fwrite(file2,"H")
		f_error=fwrite(file2,esc_c+"(1X"+space(val(headoffset) - len(last_head))+last_head)
	ELSE
		f_error=fwrite(file2,esc_c+"&a")
		f_error=fwrite(file2,alltrim(str(val(headrow) * 720))) 
		f_error=fwrite(file2,"V")
		f_error=fwrite(file2,esc_c+"&a")
		f_error=fwrite(file2,alltrim(str(val(col_mar1) * 720)))
		f_error=fwrite(file2,"H")
		f_error=fwrite(file2,esc_c+"(1X"+first_head)
	ENDIF
	wait window "Page "+alltrim(str(page_number))+" completed" nowait
	f_error=fwrite(file2,formfeed)
*
RETURN
*************************************************************************
*
* Routine to trim the balance of a string
*
PROCEDURE trim_line
*
*	wait window a
	readin = readin + " "
	blank = "N"
	IF readin = " " 
		blank = "Y"
		RETURN
	ENDIF
	ii = 1
	DO WHILE (substr(readin, ii, 1) = " " .and. ii < len(readin))
		ii = ii + 1
	ENDDO
	readin = substr(readin, ii)
	ii = len(readin)
	DO WHILE (substr(readin, ii, 1) = " " .and. ii > 1)
		ii = ii - 1
	ENDDO
	readin = left(readin, ii)
	IF readin = " " 
		blank = "Y"
	ENDIF
*	wait window a
*
RETURN
*************************************************************************
*
* Calculate column values
*
FUNCTION col_calc
*
	DO CASE
		CASE num_cols='2'
		    col_mar1 = "0.5"
			col_mar2 = "4.5"
			col_mar3 = "0.0"
			col_mar4 = "0.0"
			h_c_v = "200"
			s_c_v = "20"
		CASE num_cols='3'
		    col_mar1 = "0.5"
			col_mar2 = "3.166"
			col_mar3 = "5.832"
			col_mar4 = "0.0"
			h_c_v = "200"
			s_c_v = "20"
		CASE num_cols='4'
		    col_mar1 = "0.5"
			col_mar2 = "2.375"
			col_mar3 = "4.25"
			col_mar4 = "6.0627"
			h_c_v = "190"
			s_c_v = "12"
	ENDCASE
	@ 5,32 say col_mar1 size 1,6 picture '9.9999' color &out_color
	@ 6,32 say col_mar2 size 1,6 picture '9.9999' color &out_color
	@ 7,34 say col_mar3 size 1,6 picture '9.9999' color &out_color
	@ 8,36 say col_mar4 size 1,6 picture '9.9999' color &out_color
	@14,37 say s_c_v size 1,3 picture '999' color &out_color
	@17,38 say h_c_v size 1,3 picture '999' color &out_color
*
RETURN