*****************************************************************
*
*  Make the directory file from a database using a directory
*	format file that can be generated and managed by this module
*
*****************************************************************
*  	OUTPUT FILE FORMAT CODES: (.txt)
*
*              *S*(state) [Primary Heading]
*              *C*(city)  [Secondary Heading]
*				*R* Secondary heading description
*              *A*(address line)
*              *P*(phone)
*              *T*(title)
*              *N*(name)
*			   *I*(italicized/emphasized text)
*****************************************************************
*	DESCRIPTION OF DIRECTORY FORMAT FILE (.fmt)
*
*		dpgmid		-	program ID of source data
*		owner		-	creator of format
*		add_data	-	filename of address data file
*		pgm_path	-	program pathname (to @DICT file)
*		src_data	-	filename of source code data
*		dpublic		-	flag: publicly readable 
*		opgmnm		-	name of program that contains data
*		oprefix		-	type of program 
*		oprimary 	-	field name of primary sort field
*		osecond 	-	field name of secondary sort field
*		osecdesc  	-	field name of secondary descr. field
*		otitle		-	1=title1 & title2
*						2=title1
*						3=title2
*						4=none
*		ophone 		-	1=fax & phone
*						2=phone only
*						3=fax only
*						4=none
*		oaddress 	 -	1=both addresses
*						2=mailing address
*						3=billing address
*						4=none
*		oname 		-	1=salute & fullname
*						2=salute & lastname
*						3=no name
*		other1 		-	field name of other field
*		other1h 	-	flag: .t. field is highlight
*		other1l   	-	flag: .t. field has a label
*		other2  	-	field name of other field
*		other2h 	-	flag: .t. field is highlight 
*		other2l   	-	flag: .t. field has a label 
*		other3  	-	field name of other field
*		other3h 	-	flag: .t. field is highlight 
*		other3l   	-	flag: .t. field has a label 
*		condition	-	record condition
*		o1			-	order of title
*		o2			-	order of phone
*		o3			-	order of address
*		o4			-	order of name
*		o5			-	order of other
*****************************************************************
*
	set talk off
	set echo off
	set exclusive off
*
	define popup mmain from 5,11 to 9,46
	define bar 1 of mmain prompt '1. Add a Directory Format'
	define bar 2 of mmain prompt '2. Edit a Directory Format'
	define bar 3 of mmain prompt '3. Produce Directory from a Format'
	on selection popup mmain do mmenu
	activate popup mmain
*
	set message to
	set library to
	release popup datamain
RETURN
*******************************************************************
*
* Process menu
*
PROCEDURE mmenu
*
	ds=bar()
	yn=space(1)
	filee=.t.
	DO CASE
		CASE ds=1

			select 2					&& Blank out the fields
			use (l_dformat)
			scatter memvar blank

			msg='ADD A DIRECTORY FORMAT'
			do sub@dtit with msg
			do get_dbase with filee		&& Get the program to generate a format for
										&& Get field names for the format

			IF ! filee
				close databases
			 	msg="PRODUCE DIRECTORY FILE"
				do sub@dtit with msg
				return
			ENDIF
			do disp_defs	&& Display the data entry screen
			done=.f.
			DO WHILE ! done
				select 2
				do get_defs
				set cursor on
				read cycle
				set cursor off				
				DO CASE
					CASE lastkey()=27
						define window donemess from 10,35 to 14,74 
						activate window donemess
						@ 1, 2 say 'Do you wish to cancel? (Y/N)'
						do sub@yn with yn
						release window donemess
						IF yn='Y'
							done=.t.
							close databases
						   	msg="PRODUCE DIRECTORY FILE"
						   	do sub@dtit with msg
							close databases
							release window def_rec
							wait window 'Cancelling Operation' nowait
							return
						ELSE
							done=.f.
						ENDIF
					CASE lastkey()=23
						done=.t.
					CASE otherwise
						done=.f.
				ENDCASE	
			ENDDO
			release window def_rec

* 	Get condition
			select 3
			use (l_add_data)
			getexpr 'Enter condition to locate ' to pcond type 'L' 
			IF lastkey()=27
			   	msg="PRODUCE DIRECTORY FILE"
			   	do sub@dtit with msg
				close databases
				wait window 'Cancelling Operation' nowait
				return			
			ENDIF	
			use
			select 2
			m.condition=alltrim(pcond)		

* See if user wants to save it
			yn=' '
			define window donemess from 10,35 to 14,68
			activate window donemess
			@ 1, 2 say 'Save the new format? (Y/N)'
			do sub@yn with yn
			release window donemess

* Save the format
			IF yn='Y'

				select 2				&& Generate format id
				set order to fmtid
				goto top
				loop2=.t.
				DO WHILE loop2
					tfmtid=sys(3)
					seek tfmtid
					loop2=found()
				ENDDO
				m.fmtid=tfmtid

				select 2				&& Append the new format
				append blank
				gather memvar

				wait window 'Format Saved' nowait
 			ELSE
				wait window 'Format Not Saved' nowait
			ENDIF
			release end_win,f_list
			close databases
		   	msg="PRODUCE DIRECTORY FILE"
		   	do sub@dtit with msg

		CASE ds=2
			msg='EDIT A DIRECTORY FORMAT'
			do sub@dtit with msg

* 	Get the list of formats
			select 2
			SELECT opgmnm;
			 FROM (l_dformat);
			 WHERE downer=who or dpublic=.t.;
			 INTO ARRAY formats

			SELECT fmtid;
			 FROM (l_dformat);
			 WHERE downer=who or dpublic=.t.;
			 INTO ARRAY fmt_ids

			close databases
			num_fmts=alen(formats)

* 	Setup the list as a menu
			fwidth=0
			declare formats[num_fmts]
			FOR i=1 TO num_fmts
				formats[i] = alltrim(str(i,2))+'. '+alltrim(formats[i])
				fwidth = iif(fwidth<len(formats[i])+2,len(formats[i])+2,fwidth)
			ENDFOR
			fheight = iif(num_fmts+9>23,23,num_fmts+8)
			fwidth = 27+fwidth

*	Get the user's choice
			define popup listmain from 7,19 to fheight,fwidth
			FOR i=1 TO num_fmts
				define bar i of listmain prompt formats[i]
			ENDFOR
			on selection popup listmain do editfmt
			activate popup listmain
*
			release popup listmain
		   	msg="PRODUCE DIRECTORY FILE"
		   	do sub@dtit with msg
		CASE ds=3
 			msg='PRODUCE DIRECTORY FROM A FORMAT'
			do sub@dtit with msg

* 	Get the list of formats
			SELECT opgmnm;
			 FROM (l_dformat);
			 WHERE downer=who or dpublic=.t.;
			 INTO ARRAY formats

			SELECT fmtid;
			 FROM (l_dformat);
			 WHERE downer=who or dpublic=.t.;
			 INTO ARRAY fmt_ids

			num_fmts=alen(formats)

* 	Setup the list as a menu
			fwidth=0
			declare formats[num_fmts]
			FOR i=1 TO num_fmts
				formats[i] = alltrim(str(i,2))+'. '+alltrim(formats[i])
				fwidth = iif(fwidth<len(formats[i])+2,len(formats[i])+2,fwidth)
			ENDFOR
			fheight = iif(num_fmts+10>23,23,num_fmts+9)
			fwidth = 27+fwidth

*	Get the user's choice
			define popup listmain from 8,19 to fheight,fwidth
			FOR i=1 TO num_fmts
				define bar i of listmain prompt formats[i]
			ENDFOR
			on selection popup listmain do printfmt
			activate popup listmain
*
			release popup listmain
		   	msg="PRODUCE DIRECTORY FILE"
		   	do sub@dtit with msg
	ENDCASE
	close databases
*
RETURN
*******************************************************************
*
*  Edit a format
*
PROCEDURE editfmt
*
	wf=fmt_ids[bar()]
	select 2
	use (l_dformat)
	set order to fmtid
	seek wf
	IF ! found()
		close databases
		wait window 'Format has been damaged!' nowait
		return
	ENDIF
	scatter memvar
	l_add_data=m.add_data
	l_pgm_path=m.pgm_path
						
*	Get field names for the format, allow editing of format
	do get_dbase with filee		&& Get field names
	IF ! filee
		close databases
		return
	ENDIF
	do disp_defs				&& User validate fields
	done=.f.
	DO WHILE ! done
		select 2
		do get_defs
		set cursor on
		read cycle
		set cursor off				
		DO CASE
			CASE lastkey()=27
				define window donemess from 10,35 to 14,74 
				activate window donemess
				@ 1, 2 say 'Do you wish to cancel? (Y/N)'
				do sub@yn with yn
				release window donemess
				IF yn='Y'
					done=.t.
					close databases
					release window def_rec
					wait window 'Cancelling Operation' nowait
					return			
				ELSE
					done=.f.
				ENDIF
			CASE lastkey()=23
				done=.t.
			CASE otherwise
				done=.f.
		ENDCASE	
	ENDDO
	release window def_rec

* 	Get condition
	select 3
	use (l_add_data)
	pcond=m.condition
	getexpr 'Enter condition to locate ' to pcond type 'L' default pcond
	IF lastkey()=27 .or. pcond='CANCEL'
		close databases
		wait window 'Cancelling Operation' nowait
		return			
	ENDIF	
	use 
	select 2
	m.condition=alltrim(pcond)		

* See if user wants to save it
	define window donemess from 10,35 to 14,66
	activate window donemess
	@ 1, 2 say 'Save your changes? (Y/N)'
	do sub@yn with yn
	release window donemess

* Save changes
	IF yn='Y'
		select 2
		gather memvar
		close databases
		wait window 'Changes saved' nowait
	ELSE
		wait window 'Not saved' nowait
	ENDIF
	close databases
*
RETURN
*******************************************************************
*
*  Print a format
*
PROCEDURE printfmt
*
* 	Get the format information
	wf=fmt_ids[bar()]
	select 1
	use (l_dformat)
	set order to fmtid
	seek wf
	IF ! found()
		close databases
		wait window 'Format has been damaged!' nowait
		return
	ENDIF

* Get the name of the output file
	set default to (topath)
	out_file = putfile('Processed Directory Output File', 'DIRECT.TXT', 'TXT')
	IF lastkey()=27
	   	msg="PRODUCE DIRECTORY FILE"
	   	do sub@dtit with msg
		wait window 'Cancelling Operation' nowait
		return
	ENDIF
	delete file(out_file)

* Open the format and get/save format information
	select 1
	scatter memvar
	pcond=alltrim(m.condition)
	is_cond=iif(len(pcond)>0,.t.,.f.)
	declare f_o[5]
	f_oprimary	=	alltrim(m.oprimary)
	f_osecond	=	alltrim(m.osecond)
	f_osecdesc	=	alltrim(m.osecdesc)
	f_oaddress	=	m.oaddress
	f_oname		=	m.oname
	f_otitle	=	m.otitle
	f_ophone	=	m.ophone
	f_other1	=	alltrim(m.other1)
	f_other1l	=	m.other1l
	f_other1h	=	m.other1h
	f_other2	=	alltrim(m.other2)
	f_other2l	=	m.other2l
	f_other2h	=	m.other2h
	f_other3	=	alltrim(m.other3)
	f_other3l	=	m.other3l
	f_other3h	=	m.other3h
	f_o[1]		=	m.o1
	f_o[2]		=	m.o2
	f_o[3]		=	m.o3
	f_o[4]		=	m.o4
	f_o[5]		=	m.o5

* Build and execute a query to derive the data file
	msg='Getting records to include in the directory...'
	do sub@dism with msg
	temp_dbf=dopath+'DQUERY.DBF'
	delete file (temp_dbf)

	&& Determine if source database is included
	inc_src=.f.
	inc_src=iif(f_oprimary='SOURCE',.t.,iif(inc_src=.f.,.f.,.t.))
	inc_src=iif(f_osecond='SOURCE',.t.,iif(inc_src=.f.,.f.,.t.))
	inc_src=iif(f_osecdesc='SOURCE',.t.,iif(inc_src=.f.,.f.,.t.))
	inc_src=iif(f_other1='SOURCE',.t.,iif(inc_src=.f.,.f.,.t.))
	inc_src=iif(f_other2='SOURCE',.t.,iif(inc_src=.f.,.f.,.t.))
	inc_src=iif(f_other3='SOURCE',.t.,iif(inc_src=.f.,.f.,.t.))

	&& determine sort order fields
	sort_by=' '
	sort_by=iif(!empty(f_oprimary),'A.'+alltrim(f_oprimary),'')
	IF !empty(f_osecond)
		IF !empty(sort_by)
			sort_by=sort_by+','
		ENDIF
		sort_by=sort_by+'A.'+alltrim(f_osecond)
	ENDIF

	&& execute query			
	IF inc_src
		IF is_cond
			select a.*, b.descript;
			 from (m.add_data) a, (m.src_data) b;
			 where b.code = a.source;
			 having &pcond;
			 order by &sort_by;
			 into table (temp_dbf)
		ELSE
			select a.*, b.descript;
			 from (m.add_data) a, (m.src_data) b;
			 where b.code = a.source;
			 order by &sort_by;
			 into table (temp_dbf)
		ENDIF
	ELSE
		IF is_cond
			select a.*;
			 from (m.add_data) a;
			 having &pcond;
			 order by &sort_by;
			 into table (temp_dbf)
		ELSE
			select a.*;
			 from (m.add_data) a;
			 order by &sort_by;
			 into table (temp_dbf)
		ENDIF
	ENDIF					
			
* Generate the directory output file
	set alternate to (out_file)
	set console off
	save_prim=' '
	save_sec=' '
	save_add=' '
	save_phone=' '
	rstatus=space(40)
	goto top
	set alternate on
	DO WHILE ! eof()
		set alternate off
		set console on
		msg='Producing Directory File... Record #'+alltrim(str(recno()))
		do sub@dism with msg
		set console off
		set alternate on
		temp=&f_oprimary
		IF save_prim<>upper(temp)		&& Include primary field
			save_prim=upper(temp)
			IF ! empty(&f_oprimary)
				DO CASE
					CASE f_oprimary='SOURCE'
						temp2='*S*'+alltrim(descript)
					CASE f_oprimary='STATUS'
						status=&f_oprimary
						do get_stat with status,rstatus
						temp2='*S*'+upper(rstatus)
					OTHERWISE
						temp2='*S*'+alltrim(&f_oprimary)
				ENDCASE
				IF len(temp2)>28
					FOR I=1 TO 40
						temp3=rat(' ',temp2,i)
						IF temp3<28
							? left(temp2,temp3-1)
							? '*S*'+right(temp2,len(temp2)-temp3)
							exit
						ENDIF
					NEXT
				ELSE
					? temp2
				ENDIF
			ENDIF
		ENDIF
		
		IF ! empty(f_osecond)			&& Include secondary field
			temp=&f_osecond
			IF save_sec<>upper(temp)
				save_sec=upper(temp)
				temp2=''
				IF ! empty(&f_osecond)
					DO CASE
						CASE f_osecond='SOURCE'
							temp2='*C*'+alltrim(descript)
						CASE f_osecond='STATUS'
							status=&f_osecond
							do get_stat with status,rstatus
							temp2='*C*'+rstatus
						OTHERWISE
							temp2='*C*'+&f_osecond
					ENDCASE
				ENDIF

				IF ! empty(f_osecdesc)	&& Include secondary desc.
					IF ! empty(&f_osecdesc)
						DO CASE
							CASE f_osecdesc='SOURCE'
								temp2=temp2+'*R*'+alltrim(descript)
							CASE f_osecdesc='STATUS'
								status=&f_osecdesc
								do get_stat with status,rstatus
								temp2=temp2+'*R*'+rstatus
							OTHERWISE
								temp2=temp2+'*R*'+&f_osecdesc
						ENDCASE
					ENDIF
				ENDIF
				IF ! empty(temp2)
					? temp2
				ENDIF

			ENDIF
		ENDIF

		
		FOR I=1 TO 5
			t=ascan(f_o,i)
			DO CASE
				CASE t=1
					do put_title with f_otitle
				CASE t=2
					do put_phone with save_phone,f_ophone
				CASE t=3
					do put_addr with save_add,f_oaddress
				CASE t=4
					do put_name with f_oname
				CASE t=5
					do put_other with f_other1,f_other1l,f_other1h,f_other2,f_other2l,f_other2h,;
						f_other3,f_other3l,f_other3h
			ENDCASE
		NEXT
		
		skip
	ENDDO
	close databases
	set alternate off
	set alternate to
	set console on
   	msg="PRODUCE DIRECTORY FILE"
   	do sub@dtit with msg
	@24, 0 say space(80)
	wait window 'Processing completed' nowait
	release f_o
*
RETURN
*******************************************************************
*
* Output address
*
PROCEDURE put_addr
parameter save_add,f_oaddress
*
	IF save_add<>upper(address_1)	&& Include address
		save_add=upper(address_1)
		DO CASE
			CASE f_oaddress=1			&& Both addresses
				? '*I*Primary Address'
				IF ! empty(address_1)
					? '*A*'+address_1
				ENDIF
				IF ! empty(address_2)
					? '*A*'+address_2
				ENDIF
				? '*A*'+alltrim(city_1)+', '+st+' '+zipcode_1
				? '*I*Alternate Address'
				IF ! empty(address_3)
					? '*A*'+address_3
				ENDIF
				IF ! empty(address_4)
					? '*A*'+address_4
				ENDIF
				? '*A*'+alltrim(city_2)+', '+st+' '+zipcode_2
			CASE f_oaddress=2			&& Mailing only
				IF ! empty(address_1)
					? '*A*'+address_1
				ENDIF
				IF ! empty(address_2)
					? '*A*'+address_2
				ENDIF
				? '*A*'+alltrim(city_1)+', '+st+' '+zipcode_1
			CASE f_oaddress=3			&& Billing only
				IF ! empty(address_3)
					? '*A*'+address_3
				ENDIF
				IF ! empty(address_4)
					? '*A*'+address_4
				ENDIF
				? '*A*'+alltrim(city_2)+', '+st+' '+zipcode_2
		ENDCASE									
	ENDIF
*
RETURN
*******************************************************************
*
* Output phone info
*
PROCEDURE put_phone
parameter save_phone,f_ophone
*
	IF save_phone<>phone			&& Include phone info
		save_phone=phone
		DO CASE
			CASE f_ophone=1				&& Both numbers
				IF ! empty(phone)
				 	? '*P*Phone: ('+left(phone,3)+')'+right(phone,8)
				ENDIF
				IF ! empty(fax)
					? '*P*Fax: ('+left(fax,3)+')'+right(fax,8)
				ENDIF
			CASE f_ophone=2				&& Phone only
				IF ! empty(phone)
					? '*P*Phone: ('+left(phone,3)+')'+right(phone,8)
				ENDIF
			CASE f_ophone=3				&& Fax only
				IF ! empty(fax)
					? '*P*Fax: ('+left(fax,3)+')'+right(fax,8)
				ENDIF
		ENDCASE			
	ENDIF
*
RETURN
*******************************************************************
*
* Output name info
*
PROCEDURE put_name
parameter f_oname
*
	DO CASE							&& Include name
		CASE f_oname=1					&& Fullname
			IF ! empty(fullname)
				? '*N*'+alltrim(alltrim(salute)+' '+fullname)
			ENDIF
		CASE f_oname=2					&& Lastname only
			IF ! empty(lastname)
				? '*N*'+alltrim(alltrim(salute)+' '+lastname)
			ENDIF
	ENDCASE									
*
RETURN
*******************************************************************
*
* Output title info
*
PROCEDURE put_title
parameter f_otitle
*
	DO CASE							&& Include titles
		CASE f_otitle=1					&& Both titles
			IF ! empty(title_1)
				? '*T*'+alltrim(title_1)
			ENDIF
			IF ! empty(title_2)
				? '*T*'+alltrim(title_2)
			ENDIF
		CASE f_otitle=2					&& Title #1 only
			IF ! empty(title_1)
				? '*T*'+alltrim(title_1)
			ENDIF
		CASE f_otitle=3					&& Title #2 only
			IF ! empty(title_2)
				? '*T*'+alltrim(title_2)
			ENDIF
	ENDCASE									
*
RETURN
*******************************************************************
*
* Output other info
PROCEDURE put_other
*
parameter f_other1,f_other1l,f_other1h,f_other2,f_other2l,f_other2h,f_other3,f_other3l,f_other3h
*
	IF ! empty(f_other1)			&& Include other field #1
		DO CASE
			CASE f_other1='SOURCE'
				? iif(f_other1h,'*I*','*A*')+iif(f_other1l,f_other1+': ','')+alltrim(descript)
			CASE f_other1='STATUS'
				status=&f_other1
				do get_stat with status,rstatus
				? iif(f_other1h,'*I*','*A*')+iif(f_other1l,f_other1+': ','')+rstatus
			OTHERWISE
				IF ! empty(&f_other1)
					? iif(f_other1h,'*I*','*A*')+iif(f_other1l,f_other1+': ','')+&f_other1
				ENDIF
		ENDCASE
	ENDIF

	IF ! empty(f_other2)			&& Include other field #2
		DO CASE
			CASE f_other2='SOURCE'
				? iif(f_other2h,'*I*','*A*')+iif(f_other2l,f_other2+': ','')+alltrim(descript)
			CASE f_other2='STATUS'
				status=&f_other2
				do get_stat with status,rstatus
				? iif(f_other2h,'*I*','*A*')+iif(f_other2l,f_other2+': ','')+rstatus
			OTHERWISE
				IF ! empty(&f_other2)
					? iif(f_other2h,'*I*','*A*')+iif(f_other2l,f_other2+': ','')+&f_other2
				ENDIF
		ENDCASE
	ENDIF

	IF ! empty(f_other3)			&& Include other field #3
		DO CASE
			CASE f_other3='SOURCE'
				? iif(f_other3h,'*I*','*A*')+iif(f_other3l,f_other3+': ','')+alltrim(descript)
			CASE f_other3='STATUS'
				status=&f_other3
				do get_stat with status,rstatus
				? iif(f_other3h,'*I*','*A*')+iif(f_other3l,f_other3+': ','')+rstatus
			OTHERWISE
				IF ! empty(&f_other3)
					? iif(f_other3h,'*I*','*A*')+iif(f_other3l,f_other3+': ','')+&f_other3
				ENDIF
		ENDCASE
	ENDIF
*
RETURN
*******************************************************************
*
* Procedure to allow you to get the database you want to generate
*  a directory format for, and put some specifics into the format
*	fields
*
PROCEDURE get_stat
parameter status,rstatus
*
	DO CASE
		CASE status='P'
			rstatus='Paid'
		CASE status='R'
			rstatus='Refund Due'
		CASE status='N'
			rstatus='No Status'
		CASE status='B'
			rstatus='Billed'
		CASE status='B030'
			rstatus='Billed 30 days ago'
		CASE status='B060'
			rstatus='Billed 60 days ago'
		CASE status='B090'
			rstatus='Billed 90 days ago'
		CASE status='B120'
			rstatus='Billed 120 days ago'
		CASE status='B150'
			rstatus='Billed 150 days ago'
		CASE status='B180'
			rstatus='Billed 180 days ago'
		CASE status='BXXX'
			rstatus='Billed over 210 days ago'
		CASE status='E'
			rstatus='Expired'
		CASE status='E030'
			rstatus='Expired 30 days ago'
		CASE status='E060'
			rstatus='Expired 60 days ago'
		CASE status='E090'
			rstatus='Expired 90 days ago'
		CASE status='E120'
			rstatus='Expired 120 days ago'
		CASE status='E150'
			rstatus='Expired 150 days ago'
		CASE status='E180'
			rstatus='Expired 180 days ago'
		CASE status='EXXX'
			rstatus='Expired over 210 days ago'
		OTHERWISE
			rstatus='Unknown status'
	ENDCASE
*
RETURN
*******************************************************************
*
* Procedure to allow you to get the database you want to generate
*  a directory format for, and put some specifics into the format
*	fields
*
PROCEDURE get_dbase
parameter filee
*
	temp_dbf=dopath+'DQUERY.DBF'
	delete file (temp_dbf)

	IF empty(m.dpgmid)		&& If database is not already open, open it
		do dir@selc
		m.dpgmid=mpgmid				&& Store pgmid for this database
		m.add_data=l_add_data		&& Store address database filename
		m.pgm_path=l_pgm_path		&& Store path to @DICT file
		m.src_data=l_src_data		&& Store source codes database filename
		m.downer=who				&& Store name of creator
	ENDIF
	IF lastkey()=27
		filee=.f.
		return
	ENDIF
*
* Save field names in a temp file
*
	IF file(l_add_data)
		select 3
		use (l_add_data)
		copy structure extended to (temp_dbf)
		use (temp_dbf)
		public f_list
		declare f_list[1]
		select field_name;
		 from (temp_dbf);
		 into array f_list				
		use
* Find list length and use it to set variable window length
		end_win=23
		IF alen(f_list)<12
			end_win=9+alen(f_list)
		ENDIF
		filee=.t.
	ELSE
		wait window 'File Does Not Exist' nowait
		filee=.f.
	ENDIF
*
RETURN
**********************************************************************
*
* Display a record 
*
PROCEDURE disp_defs
*
	define window def_rec from 2,1 to 23,79 double;
		footer 'Press <Ctrl><W> to Save Changes, or <Esc> to Cancel'
   	activate window def_rec
	@ 0, 0 say 'Program: '+upper(alltrim(m.opgmnm))
	@ 0,60 say '[ ] Public'
	@ 2, 1 say 'Primary Heading: '
	@ 3, 1 say 'Secondary Heading: '
	@ 4, 1 say 'Secondary Heading Description: '
	@ 6, 1 say 'Titles:  ( ) All titles         Phone: ( ) Fax and Phone      Order:'
	@ 7, 1 say '         ( ) First title only          ( ) Phone only           Titles'
	@ 8, 1 say '         ( ) Second title only         ( ) Fax only             Phone '
	@ 9, 1 say '         ( ) No titles                 ( ) No phone numbers     Address '
	@10, 1 say '                                                                Name'
	@11, 1 say 'Address: ( ) Both addresses     Name:  ( ) Full name            Other'
	@12, 1 say '         ( ) Mailing address           ( ) Last name only'
	@13, 1 say '         ( ) Billing address           ( ) No names'
	@14, 1 say '         ( ) No addresses'
	@16, 1 say 'Other Fields:             [ ] Highlighted  [ ] Label'
	@17, 1 say '                          [ ] Highlighted  [ ] Label'
	@18, 1 say '                          [ ] Highlighted  [ ] Label'
*
RETURN
**********************************************************************
*
* Get/edit a format
*
PROCEDURE get_defs
*
	activate window def_rec
	@ 0, 9 get m.opgmnm size 1,40
	@ 0,60 get m.dpublic function '*C' picture ' Public' 
	@ 2,18 get m.oprimary size 1,10 function '!' valid sel_field()
	@ 3,20 get m.osecond size 1,10 function '!' valid sel_field()
	@ 4,32 get m.osecdesc size 1,10 function '!' valid sel_field()
	@ 6,10 get m.otitle function '*RN' picture ' All titles;First title only;Second title only;No titles'
	@ 6,40 get m.ophone function '*RN' picture ' Fax and Phone;Phone Only;Fax Only;No phone numbers'
	@11,10 get m.oaddress function '*RN' picture ' Both addresses;Mailing address;Billing address;No addresses'
	@11,40 get m.oname function '*RN' picture ' Full name;Last name only;No names'
	@16,15 get m.other1 size 1,10 function '!' valid sel_field()
	@16,27 get m.other1h function '*C' picture ' Highlighted'
	@16,44 get m.other1l function '*C' picture ' Label'
	@17,15 get m.other2 size 1,10 function '!' valid sel_field()
	@17,27 get m.other2h function '*C' picture ' Highlighted'
	@17,44 get m.other2l function '*C' picture ' Label'
	@18,15 get m.other3 size 1,10 function '!' valid sel_field()
	@18,27 get m.other3h function '*C' picture ' Highlighted'
	@18,44 get m.other3l function '*C' picture ' Label' 
	@ 7,63 get m.o1 size 1,1 range 0,5 valid chko()
	@ 8,63 get m.o2 size 1,1 range 0,5 valid chko()
	@ 9,63 get m.o3 size 1,1 range 0,5 valid chko()
	@10,63 get m.o4 size 1,1 range 0,5 valid chko()
	@11,63 get m.o5 size 1,1 range 0,5 valid chko()
*
RETURN
**********************************************************************
*
* Check order fields for dupes
*
PROCEDURE chko
*
	getvar = 'm.'+varread()
	value = &getvar

	declare t_o[5]
	t_o[1]=m.o1
	t_o[2]=m.o2
	t_o[3]=m.o3
	t_o[4]=m.o4
	t_o[5]=m.o5
	FOR I=1 TO 5
		IF t_o[i]=value
			IF val(right(getvar,1))<>i
				release t_o
				return .f.
			ENDIF
		ENDIF
	NEXT
	release t_o
*
RETURN .t.
**********************************************************************
*
* Get field
*
PROCEDURE sel_field
*
* Return if left blank deliberately
	IF lastkey()=9 .or. lastkey()=23
		return
	ENDIF
* See if we already have a value & get field name
	getvar = 'm.'+varread()
	value = &getvar
*	IF len(alltrim(value))=0
*		getvar='M.'+getvar
*		value=&getvar
*	ENDIF
* See if a fieldname was entered - if so, return
	IF len(alltrim(value))<>0
		find_field=ascan(f_list,value)
		sel_temp=find_field
		IF find_field<>0
			return .t.
		ENDIF
	ENDIF
	sel_temp=1
* Present list and read
	define window sel_val from 7,24 to end_win,40 title 'Field Name?'
	activate window sel_val
	@ 0, 0 get sel_temp from f_list default f_list(sel_temp)
	read
	release window sel_val
* Process selection
	IF lastkey()<>27
		&getvar=f_list[sel_temp]
	ENDIF
*
RETURN .t.