*******************************************************************************
*  JUST A REMINDER: 							      *
*									      *	
*  The source code contained herein is considered public domain.  You may     *
*  use all or part in your own applications.  Since I have taken the time to  *
*  develop and debug this utility, my only request is that you give me credit *
*  where credit is due.                                                       *
*                                                                             *
*  Thank you,                                                                 *
*	   								      *	
*  Todd W. Lindley						              *
*  a/k/a Slice					                              *
*******************************************************************************

*******************************************************************************
*    Name: DIALOG.PRG                  					      *
*  Author: Todd W. Lindley						      *
*    Date: 1-14-91							      *
*    Desc: Generates a dialog box which allows the user to make a selection   *
*          by pressing the first character of a choice or hi-lighting an item *
*          and pressing enter. The function then returns a numerical value    *
*          associated with the dialog item or a 0 if Esc is pressed.          *
*   Usage:						   	              *
*          choice=DIALOG(# BOXES,"STR1","STR2","STR3",ROW,COL,MESSAGE)        *
*        								      *
*   WHERE 								      *
*          # BOXES        = Number of selection items to display              *
*          STR1,STR2,STR3 = Selection descriptions     			      *
*          ROW,COL        = Upper left row,column of box                      *
*          MESSAGE        = Message to display        			      *	
*           								      *
* Example:								      *
*          choice=DIALOG(3," Yes "," No "," Cancel ",10,20,"Are You Sure?")   *
*      OR   								      *
*          choice=DIALOG(2," Yes "," No "," ",10,20,"Are You Sure?")          *
*									      *
*   Notes:								      *
*                                                                             * 
*          - This routine can easily be modified into a procedure             *
*          - DIALOG does not check the validity of passed parameters          *
*          - Make sure that 1st character of each dialog item is unique       *
*          - The first item is always hi-lighted                              *
*            - You might want to add another parameter that positions the     *
*              cursor on an item other than the first one                     *
*									      *
* Comments, questions, or suggestions?  Please leave mail addressed to Slice  *
* on the Ashton Tate BBS   					              *
*******************************************************************************

FUNCTION dialog
PARA maxdial,dial1,dial2,dial3,srow,scol,mess

** SAVE CURRENT SCREEN  
  SAVE SCREEN TO dialscrn

** SAVE STATUS OF A FEW "SET" FUNCTIONS

  esc_stat=SET("ESCAPE")
  old_colrs=SET("ATTRIBUTES")
  old_talk=SET("TALK")
  SET TALK OFF
  SET ESCAPE OFF
  SET CURSOR OFF

** COLUMN 1 STORES DIALOG STRING, COLUMN 2 STORES DISPLAY COLUMN 
  DECLARE dial[3,2]
  erow=srow+5
  ecol=0
  gap=1

** IF WE ONLY NEED 2 BOXES THEN SET THIRD BOX TO A CHAR. THAT WON'T BE SELECTED

  IF maxdial=2 
    dial3=CHR(133)
  ENDIF

** IF WE ONLY NEED 1 BOX THEN SET 2ND AND THIRD BOX TO A CHAR. THAT WON'T BE SELECTED

  IF maxdial=1
    dial2=CHR(133)
    dial3=CHR(133)
  ENDIF


** PUT DIALOG ITEM AND DISPLAY COLUMN IN ARRAY
  tcol=scol+2
  dial[1,1]=dial1
  dial[1,2]=tcol
  dial[2,1]=dial2
  dial[2,2]=tcol+LEN(dial[1,1])+gap
  dial[3,1]=dial3
  dial[3,2]=dial[2,2]+LEN(dial[2,1])+gap

** ESTABLISH ENDING COLUMN OF WINDOW
** WE NEED TO FIGURE OUT WHICH IS LONGER, MESSAGE OR DIALOG ITEMS

  width=LEN(dial[1,1]+dial[2,1]+dial[3,1])+2
  ecol=IIF(width>LEN(mess),width,LEN(mess))+(gap*3)+scol

** IF THE MESSAGE LENGTH PASSED TO PROGRAM IS LONGER THAN LENGTH OF DIALOG
** ITEMS, THEN CENTER DIALOG ITEMS

  IF LEN(mess) > width        
    center=INT((ecol-scol)/2+scol)
    half=INT(width/2)
    newcol=center-half+1
    dial[1,2]=newcol
    dial[2,2]=newcol+LEN(dial[1,1])+gap
    dial[3,2]=dial[2,2]+LEN(dial[2,1])+gap
  ENDIF    

** DRAW WINDOW

  @srow,scol CLEAR TO erow,ecol
  ptr=1
  @srow,scol TO erow,ecol DOUBLE

** DISPLAY DIALOG ITEMS
  @srow+3,dial[1,2] SAY dial[1,1]

 ** IF ONLY USING 1 DIALOG ITEM THEN SKIP SECOND
  IF maxdial = 2 .OR. maxdial = 3
    @srow+3,dial[2,2] SAY dial[2,1]
  ENDIF

 ** IF ONLY USING 2 DIALOG ITEMS THEN SKIP THIRD
  IF maxdial = 3 
    @srow+3,dial[3,2] SAY dial[3,1]
  ENDIF

  @srow,scol FILL TO erow,ecol COLOR N/W
  @srow+1,scol+2 SAY mess COLOR R/W

** DRAW SHADOW
  @srow+1,ecol+1 FILL TO erow,ecol+2 COLOR W/N
  @erow+1,scol+2 FILL TO erow+1,ecol+2 COLOR W/N

** MAIN LOOP - READS KEYBOARD
DO revdisp
DO WHILE .T.
  x=INKEY()
  DO CASE
    CASE x=4                && RIGHT ARROW
      DO nrmldisp
      ptr=ptr+1
      IF ptr>maxdial
        ptr=1
      ENDIF
      DO revdisp
    CASE x=19               && LEFT ARROW
      DO nrmldisp
      ptr=ptr-1
      IF ptr<1
        ptr=maxdial
      ENDIF
      DO revdisp

** CHECK FOR 1ST CHARACTER OF EACH DIALOG BOX - UPPER OR LOWER CASE

    CASE x=ASC(UPPER(SUBSTR(LTRIM(dial[1,1]),1,1))) .OR. x=ASC(LOWER(SUBSTR(LTRIM(dial[1,1]),1,1)))            
      ptr=1
      EXIT
    CASE x=ASC(UPPER(SUBSTR(LTRIM(dial[2,1]),1,1))) .OR. x=ASC(LOWER(SUBSTR(LTRIM(dial[2,1]),1,1)))
      ptr=2
      EXIT
    CASE x=ASC(UPPER(SUBSTR(LTRIM(dial[3,1]),1,1))) .OR. x=ASC(LOWER(SUBSTR(LTRIM(dial[3,1]),1,1)))
      ptr=3
      EXIT

    CASE x=13               && ENTER
      EXIT
    CASE x=27               && ESC     
      ptr=0
      EXIT
  ENDCASE
ENDDO

** RETURN TO CALLING PROGRAM

RESTORE SCREEN FROM dialscrn
SET ESCAPE &esc_stat
SET COLOR TO &old_colrs
SET TALK &old_talk
RELEASE SCREEN dialscrn
RELEASE esc_stat,old_colrs,x,center,half,newcol,erow,ecol,gap,maxdial,tcol
RELEASE old_talk
SET CURSOR ON
RETURN(ptr)

PROCEDURE nrmldisp
  @srow+3,dial[ptr,2] SAY dial[ptr,1] COLOR N/W
RETURN

PROCEDURE revdisp
  @srow+3,dial[ptr,2] SAY dial[ptr,1] COLOR W+/N
RETURN
