
	page	66, 120
	title 	DBASE III+ / FoxBase+ FOSSIL Interface
	subttl	By Ed Rauh

IF1
	%out	Pass 1
ENDIF
IF2
	%out	Pass 2
ENDIF

;
;       This program provides a way for FoxBASE+/dBASE III+ to make
;       use of the communications port via a FOSSIL driver as defined
;       by Vince Perriello in FOSSIL.DOC.  This routine must be
;       assembled, linked and run through EXE2BIN to create a loadable
;       module for FoxBASE+.  This is then loaded using the LOAD FOSSIL
;       command.  Access to the FOSSIL driver is provided by issuing
;       a CALL FOSSIL WITH <memvar>.  <memvar> is assumed to be
;       4-254 bytes long, and consists of a 3-byte command block followed
;       by a vector of 1-251 characters terminated by a null.
;
;       Ed Rauh
;       ex Machina Ltd.
;       17 Esther Drive
;       Middlefield, CT 06455
;
;       Fido 141/215


;       Command block format
;
;       As passed by FoxBASE+/dBASE III+, a command block should be
;       three bytes long.  It is pointed to by DS:BX upon entry to
;       this module.
;
;       [0]     Port #
;       [1]     Desired Function;  one of
;
;               Fn #   ArgVal  Meaning
;               ====   ======  =======
;               0       (0)    Set baud Rate
;               1       (A)    Transmit char with wait
;               2       (B)    Receive character with wait
;               3       (C)    Provide port status
;               4       (D)    Initialize & verify FOSSIL driver
;               5       (E)    Terminate driver
;               6       (F)    Raise/lower DTR
;               7       (G)    Put string
;               8       (H)    Get string
;               9       (I)    Purge Output Buffer
;               A       (J)    Purge Input Buffer
;               B       (K)    Transmit no wait
;               C       (L)    Read no wait
;               D       (M)    Set watchdog processing
;               E       (N)    Test CD
;               F       (O)    Enable/Disable flow control
;
;       [2]     Return Code
;
;       Remainder of string is handled as first argument of the called
;       function or data return buffer on receive/get
;
;       Please note that many of the selected primitives match the FOSSIL
;       Function # in order - this simplifies the calling procedures
;

;
;       Revision 1.1 changes:
;
;       1 - Flags register now saved at entry to maintain the integrity
;           of the D bit on return to the calling program.  You wouldn't
;           believe how quickly C programs crash when you change the
;           direction flag without fixing it...
;
;       2 - Values of DS, DX and SI are now assumed to be destroyed by
;           the FOSSIL driver upon return from INT 14h.  If I need'em,
;           they're saved on the stack.
;
;       3 - General register values and ES are not preserved by the
;           entry prefix and exit suffix code.  FoxBASE+ requires only
;           that DS and SS are preserved;  dBASE also requires DX and BX
;           be saved, and I still save BP (the old stack frame) for S&Gs.
;           The routine never should use more than 8 words on the stack.
;
;       4 - I now check the length of the string passed in DS:BX to make
;           sure an argument consisting of at least the 3-byte header
;           and a terminating null is passed.  I don't do anything if it
;           isn't, just return.

NoError         equ 'N'
IsError         equ 'Y'
magic_number    equ 1954h
fossil_int      equ 14h
status_mask     equ 6180h
cr              equ 13
lf              equ 10
eof             equ 26
null            equ 0
space           equ ' '

Command     struc               ;command header structure

CommPort    db  ?
CommFunc    db  ?
ReturnCode  db  ?
FirstArg    db  ?

command     ends

code        segment para public 'CODE'

FOSSIL      proc far

            assume cs:code

            org 0

            jmp Comm_proc

            org 16

Dispatch:                       ;function dispatch table
            dw set_baud         ;0
            dw send_wait        ;1
            dw recv_wait        ;2
            dw request_stat     ;3
            dw fossil_init      ;4
            dw fossil_term      ;5
            dw set_dtr          ;6
            dw put_string       ;7
            dw get_string       ;8
            dw purge_t_buf      ;9
            dw purge_r_buf      ;A
            dw send_nowait      ;B
            dw recv_nowait      ;C
            dw set_watchdog     ;D
            dw test_dcd         ;E
            dw set_flow         ;F
            
Comm_proc:
            pushf               ;added to maintain the integrity of D flag
            push bx
            push dx
            push ds
            push bp             ;save registers at entry

;           validate the parameter block as minimally there

            cmp bx,0                     ; was a parameter block passed?
            je exitpt
            cmp ds:[bx.CommPort], null   ; null length?
            je exitpt
            cmp ds:[bx.CommFunc], null   ; no function?
            je exitpt
            cmp ds:[bx.ReturnCode], null ;no Return Code byte?
            je exitpt
            cmp ds:[bx.FirstArg], null   ;And at least a 1 byte argument?
            je exitpt
            ;
            ;   Ok, I got a valid length command....
            ;
            ;   Which port do I use?
            ;
            mov si,bx
            mov dl, ds:[si.CommPort]
            and dx,3                    ;allow comm ports 0-3

            ;
            ; and now what do I want to do?
            ;

            mov bl, ds:[si.CommFunc]
            and bx, 15                  ;limit functions to 0-15
            xor ax,ax
            mov ah,bl                   ;save function in AH where 
            shl bx,1                    ;we need it

            call word ptr cs:[bx+Dispatch]

            
exitpt:
            pop bp      ;restore regs and flags
            pop ds
            pop dx
            pop bx
            popf
            ret
            
            
set_baud    proc near            

            mov al, ds:[si.FirstArg]
            and al,7            ;isolate the baud rate

;		000 =  110 baud
;		001 =  150  ''
;		010 =  300  ''
;		011 =  600  ''
;		100 = 1200  ''
;		101 = 2400  ''
;		110 = 4800  ''
;		111 = 9600  ''

            mov cl,5
            shl al,cl           ;move to top of byte
            or  al,3            ;and set 8 - 1 - N
            mov ds:[si.ReturnCode], NoError
            int fossil_int
            ret

set_baud    endp



send_wait   proc near

request_stat equ send_wait

            mov al, ds:[si.FirstArg]
            push ds
            push si
            int fossil_int
            pop si
            pop ds

;  Returns with the line and modem status in AX.  Status bits returned are:
;
;               In AH:
;               Bit 0 = RDA  - input data is available in buffer
;               Bit 5 = THRE - room is available in output buffer
;               Bit 6 = TSRE - output buffer is empty
;
;               In AL:
;               Bit 7 =	DCD  - carrier detect 

            and ax, status_mask ;mask defined status bits

            or al,ah
            or al,16            ;make sure you don't return a 0 
                                ;thereby truncating string length

            mov ds:[si.ReturnCode],al
            ret

send_wait   endp


recv_wait   proc near

            push ds
            push si
            int fossil_int
            pop si
            pop ds
            mov ds:[si.FirstArg],al
            mov ds:[si.ReturnCode],NoError
            ret

recv_wait   endp 


fossil_init proc near

            xor bx,bx                           ;Do not enable ^C/^K
            push ds
            push si
            int fossil_int
            pop si
            pop ds
            mov ds:[si.ReturnCode],NoError
            cmp ax,magic_number                 ;Check if FOSSIL identifier
            je f_i_return
            mov ds:[si.ReturnCode],IsError
        
f_i_return:
            ret

fossil_init endp

set_watchdog proc near

            mov ah,20                           ;watchdog processing
                                                ;1 = enable, 0 = disable
set_dtr     proc near                           ;DTR 1 = raise, 0 = lower

fossil_term equ set_dtr                         ;no args
purge_t_buf equ set_dtr                         ;no args
purge_r_buf equ set_dtr                         ;no args

            mov al,ds:[si.FirstArg]
            and al,1                            ;isolate arg (if any)
            mov ds:[si.ReturnCode],NoError
            int fossil_int
            ret

set_dtr     endp

set_watchdog endp


put_string proc near

        push si
oloop:
	cmp ds:[si.FirstArg],null       ;EOS yet?
	jz  e_out
        mov ah, 1                       ;function is send with wait
	mov al, ds:[si.FirstArg]
        push dx
        push ds
        push si
        int fossil_int
        pop si
        pop ds
        pop dx
        inc si
	jmp oloop                       ;and again

e_out:
        pop si
        and ax, status_mask             ;mask defined status bits
        or al,ah
        or al,16                        ;make sure you don't return a 0 
                                        ;thereby truncating string length
        mov ds:[si.ReturnCode],al
	ret

put_string endp


get_string proc near

        push si
                
iloop:
	cmp ds:[si.FirstArg],null      ;EOS yet?
	je e_out
        mov ah, 2                      ;function is receive with wait
        push dx
        push ds
        push si
        int fossil_int
        pop si
        pop ds
        pop dx
	mov ds:[si.FirstArg],al
        cmp al, cr
        je quit_get                     ;check for EOL sequences
        cmp al, lf
        je quit_get
        cmp al, eof
        je quit_get
        inc si
	jmp iloop       		;and again

quit_get:
        cmp ds:[si.FirstArg], null      ;pad with blanks to end
        je e_out
        mov ds:[si.FirstArg], space
        inc si
        jmp quit_get

get_string endp

send_nowait proc near

        mov al, ds:[si.FirstArg]
        push ds
        push si
        int fossil_int
        pop si
        pop ds
        mov ds:[si.ReturnCode], NoError
        cmp ax,1                        ;AX = 1 means success
        je s_n_exit
        mov ds:[si.ReturnCode], IsError

s_n_exit:
        ret

send_nowait endp

recv_nowait proc near

        push ds
        push si
        int fossil_int
        pop si
        pop ds
        mov ds:[si.ReturnCode], IsError
        cmp ax, 0FFFFh                   ;AX = 0FFFFh means no go
        je r_n_exit
        mov ds:[si.FirstArg], al
        mov ds:[si.ReturnCode], NoError

r_n_exit:
        ret

recv_nowait endp

set_flow proc near

        mov al, ds:[si.FirstArg]
        and al, 7                       ;isolate the argument

;               First Argument low bits mean:
;
;		Bit 0 = 1	XON/XOFF
;		Bit 1 = 1	CTS/RTS
;               Bit 2 = 1       DSR/DTR

        or al, 0F0h             
        mov ds:[si.ReturnCode], NoError
        int fossil_int
        ret

set_flow endp
        

test_dcd proc near

        mov ah,3                        ;request status
        push ds
        push si
        int fossil_int
        pop si
        pop ds
        mov ds:[si.ReturnCode], NoError
        test al, 80h                     ;test DCD value
        je DCD_exit
        mov ds:[si.ReturnCode], IsError

DCD_exit:
        ret

test_dcd endp


FOSSIL   endp
code     ends
         end
