PROCEDURE DbfInfo
PARAMETER FilePath
**     Date: 12/12/94
**   Author: Wyne Ince
**  Company: WynServe Computing
**	     181 Clarkson Ave
**	     Brookly NY 11226
**           Tel: 718-693-2294 	
**  Purpose: A simple utility to printout your dbf files along with:
**			 Dbf structure and index expression. 
**    Input: FilePath
**    Ouput: Parsed information placed in Results.Txt in current directory
**  Example: Do Dbfpro with "D:\dbf"
** Freeware - share it! (A minor contribution to the FoxPro world)

IF TYPE("FilePath") != "C"
	WAIT WINDOW "Usage: dbfpro <Filepath> Eg. D:\dbf" TIMEOUT 2 
	CANCEL	
ENDIF
CLEAR
IF (SET("TALK")) = "ON"
	SET TALK OFF
	Talkstate = "ON"
ELSE
	Talkstate = "OFF"
ENDIF
SET SAFETY OFF
lcDivider = REPLICATE('*',65)
lcDivider = lcDivider+REPLICATE(CHR(13),2)
OutHandle =FCREATE('Result.Txt')		
=ADIR(laDir,FilePath+"\*.dbf")
=ASORT(laDir)
J=1
laCnt= ALEN(laDir)/5	
FOR i = 1 TO laCnt
	USE (laDir[j])	
	LIST STATUS TO FILE JUNK NOCONSOLE additive
	=FWRITE(OutHandle,"File: "+STR(i,2)+" "+laDir[j]+REPLICATE(CHR(13),2))
	=ProcessThisDbf()
	=FWRITE(OutHandle,CHR(13))	
	IF LEN(DBF()) > 1
		LIST STRUCTURE TO FILE JUNK NOCONSOLE
		=ProcessThisDbf()			
	ENDIF
	=FWRITE(OutHandle,lcDivider)
	J=J+5
	USE
ENDFOR
=FCLOSE(OutHandle)	
WAIT WINDOW "All is done..." Timeout 1
WAIT CLEAR
ERASE "JUNK.TXT"
SET SAFETY ON
CLOSE ALL
RETURN


PROCEDURE ProcessThisDbf

InFileHandle = FOPEN("Junk.Txt")  
IF InFileHandle < 0 && file not open
	WAIT WINDOW "Cannot open Junk.Txt "+LTRIM(STR(FERROR()))
ELSE	
	TxtBuffer = FGETS(InFileHandle)		
	WAIT WINDOW NOWAIT "Processing Dbfs"
	DO WHILE !FEOF(InFileHandle) 
	    IF ATC("Index tag",  TxtBuffer) > 0  .OR. ;
           ATC("Field Name", TxtBuffer) > 0  .OR. ;
           ATC("Numeric  ",  TxtBuffer) > 0  .OR. ;           
           ATC("Character  ",TxtBuffer) > 0  .OR. ;           
           ATC("Date    ",   TxtBuffer) > 0  .OR. ;           
           ATC("Memo   ",    TxtBuffer) > 0  .OR. ;           
           ATC("Logical   ", TxtBuffer) > 0 
       		TxtBuffer = TxtBuffer + CHR(13)
       		IF ATC("Index tag",TxtBuffer) > 0
       			TxtBuffer = RIGHT(TxtBuffer,LEN(TxtBuffer)-5)
       			TxtBuffer=STUFF(TxtBuffer,ATC("Colla",Txtbuffer),17,'')
       		ENDIF
    		=FWRITE(OutHandle,TxtBuffer)
	    ENDIF 
   		TxtBuffer = FGETS(InFileHandle)
	ENDDO
    IF AT("** Total **",TxtBuffer) > 0 
		=FWRITE(OutHandle,TxtBuffer+CHR(13))
	ENDIF
	= FCLOSE(InFileHandle)	
ENDIF 
SET TALK &TalkState			
RETURN