/******************************************************************************
*  DbfDef Ver. 1.0  (c) 1990 Kathy Cea
*
*  This program appeared in the SET EXPERT ON column by P. L. Olympia
*  April, 1990 issue of DBMS Magazine.
*
*  DbfDef is a utility designed to replace the Force DBFDMP utility.  It is
*  similar to the DBFDMP utility in that it displays the DBFDEF for the
*  specified database files.  However, it allows wildcard characters on the
*  command line and strips the drive and directory information when
*  displaying the .dbf name.
*
*  Calling Syntax:
*     DbfDef <dbf-name>
*        <dbf-name> - The name of the .dbf to be dumped in DBFDEF format.
*                     Wildcards are accepted.
*
* Compiled in TurboC 2.0
******************************************************************************/

#include <stdio.h>
#include <string.h>
#include <dir.h>
#include <dos.h>
#include "DbfDef.h"

void main (int argc, char *argv[])
{
    FILE *fp;
    unsigned  version, nfields,n,extpos;
    int morefile;
    char dbname[MAXPATH],
         dbname2[MAXPATH],
         drive[MAXDRIVE],
         dir[MAXDIR],
         filename[MAXFILE],
         ext[MAXEXT];
    struct dbf_header header;
    struct dbf_record field;
    struct ffblk fileinfo;

/* Display command syntax if no parameters are passed */
    if (argc < 2) {
        printf("\nDbfDef -- Program to display Force .dbf definition\n");
        printf("   Usage: \n");
        printf("   DbfDef <dbf-name>, where\n");
        printf("          <dbf-name> is name of .dbf file.  Wildcards accepted.\n\n");
        exit(2);
    }
    strcpy(dbname, argv[1]);

/* Append extension if none is found */
    if (strstr(dbname,".") == NULL)
        strcat(dbname, ".dbf");

/* Process wildcard characters in .dbf name */
/* If extension .* is provided, make sure the extension is .dbf */
    if (strpbrk(dbname,"*?") != NULL) {
        if (strstr(dbname,".*") != NULL) {
            extpos = strcspn(dbname,".");
            strncpy(dbname2,dbname,extpos);
            dbname2[extpos] = '\0';
            strcat(dbname2, ".dbf");
        }
        else
            strcpy(dbname2, dbname);
        if (findfirst(dbname2,&fileinfo,0) != -1) {
/********************************************************************
 * fnsplit returns only filename and extension in fileinfo.ff_name  *
 * therefore you must prefix the file name with drive and directory *
 * entered by the user.                                             *
 ********************************************************************/
            fnsplit (dbname2,drive,dir,filename,ext);
            strcpy(dbname,drive);
            strcat(dbname,dir);
            strcat(dbname,fileinfo.ff_name);
        }
        else {
            printf("No matching .dbf files found\n");
            exit(1);
        }
    }

/* Open and process each .dbf */
    morefile = 1;
    while (morefile) {
        if ((fp=fopen(dbname, "rb"))==NULL) {
            printf ("\nERROR: Unable to open %s", dbname);
            exit(1);
        }
        else
            fread (&header, 32,1,fp);

        version = header.id & 0x07;
        nfields = (header.header_len - 33) / 32;

        if (version != 3)  {
            printf ("\nERROR: %s not in dBASE III format", dbname);
            exit(1);
        }

/* Display the DBFDEF used by Force to define .dbf structure */
        strlwr(dbname);
        fnsplit (dbname,drive,dir,filename,ext);
        printf("DBFDEF  %s\n", filename);

        for (n=0; n < nfields;n++) {
            fread (&field, 32,1,fp);
            switch (field.type) {
                case 'C':
                    printf ("\t%s", "CHAR(");
                    printf ("%2d)", field.length);
                    break;
                case 'D': printf ("\t%s\t", "DATE"); break;
                case 'N':
                case 'F':
                    if (field.decimals == 0) {
                        if (field.length > 5)
                            printf ("\t%s", "LONG(");
                        else
                            printf ("\t%s", "INT(");
                        printf ("%2d) ", field.length);
                    }
                     else {
                        printf ("\t%s", "DBL(");
                        printf ("%2d:%d)", field.length,field.decimals);
                    }
                    break;
                case 'L': printf ("\t%s\t", "LOGICAL"); break;
                case 'M': printf ("\t%s\t", "MEMO"); break;
                }
            printf ("\t%s\n", strlwr(field.name));
            }
            printf ("ENDDEF\n\n");
            fclose (fp);

/*  Check for additional files */
        if (findnext (&fileinfo) == -1)
            morefile = 0;
        else {
            strcpy(dbname,drive);
            strcat(dbname,dir);
            strcat(dbname,fileinfo.ff_name);
        }
    } /* while more files to process */
}   /* main */
