*       +----------------------------------------------------------+
*       | COMPILER.PRG ver. 1.5 - for FoxPro 2.6  +MOUSE REQUIRED+ |
*       |----------------------------------------------------------|
*       |  Author:  Shawn Kelly, Inventive Software   12 Dec 1994  |
*       |----------------------------------------------------------|
*       | Purpose: Compile the screen, menu, or program you are    |
*       |          currently editing by positioning the mouse      |
*       |          cursor anywhere on the window border and        |
*       |          pressing an ON KEY LABEL key. Avoids going      |
*       |          through the FP2 compile screens. Displays       |
*       |          compile error log automatically if created,     |
*       |          and source code for screen/menus if possible.   |
*       |          Accepts ENCRYPT and/or NODEBUG options.         |
*       |   (v1.4) Detects if file has not been saved.             |
*       |          Respects current SET LOGERRORS setting.         |
*       |   (v1.5) Works with FPW and FPW.                         |
*       |----------------------------------------------------------|
*       |  Syntax: (Usually called from an ON KEY LABEL key)       |
*       |          DO COMPILER.PRG [WITH "E"|"N"|"EN"]             |
*       |           "E"  = Compile with ENCRYPT option             |
*       |           "N"  = Compile with NODEBUG option             |
*       |           "EN" = Compile with ENCRYPT + NODEBUG options  |
*       |----------------------------------------------------------|
*       | Example: ON KEY LABEL Shift-F9 DO COMPILER.PRG with "EN" |
*       +----------------------------------------------------------+
*
PROCEDURE compiler
*
PARAMETERS m_options
*
PRIVATE m_encrypt, m_nodebug, m_window, m_position, m_root, m_ext, ;
	m_talk, w_compiler, w_saveyn, m_dispmsg, m_ver, m_answer, ;
	m_logerrors
*
IF SET("TALK") = "ON"
  SET TALK OFF
  m_talk = SET("TALK")
ELSE
  m_talk = SET("TALK")
ENDIF
*
m_ver = "1.5"
m_logerrors = SET("LOGERRORS")
*
IF !SKPBAR("_MFILE", _MFI_SAVE)
	DEFINE WINDOW w_saveyn FROM 09,18 TO 15,60 COLOR SCHEME 7 ;
    TITLE " COMPILER Ver. "+m_ver+" " SHADOW DOUBLE
  ACTIVATE WINDOW w_saveyn NOSHOW
  m_answer = 2
  @ 01,04 SAY "File has not been saved. Compile?"
  @ 03,10 GET m_answer FUNCTION "*H \<Yes;\!\<No" SIZE 1,8,5
  CLEAR TYPEAHEAD
  SHOW WINDOW w_saveyn
  READ OBJECT 2
  RELEASE WINDOW w_saveyn
  IF m_answer = 2
    WAIT WINDOW "Compile cancelled." NOWAIT
    IF m_talk = "ON"
      SET TALK ON
    ENDIF
    RETURN
  ENDIF
ENDIF
*
IF !EMPTY(m_options)
  m_options = UPPER(ALLTRIM(m_options))
ENDIF
*
DO CASE
  CASE PARAMETERS() = 0
    m_encrypt = ""
    m_nodebug = ""
  CASE m_options == "EN"
    m_encrypt = "ENCRYPT"
    m_nodebug = "NODEBUG"
  CASE m_options == "NE"
    m_nodebug = "NODEBUG"
    m_encrypt = "ENCRYPT"
  CASE m_options == "E"
    m_encrypt = "ENCRYPT"
    m_nodebug = ""
  CASE m_options == "N"
    m_encrypt = ""
    m_nodebug = "NODEBUG"
  OTHERWISE
    WAIT WINDOW "COMPILER.PRG parameters invalid. Compile not executed." NOWAIT
    IF m_talk = "ON"
      SET TALK ON
    ENDIF
    RETURN
ENDCASE
*
m_window = MWINDOW()
*
IF EMPTY(m_window)
  WAIT WINDOW "Mouse not positioned over any window." NOWAIT
  IF m_talk = "ON"
    SET TALK ON
  ENDIF
  RETURN
ENDIF
*
IF PROPER(m_window) = "Command"
  WAIT WINDOW "Command window cannot be compiled." NOWAIT
  IF m_talk = "ON"
    SET TALK ON
  ENDIF
  RETURN
ENDIF
*
IF (LEN(m_window) > 12)
  WAIT WINDOW "Window/Menu/Program '"+m_window+"' is invalid." NOWAIT
  IF m_talk = "ON"
    SET TALK ON
  ENDIF
  RETURN
ENDIF
*
IF !(FILE(m_window))
  WAIT WINDOW "Window/Menu/Program '"+m_window+"' does not exist on disk." NOWAIT
  IF m_talk = "ON"
    SET TALK ON
  ENDIF
  RETURN
ENDIF
*
m_position = RAT(".", m_window)
m_root = SUBSTR(m_window, 1, m_position - 1)
m_ext = SUBSTR(m_window, m_position + 1, 3)
SET CURSOR OFF
*
DO CASE
  CASE m_ext = "SCX"
    m_compfile = m_root+".SPR"
  CASE m_ext = "MNX"
    m_compfile = m_root+".MPR"
  CASE m_ext = "PRG"
    m_compfile = m_root+".PRG"
  OTHERWISE
    SET CURSOR ON
    WAIT WINDOW "Extension '"+m_ext+"' is invalid." NOWAIT
    IF m_talk = "ON"
      SET TALK ON
    ENDIF
    RETURN
ENDCASE
*
IF FILE(m_compfile)
  DO CASE
    CASE EMPTY(m_encrypt) .AND. EMPTY(m_nodebug)
      m_dispmsg = "Compiling "+m_compfile+" [No Options]..."
    CASE EMPTY(m_encrypt)
      m_dispmsg = "Compiling "+m_compfile+" [NODEBUG]..."
    CASE EMPTY(m_nodebug)
      m_dispmsg = "Compiling "+m_compfile+" [ENCRYPT]..."
    OTHERWISE
      m_dispmsg = "Compiling "+m_compfile+" [ENCRYPT and NODEBUG]..."
  ENDCASE
  IF _WINDOWS
	DEFINE WINDOW w_compiler FROM 03,11 TO 06,68 HALFHEIGHT SYSTEM
  ELSE
	  DEFINE WINDOW w_compiler FROM 03,11 TO 06,68 COLOR SCHEME 5 SHADOW
	ENDIF
  ACTIVATE WINDOW w_compiler NOSHOW
  @ 0,0 SAY PADC("- COMPILER ver. "+m_ver+" -", WCOLS())
  @ 1,0 SAY PADC(m_dispmsg, WCOLS())
  SHOW WINDOW w_compiler
  WAIT WINDOW "" TIMEOUT(0.5)
  CLEAR TYPEAHEAD
  IF m_logerrors = "OFF"
    SET LOGERRORS ON
  ENDIF
  COMPILE (m_compfile) &m_encrypt &m_nodebug
  RELEASE WINDOW w_compiler
ELSE
  m_compfile = GETFILE("PRG|SPR|MPR", " Where is "+m_compfile+"?  [COMPILER ver. "+m_ver+"]", "Compile")
  IF EMPTY(m_compfile)
    WAIT WINDOW "Compile cancelled." NOWAIT
  ELSE
    DO CASE
      CASE EMPTY(m_encrypt) .AND. EMPTY(m_nodebug)
	m_dispmsg = "Compiling "+m_compfile+" [No Options]..."
      CASE EMPTY(m_encrypt)
	m_dispmsg = "Compiling "+m_compfile+" [NODEBUG]..."
      CASE EMPTY(m_nodebug)
	m_dispmsg = "Compiling "+m_compfile+" [ENCRYPT]..."
      OTHERWISE
	m_dispmsg = "Compiling "+m_compfile+" [ENCRYPT and NODEBUG]..."
    ENDCASE
    DEFINE WINDOW w_compiler FROM 03,11 TO 06,68 COLOR SCHEME 5 SHADOW
    ACTIVATE WINDOW w_compiler NOSHOW
    @ 0,0 SAY PADC("- COMPILER ver. "+m_ver+" -", WCOLS())
    @ 1,0 SAY PADC(m_dispmsg, WCOLS())
    SHOW WINDOW w_compiler
    WAIT WINDOW "" TIMEOUT(0.5)
    CLEAR TYPEAHEAD
    IF m_logerrors = "OFF"
      SET LOGERRORS ON
    ENDIF
    COMPILE (m_compfile) &m_encrypt &m_nodebug
    RELEASE WINDOW w_compiler
  ENDIF
ENDIF
*
SET CURSOR ON
*
IF FILE(m_root+".ERR")
  WAIT WINDOW "Errors found during compilation!" NOWAIT
  IF EMPTY(m_encrypt)
    IF m_ext = "SCX" .OR. m_ext = "MNX"
      MODIFY COMMAND (m_compfile) NOEDIT SAVE NOWAIT
    ENDIF
  ELSE
    WAIT WINDOW "Source code ENCRYPTed - cannot display." NOWAIT
  ENDIF
  IF m_logerrors = "ON"
    MODIFY COMMAND m_root+".ERR" NOEDIT SAVE NOWAIT
  ELSE
    ERASE (m_root+".ERR")
  ENDIF
ELSE
	WAIT WINDOW "No errors found during compilation." NOWAIT
ENDIF
*
IF m_logerrors = "OFF"
  SET LOGERRORS OFF
ENDIF
*
IF m_talk = "ON"
  SET TALK ON
ENDIF
*
RETURN
*
