************************************************************************
** Sample UserCall Back function for FOXSQZ	or COMP5				   *
** (c) 1993-94 Master Creative Software, Inc.						   *
** Please feel free to use any or all of this code in your app		   *
************************************************************************
* Last Updated 3/16/94 8:22pm WSM


* WARNING FOXSQZ call back routines must follow some rules
*	 1) must always have the same parameter list as defined below
*	 2) Should ALWAYS return back to FOXSQZ !!!
*	 3) must not CANCEL and should not suspend
*	 4) should not take very long to run
*	 5) must not change the current working directory
*	 6) must never shell out to DOS
*	 7) do not load any other PLB or FLL

*#'s 1,2 are the most critical rules

** basically all they should do is proccess a message coming from
** FOXSQZ and paint something on the screen.
** Call Back functions were put in to replace FOXSQZ screen output
** and provide a custom output interface which suits your application


Parameters msg,str,i1,i2

*
*   msg = the message that FOXSQZ will pass to your call back funtion
*		 it will also tell your CB function what the parameters passed in are
*   str = for certain messages FOXSQZ will pass a string back . currently it passes
*		 strings back for CBACK_NEW And CBACK_DELETING Messages
*   i1  = these are integers that Foxsqz may pass to the CB function
*   i2    depending on the message
*
*   For those you are interested and don't know this, The method used
*   here is simliar to the way windows programs work (as a veryyy simple example)
*   Windows calls your procedures passing it a message number and parameters.
*   and your procedure would respond to the function. Here FOXSQZ does'nt care what
*   you return , JUST AS LONG AS YOU DO !!
*

** These are the currently supported messages that FOXSQZ sends
** this procedure

#define CBACK_INIT      0										&& When FoxSqz Started
#define CBACK_STORE     1										&& File will be stored
#define CBACK_PROGRESS  2										&& Update Compression progress
#define CBACK_RATIO     4										&& return compressed,decompressed size for ratio


do case
case msg = CBACK_PROGRESS
	do slidebar with "",6,i2,i1
case msg = CBACK_INIT
	do slidebar with "I",6,0,0,"Compressing"
case msg = CBACK_RATIO
	Release Wind Thermo
	Clear
	? Ltri(Str(100- (i1/i2*100))) + "% Compressed"
EndCase

Return




*************************************************************************
Procedure SlideBar
************************************************************************
Parameters _Smsg,_Srow,_i1,_i2,_Msg

** SLIDE BAR UDF v1.00 By Warren Master Nov 1991

**USSAGE:
*************************************************************
*_Smsg Set To "I" for First Time and Nothing After That    *
*_Srow Row Where Bar Will Move                              *
*_i1 Number of Thing We Want to do                       *
*_i2 The Number of Things We have Done So far          *
*************************************************************

**********************************************************
*Example                                                 *
**********************************************************
* TOTRECS=reccount()
* CCNT=0
* go top
* do slidebar with "I",20,TOTRECS,CCNT
* Do While
*     Do something
*     Skip
*    CCNT=CCNT+1
*    do slidebar with "",20,TOTRECS,CCNT
*
* Enddo

if upper(_smsg)=="I"
	Define Window Thermo From _srow-3,2 TO _srow+2,78 Double 
	Activate Window Thermo
	@ 0,0 say _msg
	@ 1,5 say "Ŀ"
	@ 2,5 say "0%              25%             50%              75%            100%"
	@ 3,5 say ""
else
	@ 2,6 fill to 2,6+round(66*(_i2/_i1)+.50,0) color n/w,w/n
endif
return
