/**************************************************\
* COMMAIZE.c written by Chuck Maier 1990           *
*                                                  *
* This program will INSERT (before) a character    *
* or REPLACE a character position in each line     *
* with the  COMMA character after replacing all    *
* commas in the line with SPACEs.                  *
*                                                  *
\**************************************************/



#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <fcntl.h>
#include <ctype.h>

#define FAILURE -1

FILE *fin,*fout;
long file_size,file_pos;
int backup;
struct FLAT {
    char type;
    int size;
};

char input[4096], output[4096], list[200][6];


main(argc,argv,envp)
int argc;
char *argv[];
char *envp[];
{
    int y,a,b,lines,c;
    char *p;


    backup=lines=0;
    if(argc < 3){
        printf("\nERROR.. COMMAIZE  requires 2+ calling parameters.");
        printf("\nCOMMAIZE <file-from>  <file-to> [ <In/Rn> <In/Rn>... etc]\n\n");
        printf("\nThe <In> is where to INSERT a comma BEFORE that char.(DEFAULT)");
        printf("\nThe <Rn> is where to REPLACE a char with a comma.\n");
        printf("\nCOMMAND :    BEFORE             AFTER");
        printf("\nI2 i4 r6   'ABCDEFGHI'        'A,BC,DE,GHI'");
        printf("\nI4 I5 I6   'ABCDEFGHI'        'ABC,D,E,FGHI");
        printf("\n   NOTE: Position references are NOT affected by INSERT! This means");
        printf("\nsimply.. If you INSERT a comma in position 4.. the original");
        printf("\ncharacter position 6 REMAINS character position 6!!");
        printf("\n\nNOTE: Character positions start counting at '1'!!");
        printf("\nIf you leave off the list of columns, you will be prompted");
        printf("\nfor a list.");

        printf("\n   Due to sensitivity of DBF.. all commas already in the");
        printf("\nfile-from are replaced by SPACEs prior to operating");
        printf("\non each line of the file.");
        printf("\nYou can leave OFF the 'I'... an insert will be done!");
        printf("\n\nIndependant work by Chuck Maier, Roy F. Weston Inc,1990");
        exit(1);
    }
    fin=fopen(argv[1],"r");
    if(fin==NULL){
        printf("ERROR opening input file.\n");
        exit(1);
    }
    fseek(fin,0,2);
    file_size=ftell(fin);
    fseek(fin,0,0);
    fout=fopen(argv[2],"w");
    if(fout==NULL){
        printf("\nERROR opening output file\n");
        fclose(fin);
        exit(1);
    } else {
        printf("\nCOMMAIZE rev 3.2 Chuck Maier 1993\n");
    }

    if(argc > 3){
        for(a=3;a<argc;a++){
            strcpy(list[a-3],argv[a]);
            list[a-3][5]=0x00;
            strupr(list[a-3]);
            y=list[a-3][0];
            if(y!='R' && y!='I') strins(list[a-3],"I");
        }

        a -= 3;
    } else {
        printf("\r\nENTER your params..BLANK line to stop!!..\r\n");
        for(a=0;;a++){
            p=gets(list[a]);
            list[a][5]=0x00;
            if(strlen(list[a])==0) break;
            strupr(list[a]);
            y=list[a][0];
            if(y!='R' && y!='I') strins(list[a],"I");
            if(p==NULL){
                break;
            }
        }
    }
    y=a;

    for(lines=0;;lines++){
        p=fgets(input,4095,fin);
        if(p==NULL) goto rexx;
        input[4095]=0x00;
        for(a=0;a<strlen(input);a++){
            if(input[a]==',') input[a]=' ';
            if(input[a]=='\r'|| input[a]=='\n'){
                input[a]=0x00;
                break;
            }
        }

        b=0;
        for(a=0;a<y;a++){
            c=atoi(&list[a][1])-1;
            if(c>strlen(input) || c<0){
                printf("\nNOTE: Read line # %d was shorter than param # %d\n",lines+1,a+1);
                break;  /* go on as long as we warned him */
            }
            switch(list[a][0]){
                case 'R':
                    input[c+b]=',';
                    break;
                case 'I':
                    strcpy(output,input);
                    strcpy(&input[c+1+b],&output[c+b]);
                    input[c+b]=',';
                    b++;
                    break;
                default:
                    printf("\r\nERROR in param # %d\r\n",a+1);
                    goto rexx;
            }
        }
        fprintf(fout,"%s\n",input);
        backup++;
        if((backup & 0x1f)==0x1f){
            file_pos=ftell(fin);
            printf("\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\bposition=%9ld of %9ld",file_pos,file_size);
            backup=0;
        }
    }
rexx:
    file_pos=ftell(fin);
    printf("\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\bposition=%9ld of %9ld",file_pos,file_size);
    fclose(fin);
    fclose(fout);
    printf("\n\nThere were %d lines processed!!",lines);
}

