*-------------------------------------------------------------------------------
*-- Program...: COLORIT.PRG
*-- Programmer: Pat Barkman (Borland)
*-- Date......: 08/??/1992
*-- Notes.....: This is from the Technotes Article "When Life Gives You GR+,
*--             Make Lemonade", with some VERY minor modifications by Ken 
*--             Mayer (KENMAYER).
*-- Updated...: 09/09/1992 -- Allows save of memvars do user's hard drive on
*--             LAN, so can colors can be "automatically" reset, using 
*--             COLORIT2.PRG ... file saved to is: 
*--                   <startupdirectory>\COLORIT.MEM
*--             09/16/1992 -- Made this more "generic" (i.e., dBASE IV, versions
*--               1.1 through current should be able to use this ...), and
*--               file COLORIT.MEM is saved in the directory that is in the PATH
*--               of dBASE (or CONFIG.DB setting).
*-- INSTRUCTIONS:
*--              Copy the files COLORIT*.PRG from the network. Easiest method:
*--              from the control center: 
*--                    <Esc>  (press escape key)
*--                    Yes    (choose 'yes' button)
*--                      (G: is where the network copy of dBASE IV is ...)
*--                    !COPY G:COLORIT*.PRG
*--                           (should say "2 file(s) copied")
*--              Next, modify the configuration file for your sessions:
*--                    MODIFY COMMAND [location of configfile]\CONFIG.DB
*--                       find line that says:
*--                    COMMAND = ASSIST
*--                       and change it to read:
*--                    COMMAND = DO COLORIT2
*--                    <Ctrl><End>   (save file)
*--              Go back to Control Center:
*--                    ASSIST          (call control center)
*--              And add COLORIT program to list of files in CC:
*--                    move cursor to Applications
*--                    <F10>         (call menu)
*--                      "Add file to catalog" (choose this)
*--                           move cursor to:
*--                       COLORIT.PRG       (press <Enter>)
*--                      for File Description, enter:
*--                       Program to set colors in Control Center   <Enter>
*--              Finally, to run COLORIT.PRG, place cursor on it, and press
*--              <Enter>   dBASE will give options to Run Application   or
*--                        modify. Choose Run Application. When it asks if you
*--                        really want to, choose "Yes" again.
*-------------------------------------------------------------------------------

*-- save environment
cTalk = set("TALK")
set talk off
lVer15 = val(right(version(),3)) => 1.5  && get version of dBASE IV (if 1.5 or >
                                         && set this to true ...
cStat = set("STATUS")
set stat off
if lVer15 
	cBox  = set("BORDER")
endif
cDir = set("DIRECTORY") && get the directory ...

clear                   && clear the screen ...
public cColNormal, cColMessages, cColTitles, cColHighlight, cColBox, cColInfo,;
		 cColFields
do dbDefault            && setup memvars, in case user doesn't select something

if iscolor()            && if user has color card ...
	*-- define the popup
	set border to double
	define popup pColor from 6,28 
	define bar 1 of pColor prompt "  Pick a Color Scheme " skip
	define bar 2 of pColor prompt replicate(chr(196),22)  skip
	define bar 3 of pColor prompt " Easy Earth Tones"
	define bar 4 of pColor prompt " Holiday Faire"
	define bar 5 of pColor prompt " Jammin' Jamaican"
	define bar 6 of pColor prompt " Patriocraty"
	define bar 7 of pColor prompt " Wall Street Stout"
	define bar 8 of pColor prompt " dBASE Default Colors "
	on selection popup pColor do WhatColor
	activate popup pColor
	
	do setcolors  && set the colors ...
	
	clear         && so user sees new color scheme
	
	*-- ask if user wants to save config
	cYN = "Y"
	@10,12 say "Save color configuration? " get cYN picture "!";
		valid required cYN $ "YN";
		error chr(7)+"Enter 'Y' or 'N'"
	read
	
	*-- if yes, save it ...
	if cYN = "Y"
		set safety off   && allow overwrite, without asking user
		save all like cCol* to cDir+"\colorit.mem"  && save it
		set safety on    && reset "safety"
	endif  && cYN
	
else  && MDA (Monochrome, no graphics, adapter ...)

	@10,12 say "You do not have color ... this program will do you no good!"
	@11,12 say " ... Press any key to return ... "
	cCursor = set("CURSOR")
	set cursor off
	x=inkey(0)
	set cursor &cCursor

endif

*-- reset environment
set talk &cTalk
set stat &cStat
if lVer15
	set border to &cBox
endif
release popup pColor
release all

RETURN

PROCEDURE WhatColor

	do case
		case bar() = 3
			do earth
		case bar() = 4
			do holiday
		case bar() = 5
			do jamaican
		case bar() = 6
			do patriot
		case bar() = 7
			do wallstreet
		case bar() = 8
			do dbDefault
	endcase
	deactivate popup

RETURN

PROCEDURE Earth               && Easy Earth Tones
	
	cColNormal    = "w+/rg"    && bright white on brown
	cColMessages  = "g/n"      && green on black
	cColTitles    = "rg+/b"    && yellow on blue
	cColHighlight = "rg+/rg"   && yellow on brown
	cColBox       = "g/b"      && green on blue
	cColInfo      = "g+/b"     && bright green on blue
	cFields       = "rg+/b"    && yellow on blue
	
RETURN

PROCEDURE Holiday             && Holiday Faire

	cColNormal    = "w+/r"     && bright white on red
	cColMessages  = "w/n"      && white on black
	cColTitles    = "g+/r"     && bright green on red
	cColHighlight = "rg+/r"    && yellow on red
	cColBox       = "r/g"      && red on green
	cColInfo      = "r/g"      && red on green
	cColFields    = "w+/g"     && bright white on green

RETURN

PROCEDURE Jamaican            && Jammin' Jamaican

	cColNormal    = "w+/gb"    && bright white on brown
	cColMessages  = "w/rb"     && white on purple
	cColTitles    = "b/gb"     && blue on cyan
	cColHighlight = "rb+/b"    && bright purple on blue
	cColBox       = "gb/rb"    && cyan on purple
	cColInfo      = "g+/rb"    && green on purple
	cColFields    = "w+/gb"    && bright white on cyan
	
RETURN

PROCEDURE Patriot             && Patriocraty

	cColNormal    = "w+/b"     && bright white on blue
	cColMessages  = "w/r"      && white on red
	cColTitles    = "w+/b"     && bright white on blue
	cColHighlight = "w+/n"     && bright white on black
	cColBox       = "b/r"      && blue on red
	cColInfo      = "w+/r"     && bright white on red
	cColFields    = "w+/n"     && bright white on black
	
RETURN

PROCEDURE WallStreet          && Wall Street Stout
	
	cColNormal    = "b/w"      && blue on white
	cColMessages  = "g/b"      && green on blue
	cColTitles    = "n+/w"     && grey on white
	cColHighlight = "r+/b"     && pink on blue
	cColBox       = "b/w"      && blue on white
	cColInfo      = "g+/b"     && bright green on blue
	cColFields    = "r/w"      && red on white

RETURN

PROCEDURE dbDefault           && dBASE Default Colors
	
	cColNormal    = "w+/b"     && bright white on blue
	cColMessages  = "w/n"      && white on black
	cColTitles    = "w+/b"     && bright white on blue
	cColHighlight = "rg+/gb"   && yellow on cyan
	cColBox       = "rg+/gb"   && yellow on cyan
	cColInfo      = "b/w"      && blue on white
	cColFields    = "n/gb"     && black on cyan
	
RETURN

PROCEDURE SetColors           && actually set the colors

	set color of normal      to &cColNormal
	set color of messages    to &cColMessages
	set color of titles      to &cColTitles
	set color of highlight   to &cColHighlight
	set color of box         to &cColBox
	set color of information to &cColInfo
	set color of fields      to &cColFields

RETURN

*-------------------------------------------------------------------------------
*-- End of Program: COLORIT.PRG
*-------------------------------------------------------------------------------
