*       *********************************************************
*       *                                                         
*       * Don Pitchford
*		* CompuServe Id:  74720,1561
*       * Plano, Texas 
*       *                                                         
*       * Description:                                            
*       *                                                         
*       *    Generates a window that shows color combination for
*       *    RGB colors.  The window shows both foreground and
*       *    background color.  It allows the user to determine
*       *    the best color combination for their screens.
*       * 
*       *    Useage:  = Color_Box(@<Int1>,@<Int2>,@<Int3>,;
*       *                         @<Int4>,@<Int5>,@<Int6>) 
*       *
*		*    The variables are passed as reference to allow useage
*       *    for other screens.
*       *
*		*    	<Int1>	-  	Integer.  Foreground Red.
*		*		<Int2>	-	Integer.  Foreground Green.
*		*		<Int3>	-	Integer.  Foreground Blue.
*		*		<Int4>	-	Integer.  Background Red.
*		*		<Int5) 	-	Integer.  Background Green.
*		*		<Int6)	-	Integer.  Background Blue.
*		*
*		*	Sample Call:
*		*   
*		*		store 128 to FR,FG,FB,BR,BG,BB)
*		*
*		* 		= Color_Box(@FR,@FG,@FB,@BR,@BG,@BB)
*		*
*		*
*		* 	About:
*		*  		Majority of this code was generated with Foxpro Screen
*		*		Gen.  This program is shareware.  The program is FREE.
*		* 		It may be distributed, altered or resold without any
*		*		compensation to the author.  
*		*
*       *********************************************************
*
*
* 		= Color_Box(128,128,128,128,128,128)
*
*----------------------------------------------------------------------
*
*----------------------------------------------------------------------
function COLOR_BOX
     parameter ForeRed,ForeGreen,ForeBlue,;
     		   BackRed,BackGreen,BackBlue
   
*   
*  Make Sure that value are in range and are integers.
*   
ForeRed = iif(ForeRed > 255,255,ForeRed)
ForeRed = iif(ForeRed < 0,0,ForeRed)
ForeRed = int(ForeRed)
ForeGreen = iif(ForeGreen > 255,255,ForeGreen)
ForeGreen = iif(ForeGreen < 0,0,ForeGreen)
ForeGreen = int(ForeGreen)
ForeBlue = iif(ForeBlue > 255,255,ForeBlue)
ForeBlue = iif(ForeBlue < 0,0,ForeBlue)
ForeBlue = int(ForeBlue)
BackRed = iif(BackRed > 255,255,BackRed)
BackRed = iif(BackRed < 0,0,BackRed)
BackRed = int(BackRed)
BackGreen = iif(BackGreen > 255,255,BackGreen)
BackGreen = iif(BackGreen < 0,0,BackGreen)
BackGreen = int(BackGreen)
BackBlue = iif(BackBlue > 255,255,BackBlue)
BackBlue = iif(BackBlue < 0,0,BackBlue)
BackBlue = int(BackBlue)



#REGION 0
REGIONAL m.currarea, m.talkstat, m.compstat

IF SET("TALK") = "ON"
	SET TALK OFF
	m.talkstat = "ON"
ELSE
	m.talkstat = "OFF"
ENDIF
m.compstat = SET("COMPATIBLE")
SET COMPATIBLE FOXPLUS

m.rborder = SET("READBORDER")
SET READBORDER ON

m.currarea = SELECT()


*       *********************************************************
*       *                                                         
*       *               Windows Window definitions                
*       *                                                         
*       *********************************************************
*

IF NOT WEXIST("colorbox") ;
	OR UPPER(WTITLE("COLORBOX")) == "COLORBOX.PJX" ;
	OR UPPER(WTITLE("COLORBOX")) == "COLORBOX.SCX" ;
	OR UPPER(WTITLE("COLORBOX")) == "COLORBOX.MNX" ;
	OR UPPER(WTITLE("COLORBOX")) == "COLORBOX.PRG" ;
	OR UPPER(WTITLE("COLORBOX")) == "COLORBOX.FRX" ;
	OR UPPER(WTITLE("COLORBOX")) == "COLORBOX.QPR"
	DEFINE WINDOW colorbox ;
		AT  0.000, 0.000  ;
		SIZE 11.538,65.800 ;
		TITLE "Color Selection" ;
		FONT "MS Sans Serif", 8 ;
		FLOAT ;
		CLOSE ;
		MINIMIZE ;
		COLOR RGB(,,,255,255,255)
	MOVE WINDOW colorbox CENTER
ENDIF


*       *********************************************************
*       *                                                         
*       *               ColorBox/Windows Screen Layout                
*       *                                                         
*       *********************************************************
*

#REGION 1
IF WVISIBLE("colorbox")
	ACTIVATE WINDOW colorbox SAME
ELSE
	ACTIVATE WINDOW colorbox NOSHOW
ENDIF

*
* Draw the intial Box
*
 = CB_Draw()

@ 3.000,13.200 GET ForeRed ;
	SPINNER 1.000, 0, 255 ;
	PICTURE "@K" ;
	SIZE 0.846, 7.200 ;
	DEFAULT 0.000 ;
	VALID CB_Draw() ;
	FONT "MS Sans Serif", 8
@ 5.077,13.200 GET ForeGreen ;
	SPINNER 1.000, 0, 255 ;
	PICTURE "@K" ;
	SIZE 0.846, 7.200 ;
	DEFAULT 0.000 ;
	VALID CB_Draw() ;
	FONT "MS Sans Serif", 8
@ 7.154,13.200 GET ForeBlue ;
	SPINNER 1.000, 0, 255 ;
	PICTURE "@K" ;
	SIZE 0.846, 7.200 ;
	DEFAULT 0.000 ;
	VALID CB_Draw() ;
	FONT "MS Sans Serif", 8
@ 3.000,29.400 GET BackRed ;
	SPINNER 1.000, 0, 255 ;
	PICTURE "@K" ;
	SIZE 0.846, 7.200 ;
	DEFAULT 0.000 ;
	VALID CB_Draw() ;
	FONT "MS Sans Serif", 8
@ 5.077,29.400 GET BackGreen ;
	SPINNER 1.000, 0, 255 ;
	PICTURE "@K" ;
	SIZE 0.846, 7.200 ;
	DEFAULT 0.000 ;
	VALID CB_Draw() ;
	FONT "MS Sans Serif", 8
@ 7.154,29.400 GET BackBlue ;
	SPINNER 1.000, 0, 255 ;
	PICTURE "@K" ;
	SIZE 0.846, 7.200 ;
	DEFAULT 0.000 ;
	VALID CB_Draw() ;
	FONT "MS Sans Serif", 8
@ 2.154,43.400 TO 8.385,61.400 ;
	PEN 1, 8
@ 9.000,23.400 GET mok ;
	PICTURE "@*HT Ok" ;
	SIZE 1.769,13.667,0.667 ;
	DEFAULT 1 ;
	FONT "MS Sans Serif", 8 ;
	STYLE "B"
@ 1.077,9.00 SAY "Foreground" ;
	FONT "MS Sans Serif", 10 ;
	STYLE "BT"
@ 4.769,1.600 SAY "Green" ;
	FONT "MS Sans Serif", 10 ;
	STYLE "BT" ;
	COLOR RGB(0,255,0,0,255,0)
@ 6.769,3.800 SAY "Blue" ;
	FONT "MS Sans Serif", 10 ;
	STYLE "BT" ;
	COLOR RGB(0,0,255,,,,)
@ 2.846,4.200 SAY "Red" ;
	FONT "MS Sans Serif", 10 ;
	STYLE "BT" ;
	COLOR RGB(255,0,0,,,,)
@ 1.077,25.800 SAY "Background" ;
	FONT "MS Sans Serif", 10 ;
	STYLE "BT"

IF NOT WVISIBLE("colorbox")
	ACTIVATE WINDOW colorbox
ENDIF

READ CYCLE ;
	SHOW CB_Draw()

RELEASE WINDOW colorbox
SELECT (m.currarea)


#REGION 0

SET READBORDER &rborder

IF m.talkstat = "ON"
	SET TALK ON
ENDIF
IF m.compstat = "ON"
	SET COMPATIBLE ON
ENDIF



#REGION 1

*       *********************************************************
*       *                                                         
*       *    Colorbox/Windows Supporting Procedures and Functions     
*       *                                                         
*       *********************************************************
*

#REGION 1
function CB_Draw

IF NOT WVISIBLE("colorbox")
	ACTIVATE WINDOW colorbox
ENDIF

*
*  Draw the actual Box.  This 
*

@ 2.154,43.400 TO 8.385,61.400 ;
	PEN 4, 8;
	Pattern 1;
	color RGB (ForeRed,ForeGreen,ForeBlue,;
	           BackRed,BackGreen,BackBlue)

@ 8.4,49.1 SAY "Test" ;
	FONT "MS Sans Serif", 10 ;
	STYLE "BT";
	color RGB (ForeRed,ForeGreen,ForeBlue,;
	           BackRed,BackGreen,BackBlue)

@ 4.5,48.2 SAY "Color" ;
	FONT "MS Sans Serif", 10 ;
	STYLE "BT";
	color RGB (ForeRed,ForeGreen,ForeBlue,;
	           BackRed,BackGreen,BackBlue)
	           

return .t.

*-----------------------------------------------
*
*-----------------------------------------------

