***************************************************************************
*
* Procedure file: DEMO.PRG
*        Version: 1.0
*         Author: Bill Anderson
*        CIS ID#: 72712,3417
*      Copyright: None (Public Domain)
*
***************************************************************************
*
* DEMO - Program which demonstrates the CLICKSCR driver.
*
*
*
*                  * * *  DECLARED MEMORY VARIABLES  * * *
*
*            m.woutput    = memory variable used to hold the window name
*                           of the calling screen.
*            m.window     = memory variable used to hold the parent window
*                           name of the clicked screen.
*            m.mrow       = memory variable used to hold the row of the 
*                           mouse when the screen is clicked.
*            m.mcol       = memory variable used to hold the column of the 
*                           mouse when the screen is clicked.
*            m.sfont_name = memory variable used to hold the font name for
*                           the desktop window (screen).
*            m.sfont_size = memory variable used to hold the font size for
*                           the desktop window (screen).
*            m.sfont_styl = memory variable used to hold the font style for
*                           the desktop window (screen).
*            m.wfont_name = memory variable used to hold the font name for
*                           the clicked screen.
*            m.wfont_size = memory variable used to hold the font size for
*                           the clicked screen.
*            m.wfont_styl = memory variable used to hold the font style for
*                           the clicked screen.
*
*

DO TESTER.SPR

RETURN

******************
FUNCTION WinParent
******************

PARAMETER woutput

** End parent window loop
DO WHILE NOT EMPTY(WPARENT(m.woutput))

  ** Macdesktop test
  IF _mac AND SET([MACDESKTOP]) = [ON] AND ;
  WPARENT(m.woutput) = [MACDESKTOP]
  
    EXIT
    
  ELSE 

    m.woutput = WPARENT(m.woutput)
    
  ENDIF _mac AND SET([MACDESKTOP]) = [ON] AND ;
  WPARENT(m.woutput) = [MACDESKTOP]
  ** End macdesktop test

ENDDO WHILE NOT EMPTY(WPARENT(m.woutput))
** Parent window loop

RETURN m.woutput

*****************
FUNCTION BldPopup
*****************

PARAMETER woutput

DEFINE POPUP _windpop IN WINDOW (m.woutput) MARGIN RELATIVE SHADOW COLOR SCHEME 4
DEFINE BAR 1 OF _windpop PROMPT "Next" MESSAGE [Go to the next record.] 
DEFINE BAR 2 OF _windpop PROMPT "Previous" MESSAGE [Go to the previous record.]
DEFINE BAR 3 OF _windpop PROMPT "Top" MESSAGE [Go to the top of the file.]
DEFINE BAR 4 OF _windpop PROMPT "Bottom" MESSAGE [Go to the bottom of the file.]
DEFINE BAR 5 OF _windpop PROMPT "\-"
DEFINE BAR 6 OF _windpop PROMPT "Add" MESSAGE [Add a record.]
DEFINE BAR 7 OF _windpop PROMPT "Edit" MESSAGE [Edit a record.]
DEFINE BAR 8 OF _windpop PROMPT "Save" MESSAGE [Save this record.]
DEFINE BAR 9 OF _windpop PROMPT "Cancel" MESSAGE [Cancel editing this record.]
DEFINE BAR 10 OF _windpop PROMPT "Find" MESSAGE [Find a specific record.]
DEFINE BAR 11 OF _windpop PROMPT "Close" MESSAGE [Close this window.]
ON SELECTION BAR 1 OF _windpop DO Pop_Action WITH [Next]
ON SELECTION BAR 2 OF _windpop DO Pop_Action WITH [Previous]
ON SELECTION BAR 3 OF _windpop DO Pop_Action WITH [Top]
ON SELECTION BAR 4 OF _windpop DO Pop_Action WITH [Bottom]
ON SELECTION BAR 6 OF _windpop DO Pop_Action WITH [Add]
ON SELECTION BAR 7 OF _windpop DO Pop_Action WITH [Edit]
ON SELECTION BAR 8 OF _windpop DO Pop_Action WITH [Save]
ON SELECTION BAR 9 OF _windpop DO Pop_Action WITH [Cancel]
ON SELECTION BAR 10 OF _windpop DO Pop_Action WITH [Find]
ON SELECTION BAR 11 OF _windpop DO Pop_Action WITH [Close]

RETURN

*****************
FUNCTION Clkhandl
*****************

PARAMETER window

PRIVATE window, mrow, mcol, sfont_name, sfont_size, sfont_styl, wfont_name, wfont_size, wfont_styl

m.mrow = MROW(m.window)
m.mcol = MCOL(m.window)

** Platform test
IF _windows OR _mac

  m.sfont_name = WFONT(1, [])
  m.sfont_size = WFONT(2, [])
  m.sfont_styl = WFONT(3, [])
  m.wfont_name = WFONT(1, m.window)
  m.wfont_size = WFONT(2, m.window)
  m.wfont_styl = WFONT(3, m.window)
  MODIFY WINDOW SCREEN FONT (m.wfont_name), (m.wfont_size) STYLE (m.wfont_styl)
  
ENDIF _windows OR _mac
** End platform test

MOVE POPUP _windpop TO m.mrow, m.mcol
ACTIVATE POPUP _windpop

** Platform test
IF _windows OR _mac

  MODIFY WINDOW SCREEN FONT (m.sfont_name), (m.sfont_size) STYLE (m.sfont_styl)
  
ENDIF _windows OR _mac
** End platform test

RETURN

********************
PROCEDURE Pop_Action
********************

PARAMETER paction

HIDE POPUP _windpop

** Selected an option test
IF BAR() # 0

  WAIT [You selected ] + m.paction + [.] WINDOW NOWAIT
   
ENDIF BAR() # 0
** End selected an option test

DEACTIVATE POPUP _windpop

RETURN

* EOF: DEMO.PRG
