***************************************************************************
*
* Procedure file: CLICKSCR.PRG
*        Version: 1.0
*         Author: Bill Anderson
*        CIS ID#: 72712,3417
*      Copyright: None (Public Domain)
*
***************************************************************************
*
* CLICKSCR - Traps for left (main) mouse click on a screen
*
* Description:
* This program is used to capture a click in the screen without affecting
* any other GETs on the screen.
* 
*
*                  * * *  DECLARED MEMORY VARIABLES  * * *
*
*            m.c_no3d     = memory variable used to hold the directive
*                           for the no 3D statement in the 
*                           box's comment field.
*            m.c_clickscr = memory variable used to hold the 
*                           directive for the click screen
*                           in the setup code snippet.
*            m.c_clickprg = memory variable used to hold the directive
*                           name of the program to be run when the
*                           screen is clicked.
*            m.m_clickscr = memory variable used to hold the processed
*                           directive for the click screen
*                           in the setup code snippet.
*            m.m_clickprg = memory variable used to hold the processed 
*                           directive name of the program to be run 
*                           when the screen is clicked.
*            m.clickscr   = memory variable used to hold the position
*                           of the driver name.
*            m.clickprg   = memory variable used to hold the
*                           name of the program to be run when the
*                           screen is clicked.
*            m.oldfilt    = memory variable used to hold the previous
*                           SET FILTER setting.
*            m.proc_name  = memory variable used to hold a procedure name.
*            m.g_platform = memory variable used as a logical variable
*                           to indicate if we are compiling for a 
*                           graphical operating environment.
*            m.hdr_rec    = memory variable used to hold the record number
*                           for the header record.
*
*
**************************
* Version 1.0 - 11/13/95
**************************
*
* First attempt to build a driver.
*

EXTERNAL ARRAY a_scxupd

PRIVATE c_no3d, c_clickscr, c_clickprg, m_clickscr, m_clickprg, ;
clickscr, clickprg, oldfilt, proc_name, g_platform, hdr_rec

** Not at header record and driver turned off test
IF SCXDATA.Objtype # 1 .OR. NOT Drvenable(PROGRAM())

  GOTO BOTTOM IN SCXDATA
  RETURN .f.

ENDIF SCXDATA.Objtype # 1 .OR. NOT Drvenable(PROGRAM())
** End not at header record and driver turned off test

** Versioning test
IF TYPE([m.gsxversion]) # [C] .OR. LEFT(m.gsxversion, 4) < [1.7a]

  GOTO BOTTOM
  = Warning([Clickscr driver requires GENSCNRX 1.7a or later])
  RETURN .f.

ENDIF TYPE([m.gsxversion]) # [C] .OR. LEFT(m.gsxversion, 4) < [1.7a]
** End versioning test

** Inappropriate driver call position test
IF m.drv_no # 5

  GOTO BOTTOM IN SCXDATA
  = Warning([Clickscr driver requires *:SCXDRV5])
  RETURN .f.

ENDIF m.drv_no # 5
** End inappropriate driver call position test

m.c_clickscr = [*:SCXDRV5 CLICKSCR]
m.c_clickprg = [*:CLICKPRG]
m.m_clickscr = [*-:SCXDRV5 CLICKSCR]
m.m_clickprg = [*-:CLICKPRG]
m.c_no3d = [*:NO3D]
m.oldfilt = FILTER()
STORE [] TO m.clickscr, m.clickprg 
m.g_platform = INLIST(m.platform_, [WINDOWS], [MAC])
m.hdr_rec = 0

** Platform setting test
IF TYPE([SCXDATA.Platform]) = [C]

  SET FILTER TO PLATFORM == m.platform_

ELSE

  SET FILTER TO

ENDIF TYPE([SCXDATA.Platform]) = [C]
** End platform setting test

** Get header record loop
SCAN FOR NOT DELETED([SCXDATA])

  ** Get header record test
  IF SCXDATA.Objtype = 1

    m.clickscr = Wordsearch(m.c_clickscr, .t.)
    m.clickprg = Wordsearch(m.c_clickprg, .t.)
    m.hdr_rec = RECNO([SCXDATA])
    GOTO BOTTOM IN SCXDATA
    EXIT

  ENDIF SCXDATA.Objtype = 1
  ** End processing record test

ENDSCAN FOR NOT DELETED([SCXDATA])
** End get header record loop

** Didn't find a header record or driver test
IF m.hdr_rec = 0 .OR. m.clickscr == m.null

  RETURN .f.

ENDIF m.hdr_rec = 0 .OR. m.clickscr == m.null
** End didn't find a header record or driver test

** Inserted record test
IF InsBlank()

  m.proc_name = SYS(2015)

  ** Graphical environment test
  IF m.g_platform
  
    REPLACE SCXDATA.Vpos WITH 0.000, SCXDATA.Hpos WITH 0.000, ;
    SCXDATA.Height WITH m.height, SCXDATA.Width WITH m.width, ;
    SCXDATA.Objtype WITH 7, SCXDATA.Objcode WITH 4, ;
    SCXDATA.Style WITH 0, SCXDATA.Boxchar WITH [ ], ;
    SCXDATA.Fillchar WITH [ ], SCXDATA.Mode WITH 1, ;
    SCXDATA.Penred WITH m.fillred, SCXDATA.Pengreen WITH m.fillgreen, ;
    SCXDATA.Penblue WITH m.fillblue, SCXDATA.Fillred WITH m.fillred, ;
    SCXDATA.Fillgreen WITH m.fillgreen, SCXDATA.Fillblue WITH m.fillblue, ;
    SCXDATA.Pensize WITH 1, SCXDATA.Penpat WITH 8, ;
    SCXDATA.Fillpat WITH 0, SCXDATA.Comment WITH ;
    IIF(Wordsearch(m.c_no3d, .f.) = m.null, m.c_no3d + m.cr_lf, []) + ;
    [*:CLICK ] + IIF(m.clickprg # m.null .AND. NOT EMPTY(m.clickprg), ;
    m.clickprg, m.proc_name + m.cr_lf + [*:FUNCTION ] + m.proc_name + ;
    m.cr_lf + [?? CHR(7)] + m.cr_lf + ;
    [WAIT "Clicked the screen!" WINDOW NOWAIT] + m.cr_lf + [*:ENDFNCT])    

  ELSE && DOS or UNIX    

    REPLACE SCXDATA.Vpos WITH 0.000, SCXDATA.Hpos WITH 0.000, ;
    SCXDATA.Height WITH m.height - 2, SCXDATA.Width WITH m.width - 2, ;
    SCXDATA.Objtype WITH 7, SCXDATA.Objcode WITH 4, ;
    SCXDATA.Style WITH 0, SCXDATA.Boxchar WITH CHR(219), ;
    SCXDATA.Fillchar WITH m.null, ;
    SCXDATA.Colorpair WITH SUBSTR(SCHEME(m.scheme, 3), AT([/], ;
    SCHEME(m.scheme, 3)) + 1) + [/] + SUBSTR(SCHEME(m.scheme, 3), ;
    AT([/], SCHEME(m.scheme, 3)) + 1), ;
    SCXDATA.Comment WITH IIF(Wordsearch(m.c_no3d, .f.) = m.null, ;
    m.c_no3d + m.cr_lf, []) + [*:CLICK ] + IIF(m.clickprg # m.null .AND. ;
    NOT EMPTY(m.clickprg), m.clickprg, m.proc_name + m.cr_lf + ;
    [*:FUNCTION ] + m.proc_name + m.cr_lf + [?? CHR(7)] + m.cr_lf + ;
    [WAIT "Clicked the screen!" WINDOW NOWAIT] + m.cr_lf + [*:ENDFNCT])

  ENDIF m.g_platform
  ** End graphical environment test
  
  GOTO m.hdr_rec IN SCXDATA
  REPLACE SCXDATA.Setupcode WITH ;
  Strtranc(SCXDATA.Setupcode, m.c_clickscr, m.m_clickscr), ;
  SCXDATA.Setupcode WITH ;
  Strtranc(SCXDATA.Setupcode, m.c_clickprg, m.m_clickprg)
  m.setupcode = Strtranc(m.setupcode, m.c_clickscr, m.m_clickscr)
  m.setupcode = Strtranc(m.setupcode, m.c_clickprg, m.m_clickprg)
  a_scxupd(m.scxcount) = [*]
  
ELSE

  RETURN .f.

ENDIF InsBlank()
** End inserted record test

SET FILTER TO &oldfilt
GOTO BOTTOM IN SCXDATA

RETURN .t.

* EOF: CLICKSCR.PRG
