  * Created by George L. Dvorak   CIS 70403,732
  * This program creates a class listing hierarchy that lets one
  * visually follow the subclassing in a project.

  * This program reads a project file and extracts a list of class libraries
  *   and program files by inspecting memo field Name of the project file for the
  *   string ".vcx" or ".prg" and then extracts class definitions from these files.
  * The class information is extracted from a class library by:
  * filtering NOT EMPTY(objname) AND NOT EMPTY(baseclass) AND EMPTY(parent)
  * the class is objname
  * the parent class is class
  * the parent classes file is classloc
  * the base class is baseclass
  * the class location is this VCX file

  * I hope this helps you to understand the derivation of classes in examples
  *   and books that you are studying.  Let me know about problems and successes.

  CLOSE ALL
  SET DELETED ON

  * The front end is all hard-coded to my directory.
  * I hope someone will put a pretty face on this.
  cProject = GETFILE("PJX", "Select Project File", "OK", 0)
  IF EMPTY(cProject)
    RETURN
  ENDIF
  IF ! FILE(cProject)
    ?? CHR(9)
    WAIT WINDOW cProject+" does not exist!"
    RETURN
  ENDIF
  cOutput  = GETFILE("TXT; TRE", "Select Output File", "OK", 1)
  IF EMPTY(cOutput)
    RETURN
  ENDIF
  nClassLib = 0
  * Pull the classes from CD.PJX.
  WAIT WINDOW NOWAIT "Extracting class libraries and programs from project."
  USE (cProject)
  SCAN FOR ".VCX"$UPPER(name)
    nClassLib = nClassLib +1
    DIMENSION aClassLib[nClassLib]
    * Remove garbage that follows the class file name.
    aClassLib[nClassLib] = FULLPATH(LEFT(name, ATC(".vcx", name) +3))
  ENDSCAN

  SCAN FOR ".PRG"$UPPER(name)
    nClassLib = nClassLib +1
    DIMENSION aClassLib[nClassLib]
    * Remove garbage that follows the class file name.
    aClassLib[nClassLib] = FULLPATH(LEFT(name, ATC(".prg", name) +3))
  ENDSCAN

  WAIT CLEAR
  WAIT WINDOW NOWAIT "Creating temporary file of classes."

  * Create a cursor for the temporary file.
  CREATE CURSOR ClassTmp ;
     (baseclass C(40),;
      parent    C(40),;
      parentlib C(80),;
      class     C(40),;
      classlib  C(80),;
      processed L(1))

  * Fill the temporary file with classes from the class libraries.
  * I am saving the parent class library location because I have a hunch
  * that there could be a problem with like named classes from another library.
  * Although I do not check for that on the output end.
  nCurrClass = 1
  DO WHILE TYPE("aClassLib[nCurrClass]")<>"U"
    DO CASE
    CASE ".VCX"$UPPER(aClassLib[nCurrClass])
      DO ExtractV
    CASE ".PRG"$UPPER(aClassLib[nCurrClass])
      DO ExtractP
    ENDCASE
    nCurrClass = nCurrClass +1
  ENDDO
  WAIT CLEAR
  WAIT WINDOW NOWAIT "Indexing temporary class file."

  * Finished with extracting the classes, now index.
  SELECT ClassTmp
  INDEX ON UPPER(class) TAG Class
  INDEX ON baseclass+parentlib+parent+class TAG ClassOrder
  WAIT CLEAR
  WAIT WINDOW NOWAIT "Determining baseclass for classes found in program files."

  * Resolve the BaseClasses for the classes found in PRG files.
  * Order ClassOrder will put those classes without a baseclass at the beginning of the file.
  DO WHILE EMPTY(baseclass) AND ! EOF()
    nRecno = RECNO()
    cNewParent =parent
    DO WHILE ! EMPTY(cNewParent)
      cParent = cNewParent
      cNewParent = GetParent(parent)
    ENDDO
    GOTO nRecno
    REPLACE baseclass with lower(cParent)
    GO TOP
  ENDDO
  WAIT CLEAR
  WAIT WINDOW NOWAIT "Writing CDBKCLSS.TRE."

  * This is also hard-coded, should ask up front where the output is to be placed.
  nHandle = FCREATE(cOutput)
  IF nHandle<=0
    WAIT WINDOW "Invalid handle."
    SUSPEND
  ENDIF

  *This creates the hierarchy.
  cBaseClass = "~"
  SCAN FOR NOT processed
    IF cBaseClass<>ClassTmp.baseclass
      * A new base class.
      nIndent = 0
      = FPUTS(nHandle,"")
      = FPUTS(nHandle, SPACE(nIndent *4)+ClassTmp.baseclass)
      nIndent = nIndent +1
      cParentClass = ClassTmp.parent
    ENDIF
    REPLACE processed WITH .t.
    = FPUTS(nHandle, ;
        LEFT(SPACE(nIndent *4)+ClassTmp.class+SPACE(46), 46)+LOWER(SUBSTR(ClassTmp.classlib, 4)))
    cCurrentClass = ClassTmp.class
    nRecno = RECNO("ClassTmp")
    = SubClasses(ClassTmp.class, ClassTmp.baseclass, nIndent)
    GOTO nRecno
    cBaseClass = ClassTmp.baseclass
  ENDSCAN
  = FCLOSE(nHandle)
  WAIT CLEAR
  CLOSE DATA
  ?? CHR(9)
  ? "Finished!"
* end of Classes


PROCEDURE ExtractP
  nHandle = FOPEN(aClassLib[nCurrClass])
  IF nHandle<=0
    WAIT WINDOW aClassLib[nCurrClass]+" was not opened!"
  ENDIF
  DO WHILE NOT FEOF(nHandle)
    cPrgLine = FGETS(nHandle)
    IF ! "DEFINE CLASS"$UPPER(cPrgLine)
      LOOP
    ENDIF
    nDefClass = AT("DEFINE CLASS ", UPPER(cPrgLine))
    nAs = AT(" AS ", UPPER(cPrgLine))
    cBaseClass = SUBSTR(cPrgLine, nDefClass +13, nAs -nDefClass -13)
    cParent = SUBSTR(cPrgLine, nAs +4)
    INSERT INTO ClassTmp ;
       (baseclass, parent, parentlib, class, classlib, processed) ;
       VALUES ("", cParent, "", cBaseClass, aClassLib[nCurrClass], .F.)
  ENDDO
  nResult = FCLOSE(nHandle)
* end of ExtractP


PROCEDURE ExtractV
  SELECT 0
  USE (aClassLib[nCurrClass]) ALIAS CurrClass
  SCAN FOR NOT EMPTY(objname) ;
      AND NOT EMPTY(baseclass) ;
      AND EMPTY(parent)
    IF EMPTY(CurrClass.classloc)
      * Parent is a base class.
      cParentLoc = ""
    ELSE
      * Get the full path of the path to the current class file plus the path to the new class file.
      cParentLoc = FULLPATH(LEFT(aClassLib[nCurrClass], RAT("\", aClassLib[nCurrClass]));
          +CurrClass.classloc)
    ENDIF
    IF NOT EMPTY(CurrClass.classloc) AND ASCAN(aClassLib, cParentLoc) = 0
      * A reference to a class that was not in the project.
      nClassLib = nClassLib +1
      DIMENSION aClassLib[nClassLib]
      aClassLib[nClassLib] = cParentLoc
    ENDIF
    INSERT INTO ClassTmp ;
       (baseclass, parent, parentlib, class, classlib, processed) ;
       VALUES (CurrClass.baseclass, CurrClass.class, cParentLoc, CurrClass.objname, ;
           aClassLib[nCurrClass], .F.)
  ENDSCAN
  SELECT CurrClass
  USE
* end of ExtractV


PROCEDURE GetParent
  PARAMETERS cParent
  LOCATE FOR UPPER(class)=UPPER(cParent)
  IF FOUND()
    RETURN parent
  ELSE
    RETURN ""
  ENDIF
* end of GetParent


PROCEDURE SubClasses(cClassName, cBaseClass, nIndent)
  * This routine calls itself as the classes are subclassed.
  LOCATE FOR ClassTmp.parent=cClassName ;
      AND ClassTmp.baseclass=cBaseClass ;
      AND NOT ClassTmp.processed
  LOCAL nRecno
  nIndent = nIndent +1
  DO WHILE FOUND()
    nRecno = RECNO("ClassTmp")
    REPLACE processed WITH .t.
  = FPUTS(nHandle, ;
      LEFT(SPACE(nIndent *4)+ClassTmp.class+SPACE(46), 46)+LOWER(SUBSTR(ClassTmp.classlib, 4)))
    = SubClasses(ClassTmp.class, ClassTmp.baseclass, nIndent)
    GO nRecno
    CONTINUE
  ENDDO
* end of SubClasses
* EOF: CLASSES.PRG