* Skeleton of a program to extract VCX files from a project
*   by inspecting memo field Name of the project file for the
*   string ".vcx" and storing the file names and locations
* or to be given the names of VCX files.
* Then to extract the class by:
*	filtering NOT EMPTY(objname) AND NOT EMPTY(baseclass) AND EMPTY(parent)
*	the class        is objname
*	the parent class is class
*	the parent classes file is classloc
*	the base class is baseclass
*	the class location is this VCX file

CLOSE ALL

SET DEFAULT TO k:\cdbk30\cd
nClassLib = 0
* Pull the classes from CD.PJX.
USE cd.pjx
SCAN FOR ".VCX"$UPPER(name)
  nClassLib = nClassLib +1
  DIMENSION aClassLib[nClassLib]
  * Remove garbage that follows the class file name.
  aClassLib[nClassLib] = FULLPATH(LEFT(name, ATC(".vcx", name) +3))
ENDSCAN

* Now pick up from builderb,custctl, supercls, wrappers, qstart, tools, and flashstd
cLoc = UPPER("K:\cdbk30\common30\utils\builderb.vcx")
IF ASCAN(aClassLib, cLoc) = 0
  nClassLib = nClassLib +1
  DIMENSION aClassLib[nClassLib]
  aClassLib[nClassLib] = cLoc
ENDIF
cLoc = UPPER("K:\cdbk30\common30\libs\ccustctl.vcx")
IF ASCAN(aClassLib, cLoc) = 0
  nClassLib = nClassLib +1
  DIMENSION aClassLib[nClassLib]
  aClassLib[nClassLib] = cLoc
ENDIF
cLoc = UPPER("K:\cdbk30\common30\utils\supercls.vcx")
IF ASCAN(aClassLib, cLoc) = 0
  nClassLib = nClassLib +1
  DIMENSION aClassLib[nClassLib]
  aClassLib[nClassLib] = cLoc
ENDIF
cLoc = UPPER("K:\cdbk30\common30\utils\wrappers.vcx")
IF ASCAN(aClassLib, cLoc) = 0
  nClassLib = nClassLib +1
  DIMENSION aClassLib[nClassLib]
  aClassLib[nClassLib] = cLoc
ENDIF
cLoc = UPPER("K:\cdbk30\common30\utils\menubldr.vcx")
IF ASCAN(aClassLib, cLoc) = 0
  nClassLib = nClassLib +1
  DIMENSION aClassLib[nClassLib]
  aClassLib[nClassLib] = cLoc
ENDIF
cLoc = UPPER("K:\cdbk30\common30\utils\qstart\libs\forms.vcx")
IF ASCAN(aClassLib, cLoc) = 0
  nClassLib = nClassLib +1
  DIMENSION aClassLib[nClassLib]
  aClassLib[nClassLib] = cLoc
ENDIF
cLoc = UPPER("K:\cdbk30\common30\utils\flashstd\libs\tools.vcx")
IF ASCAN(aClassLib, cLoc) = 0
  nClassLib = nClassLib +1
  DIMENSION aClassLib[nClassLib]
  aClassLib[nClassLib] = cLoc
ENDIF
cLoc = UPPER("K:\cdbk30\common30\utils\flashstd\libs\flashstd.vcx")
IF ASCAN(aClassLib, cLoc) = 0
  nClassLib = nClassLib +1
  DIMENSION aClassLib[nClassLib]
  aClassLib[nClassLib] = cLoc
ENDIF

CREATE CURSOR ClassTmp ;
   (baseclass C(40),;
    parent    C(40),;
    parentlib C(80),;
    class     C(40),;
    classlib  C(80),;
    processed L(1))

nCurrClass = 1
DO WHILE TYPE("aClassLib[nCurrClass]")<>"U"
  SELECT 0
  USE (aClassLib[nCurrClass]) ALIAS CurrClass
  SCAN FOR NOT EMPTY(objname) ;
      AND NOT EMPTY(baseclass) ;
      AND EMPTY(parent)
    IF EMPTY(CurrClass.classloc)
      * Parent is a base class.
      cParentLoc = ""
    ELSE  
      * Get the full path of the path to the current class file plus the path to the new class file.
      cParentLoc = FULLPATH(LEFT(aClassLib[nCurrClass], RAT("\", aClassLib[nCurrClass]));
          +CurrClass.classloc)  
    ENDIF
    IF NOT EMPTY(CurrClass.classloc) AND ASCAN(aClassLib, cParentLoc) = 0
      * A reference to a class that was not in the project.
      nClassLib = nClassLib +1
      DIMENSION aClassLib[nClassLib]
      aClassLib[nClassLib] = cParentLoc
    ENDIF
    INSERT INTO ClassTmp ;
       (baseclass, parent, parentlib, class, classlib, processed) ;
       VALUES (CurrClass.baseclass, CurrClass.class, cParentLoc, CurrClass.objname, ;
           aClassLib[nCurrClass], .F.)
  ENDSCAN
  SELECT CurrClass
  USE
  nCurrClass = nCurrClass +1
ENDDO

SELECT ClassTmp
INDEX ON baseclass FOR baseclass = parent TAG BaseOrder
INDEX ON baseclass+parentlib+parent+class TAG ClassOrder
CLEAR

nHandle = FCREATE("K:\CDBK30\CDBKCLSS.TRE")
IF nHandle<=0
  WAIT WINDOW "Invalid handle."
  SUSPEND
ENDIF

cBaseClass = "~"
SCAN FOR NOT processed
  IF cBaseClass<>ClassTmp.baseclass
    * A new base class.
    nIndent = 0
    = FPUTS(nHandle,"")
    = FPUTS(nHandle, SPACE(nIndent *4)+ClassTmp.baseclass)
    nIndent = nIndent +1
    cParentClass = ClassTmp.parent
  ENDIF
  REPLACE processed WITH .t.
  = FPUTS(nHandle, ;
      LEFT(SPACE(nIndent *4)+ClassTmp.class+SPACE(46), 46)+LOWER(SUBSTR(ClassTmp.classlib, 4)))
  cCurrentClass = ClassTmp.class
  nRecno = RECNO("ClassTmp")
  = SubClasses(ClassTmp.class, ClassTmp.baseclass, nIndent)
  GOTO nRecno
  cBaseClass = ClassTmp.baseclass
ENDSCAN
= FCLOSE(nHandle)


PROCEDURE SubClasses(cClassName, cBaseClass, nIndent)
  LOCATE FOR ClassTmp.parent=cClassName ;
      AND ClassTmp.baseclass=cBaseClass ;
      AND NOT ClassTmp.processed
  LOCAL nRecno
  nIndent = nIndent +1
  DO WHILE FOUND()
    nRecno = RECNO("ClassTmp")
    REPLACE processed WITH .t.
  = FPUTS(nHandle, ;
      LEFT(SPACE(nIndent *4)+ClassTmp.class+SPACE(46), 46)+LOWER(SUBSTR(ClassTmp.classlib, 4)))
    = SubClasses(ClassTmp.class, ClassTmp.baseclass, nIndent)
    GO nRecno
    CONTINUE
  ENDDO
