*:*********************************************************************
*:
*:        Program: CHGDATEF.PRG
*:
*:         System: Change Date
*:         Author: Terry Blankenship
*:  Last modified: 11/11/91     14:51
*:
*:  Procs & Fncts: INITCD
*:               : CHGDATE()
*:               : DATEOFF()
*:               : KEYDATE
*:               : UPDAY
*:               : DNDAY
*:               : UPMONTH
*:               : DNMONTH
*:               : UPYEAR
*:               : DNYEAR
*:               : THISDAY
*:               : FIRSTYR
*:               : LASTYR
*:               : FIRSTMO
*:               : LASTMO
*:
*:      Documented 11/11/91 at 14:51                SNAP!  version 4.02i
*:*********************************************************************
*----------------------------------------------------------------------
*)- Programmer..: Terry Blankenship
*)                Blankenship Resources
*)                1821 Westlake Dr. Suite #123
*)                Austin, Texas   78746
*)                (512) 327-3718 Voice/Fax
*)                ATBBS - Killshot
*)                PRODIGY BCFW31A
*)
*)- Date........: 11/11/1991
*)- Notes.......: Used to modify @ GET date fields with following keys:
*)
*)                +    - Increment date 1 day
*)                =    - Increment date 1 day
*)                -    - Decrement date 1 day
*)                [    - Decrement date 1 month
*)                ]    - Increment date 1 month
*)                '    - Increment date 1 year
*)                ;    - Decrement date 1 year
*)                T    - Today
*)                M    - First day of Month
*)                H    - Last day of montH
*)                Y    - First day of Year
*)                R    - Last day of yeaR
*)
*)                Uses KEYBOARD & ON KEY LABEL commands
*)
*)- Prg Note....:  Program the following Public variables:
*)
*)                  cTalkCd, cConfCd, cFldCd, dDateCd, nDateCd
*)                              - or -
*)                do InitCd to initialize Public Variables.
*)
*)- Written for.: dBASE IV  1.1
*)- Rev. History: 11/10/1991 0.1 - Original version CHGDATEF.PRG
*)
*)- Usage.......: get <dArg> when ChgDate() valid required DateOff()
*)- Example.....: @ 10, 10 say "Enter Date : " get dDate;
*)                  when ChgDate() valid required DateOff()
*)
*)- Returns.....: dArg is Changed and KEYBOARDed into the date field
*)- Parameters..: none
*)---------------------------------------------------------------------

*!*********************************************************************
*!
*!      Procedure: INITCD
*!
*!*********************************************************************
PROCEDURE InitCd
public cTalkCd, cConfCd, cFldCd, dDateCd, nDateCd
RETURN
***EOP InitCd***

*!*********************************************************************
*!
*!       Function: CHGDATE()
*!
*!          Calls: UPDAY          (PROCEDURE in CHGDATEF.PRG)
*!               : DNDAY          (PROCEDURE in CHGDATEF.PRG)
*!               : UPMONTH        (PROCEDURE in CHGDATEF.PRG)
*!               : DNMONTH        (PROCEDURE in CHGDATEF.PRG)
*!               : UPYEAR         (PROCEDURE in CHGDATEF.PRG)
*!               : DNYEAR         (PROCEDURE in CHGDATEF.PRG)
*!               : THISDAY        (PROCEDURE in CHGDATEF.PRG)
*!               : FIRSTMO        (PROCEDURE in CHGDATEF.PRG)
*!               : LASTMO         (PROCEDURE in CHGDATEF.PRG)
*!               : FIRSTYR        (PROCEDURE in CHGDATEF.PRG)
*!               : LASTYR         (PROCEDURE in CHGDATEF.PRG)
*!
*!*********************************************************************
FUNCTION ChgDate
*----------------------------------------------------------------------
*
*  Sets variables and ON KEY LABEL Keys
*  Sets Talk & Confirm Status
*
*----------------------------------------------------------------------

*--- Talk should be off. Status saved for reset for DateOff()
if set('TALK') = "ON"
  cTalkCd = "ON"
  set talk off
else
  cTalkCd = "OFF"
endif

*--- Confirm needs to be on to prevent cursor advancing to next field
*--- and status saved for reset for DateOff()
cConfCd = set('CONFIRM')
set confirm on

*--- Length of Date field 6 or 8 based on CENTURY Status
nDateCd = iif(set('CENT')="ON",8,6)

*--- Get name of Date Field
cFldCd = varread()

*--- Get initial value of Date Field
dDateCd = &cFldCd

*-- Initialize the Date Change keys
on key label + do UpDay
on key label = do UpDay
on key label - do DnDay
on key label ] do UpMonth
on key label [ do DnMonth
on key label ' do UpYear
on key label ; do DnYear
on key label T do ThisDay
on key label M do FirstMo
on key label H do LastMo
on key label Y do FirstYr
on key label R do LastYr
RETURN .t.
***EOF ChgDate***

*!*********************************************************************
*!
*!       Function: DATEOFF()
*!
*!*********************************************************************
FUNCTION DateOff
*----------------------------------------------------------------------
*
*  Releases ON KEY LABEL Keys
*  Resets Talk & Confirm Status
*
*----------------------------------------------------------------------
*-- Turn Off special keys
on key label +
on key label =
on key label -
on key label ]
on key label [
on key label '
on key label ;;
&& This line needs this comment or should be blank to assign ; to Label
on key label T
on key label M
on key label h
on key label Y
on key label r

set confirm &cConfCd
set talk &cTalkCd
RETURN .t.
***EOF DateOff***

*!*********************************************************************
*!
*!      Procedure: KEYDATE
*!
*!      Called by: UPDAY          (PROCEDURE in CHGDATEF.PRG)
*!               : DNDAY          (PROCEDURE in CHGDATEF.PRG)
*!               : UPMONTH        (PROCEDURE in CHGDATEF.PRG)
*!               : DNMONTH        (PROCEDURE in CHGDATEF.PRG)
*!               : UPYEAR         (PROCEDURE in CHGDATEF.PRG)
*!               : DNYEAR         (PROCEDURE in CHGDATEF.PRG)
*!               : THISDAY        (PROCEDURE in CHGDATEF.PRG)
*!               : FIRSTYR        (PROCEDURE in CHGDATEF.PRG)
*!               : LASTYR         (PROCEDURE in CHGDATEF.PRG)
*!               : FIRSTMO        (PROCEDURE in CHGDATEF.PRG)
*!               : LASTMO         (PROCEDURE in CHGDATEF.PRG)
*!
*!*********************************************************************
PROCEDURE KeyDate
*----------------------------------------------------------------------
*
*  Parses the dDateCd variable and KEYBOARDs value into Date Field
*  Retruns cursor to beginning of Date Field
*
*----------------------------------------------------------------------
*--- Need to advance cursor and reset it to the beginning of Date Field
*    before KEYBOARDing Date value.  The cursor needs to be advanced
*    to protect CHR(1) Ctrl-A from moving cursor to previous field.
*
keyboard "/" + chr(1)

*--- Key in new date characters
keyboard substr(dtos(dDateCd),5,4)+substr(dtos(dDateCd),;
  9-nDateCd,nDateCd-4)

*--- Reset cursor to beginning of field
keyboard chr(1)
RETURN

*----------------------------------------------------------------------
*
*  The remaining PROCEDUREs change the date depending on the special
*  Key pressed.
*
*----------------------------------------------------------------------
*!*********************************************************************
*!
*!      Procedure: UPDAY
*!
*!      Called by: CHGDATE()      (FUNCTION  in CHGDATEF.PRG)
*!
*!          Calls: KEYDATE        (PROCEDURE in CHGDATEF.PRG)
*!
*!*********************************************************************
PROCEDURE UpDay
dDateCd = dDateCd + 1
do KeyDate
RETURN

*!*********************************************************************
*!
*!      Procedure: DNDAY
*!
*!      Called by: CHGDATE()      (FUNCTION  in CHGDATEF.PRG)
*!
*!          Calls: KEYDATE        (PROCEDURE in CHGDATEF.PRG)
*!
*!*********************************************************************
PROCEDURE DnDay                    && Decrement date 1 day
dDateCd = dDateCd - 1
do KeyDate
RETURN
***EOP DnDay***

*!*********************************************************************
*!
*!      Procedure: UPMONTH
*!
*!      Called by: CHGDATE()      (FUNCTION  in CHGDATEF.PRG)
*!
*!          Calls: KEYDATE        (PROCEDURE in CHGDATEF.PRG)
*!
*!*********************************************************************
PROCEDURE UpMonth                  && Increment date 1 month
dDateCd = ctod(ltrim(str(month(dDateCd)+1))+;
  right(dtoc(dDateCd),nDateCd))
do KeyDate
RETURN
***EOP UpMonth***

*!*********************************************************************
*!
*!      Procedure: DNMONTH
*!
*!      Called by: CHGDATE()      (FUNCTION  in CHGDATEF.PRG)
*!
*!          Calls: KEYDATE        (PROCEDURE in CHGDATEF.PRG)
*!
*!*********************************************************************
PROCEDURE DnMonth                  && Decrement date 1 month
dDateCd = ctod(ltrim(str(month(dDateCd)-1));
  +right(dtoc(dDateCd),nDateCd))
do KeyDate
RETURN
***EOP DnMonth***

*!*********************************************************************
*!
*!      Procedure: UPYEAR
*!
*!      Called by: CHGDATE()      (FUNCTION  in CHGDATEF.PRG)
*!
*!          Calls: KEYDATE        (PROCEDURE in CHGDATEF.PRG)
*!
*!*********************************************************************
PROCEDURE UpYear                   && Increment date 1 year
dDateCd = ctod(left(dtoc(dDateCd),6)+;
  right(str(year(dDateCd)+1),nDateCd-4))
do KeyDate
RETURN
***EOP UpYear***

*!*********************************************************************
*!
*!      Procedure: DNYEAR
*!
*!      Called by: CHGDATE()      (FUNCTION  in CHGDATEF.PRG)
*!
*!          Calls: KEYDATE        (PROCEDURE in CHGDATEF.PRG)
*!
*!*********************************************************************
PROCEDURE DnYear                   && Decrement date 1 year
dDateCd = ctod(left(dtoc(dDateCd),6)+;
  right(str(year(dDateCd)-1),nDateCd-4))
do KeyDate
RETURN
***EOP DnYear***

*!*********************************************************************
*!
*!      Procedure: THISDAY
*!
*!      Called by: CHGDATE()      (FUNCTION  in CHGDATEF.PRG)
*!
*!          Calls: KEYDATE        (PROCEDURE in CHGDATEF.PRG)
*!
*!*********************************************************************
PROCEDURE ThisDay                  && Use todays date
dDateCd = date()
do KeyDate
RETURN
***EOP ThisDay***

*!*********************************************************************
*!
*!      Procedure: FIRSTYR
*!
*!      Called by: CHGDATE()      (FUNCTION  in CHGDATEF.PRG)
*!
*!          Calls: KEYDATE        (PROCEDURE in CHGDATEF.PRG)
*!
*!*********************************************************************
PROCEDURE FirstYr                  && First of Year
dDateCd = ctod('01/01/'+right(str(year(dDateCd)),nDateCd-4))
do KeyDate
RETURN
***EOP FirstYr***

*!*********************************************************************
*!
*!      Procedure: LASTYR
*!
*!      Called by: CHGDATE()      (FUNCTION  in CHGDATEF.PRG)
*!
*!          Calls: KEYDATE        (PROCEDURE in CHGDATEF.PRG)
*!
*!*********************************************************************
PROCEDURE LastYr                  && Last of Year
dDateCd = ctod('12/31/'+right(str(year(dDateCd)),nDateCd-4))
do KeyDate
RETURN
***EOP LastYr***

*!*********************************************************************
*!
*!      Procedure: FIRSTMO
*!
*!      Called by: CHGDATE()      (FUNCTION  in CHGDATEF.PRG)
*!
*!          Calls: KEYDATE        (PROCEDURE in CHGDATEF.PRG)
*!
*!*********************************************************************
PROCEDURE FirstMo                  && First of Month
dDateCd = ctod(str(month(dDateCd))+'/01/'+;
  right(str(year(dDateCd)),nDateCd-4))
do KeyDate
RETURN
***EOP FirstMo***

*!*********************************************************************
*!
*!      Procedure: LASTMO
*!
*!      Called by: CHGDATE()      (FUNCTION  in CHGDATEF.PRG)
*!
*!          Calls: KEYDATE        (PROCEDURE in CHGDATEF.PRG)
*!
*!*********************************************************************
PROCEDURE LastMo                  && Last of Month
dDateCd = ctod(str(month(dDateCd)+1)+'/01/'+;
  right(str(year(dDateCd)),nDateCd-4)) - 1
do KeyDate
RETURN
***EOP LastMo***

*: EOF: CHGDATEF.PRG
